/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.tools.buildmagic.task;

import org.apache.tools.ant.*;

/**
 * Thrown to indicate that a task is missing a required nested element.
 *
 * @version <pre>$Id: MissingElementException.java 21373 2008-08-05 19:10:51Z pgier $</pre>
 * @author  <a href="mailto:jason@planet57.com">Jason Dillon</a>
 */
public class MissingElementException
   extends BuildException
{
   public MissingElementException(String name, Task task) {
      super(task.getClass() + " requires a '" + name + "' element",
            task.getLocation());
   }
}

