/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.tools.buildmagic.task;

import java.util.List;
import java.util.LinkedList;
import java.util.Iterator;

import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Path.PathElement;

/**
 * Append a path to another path
 *
 * @version <pre>$Id: AppendPath.java 21939 2008-08-27 21:01:35Z pgier $</pre>
 * @author  <a href="mailto:jason@planet57.com">Jason Dillon</a>
 */
public class AppendPath
   extends Task
{
   protected List paths = new LinkedList();
   protected String refid;

   public void setRefid(String id) {
      this.refid = id;
   }
   
   /**
    * Create a nested path.
    */
   public Path createPath() {
      Path path = new Path(getProject());
      paths.add(path);
      return path;
   }

   /**
    * Create a nested path element.
    */
   public PathElement createPathElement() {
      Path path = new Path(getProject());
      paths.add(path);
      return path.createPathElement();
   }
   
   /**
    * Execute the task.
    */
   public void execute() throws BuildException {
      if (refid == null)
         throw new MissingAttributeException("refid", this);

      Path target = (Path)getProject().getReferences().get(refid);
      Iterator iter = paths.iterator();
      while (iter.hasNext()) {
         Path path = (Path)iter.next();
         target.append(path);
      }
   }
}
