dnl Copyright (C) 2005-2008 EDF
dnl
dnl This file is part of the FVM software package.  For license
dnl information, see the COPYING file in the top level directory of the
dnl FVM source distribution.

# FVM_AC_TEST_HDF5
#----------------
# modifies or sets have_hdf5, HDF_CPPFLAGS, HDF_LDFLAGS, and HDF_LIBS
# depending on libraries found

AC_DEFUN([FVM_AC_TEST_HDF5], [

AC_REQUIRE([FVM_AC_CONFIG_PUBL_INIT])dnl

have_hdf5=no

AC_ARG_ENABLE(hdf5,
  [  --disable-hdf5          do not use HDF5 when available],
  [
    case "${enableval}" in
      yes) hdf5=true ;;
      no)  hdf5=false ;;
      *)   AC_MSG_ERROR([bad value ${enableval} for --enable-hdf5]) ;;
    esac
  ],
  [ hdf5=true ]
)

AC_ARG_WITH(hdf5,
  [  --with-hdf5=PATH        specify prefix directory for HDF5],[
])

AC_ARG_WITH(hdf5-include,
  [  --with-hdf5-include=PATH  specify directory for HDF5 include files]
)

AC_ARG_WITH(hdf5-lib,
  [  --with-hdf5-lib=PATH    specify directory for HDF5 library]
)

if test "x$hdf5" = "xtrue" ; then

  saved_CPPFLAGS="$CPPFLAGS"
  saved_LDFLAGS="$LDFLAGS"
  saved_LIBS="$LIBS"

  if test "x$with_hdf5_include" != "x" ; then
    HDF5_CPPFLAGS="-I$with_hdf5_include"
  elif test "x$with_hdf5" != "x" ; then
    HDF5_CPPFLAGS="-I$with_hdf5/include"
  fi

  if test "x$with_hdf5_lib" != "x" ; then
    HDF5_LDFLAGS="-L$with_hdf5_lib"
  elif test "x$with_hdf5" != "x" ; then
    HDF5_LDFLAGS="-L$with_hdf5/lib"
  fi

  HDF5_LIBS="-lhdf5 $PTHREAD_LIBS"
  
  CPPFLAGS="${CPPFLAGS} ${HDF5_CPPFLAGS}"
  LDFLAGS="${LDFLAGS} ${HDF5_LDFLAGS}"
  LIBS="${LIBS} ${HDF5_LIBS}"

  AC_CHECK_LIB(hdf5, H5Fopen, 
               [ AC_DEFINE([HAVE_HDF5], 1, [HDF5 file support])
                 have_hdf5=yes
               ], 
               [ AC_MSG_WARN([no HDF5 file support])
               ],
               )

  if test "x$have_hdf5" = "xno"; then
    HDF5_CPPFLAGS=""
    HDF5_LDFLAGS=""
    HDF5_LIBS=""
  fi

  CPPFLAGS="$saved_CPPFLAGS"
  LDFLAGS="$saved_LDFLAGS"
  LIBS="$saved_LIBS"

  unset saved_CPPFLAGS
  unset saved_LDFLAGS
  unset saved_LIBS

fi

AC_SUBST(HDF5_CPPFLAGS)
AC_SUBST(HDF5_LDFLAGS)
AC_SUBST(HDF5_LIBS)

])dnl

