/***************************************************************************
                           ciconv.cpp  -  DCLib C++ iconv wrapper
                             -------------------
    begin                : Thu Sep 20 2007
    copyright            : (C) 2007 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifndef ICONV_CONST
#define ICONV_CONST
#endif

#include <stdio.h>
#include <stdlib.h>

#include "ciconv.h"

/** calls iconv_open */
CIconv::CIconv( CString from, CString to )
{
	cd = iconv_open( to.Data(), from.Data() );
}

/** calls iconv_close */
CIconv::~CIconv()
{
	iconv_close( cd );
}

/** calls iconv */
CString CIconv::encode( CString orig )
{
	if ( orig == "" )
	{
		return "";
	}
	
	CString result = "";
	size_t retval;
	
	size_t inleft = orig.Length();
	size_t outleft = inleft * 4;
	
	char * inbuf = orig.Data();
	char * outbuf = (char*) calloc( 1, outleft );
	char * outstart = outbuf;
	
	retval = iconv( cd, (ICONV_CONST char **)&inbuf, &inleft, &outbuf, &outleft );
	
	if ( (inleft != 0) || (retval == (size_t) -1) )
	{
		printf("iconv fail: %d\n", retval);
		perror("CIconv::encode");
		
		free(outstart);
		return orig;
	}
	else
	{
		result = outstart;
		free(outstart);
		
		//printf( "orig=\"%s\" len=%d\nresult=\"%s\" len=%d\n", orig.Data(), orig.Length(), result.Data(), result.Length() );
		
		return result;
	}
}
