/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Logger;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StreamEncodingDetector;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLConnection;
import java.nio.charset.Charset;

final class EncodingDetector {
    private final InputStream inputStream;
    private String encoding = null;
    private String encodingSpecificationInfo = null;
    private final String preliminaryEncoding;
    private final String preliminaryEncodingSpecificationInfo;
    private final String alternativePreliminaryEncoding;
    private static final int PREVIEW_BYTE_COUNT = 2048;
    private static final String UTF_8 = "UTF-8";
    private static final String ISO_8859_1 = "ISO-8859-1";

    public EncodingDetector(URLConnection uRLConnection) throws IOException {
        this(new StreamEncodingDetector(uRLConnection));
    }

    public EncodingDetector(InputStream inputStream) throws IOException {
        this(new StreamEncodingDetector(inputStream));
    }

    public EncodingDetector(InputStream inputStream, String string) throws IOException {
        this(inputStream, string, "preliminary encoding set explicitly", null);
        if (!Charset.isSupported(string)) {
            throw new UnsupportedEncodingException(string + " specified as preliminaryEncoding constructor argument");
        }
        this.detectDocumentSpecifiedEncoding();
    }

    private EncodingDetector(StreamEncodingDetector streamEncodingDetector) throws IOException {
        this(streamEncodingDetector, ISO_8859_1);
    }

    private EncodingDetector(StreamEncodingDetector streamEncodingDetector, String string) throws IOException {
        this(streamEncodingDetector.getInputStream(), streamEncodingDetector.getEncoding(), streamEncodingDetector.getEncodingSpecificationInfo(), string);
        if (streamEncodingDetector.isDifinitive() || !streamEncodingDetector.isDocumentSpecifiedEncodingPossible()) {
            this.setEncoding(this.preliminaryEncoding, this.preliminaryEncodingSpecificationInfo);
        } else {
            this.detectDocumentSpecifiedEncoding();
        }
    }

    private EncodingDetector(InputStream inputStream, String string, String string2, String string3) throws IOException {
        this.inputStream = inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream);
        this.preliminaryEncoding = string;
        this.preliminaryEncodingSpecificationInfo = string2;
        this.alternativePreliminaryEncoding = string3;
        if (string3 != null && !Charset.isSupported(string3)) {
            throw new UnsupportedEncodingException(string3 + " specified as alternativePreliminaryEncoding constructor argument");
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getEncodingSpecificationInfo() {
        return this.encodingSpecificationInfo;
    }

    public String getPreliminaryEncoding() {
        return this.preliminaryEncoding;
    }

    public String getPreliminaryEncodingSpecificationInfo() {
        return this.preliminaryEncodingSpecificationInfo;
    }

    public Reader openReader() throws UnsupportedEncodingException {
        if (this.encoding == null) {
            return new InputStreamReader(this.inputStream, ISO_8859_1);
        }
        if (!Charset.isSupported(this.encoding)) {
            throw new UnsupportedEncodingException(this.encoding + ": " + this.encodingSpecificationInfo);
        }
        return new InputStreamReader(this.inputStream, this.encoding);
    }

    private boolean setEncoding(String string, String string2) {
        this.encoding = string;
        this.encodingSpecificationInfo = string2;
        return true;
    }

    private boolean detectDocumentSpecifiedEncoding() throws IOException {
        String string;
        String string2;
        this.inputStream.mark(2048);
        if (Charset.isSupported(this.preliminaryEncoding)) {
            string2 = this.preliminaryEncoding;
        } else {
            if (this.alternativePreliminaryEncoding == null) {
                throw new UnsupportedEncodingException(this.preliminaryEncoding + ": " + this.preliminaryEncodingSpecificationInfo);
            }
            string2 = this.alternativePreliminaryEncoding;
        }
        Source source = this.getPreviewSource(string2);
        this.inputStream.reset();
        Logger logger = source.getLogger();
        source.setLogger(null);
        if (this.preliminaryEncoding != string2 && logger.isWarnEnabled()) {
            logger.warn("Alternative encoding " + string2 + " substituted for unsupported preliminary encoding " + this.preliminaryEncoding + ": " + this.preliminaryEncodingSpecificationInfo);
        }
        if (source.getDocumentSpecifiedEncoding() == null) {
            if (source.isXML()) {
                return this.setEncoding(UTF_8, "mandatory XML encoding when no BOM or encoding declaration is present");
            }
            string = "no encoding specified in document";
        } else {
            if (Charset.isSupported(source.getDocumentSpecifiedEncoding())) {
                return this.setEncoding(source.getDocumentSpecifiedEncoding(), source.getEncodingSpecificationInfo());
            }
            string = "encoding " + source.getDocumentSpecifiedEncoding() + " specified in document is not supported";
            if (logger.isWarnEnabled()) {
                logger.warn("Unsupported encoding " + source.getDocumentSpecifiedEncoding() + " specified in document, using preliminary encoding " + string2 + " instead");
            }
        }
        if (this.preliminaryEncoding != string2) {
            return this.setEncoding(string2, "alternative encoding substituted for unsupported preliminary encoding " + this.preliminaryEncoding + ": " + this.preliminaryEncodingSpecificationInfo + ", " + string);
        }
        return this.setEncoding(this.preliminaryEncoding, this.preliminaryEncodingSpecificationInfo + ", " + string);
    }

    private Source getPreviewSource(String string) throws IOException {
        int n;
        int n2;
        byte[] byArray = new byte[2048];
        for (n2 = 0; n2 < 2048 && (n = this.inputStream.read()) != -1; ++n2) {
            byArray[n2] = (byte)n;
        }
        return new Source(new InputStreamReader((InputStream)new ByteArrayInputStream(byArray, 0, n2), string), null);
    }
}

