/*
 *  declarations for device-mapper utilities for cryptmount
 *  $Revision: 134 $, $Date: 2007-02-19 17:18:07 +0000 (Mon, 19 Feb 2007) $
 *  Copyright 2005-2007, RW Penney
 */

/*
    This file is part of cryptmount

    cryptmount is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exemption, permission is granted to link cryptmount
    with the OpenSSL project's "OpenSSL" library and distribute
    the linked code without invoking clause 2(b) of the GNU GPL version 2.

    cryptmount is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with cryptmount; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef _DMUTILS_H
#define _DMUTILS_H

#include <config.h>

#include <libdevmapper.h>


struct dm_task *devmap_prepare(int type, const char *devname);
int devmap_path(char **buff, const char *ident);
int devmap_create(const char *ident, uint64_t blk0, uint64_t blklen,
                const char *tgttype, const char *params);
int devmap_dependencies(const char *ident, unsigned *count, dev_t **devids);
int devmap_remove(const char *ident);

int is_configured(const char *ident, struct dm_info *dminfo);

#endif  /* _DMUTILS_H */

/*
 *  (C)Copyright 2005-2007, RW Penney
 */
