from __future__ import generators

import py
from py.__.rest.latex import process_configfile, process_rest_file
try:
    import docutils
except ImportError:
    py.test.skip("docutils not present")


def setup_module(mod):
    if not py.path.local.sysfind("gs") or \
           not py.path.local.sysfind("dot") or \
           not py.path.local.sysfind("latex"):
        py.test.skip("ghostscript, graphviz and latex needed")
    mod.data = py.magic.autopath().dirpath().join("data")

class TestRst2Pdf(object):
    def _process_rest_file(self):
        data = py.magic.autopath().dirpath().join("data")
        part2 = data.join("part1.txt")
        pdf = part2.new(ext="pdf")
        process_rest_file(part2)
        assert pdf.check()
        pdf.remove()

    def _process_configfile(self):
        data = py.magic.autopath().dirpath().join("data")
        config = data.join("example.rst2pdfconfig")
        pdf = config.new(ext="pdf")
        tex = data.join('example.tex')
        process_configfile(config, debug=True)
        assert pdf.check()
        assert tex.check()
        texcontent = tex.read()
        assert "Generated by" in texcontent
        assert "Docutils" in texcontent
        process_configfile(config, debug=False)
        assert pdf.check()
        assert not tex.check()
        pdf.remove()

    def _process_all(self):
        # fallback test: only checks that no exception is raised
        def rec(p):
            return p.check(dotfile=0)

        for x in data.visit("*.rst2pdfconfig", rec=rec):
            process_configfile(x)
        for x in data.visit("*.txt", rec=rec):
            process_rest_file(x)

    def test_rst2pdf(self):
        self._process_rest_file()
        self._process_configfile()
        self._process_all()
