/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/
#define BEGIN_CALLSIGN "begin calldata"
#define END_CALLSIGN	">Email: "
#define NOT_FOUND        "<div style=\"margin:1em\">"
#define END_NOT_FOUND        "<span style="

void Form1::init()
{
connect(&http, SIGNAL(done(bool)), this, SLOT(httpDone(bool)));
}

void Form1::getit()
{
    result_TE->setText(tr("...Working..."));
    website = "www.qrz.com";
    callsign = callsign_LE->text().upper();
    gohere = "/callsign/" + callsign;
    if (callsign_LE->text() == "") {
	result_TE->setText(tr("...Done..."));
    	QMessageBox::critical(this,tr( "Empty query"),
			      tr("Please type a callsign."),
			      QMessageBox::Ok, QMessageBox::NoButton);	
    }else{
    	file.setName("result.html");
	if (!file.open(IO_WriteOnly)) {
	QMessageBox::warning(this, tr("HTTP Get"),
			      tr("Cannot write to file. %1\n%2")
			      .arg(file.name())
			      .arg(file.errorString()));
	result_TE->setText("...Done...");
	return;
    }		    
	
	http.setHost(website);
	http.get(gohere, &file);
	http.closeConnection();

   }
    file.close();
}


void Form1::httpDone( bool error)
{
if (error)
    QMessageBox::warning(this, tr("HTTP Get"),
			 tr("Error while fetching file with HTTP: %1")
			      .arg(http.errorString()));
file.close();
parseit();
}


void Form1::parseit()
{
result_TE->setText(tr("...Checking Received HTML..."));    
if (!file.open(IO_ReadOnly | IO_Translate)) {
	QMessageBox::warning(this, tr("Parser"),
			      tr("Cannot open file. %1\n%2")
			      .arg(file.name())
			      .arg(file.errorString()));
	result_TE->setText("...Done...");
	return;
    }
flag = FALSE;
QString str = "";
QTextStream in (&file);
// Main parser loop
while (!in.atEnd()){
    lineOdata = in.readLine();
    // Read in one line of text at a time
    if (lineOdata.find(NOT_FOUND, 0) >= 0){
	// A text string was found that indicates the callsign not in database
	flag = TRUE;	       
	result_TE->setText(tr("...Callsign not found..."));	
    }
    if ( flag && (lineOdata.find(END_NOT_FOUND, 0) >= 0)) {
	// The last part of the text we want is done so stop looking at any more text
	flag = FALSE;
    }    
    
/********************************** CALLSIGN ***********************************/		
    if (lineOdata.find(BEGIN_CALLSIGN, 0) >= 0) {
	// Found the callsign in the database
		flag = TRUE;
		result_TE->setText(tr("...Found callsign..."));	
	    }	
    if ( flag && (lineOdata.find(END_CALLSIGN, 0) >= 0)) {
	// The last part of the text we want is done so stop looking at any more text
	flag = FALSE;
    }
    

    if (flag && (lineOdata.find("<img src=", 0) >= 0)){
	// Erase lines referencing image data (for now)
	lineOdata = "";
} 


    // Save the line if its good
    if (flag ) {
    str = str + lineOdata;
    }
          
}
 file.close();
// Print result to main window
 result_TE->setText(str);
 // Clear callsin field and wait for next query
 clear_callsign();
}


void Form1::saveit()
{
saved_TE->setText(result_TE->text());
}


void Form1::clear_callsign()
{
callsign_LE->clear();
callsign_LE->setFocus();
}


void Form1::callsign_RX()
{

}
