# Written by Henrik Nilsen Omma
# (C) Canonical, Ltd. Licensed under the GPL

import re
import os
import urllib2
import sys

import XMLOperations
from infoFilesDefinitions import clueCondition as clueCondition
from infoFilesDefinitions import bugClue as bugClue

def search_ng(cond,attribute,case_sensitive=None):
    if isinstance(attribute, str):
        if case_sensitive:
            if cond.startswith("r'") and cond.endswith("'"):
                res = re.search(cond, attribute, re.MULTILINE) is not None
            else:
                res = attribute.count(cond)>0
        else:
            low_text =attribute.lower()
            a = re.search(r"^r'(.*)'$",cond)
            if a:
                res = re.search(a.group(1), low_text, re.MULTILINE|re.IGNORECASE) is not None
            else:
                low_cond = cond.lower()
                res = low_text.count(cond.lower())>0
        return res
        
    elif isinstance(attribute, list) or isinstance(attribute, tuple):
        a = [search_ng(cond,l) for l in attribute]
        #print a
        if True in a: return True
        return False

    else:
        raise TypeError, "Unknown type of attribute '%s': %s" % (attribute, type(attribute))


class InfoFiles(object):
    def __init__(self, packages_dirs):
        self.files = dict()
        self.packages_dirs = packages_dirs
        
    def add_simple_clue(self, srcpkg, condition, info):
        if not self.files.has_key(srcpkg):
            self.files[srcpkg] = InfoFile(srcpkg, self, [])
        a = set()
        a.add(clueCondition(None, None, condition, False))
        self.files[srcpkg].clues.add(bugClue(info, a))

    def get_info_file(self, srcpkg, verbosity=0):
        if not self.files.has_key(srcpkg):
            self.files[srcpkg] = InfoFile(srcpkg, self, self.packages_dirs)
            inherited_clues = self.get_inherited_clues(srcpkg, verbosity)
            self.files[srcpkg].set_inherited_clues(inherited_clues)
        return self.files[srcpkg]

    def get_inherited_clues(self, srcpkg, verbosity):
        #FIXME: Thanks Matthias Klose: fix endless recursion!
        inheritlist = set()
        srcpkginfo = self.get_info_file(srcpkg, verbosity)
        if verbosity > 0:
            verbosity -= 1
            if srcpkginfo.inherits:
                for inherit in srcpkginfo.inherits:
                    inheritobj = self.get_info_file(inherit, verbosity)
                    if inheritobj:
                        inheritlist.update(inheritobj.clues)
                        inheritlist.update(self.get_inherited_clues(inheritobj.srcpkg, \
                                                                    verbosity))
            else:
                inheritlist.update(set(self.get_info_file(srcpkg, 
                                                          verbosity).clues))
        return inheritlist
        
    def get_available_clue_files(self):
        files = set()
        for directory in self.packages_dirs:
            if directory:
                isFile = lambda a: os.path.isfile(os.path.join(directory, a))
                files.update(filter(isFile, os.listdir(directory)))
        getPackageName = lambda a: os.path.splitext(a)[0]
        return map(getPackageName, files)

class InfoFile(object):
    def __init__(self, srcpkg, filelist=None, packages_dirs=None):
        self.filelist = filelist
        self.srcpkg = srcpkg
        self.clues = set()
        self.inherits = set()
        self.dontlist = set()
        self.inherited_clues = set()
        filenames = [os.path.join("%s/%s.info" % (p_dir, srcpkg)) \
                            for p_dir in \
                                filter(lambda p: p!=None, packages_dirs)]
        try:
            (self.inherits, 
             self.dontlist, 
             self.clues) = XMLOperations.read_clue_files(filenames)
        except XMLOperations.NoClueFoundError, e:
            print >> sys.stderr,e
        
    def set_inherited_clues(self, inherited_clues):
        self.inherited_clues = inherited_clues
        

    def clue_matches(self, clue, bug_or_attachment, case_sensitive=False):
        for condition in clue.conditions:
            return self.condition_matches(condition, bug_or_attachment, case_sensitive)
            

    def condition_matches(self, cond, bug_or_attachment, case_sensitive=False):
        if cond.simple_cond:
            #print "tags:",getattr(bug_or_attachment,"proptags",None)
            #print type(getattr(bug_or_attachment,"text",None))
            if cond.cond_field:
                # search only in attribute given by cond.cond_field
                # if the bug_or_attachment-object does not have the given attribute
                # this raises an AttributeError, this AttributeError is
                # catched in clue_matches with the result, that is clue
                # does not match
                try:
                    search_text = getattr(bug_or_attachment, cond.cond_field)
                except IOError, e:
                    raise AttributeError, "Failed reading '%s.%s': %s" %(bug_or_attachment, cond.cond_field, e)
            else:
                try:
                    search_text = bug_or_attachment.text
                except IOError, e:
                    raise AttributeError, "Failed reading '%s.text': %s" %(bug_or_attachment, e)
           
            try:
                res = search_ng(cond.simple_cond, search_text, case_sensitive)
            except TypeError, e:
                print >> sys.stderr, "Error while checking '%s''%s' (%s): %s" %(cond.cond_field, type(cond.cond_field), bug_or_attachment.contenttype, e)
                sys.exit(1)
            return cond.not_cond != res
        
        if cond.and_cond:
            res = len(cond.and_cond) == \
                [self.condition_matches(n, bug_or_attachment, case_sensitive) \
                    for n in cond.and_cond].count(True)
            return cond.not_cond != res
            
        if cond.or_cond:
            res = [self.condition_matches(n, bug_or_attachment, case_sensitive) \
                for n in cond.or_cond].count(True) != 0
            return cond.not_cond != res

        return False
