#ifndef _SYNTH_REG_REG_H_
#define _SYNTH_REG_REG_H_

#define SYNTH_SYNTH1_ADDRESS                     0x00000000
#define SYNTH_SYNTH1_OFFSET                      0x00000000
#define SYNTH_SYNTH1_PWD_BIAS_MSB                31
#define SYNTH_SYNTH1_PWD_BIAS_LSB                31
#define SYNTH_SYNTH1_PWD_BIAS_MASK               0x80000000
#define SYNTH_SYNTH1_PWD_BIAS_GET(x)             (((x) & SYNTH_SYNTH1_PWD_BIAS_MASK) >> SYNTH_SYNTH1_PWD_BIAS_LSB)
#define SYNTH_SYNTH1_PWD_BIAS_SET(x)             (((x) << SYNTH_SYNTH1_PWD_BIAS_LSB) & SYNTH_SYNTH1_PWD_BIAS_MASK)
#define SYNTH_SYNTH1_PWD_CP_MSB                  30
#define SYNTH_SYNTH1_PWD_CP_LSB                  30
#define SYNTH_SYNTH1_PWD_CP_MASK                 0x40000000
#define SYNTH_SYNTH1_PWD_CP_GET(x)               (((x) & SYNTH_SYNTH1_PWD_CP_MASK) >> SYNTH_SYNTH1_PWD_CP_LSB)
#define SYNTH_SYNTH1_PWD_CP_SET(x)               (((x) << SYNTH_SYNTH1_PWD_CP_LSB) & SYNTH_SYNTH1_PWD_CP_MASK)
#define SYNTH_SYNTH1_PWD_VCMON_MSB               29
#define SYNTH_SYNTH1_PWD_VCMON_LSB               29
#define SYNTH_SYNTH1_PWD_VCMON_MASK              0x20000000
#define SYNTH_SYNTH1_PWD_VCMON_GET(x)            (((x) & SYNTH_SYNTH1_PWD_VCMON_MASK) >> SYNTH_SYNTH1_PWD_VCMON_LSB)
#define SYNTH_SYNTH1_PWD_VCMON_SET(x)            (((x) << SYNTH_SYNTH1_PWD_VCMON_LSB) & SYNTH_SYNTH1_PWD_VCMON_MASK)
#define SYNTH_SYNTH1_PWD_VCO_MSB                 28
#define SYNTH_SYNTH1_PWD_VCO_LSB                 28
#define SYNTH_SYNTH1_PWD_VCO_MASK                0x10000000
#define SYNTH_SYNTH1_PWD_VCO_GET(x)              (((x) & SYNTH_SYNTH1_PWD_VCO_MASK) >> SYNTH_SYNTH1_PWD_VCO_LSB)
#define SYNTH_SYNTH1_PWD_VCO_SET(x)              (((x) << SYNTH_SYNTH1_PWD_VCO_LSB) & SYNTH_SYNTH1_PWD_VCO_MASK)
#define SYNTH_SYNTH1_PWD_PRESC_MSB               27
#define SYNTH_SYNTH1_PWD_PRESC_LSB               27
#define SYNTH_SYNTH1_PWD_PRESC_MASK              0x08000000
#define SYNTH_SYNTH1_PWD_PRESC_GET(x)            (((x) & SYNTH_SYNTH1_PWD_PRESC_MASK) >> SYNTH_SYNTH1_PWD_PRESC_LSB)
#define SYNTH_SYNTH1_PWD_PRESC_SET(x)            (((x) << SYNTH_SYNTH1_PWD_PRESC_LSB) & SYNTH_SYNTH1_PWD_PRESC_MASK)
#define SYNTH_SYNTH1_PWD_LODIV_MSB               26
#define SYNTH_SYNTH1_PWD_LODIV_LSB               26
#define SYNTH_SYNTH1_PWD_LODIV_MASK              0x04000000
#define SYNTH_SYNTH1_PWD_LODIV_GET(x)            (((x) & SYNTH_SYNTH1_PWD_LODIV_MASK) >> SYNTH_SYNTH1_PWD_LODIV_LSB)
#define SYNTH_SYNTH1_PWD_LODIV_SET(x)            (((x) << SYNTH_SYNTH1_PWD_LODIV_LSB) & SYNTH_SYNTH1_PWD_LODIV_MASK)
#define SYNTH_SYNTH1_PWD_LOMIX_MSB               25
#define SYNTH_SYNTH1_PWD_LOMIX_LSB               25
#define SYNTH_SYNTH1_PWD_LOMIX_MASK              0x02000000
#define SYNTH_SYNTH1_PWD_LOMIX_GET(x)            (((x) & SYNTH_SYNTH1_PWD_LOMIX_MASK) >> SYNTH_SYNTH1_PWD_LOMIX_LSB)
#define SYNTH_SYNTH1_PWD_LOMIX_SET(x)            (((x) << SYNTH_SYNTH1_PWD_LOMIX_LSB) & SYNTH_SYNTH1_PWD_LOMIX_MASK)
#define SYNTH_SYNTH1_FORCE_LO_ON_MSB             24
#define SYNTH_SYNTH1_FORCE_LO_ON_LSB             24
#define SYNTH_SYNTH1_FORCE_LO_ON_MASK            0x01000000
#define SYNTH_SYNTH1_FORCE_LO_ON_GET(x)          (((x) & SYNTH_SYNTH1_FORCE_LO_ON_MASK) >> SYNTH_SYNTH1_FORCE_LO_ON_LSB)
#define SYNTH_SYNTH1_FORCE_LO_ON_SET(x)          (((x) << SYNTH_SYNTH1_FORCE_LO_ON_LSB) & SYNTH_SYNTH1_FORCE_LO_ON_MASK)
#define SYNTH_SYNTH1_PWD_LOBUF5G_MSB             23
#define SYNTH_SYNTH1_PWD_LOBUF5G_LSB             23
#define SYNTH_SYNTH1_PWD_LOBUF5G_MASK            0x00800000
#define SYNTH_SYNTH1_PWD_LOBUF5G_GET(x)          (((x) & SYNTH_SYNTH1_PWD_LOBUF5G_MASK) >> SYNTH_SYNTH1_PWD_LOBUF5G_LSB)
#define SYNTH_SYNTH1_PWD_LOBUF5G_SET(x)          (((x) << SYNTH_SYNTH1_PWD_LOBUF5G_LSB) & SYNTH_SYNTH1_PWD_LOBUF5G_MASK)
#define SYNTH_SYNTH1_VCOREGBYPASS_MSB            22
#define SYNTH_SYNTH1_VCOREGBYPASS_LSB            22
#define SYNTH_SYNTH1_VCOREGBYPASS_MASK           0x00400000
#define SYNTH_SYNTH1_VCOREGBYPASS_GET(x)         (((x) & SYNTH_SYNTH1_VCOREGBYPASS_MASK) >> SYNTH_SYNTH1_VCOREGBYPASS_LSB)
#define SYNTH_SYNTH1_VCOREGBYPASS_SET(x)         (((x) << SYNTH_SYNTH1_VCOREGBYPASS_LSB) & SYNTH_SYNTH1_VCOREGBYPASS_MASK)
#define SYNTH_SYNTH1_VCOREGLEVEL_MSB             21
#define SYNTH_SYNTH1_VCOREGLEVEL_LSB             20
#define SYNTH_SYNTH1_VCOREGLEVEL_MASK            0x00300000
#define SYNTH_SYNTH1_VCOREGLEVEL_GET(x)          (((x) & SYNTH_SYNTH1_VCOREGLEVEL_MASK) >> SYNTH_SYNTH1_VCOREGLEVEL_LSB)
#define SYNTH_SYNTH1_VCOREGLEVEL_SET(x)          (((x) << SYNTH_SYNTH1_VCOREGLEVEL_LSB) & SYNTH_SYNTH1_VCOREGLEVEL_MASK)
#define SYNTH_SYNTH1_VCOREGBIAS_MSB              19
#define SYNTH_SYNTH1_VCOREGBIAS_LSB              18
#define SYNTH_SYNTH1_VCOREGBIAS_MASK             0x000c0000
#define SYNTH_SYNTH1_VCOREGBIAS_GET(x)           (((x) & SYNTH_SYNTH1_VCOREGBIAS_MASK) >> SYNTH_SYNTH1_VCOREGBIAS_LSB)
#define SYNTH_SYNTH1_VCOREGBIAS_SET(x)           (((x) << SYNTH_SYNTH1_VCOREGBIAS_LSB) & SYNTH_SYNTH1_VCOREGBIAS_MASK)
#define SYNTH_SYNTH1_SLIDINGIF_MSB               17
#define SYNTH_SYNTH1_SLIDINGIF_LSB               17
#define SYNTH_SYNTH1_SLIDINGIF_MASK              0x00020000
#define SYNTH_SYNTH1_SLIDINGIF_GET(x)            (((x) & SYNTH_SYNTH1_SLIDINGIF_MASK) >> SYNTH_SYNTH1_SLIDINGIF_LSB)
#define SYNTH_SYNTH1_SLIDINGIF_SET(x)            (((x) << SYNTH_SYNTH1_SLIDINGIF_LSB) & SYNTH_SYNTH1_SLIDINGIF_MASK)
#define SYNTH_SYNTH1_SPARE_PWD_MSB               16
#define SYNTH_SYNTH1_SPARE_PWD_LSB               16
#define SYNTH_SYNTH1_SPARE_PWD_MASK              0x00010000
#define SYNTH_SYNTH1_SPARE_PWD_GET(x)            (((x) & SYNTH_SYNTH1_SPARE_PWD_MASK) >> SYNTH_SYNTH1_SPARE_PWD_LSB)
#define SYNTH_SYNTH1_SPARE_PWD_SET(x)            (((x) << SYNTH_SYNTH1_SPARE_PWD_LSB) & SYNTH_SYNTH1_SPARE_PWD_MASK)
#define SYNTH_SYNTH1_CON_VDDVCOREG_MSB           15
#define SYNTH_SYNTH1_CON_VDDVCOREG_LSB           15
#define SYNTH_SYNTH1_CON_VDDVCOREG_MASK          0x00008000
#define SYNTH_SYNTH1_CON_VDDVCOREG_GET(x)        (((x) & SYNTH_SYNTH1_CON_VDDVCOREG_MASK) >> SYNTH_SYNTH1_CON_VDDVCOREG_LSB)
#define SYNTH_SYNTH1_CON_VDDVCOREG_SET(x)        (((x) << SYNTH_SYNTH1_CON_VDDVCOREG_LSB) & SYNTH_SYNTH1_CON_VDDVCOREG_MASK)
#define SYNTH_SYNTH1_CON_IVCOREG_MSB             14
#define SYNTH_SYNTH1_CON_IVCOREG_LSB             14
#define SYNTH_SYNTH1_CON_IVCOREG_MASK            0x00004000
#define SYNTH_SYNTH1_CON_IVCOREG_GET(x)          (((x) & SYNTH_SYNTH1_CON_IVCOREG_MASK) >> SYNTH_SYNTH1_CON_IVCOREG_LSB)
#define SYNTH_SYNTH1_CON_IVCOREG_SET(x)          (((x) << SYNTH_SYNTH1_CON_IVCOREG_LSB) & SYNTH_SYNTH1_CON_IVCOREG_MASK)
#define SYNTH_SYNTH1_CON_IVCOBUF_MSB             13
#define SYNTH_SYNTH1_CON_IVCOBUF_LSB             13
#define SYNTH_SYNTH1_CON_IVCOBUF_MASK            0x00002000
#define SYNTH_SYNTH1_CON_IVCOBUF_GET(x)          (((x) & SYNTH_SYNTH1_CON_IVCOBUF_MASK) >> SYNTH_SYNTH1_CON_IVCOBUF_LSB)
#define SYNTH_SYNTH1_CON_IVCOBUF_SET(x)          (((x) << SYNTH_SYNTH1_CON_IVCOBUF_LSB) & SYNTH_SYNTH1_CON_IVCOBUF_MASK)
#define SYNTH_SYNTH1_SEL_VCMONABUS_MSB           12
#define SYNTH_SYNTH1_SEL_VCMONABUS_LSB           10
#define SYNTH_SYNTH1_SEL_VCMONABUS_MASK          0x00001c00
#define SYNTH_SYNTH1_SEL_VCMONABUS_GET(x)        (((x) & SYNTH_SYNTH1_SEL_VCMONABUS_MASK) >> SYNTH_SYNTH1_SEL_VCMONABUS_LSB)
#define SYNTH_SYNTH1_SEL_VCMONABUS_SET(x)        (((x) << SYNTH_SYNTH1_SEL_VCMONABUS_LSB) & SYNTH_SYNTH1_SEL_VCMONABUS_MASK)
#define SYNTH_SYNTH1_PWUP_VCOBUF_PD_MSB          9
#define SYNTH_SYNTH1_PWUP_VCOBUF_PD_LSB          9
#define SYNTH_SYNTH1_PWUP_VCOBUF_PD_MASK         0x00000200
#define SYNTH_SYNTH1_PWUP_VCOBUF_PD_GET(x)       (((x) & SYNTH_SYNTH1_PWUP_VCOBUF_PD_MASK) >> SYNTH_SYNTH1_PWUP_VCOBUF_PD_LSB)
#define SYNTH_SYNTH1_PWUP_VCOBUF_PD_SET(x)       (((x) << SYNTH_SYNTH1_PWUP_VCOBUF_PD_LSB) & SYNTH_SYNTH1_PWUP_VCOBUF_PD_MASK)
#define SYNTH_SYNTH1_PWUP_LODIV_PD_MSB           8
#define SYNTH_SYNTH1_PWUP_LODIV_PD_LSB           8
#define SYNTH_SYNTH1_PWUP_LODIV_PD_MASK          0x00000100
#define SYNTH_SYNTH1_PWUP_LODIV_PD_GET(x)        (((x) & SYNTH_SYNTH1_PWUP_LODIV_PD_MASK) >> SYNTH_SYNTH1_PWUP_LODIV_PD_LSB)
#define SYNTH_SYNTH1_PWUP_LODIV_PD_SET(x)        (((x) << SYNTH_SYNTH1_PWUP_LODIV_PD_LSB) & SYNTH_SYNTH1_PWUP_LODIV_PD_MASK)
#define SYNTH_SYNTH1_PWUP_LOMIX_PD_MSB           7
#define SYNTH_SYNTH1_PWUP_LOMIX_PD_LSB           7
#define SYNTH_SYNTH1_PWUP_LOMIX_PD_MASK          0x00000080
#define SYNTH_SYNTH1_PWUP_LOMIX_PD_GET(x)        (((x) & SYNTH_SYNTH1_PWUP_LOMIX_PD_MASK) >> SYNTH_SYNTH1_PWUP_LOMIX_PD_LSB)
#define SYNTH_SYNTH1_PWUP_LOMIX_PD_SET(x)        (((x) << SYNTH_SYNTH1_PWUP_LOMIX_PD_LSB) & SYNTH_SYNTH1_PWUP_LOMIX_PD_MASK)
#define SYNTH_SYNTH1_PWUP_LOBUF5G_PD_MSB         6
#define SYNTH_SYNTH1_PWUP_LOBUF5G_PD_LSB         6
#define SYNTH_SYNTH1_PWUP_LOBUF5G_PD_MASK        0x00000040
#define SYNTH_SYNTH1_PWUP_LOBUF5G_PD_GET(x)      (((x) & SYNTH_SYNTH1_PWUP_LOBUF5G_PD_MASK) >> SYNTH_SYNTH1_PWUP_LOBUF5G_PD_LSB)
#define SYNTH_SYNTH1_PWUP_LOBUF5G_PD_SET(x)      (((x) << SYNTH_SYNTH1_PWUP_LOBUF5G_PD_LSB) & SYNTH_SYNTH1_PWUP_LOBUF5G_PD_MASK)
#define SYNTH_SYNTH1_MONITOR_FB_MSB              5
#define SYNTH_SYNTH1_MONITOR_FB_LSB              5
#define SYNTH_SYNTH1_MONITOR_FB_MASK             0x00000020
#define SYNTH_SYNTH1_MONITOR_FB_GET(x)           (((x) & SYNTH_SYNTH1_MONITOR_FB_MASK) >> SYNTH_SYNTH1_MONITOR_FB_LSB)
#define SYNTH_SYNTH1_MONITOR_FB_SET(x)           (((x) << SYNTH_SYNTH1_MONITOR_FB_LSB) & SYNTH_SYNTH1_MONITOR_FB_MASK)
#define SYNTH_SYNTH1_MONITOR_REF_MSB             4
#define SYNTH_SYNTH1_MONITOR_REF_LSB             4
#define SYNTH_SYNTH1_MONITOR_REF_MASK            0x00000010
#define SYNTH_SYNTH1_MONITOR_REF_GET(x)          (((x) & SYNTH_SYNTH1_MONITOR_REF_MASK) >> SYNTH_SYNTH1_MONITOR_REF_LSB)
#define SYNTH_SYNTH1_MONITOR_REF_SET(x)          (((x) << SYNTH_SYNTH1_MONITOR_REF_LSB) & SYNTH_SYNTH1_MONITOR_REF_MASK)
#define SYNTH_SYNTH1_MONITOR_FB_DIV2_MSB         3
#define SYNTH_SYNTH1_MONITOR_FB_DIV2_LSB         3
#define SYNTH_SYNTH1_MONITOR_FB_DIV2_MASK        0x00000008
#define SYNTH_SYNTH1_MONITOR_FB_DIV2_GET(x)      (((x) & SYNTH_SYNTH1_MONITOR_FB_DIV2_MASK) >> SYNTH_SYNTH1_MONITOR_FB_DIV2_LSB)
#define SYNTH_SYNTH1_MONITOR_FB_DIV2_SET(x)      (((x) << SYNTH_SYNTH1_MONITOR_FB_DIV2_LSB) & SYNTH_SYNTH1_MONITOR_FB_DIV2_MASK)
#define SYNTH_SYNTH1_MONITOR_VC2HIGH_MSB         2
#define SYNTH_SYNTH1_MONITOR_VC2HIGH_LSB         2
#define SYNTH_SYNTH1_MONITOR_VC2HIGH_MASK        0x00000004
#define SYNTH_SYNTH1_MONITOR_VC2HIGH_GET(x)      (((x) & SYNTH_SYNTH1_MONITOR_VC2HIGH_MASK) >> SYNTH_SYNTH1_MONITOR_VC2HIGH_LSB)
#define SYNTH_SYNTH1_MONITOR_VC2HIGH_SET(x)      (((x) << SYNTH_SYNTH1_MONITOR_VC2HIGH_LSB) & SYNTH_SYNTH1_MONITOR_VC2HIGH_MASK)
#define SYNTH_SYNTH1_MONITOR_VC2LOW_MSB          1
#define SYNTH_SYNTH1_MONITOR_VC2LOW_LSB          1
#define SYNTH_SYNTH1_MONITOR_VC2LOW_MASK         0x00000002
#define SYNTH_SYNTH1_MONITOR_VC2LOW_GET(x)       (((x) & SYNTH_SYNTH1_MONITOR_VC2LOW_MASK) >> SYNTH_SYNTH1_MONITOR_VC2LOW_LSB)
#define SYNTH_SYNTH1_MONITOR_VC2LOW_SET(x)       (((x) << SYNTH_SYNTH1_MONITOR_VC2LOW_LSB) & SYNTH_SYNTH1_MONITOR_VC2LOW_MASK)
#define SYNTH_SYNTH1_MONITOR_SYNTHLOCKVCOK_MSB   0
#define SYNTH_SYNTH1_MONITOR_SYNTHLOCKVCOK_LSB   0
#define SYNTH_SYNTH1_MONITOR_SYNTHLOCKVCOK_MASK  0x00000001
#define SYNTH_SYNTH1_MONITOR_SYNTHLOCKVCOK_GET(x) (((x) & SYNTH_SYNTH1_MONITOR_SYNTHLOCKVCOK_MASK) >> SYNTH_SYNTH1_MONITOR_SYNTHLOCKVCOK_LSB)
#define SYNTH_SYNTH1_MONITOR_SYNTHLOCKVCOK_SET(x) (((x) << SYNTH_SYNTH1_MONITOR_SYNTHLOCKVCOK_LSB) & SYNTH_SYNTH1_MONITOR_SYNTHLOCKVCOK_MASK)

#define SYNTH_SYNTH2_ADDRESS                     0x00000004
#define SYNTH_SYNTH2_OFFSET                      0x00000004
#define SYNTH_SYNTH2_VC_CAL_REF_MSB              31
#define SYNTH_SYNTH2_VC_CAL_REF_LSB              29
#define SYNTH_SYNTH2_VC_CAL_REF_MASK             0xe0000000
#define SYNTH_SYNTH2_VC_CAL_REF_GET(x)           (((x) & SYNTH_SYNTH2_VC_CAL_REF_MASK) >> SYNTH_SYNTH2_VC_CAL_REF_LSB)
#define SYNTH_SYNTH2_VC_CAL_REF_SET(x)           (((x) << SYNTH_SYNTH2_VC_CAL_REF_LSB) & SYNTH_SYNTH2_VC_CAL_REF_MASK)
#define SYNTH_SYNTH2_VC_HI_REF_MSB               28
#define SYNTH_SYNTH2_VC_HI_REF_LSB               26
#define SYNTH_SYNTH2_VC_HI_REF_MASK              0x1c000000
#define SYNTH_SYNTH2_VC_HI_REF_GET(x)            (((x) & SYNTH_SYNTH2_VC_HI_REF_MASK) >> SYNTH_SYNTH2_VC_HI_REF_LSB)
#define SYNTH_SYNTH2_VC_HI_REF_SET(x)            (((x) << SYNTH_SYNTH2_VC_HI_REF_LSB) & SYNTH_SYNTH2_VC_HI_REF_MASK)
#define SYNTH_SYNTH2_VC_MID_REF_MSB              25
#define SYNTH_SYNTH2_VC_MID_REF_LSB              23
#define SYNTH_SYNTH2_VC_MID_REF_MASK             0x03800000
#define SYNTH_SYNTH2_VC_MID_REF_GET(x)           (((x) & SYNTH_SYNTH2_VC_MID_REF_MASK) >> SYNTH_SYNTH2_VC_MID_REF_LSB)
#define SYNTH_SYNTH2_VC_MID_REF_SET(x)           (((x) << SYNTH_SYNTH2_VC_MID_REF_LSB) & SYNTH_SYNTH2_VC_MID_REF_MASK)
#define SYNTH_SYNTH2_VC_LOW_REF_MSB              22
#define SYNTH_SYNTH2_VC_LOW_REF_LSB              20
#define SYNTH_SYNTH2_VC_LOW_REF_MASK             0x00700000
#define SYNTH_SYNTH2_VC_LOW_REF_GET(x)           (((x) & SYNTH_SYNTH2_VC_LOW_REF_MASK) >> SYNTH_SYNTH2_VC_LOW_REF_LSB)
#define SYNTH_SYNTH2_VC_LOW_REF_SET(x)           (((x) << SYNTH_SYNTH2_VC_LOW_REF_LSB) & SYNTH_SYNTH2_VC_LOW_REF_MASK)
#define SYNTH_SYNTH2_LOOP_3RD_ORDER_R_MSB        19
#define SYNTH_SYNTH2_LOOP_3RD_ORDER_R_LSB        15
#define SYNTH_SYNTH2_LOOP_3RD_ORDER_R_MASK       0x000f8000
#define SYNTH_SYNTH2_LOOP_3RD_ORDER_R_GET(x)     (((x) & SYNTH_SYNTH2_LOOP_3RD_ORDER_R_MASK) >> SYNTH_SYNTH2_LOOP_3RD_ORDER_R_LSB)
#define SYNTH_SYNTH2_LOOP_3RD_ORDER_R_SET(x)     (((x) << SYNTH_SYNTH2_LOOP_3RD_ORDER_R_LSB) & SYNTH_SYNTH2_LOOP_3RD_ORDER_R_MASK)
#define SYNTH_SYNTH2_LOOP_CP_MSB                 14
#define SYNTH_SYNTH2_LOOP_CP_LSB                 10
#define SYNTH_SYNTH2_LOOP_CP_MASK                0x00007c00
#define SYNTH_SYNTH2_LOOP_CP_GET(x)              (((x) & SYNTH_SYNTH2_LOOP_CP_MASK) >> SYNTH_SYNTH2_LOOP_CP_LSB)
#define SYNTH_SYNTH2_LOOP_CP_SET(x)              (((x) << SYNTH_SYNTH2_LOOP_CP_LSB) & SYNTH_SYNTH2_LOOP_CP_MASK)
#define SYNTH_SYNTH2_LOOP_RS_MSB                 9
#define SYNTH_SYNTH2_LOOP_RS_LSB                 5
#define SYNTH_SYNTH2_LOOP_RS_MASK                0x000003e0
#define SYNTH_SYNTH2_LOOP_RS_GET(x)              (((x) & SYNTH_SYNTH2_LOOP_RS_MASK) >> SYNTH_SYNTH2_LOOP_RS_LSB)
#define SYNTH_SYNTH2_LOOP_RS_SET(x)              (((x) << SYNTH_SYNTH2_LOOP_RS_LSB) & SYNTH_SYNTH2_LOOP_RS_MASK)
#define SYNTH_SYNTH2_LOOP_CS_MSB                 4
#define SYNTH_SYNTH2_LOOP_CS_LSB                 3
#define SYNTH_SYNTH2_LOOP_CS_MASK                0x00000018
#define SYNTH_SYNTH2_LOOP_CS_GET(x)              (((x) & SYNTH_SYNTH2_LOOP_CS_MASK) >> SYNTH_SYNTH2_LOOP_CS_LSB)
#define SYNTH_SYNTH2_LOOP_CS_SET(x)              (((x) << SYNTH_SYNTH2_LOOP_CS_LSB) & SYNTH_SYNTH2_LOOP_CS_MASK)
#define SYNTH_SYNTH2_SPARE_BITS_MSB              2
#define SYNTH_SYNTH2_SPARE_BITS_LSB              0
#define SYNTH_SYNTH2_SPARE_BITS_MASK             0x00000007
#define SYNTH_SYNTH2_SPARE_BITS_GET(x)           (((x) & SYNTH_SYNTH2_SPARE_BITS_MASK) >> SYNTH_SYNTH2_SPARE_BITS_LSB)
#define SYNTH_SYNTH2_SPARE_BITS_SET(x)           (((x) << SYNTH_SYNTH2_SPARE_BITS_LSB) & SYNTH_SYNTH2_SPARE_BITS_MASK)

#define SYNTH_SYNTH3_ADDRESS                     0x00000008
#define SYNTH_SYNTH3_OFFSET                      0x00000008
#define SYNTH_SYNTH3_DIS_CLK_XTAL_MSB            31
#define SYNTH_SYNTH3_DIS_CLK_XTAL_LSB            31
#define SYNTH_SYNTH3_DIS_CLK_XTAL_MASK           0x80000000
#define SYNTH_SYNTH3_DIS_CLK_XTAL_GET(x)         (((x) & SYNTH_SYNTH3_DIS_CLK_XTAL_MASK) >> SYNTH_SYNTH3_DIS_CLK_XTAL_LSB)
#define SYNTH_SYNTH3_DIS_CLK_XTAL_SET(x)         (((x) << SYNTH_SYNTH3_DIS_CLK_XTAL_LSB) & SYNTH_SYNTH3_DIS_CLK_XTAL_MASK)
#define SYNTH_SYNTH3_SEL_CLK_DIV2_MSB            30
#define SYNTH_SYNTH3_SEL_CLK_DIV2_LSB            30
#define SYNTH_SYNTH3_SEL_CLK_DIV2_MASK           0x40000000
#define SYNTH_SYNTH3_SEL_CLK_DIV2_GET(x)         (((x) & SYNTH_SYNTH3_SEL_CLK_DIV2_MASK) >> SYNTH_SYNTH3_SEL_CLK_DIV2_LSB)
#define SYNTH_SYNTH3_SEL_CLK_DIV2_SET(x)         (((x) << SYNTH_SYNTH3_SEL_CLK_DIV2_LSB) & SYNTH_SYNTH3_SEL_CLK_DIV2_MASK)
#define SYNTH_SYNTH3_WAIT_SHORTR_PWRUP_MSB       29
#define SYNTH_SYNTH3_WAIT_SHORTR_PWRUP_LSB       24
#define SYNTH_SYNTH3_WAIT_SHORTR_PWRUP_MASK      0x3f000000
#define SYNTH_SYNTH3_WAIT_SHORTR_PWRUP_GET(x)    (((x) & SYNTH_SYNTH3_WAIT_SHORTR_PWRUP_MASK) >> SYNTH_SYNTH3_WAIT_SHORTR_PWRUP_LSB)
#define SYNTH_SYNTH3_WAIT_SHORTR_PWRUP_SET(x)    (((x) << SYNTH_SYNTH3_WAIT_SHORTR_PWRUP_LSB) & SYNTH_SYNTH3_WAIT_SHORTR_PWRUP_MASK)
#define SYNTH_SYNTH3_WAIT_PWRUP_MSB              23
#define SYNTH_SYNTH3_WAIT_PWRUP_LSB              18
#define SYNTH_SYNTH3_WAIT_PWRUP_MASK             0x00fc0000
#define SYNTH_SYNTH3_WAIT_PWRUP_GET(x)           (((x) & SYNTH_SYNTH3_WAIT_PWRUP_MASK) >> SYNTH_SYNTH3_WAIT_PWRUP_LSB)
#define SYNTH_SYNTH3_WAIT_PWRUP_SET(x)           (((x) << SYNTH_SYNTH3_WAIT_PWRUP_LSB) & SYNTH_SYNTH3_WAIT_PWRUP_MASK)
#define SYNTH_SYNTH3_WAIT_CAL_BIN_MSB            17
#define SYNTH_SYNTH3_WAIT_CAL_BIN_LSB            12
#define SYNTH_SYNTH3_WAIT_CAL_BIN_MASK           0x0003f000
#define SYNTH_SYNTH3_WAIT_CAL_BIN_GET(x)         (((x) & SYNTH_SYNTH3_WAIT_CAL_BIN_MASK) >> SYNTH_SYNTH3_WAIT_CAL_BIN_LSB)
#define SYNTH_SYNTH3_WAIT_CAL_BIN_SET(x)         (((x) << SYNTH_SYNTH3_WAIT_CAL_BIN_LSB) & SYNTH_SYNTH3_WAIT_CAL_BIN_MASK)
#define SYNTH_SYNTH3_WAIT_CAL_LIN_MSB            11
#define SYNTH_SYNTH3_WAIT_CAL_LIN_LSB            6
#define SYNTH_SYNTH3_WAIT_CAL_LIN_MASK           0x00000fc0
#define SYNTH_SYNTH3_WAIT_CAL_LIN_GET(x)         (((x) & SYNTH_SYNTH3_WAIT_CAL_LIN_MASK) >> SYNTH_SYNTH3_WAIT_CAL_LIN_LSB)
#define SYNTH_SYNTH3_WAIT_CAL_LIN_SET(x)         (((x) << SYNTH_SYNTH3_WAIT_CAL_LIN_LSB) & SYNTH_SYNTH3_WAIT_CAL_LIN_MASK)
#define SYNTH_SYNTH3_WAIT_VC_CHECK_MSB           5
#define SYNTH_SYNTH3_WAIT_VC_CHECK_LSB           0
#define SYNTH_SYNTH3_WAIT_VC_CHECK_MASK          0x0000003f
#define SYNTH_SYNTH3_WAIT_VC_CHECK_GET(x)        (((x) & SYNTH_SYNTH3_WAIT_VC_CHECK_MASK) >> SYNTH_SYNTH3_WAIT_VC_CHECK_LSB)
#define SYNTH_SYNTH3_WAIT_VC_CHECK_SET(x)        (((x) << SYNTH_SYNTH3_WAIT_VC_CHECK_LSB) & SYNTH_SYNTH3_WAIT_VC_CHECK_MASK)

#define SYNTH_SYNTH4_ADDRESS                     0x0000000c
#define SYNTH_SYNTH4_OFFSET                      0x0000000c
#define SYNTH_SYNTH4_DIS_LIN_CAPSEARCH_MSB       31
#define SYNTH_SYNTH4_DIS_LIN_CAPSEARCH_LSB       31
#define SYNTH_SYNTH4_DIS_LIN_CAPSEARCH_MASK      0x80000000
#define SYNTH_SYNTH4_DIS_LIN_CAPSEARCH_GET(x)    (((x) & SYNTH_SYNTH4_DIS_LIN_CAPSEARCH_MASK) >> SYNTH_SYNTH4_DIS_LIN_CAPSEARCH_LSB)
#define SYNTH_SYNTH4_DIS_LIN_CAPSEARCH_SET(x)    (((x) << SYNTH_SYNTH4_DIS_LIN_CAPSEARCH_LSB) & SYNTH_SYNTH4_DIS_LIN_CAPSEARCH_MASK)
#define SYNTH_SYNTH4_DIS_LOSTVC_MSB              30
#define SYNTH_SYNTH4_DIS_LOSTVC_LSB              30
#define SYNTH_SYNTH4_DIS_LOSTVC_MASK             0x40000000
#define SYNTH_SYNTH4_DIS_LOSTVC_GET(x)           (((x) & SYNTH_SYNTH4_DIS_LOSTVC_MASK) >> SYNTH_SYNTH4_DIS_LOSTVC_LSB)
#define SYNTH_SYNTH4_DIS_LOSTVC_SET(x)           (((x) << SYNTH_SYNTH4_DIS_LOSTVC_LSB) & SYNTH_SYNTH4_DIS_LOSTVC_MASK)
#define SYNTH_SYNTH4_ALWAYS_SHORTR_MSB           29
#define SYNTH_SYNTH4_ALWAYS_SHORTR_LSB           29
#define SYNTH_SYNTH4_ALWAYS_SHORTR_MASK          0x20000000
#define SYNTH_SYNTH4_ALWAYS_SHORTR_GET(x)        (((x) & SYNTH_SYNTH4_ALWAYS_SHORTR_MASK) >> SYNTH_SYNTH4_ALWAYS_SHORTR_LSB)
#define SYNTH_SYNTH4_ALWAYS_SHORTR_SET(x)        (((x) << SYNTH_SYNTH4_ALWAYS_SHORTR_LSB) & SYNTH_SYNTH4_ALWAYS_SHORTR_MASK)
#define SYNTH_SYNTH4_SHORTR_UNTIL_LOCKED_MSB     28
#define SYNTH_SYNTH4_SHORTR_UNTIL_LOCKED_LSB     28
#define SYNTH_SYNTH4_SHORTR_UNTIL_LOCKED_MASK    0x10000000
#define SYNTH_SYNTH4_SHORTR_UNTIL_LOCKED_GET(x)  (((x) & SYNTH_SYNTH4_SHORTR_UNTIL_LOCKED_MASK) >> SYNTH_SYNTH4_SHORTR_UNTIL_LOCKED_LSB)
#define SYNTH_SYNTH4_SHORTR_UNTIL_LOCKED_SET(x)  (((x) << SYNTH_SYNTH4_SHORTR_UNTIL_LOCKED_LSB) & SYNTH_SYNTH4_SHORTR_UNTIL_LOCKED_MASK)
#define SYNTH_SYNTH4_FORCE_PINVC_MSB             27
#define SYNTH_SYNTH4_FORCE_PINVC_LSB             27
#define SYNTH_SYNTH4_FORCE_PINVC_MASK            0x08000000
#define SYNTH_SYNTH4_FORCE_PINVC_GET(x)          (((x) & SYNTH_SYNTH4_FORCE_PINVC_MASK) >> SYNTH_SYNTH4_FORCE_PINVC_LSB)
#define SYNTH_SYNTH4_FORCE_PINVC_SET(x)          (((x) << SYNTH_SYNTH4_FORCE_PINVC_LSB) & SYNTH_SYNTH4_FORCE_PINVC_MASK)
#define SYNTH_SYNTH4_FORCE_VCOCAP_MSB            26
#define SYNTH_SYNTH4_FORCE_VCOCAP_LSB            26
#define SYNTH_SYNTH4_FORCE_VCOCAP_MASK           0x04000000
#define SYNTH_SYNTH4_FORCE_VCOCAP_GET(x)         (((x) & SYNTH_SYNTH4_FORCE_VCOCAP_MASK) >> SYNTH_SYNTH4_FORCE_VCOCAP_LSB)
#define SYNTH_SYNTH4_FORCE_VCOCAP_SET(x)         (((x) << SYNTH_SYNTH4_FORCE_VCOCAP_LSB) & SYNTH_SYNTH4_FORCE_VCOCAP_MASK)
#define SYNTH_SYNTH4_VCOCAP_OVR_MSB              25
#define SYNTH_SYNTH4_VCOCAP_OVR_LSB              18
#define SYNTH_SYNTH4_VCOCAP_OVR_MASK             0x03fc0000
#define SYNTH_SYNTH4_VCOCAP_OVR_GET(x)           (((x) & SYNTH_SYNTH4_VCOCAP_OVR_MASK) >> SYNTH_SYNTH4_VCOCAP_OVR_LSB)
#define SYNTH_SYNTH4_VCOCAP_OVR_SET(x)           (((x) << SYNTH_SYNTH4_VCOCAP_OVR_LSB) & SYNTH_SYNTH4_VCOCAP_OVR_MASK)
#define SYNTH_SYNTH4_VCOCAPPULLUP_MSB            17
#define SYNTH_SYNTH4_VCOCAPPULLUP_LSB            17
#define SYNTH_SYNTH4_VCOCAPPULLUP_MASK           0x00020000
#define SYNTH_SYNTH4_VCOCAPPULLUP_GET(x)         (((x) & SYNTH_SYNTH4_VCOCAPPULLUP_MASK) >> SYNTH_SYNTH4_VCOCAPPULLUP_LSB)
#define SYNTH_SYNTH4_VCOCAPPULLUP_SET(x)         (((x) << SYNTH_SYNTH4_VCOCAPPULLUP_LSB) & SYNTH_SYNTH4_VCOCAPPULLUP_MASK)
#define SYNTH_SYNTH4_REFDIVSEL_MSB               16
#define SYNTH_SYNTH4_REFDIVSEL_LSB               15
#define SYNTH_SYNTH4_REFDIVSEL_MASK              0x00018000
#define SYNTH_SYNTH4_REFDIVSEL_GET(x)            (((x) & SYNTH_SYNTH4_REFDIVSEL_MASK) >> SYNTH_SYNTH4_REFDIVSEL_LSB)
#define SYNTH_SYNTH4_REFDIVSEL_SET(x)            (((x) << SYNTH_SYNTH4_REFDIVSEL_LSB) & SYNTH_SYNTH4_REFDIVSEL_MASK)
#define SYNTH_SYNTH4_PFDDELAY_MSB                14
#define SYNTH_SYNTH4_PFDDELAY_LSB                14
#define SYNTH_SYNTH4_PFDDELAY_MASK               0x00004000
#define SYNTH_SYNTH4_PFDDELAY_GET(x)             (((x) & SYNTH_SYNTH4_PFDDELAY_MASK) >> SYNTH_SYNTH4_PFDDELAY_LSB)
#define SYNTH_SYNTH4_PFDDELAY_SET(x)             (((x) << SYNTH_SYNTH4_PFDDELAY_LSB) & SYNTH_SYNTH4_PFDDELAY_MASK)
#define SYNTH_SYNTH4_PFD_DISABLE_MSB             13
#define SYNTH_SYNTH4_PFD_DISABLE_LSB             13
#define SYNTH_SYNTH4_PFD_DISABLE_MASK            0x00002000
#define SYNTH_SYNTH4_PFD_DISABLE_GET(x)          (((x) & SYNTH_SYNTH4_PFD_DISABLE_MASK) >> SYNTH_SYNTH4_PFD_DISABLE_LSB)
#define SYNTH_SYNTH4_PFD_DISABLE_SET(x)          (((x) << SYNTH_SYNTH4_PFD_DISABLE_LSB) & SYNTH_SYNTH4_PFD_DISABLE_MASK)
#define SYNTH_SYNTH4_PRESCSEL_MSB                12
#define SYNTH_SYNTH4_PRESCSEL_LSB                11
#define SYNTH_SYNTH4_PRESCSEL_MASK               0x00001800
#define SYNTH_SYNTH4_PRESCSEL_GET(x)             (((x) & SYNTH_SYNTH4_PRESCSEL_MASK) >> SYNTH_SYNTH4_PRESCSEL_LSB)
#define SYNTH_SYNTH4_PRESCSEL_SET(x)             (((x) << SYNTH_SYNTH4_PRESCSEL_LSB) & SYNTH_SYNTH4_PRESCSEL_MASK)
#define SYNTH_SYNTH4_RESET_PRESC_MSB             10
#define SYNTH_SYNTH4_RESET_PRESC_LSB             10
#define SYNTH_SYNTH4_RESET_PRESC_MASK            0x00000400
#define SYNTH_SYNTH4_RESET_PRESC_GET(x)          (((x) & SYNTH_SYNTH4_RESET_PRESC_MASK) >> SYNTH_SYNTH4_RESET_PRESC_LSB)
#define SYNTH_SYNTH4_RESET_PRESC_SET(x)          (((x) << SYNTH_SYNTH4_RESET_PRESC_LSB) & SYNTH_SYNTH4_RESET_PRESC_MASK)
#define SYNTH_SYNTH4_SDM_DISABLE_MSB             9
#define SYNTH_SYNTH4_SDM_DISABLE_LSB             9
#define SYNTH_SYNTH4_SDM_DISABLE_MASK            0x00000200
#define SYNTH_SYNTH4_SDM_DISABLE_GET(x)          (((x) & SYNTH_SYNTH4_SDM_DISABLE_MASK) >> SYNTH_SYNTH4_SDM_DISABLE_LSB)
#define SYNTH_SYNTH4_SDM_DISABLE_SET(x)          (((x) << SYNTH_SYNTH4_SDM_DISABLE_LSB) & SYNTH_SYNTH4_SDM_DISABLE_MASK)
#define SYNTH_SYNTH4_SDM_MODE_MSB                8
#define SYNTH_SYNTH4_SDM_MODE_LSB                8
#define SYNTH_SYNTH4_SDM_MODE_MASK               0x00000100
#define SYNTH_SYNTH4_SDM_MODE_GET(x)             (((x) & SYNTH_SYNTH4_SDM_MODE_MASK) >> SYNTH_SYNTH4_SDM_MODE_LSB)
#define SYNTH_SYNTH4_SDM_MODE_SET(x)             (((x) << SYNTH_SYNTH4_SDM_MODE_LSB) & SYNTH_SYNTH4_SDM_MODE_MASK)
#define SYNTH_SYNTH4_SDM_DITHER_MSB              7
#define SYNTH_SYNTH4_SDM_DITHER_LSB              6
#define SYNTH_SYNTH4_SDM_DITHER_MASK             0x000000c0
#define SYNTH_SYNTH4_SDM_DITHER_GET(x)           (((x) & SYNTH_SYNTH4_SDM_DITHER_MASK) >> SYNTH_SYNTH4_SDM_DITHER_LSB)
#define SYNTH_SYNTH4_SDM_DITHER_SET(x)           (((x) << SYNTH_SYNTH4_SDM_DITHER_LSB) & SYNTH_SYNTH4_SDM_DITHER_MASK)
#define SYNTH_SYNTH4_PSCOUNT_FBSEL_MSB           5
#define SYNTH_SYNTH4_PSCOUNT_FBSEL_LSB           5
#define SYNTH_SYNTH4_PSCOUNT_FBSEL_MASK          0x00000020
#define SYNTH_SYNTH4_PSCOUNT_FBSEL_GET(x)        (((x) & SYNTH_SYNTH4_PSCOUNT_FBSEL_MASK) >> SYNTH_SYNTH4_PSCOUNT_FBSEL_LSB)
#define SYNTH_SYNTH4_PSCOUNT_FBSEL_SET(x)        (((x) << SYNTH_SYNTH4_PSCOUNT_FBSEL_LSB) & SYNTH_SYNTH4_PSCOUNT_FBSEL_MASK)
#define SYNTH_SYNTH4_SEL_CLKXTAL_EDGE_MSB        4
#define SYNTH_SYNTH4_SEL_CLKXTAL_EDGE_LSB        4
#define SYNTH_SYNTH4_SEL_CLKXTAL_EDGE_MASK       0x00000010
#define SYNTH_SYNTH4_SEL_CLKXTAL_EDGE_GET(x)     (((x) & SYNTH_SYNTH4_SEL_CLKXTAL_EDGE_MASK) >> SYNTH_SYNTH4_SEL_CLKXTAL_EDGE_LSB)
#define SYNTH_SYNTH4_SEL_CLKXTAL_EDGE_SET(x)     (((x) << SYNTH_SYNTH4_SEL_CLKXTAL_EDGE_LSB) & SYNTH_SYNTH4_SEL_CLKXTAL_EDGE_MASK)
#define SYNTH_SYNTH4_SPARE_MISC_MSB              3
#define SYNTH_SYNTH4_SPARE_MISC_LSB              2
#define SYNTH_SYNTH4_SPARE_MISC_MASK             0x0000000c
#define SYNTH_SYNTH4_SPARE_MISC_GET(x)           (((x) & SYNTH_SYNTH4_SPARE_MISC_MASK) >> SYNTH_SYNTH4_SPARE_MISC_LSB)
#define SYNTH_SYNTH4_SPARE_MISC_SET(x)           (((x) << SYNTH_SYNTH4_SPARE_MISC_LSB) & SYNTH_SYNTH4_SPARE_MISC_MASK)
#define SYNTH_SYNTH4_LONGSHIFTSEL_MSB            1
#define SYNTH_SYNTH4_LONGSHIFTSEL_LSB            1
#define SYNTH_SYNTH4_LONGSHIFTSEL_MASK           0x00000002
#define SYNTH_SYNTH4_LONGSHIFTSEL_GET(x)         (((x) & SYNTH_SYNTH4_LONGSHIFTSEL_MASK) >> SYNTH_SYNTH4_LONGSHIFTSEL_LSB)
#define SYNTH_SYNTH4_LONGSHIFTSEL_SET(x)         (((x) << SYNTH_SYNTH4_LONGSHIFTSEL_LSB) & SYNTH_SYNTH4_LONGSHIFTSEL_MASK)
#define SYNTH_SYNTH4_FORCE_SHIFTREG_MSB          0
#define SYNTH_SYNTH4_FORCE_SHIFTREG_LSB          0
#define SYNTH_SYNTH4_FORCE_SHIFTREG_MASK         0x00000001
#define SYNTH_SYNTH4_FORCE_SHIFTREG_GET(x)       (((x) & SYNTH_SYNTH4_FORCE_SHIFTREG_MASK) >> SYNTH_SYNTH4_FORCE_SHIFTREG_LSB)
#define SYNTH_SYNTH4_FORCE_SHIFTREG_SET(x)       (((x) << SYNTH_SYNTH4_FORCE_SHIFTREG_LSB) & SYNTH_SYNTH4_FORCE_SHIFTREG_MASK)

#define SYNTH_SYNTH5_ADDRESS                     0x00000010
#define SYNTH_SYNTH5_OFFSET                      0x00000010
#define SYNTH_SYNTH5_LOOP_IP0_MSB                31
#define SYNTH_SYNTH5_LOOP_IP0_LSB                28
#define SYNTH_SYNTH5_LOOP_IP0_MASK               0xf0000000
#define SYNTH_SYNTH5_LOOP_IP0_GET(x)             (((x) & SYNTH_SYNTH5_LOOP_IP0_MASK) >> SYNTH_SYNTH5_LOOP_IP0_LSB)
#define SYNTH_SYNTH5_LOOP_IP0_SET(x)             (((x) << SYNTH_SYNTH5_LOOP_IP0_LSB) & SYNTH_SYNTH5_LOOP_IP0_MASK)
#define SYNTH_SYNTH5_SLOPE_IP_MSB                27
#define SYNTH_SYNTH5_SLOPE_IP_LSB                25
#define SYNTH_SYNTH5_SLOPE_IP_MASK               0x0e000000
#define SYNTH_SYNTH5_SLOPE_IP_GET(x)             (((x) & SYNTH_SYNTH5_SLOPE_IP_MASK) >> SYNTH_SYNTH5_SLOPE_IP_LSB)
#define SYNTH_SYNTH5_SLOPE_IP_SET(x)             (((x) << SYNTH_SYNTH5_SLOPE_IP_LSB) & SYNTH_SYNTH5_SLOPE_IP_MASK)
#define SYNTH_SYNTH5_CPBIAS_MSB                  24
#define SYNTH_SYNTH5_CPBIAS_LSB                  23
#define SYNTH_SYNTH5_CPBIAS_MASK                 0x01800000
#define SYNTH_SYNTH5_CPBIAS_GET(x)               (((x) & SYNTH_SYNTH5_CPBIAS_MASK) >> SYNTH_SYNTH5_CPBIAS_LSB)
#define SYNTH_SYNTH5_CPBIAS_SET(x)               (((x) << SYNTH_SYNTH5_CPBIAS_LSB) & SYNTH_SYNTH5_CPBIAS_MASK)
#define SYNTH_SYNTH5_CPSTEERING_EN_MSB           22
#define SYNTH_SYNTH5_CPSTEERING_EN_LSB           22
#define SYNTH_SYNTH5_CPSTEERING_EN_MASK          0x00400000
#define SYNTH_SYNTH5_CPSTEERING_EN_GET(x)        (((x) & SYNTH_SYNTH5_CPSTEERING_EN_MASK) >> SYNTH_SYNTH5_CPSTEERING_EN_LSB)
#define SYNTH_SYNTH5_CPSTEERING_EN_SET(x)        (((x) << SYNTH_SYNTH5_CPSTEERING_EN_LSB) & SYNTH_SYNTH5_CPSTEERING_EN_MASK)
#define SYNTH_SYNTH5_CPLOWLK_MSB                 21
#define SYNTH_SYNTH5_CPLOWLK_LSB                 21
#define SYNTH_SYNTH5_CPLOWLK_MASK                0x00200000
#define SYNTH_SYNTH5_CPLOWLK_GET(x)              (((x) & SYNTH_SYNTH5_CPLOWLK_MASK) >> SYNTH_SYNTH5_CPLOWLK_LSB)
#define SYNTH_SYNTH5_CPLOWLK_SET(x)              (((x) << SYNTH_SYNTH5_CPLOWLK_LSB) & SYNTH_SYNTH5_CPLOWLK_MASK)
#define SYNTH_SYNTH5_LOOPLEAKCUR_MSB             20
#define SYNTH_SYNTH5_LOOPLEAKCUR_LSB             17
#define SYNTH_SYNTH5_LOOPLEAKCUR_MASK            0x001e0000
#define SYNTH_SYNTH5_LOOPLEAKCUR_GET(x)          (((x) & SYNTH_SYNTH5_LOOPLEAKCUR_MASK) >> SYNTH_SYNTH5_LOOPLEAKCUR_LSB)
#define SYNTH_SYNTH5_LOOPLEAKCUR_SET(x)          (((x) << SYNTH_SYNTH5_LOOPLEAKCUR_LSB) & SYNTH_SYNTH5_LOOPLEAKCUR_MASK)
#define SYNTH_SYNTH5_CAPRANGE1_MSB               16
#define SYNTH_SYNTH5_CAPRANGE1_LSB               13
#define SYNTH_SYNTH5_CAPRANGE1_MASK              0x0001e000
#define SYNTH_SYNTH5_CAPRANGE1_GET(x)            (((x) & SYNTH_SYNTH5_CAPRANGE1_MASK) >> SYNTH_SYNTH5_CAPRANGE1_LSB)
#define SYNTH_SYNTH5_CAPRANGE1_SET(x)            (((x) << SYNTH_SYNTH5_CAPRANGE1_LSB) & SYNTH_SYNTH5_CAPRANGE1_MASK)
#define SYNTH_SYNTH5_CAPRANGE2_MSB               12
#define SYNTH_SYNTH5_CAPRANGE2_LSB               9
#define SYNTH_SYNTH5_CAPRANGE2_MASK              0x00001e00
#define SYNTH_SYNTH5_CAPRANGE2_GET(x)            (((x) & SYNTH_SYNTH5_CAPRANGE2_MASK) >> SYNTH_SYNTH5_CAPRANGE2_LSB)
#define SYNTH_SYNTH5_CAPRANGE2_SET(x)            (((x) << SYNTH_SYNTH5_CAPRANGE2_LSB) & SYNTH_SYNTH5_CAPRANGE2_MASK)
#define SYNTH_SYNTH5_CAPRANGE3_MSB               8
#define SYNTH_SYNTH5_CAPRANGE3_LSB               5
#define SYNTH_SYNTH5_CAPRANGE3_MASK              0x000001e0
#define SYNTH_SYNTH5_CAPRANGE3_GET(x)            (((x) & SYNTH_SYNTH5_CAPRANGE3_MASK) >> SYNTH_SYNTH5_CAPRANGE3_LSB)
#define SYNTH_SYNTH5_CAPRANGE3_SET(x)            (((x) << SYNTH_SYNTH5_CAPRANGE3_LSB) & SYNTH_SYNTH5_CAPRANGE3_MASK)
#define SYNTH_SYNTH5_FORCE_LOBUF5GTUNE_MSB       4
#define SYNTH_SYNTH5_FORCE_LOBUF5GTUNE_LSB       4
#define SYNTH_SYNTH5_FORCE_LOBUF5GTUNE_MASK      0x00000010
#define SYNTH_SYNTH5_FORCE_LOBUF5GTUNE_GET(x)    (((x) & SYNTH_SYNTH5_FORCE_LOBUF5GTUNE_MASK) >> SYNTH_SYNTH5_FORCE_LOBUF5GTUNE_LSB)
#define SYNTH_SYNTH5_FORCE_LOBUF5GTUNE_SET(x)    (((x) << SYNTH_SYNTH5_FORCE_LOBUF5GTUNE_LSB) & SYNTH_SYNTH5_FORCE_LOBUF5GTUNE_MASK)
#define SYNTH_SYNTH5_LOBUF5GTUNE_OVR_MSB         3
#define SYNTH_SYNTH5_LOBUF5GTUNE_OVR_LSB         2
#define SYNTH_SYNTH5_LOBUF5GTUNE_OVR_MASK        0x0000000c
#define SYNTH_SYNTH5_LOBUF5GTUNE_OVR_GET(x)      (((x) & SYNTH_SYNTH5_LOBUF5GTUNE_OVR_MASK) >> SYNTH_SYNTH5_LOBUF5GTUNE_OVR_LSB)
#define SYNTH_SYNTH5_LOBUF5GTUNE_OVR_SET(x)      (((x) << SYNTH_SYNTH5_LOBUF5GTUNE_OVR_LSB) & SYNTH_SYNTH5_LOBUF5GTUNE_OVR_MASK)
#define SYNTH_SYNTH5_SPARE_MSB                   1
#define SYNTH_SYNTH5_SPARE_LSB                   0
#define SYNTH_SYNTH5_SPARE_MASK                  0x00000003
#define SYNTH_SYNTH5_SPARE_GET(x)                (((x) & SYNTH_SYNTH5_SPARE_MASK) >> SYNTH_SYNTH5_SPARE_LSB)
#define SYNTH_SYNTH5_SPARE_SET(x)                (((x) << SYNTH_SYNTH5_SPARE_LSB) & SYNTH_SYNTH5_SPARE_MASK)

#define SYNTH_SYNTH6_ADDRESS                     0x00000014
#define SYNTH_SYNTH6_OFFSET                      0x00000014
#define SYNTH_SYNTH6_IRCP_MSB                    31
#define SYNTH_SYNTH6_IRCP_LSB                    29
#define SYNTH_SYNTH6_IRCP_MASK                   0xe0000000
#define SYNTH_SYNTH6_IRCP_GET(x)                 (((x) & SYNTH_SYNTH6_IRCP_MASK) >> SYNTH_SYNTH6_IRCP_LSB)
#define SYNTH_SYNTH6_IRCP_SET(x)                 (((x) << SYNTH_SYNTH6_IRCP_LSB) & SYNTH_SYNTH6_IRCP_MASK)
#define SYNTH_SYNTH6_IRVCMON_MSB                 28
#define SYNTH_SYNTH6_IRVCMON_LSB                 26
#define SYNTH_SYNTH6_IRVCMON_MASK                0x1c000000
#define SYNTH_SYNTH6_IRVCMON_GET(x)              (((x) & SYNTH_SYNTH6_IRVCMON_MASK) >> SYNTH_SYNTH6_IRVCMON_LSB)
#define SYNTH_SYNTH6_IRVCMON_SET(x)              (((x) << SYNTH_SYNTH6_IRVCMON_LSB) & SYNTH_SYNTH6_IRVCMON_MASK)
#define SYNTH_SYNTH6_IRSPARE_MSB                 25
#define SYNTH_SYNTH6_IRSPARE_LSB                 23
#define SYNTH_SYNTH6_IRSPARE_MASK                0x03800000
#define SYNTH_SYNTH6_IRSPARE_GET(x)              (((x) & SYNTH_SYNTH6_IRSPARE_MASK) >> SYNTH_SYNTH6_IRSPARE_LSB)
#define SYNTH_SYNTH6_IRSPARE_SET(x)              (((x) << SYNTH_SYNTH6_IRSPARE_LSB) & SYNTH_SYNTH6_IRSPARE_MASK)
#define SYNTH_SYNTH6_ICPRESC_MSB                 22
#define SYNTH_SYNTH6_ICPRESC_LSB                 20
#define SYNTH_SYNTH6_ICPRESC_MASK                0x00700000
#define SYNTH_SYNTH6_ICPRESC_GET(x)              (((x) & SYNTH_SYNTH6_ICPRESC_MASK) >> SYNTH_SYNTH6_ICPRESC_LSB)
#define SYNTH_SYNTH6_ICPRESC_SET(x)              (((x) << SYNTH_SYNTH6_ICPRESC_LSB) & SYNTH_SYNTH6_ICPRESC_MASK)
#define SYNTH_SYNTH6_ICLODIV_MSB                 19
#define SYNTH_SYNTH6_ICLODIV_LSB                 17
#define SYNTH_SYNTH6_ICLODIV_MASK                0x000e0000
#define SYNTH_SYNTH6_ICLODIV_GET(x)              (((x) & SYNTH_SYNTH6_ICLODIV_MASK) >> SYNTH_SYNTH6_ICLODIV_LSB)
#define SYNTH_SYNTH6_ICLODIV_SET(x)              (((x) << SYNTH_SYNTH6_ICLODIV_LSB) & SYNTH_SYNTH6_ICLODIV_MASK)
#define SYNTH_SYNTH6_ICLOMIX_MSB                 16
#define SYNTH_SYNTH6_ICLOMIX_LSB                 14
#define SYNTH_SYNTH6_ICLOMIX_MASK                0x0001c000
#define SYNTH_SYNTH6_ICLOMIX_GET(x)              (((x) & SYNTH_SYNTH6_ICLOMIX_MASK) >> SYNTH_SYNTH6_ICLOMIX_LSB)
#define SYNTH_SYNTH6_ICLOMIX_SET(x)              (((x) << SYNTH_SYNTH6_ICLOMIX_LSB) & SYNTH_SYNTH6_ICLOMIX_MASK)
#define SYNTH_SYNTH6_ICSPAREA_MSB                13
#define SYNTH_SYNTH6_ICSPAREA_LSB                11
#define SYNTH_SYNTH6_ICSPAREA_MASK               0x00003800
#define SYNTH_SYNTH6_ICSPAREA_GET(x)             (((x) & SYNTH_SYNTH6_ICSPAREA_MASK) >> SYNTH_SYNTH6_ICSPAREA_LSB)
#define SYNTH_SYNTH6_ICSPAREA_SET(x)             (((x) << SYNTH_SYNTH6_ICSPAREA_LSB) & SYNTH_SYNTH6_ICSPAREA_MASK)
#define SYNTH_SYNTH6_ICSPAREB_MSB                10
#define SYNTH_SYNTH6_ICSPAREB_LSB                8
#define SYNTH_SYNTH6_ICSPAREB_MASK               0x00000700
#define SYNTH_SYNTH6_ICSPAREB_GET(x)             (((x) & SYNTH_SYNTH6_ICSPAREB_MASK) >> SYNTH_SYNTH6_ICSPAREB_LSB)
#define SYNTH_SYNTH6_ICSPAREB_SET(x)             (((x) << SYNTH_SYNTH6_ICSPAREB_LSB) & SYNTH_SYNTH6_ICSPAREB_MASK)
#define SYNTH_SYNTH6_ICVCO_MSB                   7
#define SYNTH_SYNTH6_ICVCO_LSB                   5
#define SYNTH_SYNTH6_ICVCO_MASK                  0x000000e0
#define SYNTH_SYNTH6_ICVCO_GET(x)                (((x) & SYNTH_SYNTH6_ICVCO_MASK) >> SYNTH_SYNTH6_ICVCO_LSB)
#define SYNTH_SYNTH6_ICVCO_SET(x)                (((x) << SYNTH_SYNTH6_ICVCO_LSB) & SYNTH_SYNTH6_ICVCO_MASK)
#define SYNTH_SYNTH6_VCOBUFBIAS_MSB              4
#define SYNTH_SYNTH6_VCOBUFBIAS_LSB              3
#define SYNTH_SYNTH6_VCOBUFBIAS_MASK             0x00000018
#define SYNTH_SYNTH6_VCOBUFBIAS_GET(x)           (((x) & SYNTH_SYNTH6_VCOBUFBIAS_MASK) >> SYNTH_SYNTH6_VCOBUFBIAS_LSB)
#define SYNTH_SYNTH6_VCOBUFBIAS_SET(x)           (((x) << SYNTH_SYNTH6_VCOBUFBIAS_LSB) & SYNTH_SYNTH6_VCOBUFBIAS_MASK)
#define SYNTH_SYNTH6_SPARE_BIAS_MSB              2
#define SYNTH_SYNTH6_SPARE_BIAS_LSB              0
#define SYNTH_SYNTH6_SPARE_BIAS_MASK             0x00000007
#define SYNTH_SYNTH6_SPARE_BIAS_GET(x)           (((x) & SYNTH_SYNTH6_SPARE_BIAS_MASK) >> SYNTH_SYNTH6_SPARE_BIAS_LSB)
#define SYNTH_SYNTH6_SPARE_BIAS_SET(x)           (((x) << SYNTH_SYNTH6_SPARE_BIAS_LSB) & SYNTH_SYNTH6_SPARE_BIAS_MASK)

#define SYNTH_SYNTH7_ADDRESS                     0x00000018
#define SYNTH_SYNTH7_OFFSET                      0x00000018
#define SYNTH_SYNTH7_SYNTH_ON_MSB                31
#define SYNTH_SYNTH7_SYNTH_ON_LSB                31
#define SYNTH_SYNTH7_SYNTH_ON_MASK               0x80000000
#define SYNTH_SYNTH7_SYNTH_ON_GET(x)             (((x) & SYNTH_SYNTH7_SYNTH_ON_MASK) >> SYNTH_SYNTH7_SYNTH_ON_LSB)
#define SYNTH_SYNTH7_SYNTH_ON_SET(x)             (((x) << SYNTH_SYNTH7_SYNTH_ON_LSB) & SYNTH_SYNTH7_SYNTH_ON_MASK)
#define SYNTH_SYNTH7_SYNTH_SM_STATE_MSB          30
#define SYNTH_SYNTH7_SYNTH_SM_STATE_LSB          27
#define SYNTH_SYNTH7_SYNTH_SM_STATE_MASK         0x78000000
#define SYNTH_SYNTH7_SYNTH_SM_STATE_GET(x)       (((x) & SYNTH_SYNTH7_SYNTH_SM_STATE_MASK) >> SYNTH_SYNTH7_SYNTH_SM_STATE_LSB)
#define SYNTH_SYNTH7_SYNTH_SM_STATE_SET(x)       (((x) << SYNTH_SYNTH7_SYNTH_SM_STATE_LSB) & SYNTH_SYNTH7_SYNTH_SM_STATE_MASK)
#define SYNTH_SYNTH7_CAP_SEARCH_MSB              26
#define SYNTH_SYNTH7_CAP_SEARCH_LSB              26
#define SYNTH_SYNTH7_CAP_SEARCH_MASK             0x04000000
#define SYNTH_SYNTH7_CAP_SEARCH_GET(x)           (((x) & SYNTH_SYNTH7_CAP_SEARCH_MASK) >> SYNTH_SYNTH7_CAP_SEARCH_LSB)
#define SYNTH_SYNTH7_CAP_SEARCH_SET(x)           (((x) << SYNTH_SYNTH7_CAP_SEARCH_LSB) & SYNTH_SYNTH7_CAP_SEARCH_MASK)
#define SYNTH_SYNTH7_SYNTH_LOCK_VC_OK_MSB        25
#define SYNTH_SYNTH7_SYNTH_LOCK_VC_OK_LSB        25
#define SYNTH_SYNTH7_SYNTH_LOCK_VC_OK_MASK       0x02000000
#define SYNTH_SYNTH7_SYNTH_LOCK_VC_OK_GET(x)     (((x) & SYNTH_SYNTH7_SYNTH_LOCK_VC_OK_MASK) >> SYNTH_SYNTH7_SYNTH_LOCK_VC_OK_LSB)
#define SYNTH_SYNTH7_SYNTH_LOCK_VC_OK_SET(x)     (((x) << SYNTH_SYNTH7_SYNTH_LOCK_VC_OK_LSB) & SYNTH_SYNTH7_SYNTH_LOCK_VC_OK_MASK)
#define SYNTH_SYNTH7_PIN_VC_MSB                  24
#define SYNTH_SYNTH7_PIN_VC_LSB                  24
#define SYNTH_SYNTH7_PIN_VC_MASK                 0x01000000
#define SYNTH_SYNTH7_PIN_VC_GET(x)               (((x) & SYNTH_SYNTH7_PIN_VC_MASK) >> SYNTH_SYNTH7_PIN_VC_LSB)
#define SYNTH_SYNTH7_PIN_VC_SET(x)               (((x) << SYNTH_SYNTH7_PIN_VC_LSB) & SYNTH_SYNTH7_PIN_VC_MASK)
#define SYNTH_SYNTH7_VCO_CAP_ST_MSB              23
#define SYNTH_SYNTH7_VCO_CAP_ST_LSB              16
#define SYNTH_SYNTH7_VCO_CAP_ST_MASK             0x00ff0000
#define SYNTH_SYNTH7_VCO_CAP_ST_GET(x)           (((x) & SYNTH_SYNTH7_VCO_CAP_ST_MASK) >> SYNTH_SYNTH7_VCO_CAP_ST_LSB)
#define SYNTH_SYNTH7_VCO_CAP_ST_SET(x)           (((x) << SYNTH_SYNTH7_VCO_CAP_ST_LSB) & SYNTH_SYNTH7_VCO_CAP_ST_MASK)
#define SYNTH_SYNTH7_SHORT_R_MSB                 15
#define SYNTH_SYNTH7_SHORT_R_LSB                 15
#define SYNTH_SYNTH7_SHORT_R_MASK                0x00008000
#define SYNTH_SYNTH7_SHORT_R_GET(x)              (((x) & SYNTH_SYNTH7_SHORT_R_MASK) >> SYNTH_SYNTH7_SHORT_R_LSB)
#define SYNTH_SYNTH7_SHORT_R_SET(x)              (((x) << SYNTH_SYNTH7_SHORT_R_LSB) & SYNTH_SYNTH7_SHORT_R_MASK)
#define SYNTH_SYNTH7_RESET_RFD_MSB               14
#define SYNTH_SYNTH7_RESET_RFD_LSB               14
#define SYNTH_SYNTH7_RESET_RFD_MASK              0x00004000
#define SYNTH_SYNTH7_RESET_RFD_GET(x)            (((x) & SYNTH_SYNTH7_RESET_RFD_MASK) >> SYNTH_SYNTH7_RESET_RFD_LSB)
#define SYNTH_SYNTH7_RESET_RFD_SET(x)            (((x) << SYNTH_SYNTH7_RESET_RFD_LSB) & SYNTH_SYNTH7_RESET_RFD_MASK)
#define SYNTH_SYNTH7_RESET_PFD_MSB               13
#define SYNTH_SYNTH7_RESET_PFD_LSB               13
#define SYNTH_SYNTH7_RESET_PFD_MASK              0x00002000
#define SYNTH_SYNTH7_RESET_PFD_GET(x)            (((x) & SYNTH_SYNTH7_RESET_PFD_MASK) >> SYNTH_SYNTH7_RESET_PFD_LSB)
#define SYNTH_SYNTH7_RESET_PFD_SET(x)            (((x) << SYNTH_SYNTH7_RESET_PFD_LSB) & SYNTH_SYNTH7_RESET_PFD_MASK)
#define SYNTH_SYNTH7_RESET_PSCOUNTERS_MSB        12
#define SYNTH_SYNTH7_RESET_PSCOUNTERS_LSB        12
#define SYNTH_SYNTH7_RESET_PSCOUNTERS_MASK       0x00001000
#define SYNTH_SYNTH7_RESET_PSCOUNTERS_GET(x)     (((x) & SYNTH_SYNTH7_RESET_PSCOUNTERS_MASK) >> SYNTH_SYNTH7_RESET_PSCOUNTERS_LSB)
#define SYNTH_SYNTH7_RESET_PSCOUNTERS_SET(x)     (((x) << SYNTH_SYNTH7_RESET_PSCOUNTERS_LSB) & SYNTH_SYNTH7_RESET_PSCOUNTERS_MASK)
#define SYNTH_SYNTH7_RESET_SDM_B_MSB             11
#define SYNTH_SYNTH7_RESET_SDM_B_LSB             11
#define SYNTH_SYNTH7_RESET_SDM_B_MASK            0x00000800
#define SYNTH_SYNTH7_RESET_SDM_B_GET(x)          (((x) & SYNTH_SYNTH7_RESET_SDM_B_MASK) >> SYNTH_SYNTH7_RESET_SDM_B_LSB)
#define SYNTH_SYNTH7_RESET_SDM_B_SET(x)          (((x) << SYNTH_SYNTH7_RESET_SDM_B_LSB) & SYNTH_SYNTH7_RESET_SDM_B_MASK)
#define SYNTH_SYNTH7_VC2HIGH_MSB                 10
#define SYNTH_SYNTH7_VC2HIGH_LSB                 10
#define SYNTH_SYNTH7_VC2HIGH_MASK                0x00000400
#define SYNTH_SYNTH7_VC2HIGH_GET(x)              (((x) & SYNTH_SYNTH7_VC2HIGH_MASK) >> SYNTH_SYNTH7_VC2HIGH_LSB)
#define SYNTH_SYNTH7_VC2HIGH_SET(x)              (((x) << SYNTH_SYNTH7_VC2HIGH_LSB) & SYNTH_SYNTH7_VC2HIGH_MASK)
#define SYNTH_SYNTH7_VC2LOW_MSB                  9
#define SYNTH_SYNTH7_VC2LOW_LSB                  9
#define SYNTH_SYNTH7_VC2LOW_MASK                 0x00000200
#define SYNTH_SYNTH7_VC2LOW_GET(x)               (((x) & SYNTH_SYNTH7_VC2LOW_MASK) >> SYNTH_SYNTH7_VC2LOW_LSB)
#define SYNTH_SYNTH7_VC2LOW_SET(x)               (((x) << SYNTH_SYNTH7_VC2LOW_LSB) & SYNTH_SYNTH7_VC2LOW_MASK)
#define SYNTH_SYNTH7_LOOP_IP_MSB                 8
#define SYNTH_SYNTH7_LOOP_IP_LSB                 5
#define SYNTH_SYNTH7_LOOP_IP_MASK                0x000001e0
#define SYNTH_SYNTH7_LOOP_IP_GET(x)              (((x) & SYNTH_SYNTH7_LOOP_IP_MASK) >> SYNTH_SYNTH7_LOOP_IP_LSB)
#define SYNTH_SYNTH7_LOOP_IP_SET(x)              (((x) << SYNTH_SYNTH7_LOOP_IP_LSB) & SYNTH_SYNTH7_LOOP_IP_MASK)
#define SYNTH_SYNTH7_LOBUF5GTUNE_MSB             4
#define SYNTH_SYNTH7_LOBUF5GTUNE_LSB             3
#define SYNTH_SYNTH7_LOBUF5GTUNE_MASK            0x00000018
#define SYNTH_SYNTH7_LOBUF5GTUNE_GET(x)          (((x) & SYNTH_SYNTH7_LOBUF5GTUNE_MASK) >> SYNTH_SYNTH7_LOBUF5GTUNE_LSB)
#define SYNTH_SYNTH7_LOBUF5GTUNE_SET(x)          (((x) << SYNTH_SYNTH7_LOBUF5GTUNE_LSB) & SYNTH_SYNTH7_LOBUF5GTUNE_MASK)
#define SYNTH_SYNTH7_SPARE_READ_MSB              2
#define SYNTH_SYNTH7_SPARE_READ_LSB              0
#define SYNTH_SYNTH7_SPARE_READ_MASK             0x00000007
#define SYNTH_SYNTH7_SPARE_READ_GET(x)           (((x) & SYNTH_SYNTH7_SPARE_READ_MASK) >> SYNTH_SYNTH7_SPARE_READ_LSB)
#define SYNTH_SYNTH7_SPARE_READ_SET(x)           (((x) << SYNTH_SYNTH7_SPARE_READ_LSB) & SYNTH_SYNTH7_SPARE_READ_MASK)

#define SYNTH_SYNTH8_ADDRESS                     0x0000001c
#define SYNTH_SYNTH8_OFFSET                      0x0000001c
#define SYNTH_SYNTH8_LOADSYNTHCHANNEL_MSB        31
#define SYNTH_SYNTH8_LOADSYNTHCHANNEL_LSB        31
#define SYNTH_SYNTH8_LOADSYNTHCHANNEL_MASK       0x80000000
#define SYNTH_SYNTH8_LOADSYNTHCHANNEL_GET(x)     (((x) & SYNTH_SYNTH8_LOADSYNTHCHANNEL_MASK) >> SYNTH_SYNTH8_LOADSYNTHCHANNEL_LSB)
#define SYNTH_SYNTH8_LOADSYNTHCHANNEL_SET(x)     (((x) << SYNTH_SYNTH8_LOADSYNTHCHANNEL_LSB) & SYNTH_SYNTH8_LOADSYNTHCHANNEL_MASK)
#define SYNTH_SYNTH8_FRACMODE_MSB                30
#define SYNTH_SYNTH8_FRACMODE_LSB                30
#define SYNTH_SYNTH8_FRACMODE_MASK               0x40000000
#define SYNTH_SYNTH8_FRACMODE_GET(x)             (((x) & SYNTH_SYNTH8_FRACMODE_MASK) >> SYNTH_SYNTH8_FRACMODE_LSB)
#define SYNTH_SYNTH8_FRACMODE_SET(x)             (((x) << SYNTH_SYNTH8_FRACMODE_LSB) & SYNTH_SYNTH8_FRACMODE_MASK)
#define SYNTH_SYNTH8_AMODEREFSEL_MSB             29
#define SYNTH_SYNTH8_AMODEREFSEL_LSB             28
#define SYNTH_SYNTH8_AMODEREFSEL_MASK            0x30000000
#define SYNTH_SYNTH8_AMODEREFSEL_GET(x)          (((x) & SYNTH_SYNTH8_AMODEREFSEL_MASK) >> SYNTH_SYNTH8_AMODEREFSEL_LSB)
#define SYNTH_SYNTH8_AMODEREFSEL_SET(x)          (((x) << SYNTH_SYNTH8_AMODEREFSEL_LSB) & SYNTH_SYNTH8_AMODEREFSEL_MASK)
#define SYNTH_SYNTH8_SPARE_MSB                   27
#define SYNTH_SYNTH8_SPARE_LSB                   27
#define SYNTH_SYNTH8_SPARE_MASK                  0x08000000
#define SYNTH_SYNTH8_SPARE_GET(x)                (((x) & SYNTH_SYNTH8_SPARE_MASK) >> SYNTH_SYNTH8_SPARE_LSB)
#define SYNTH_SYNTH8_SPARE_SET(x)                (((x) << SYNTH_SYNTH8_SPARE_LSB) & SYNTH_SYNTH8_SPARE_MASK)
#define SYNTH_SYNTH8_CHANSEL_MSB                 26
#define SYNTH_SYNTH8_CHANSEL_LSB                 18
#define SYNTH_SYNTH8_CHANSEL_MASK                0x07fc0000
#define SYNTH_SYNTH8_CHANSEL_GET(x)              (((x) & SYNTH_SYNTH8_CHANSEL_MASK) >> SYNTH_SYNTH8_CHANSEL_LSB)
#define SYNTH_SYNTH8_CHANSEL_SET(x)              (((x) << SYNTH_SYNTH8_CHANSEL_LSB) & SYNTH_SYNTH8_CHANSEL_MASK)
#define SYNTH_SYNTH8_CHANFRAC_MSB                17
#define SYNTH_SYNTH8_CHANFRAC_LSB                1
#define SYNTH_SYNTH8_CHANFRAC_MASK               0x0003fffe
#define SYNTH_SYNTH8_CHANFRAC_GET(x)             (((x) & SYNTH_SYNTH8_CHANFRAC_MASK) >> SYNTH_SYNTH8_CHANFRAC_LSB)
#define SYNTH_SYNTH8_CHANFRAC_SET(x)             (((x) << SYNTH_SYNTH8_CHANFRAC_LSB) & SYNTH_SYNTH8_CHANFRAC_MASK)
#define SYNTH_SYNTH8_FORCE_FRACLSB_MSB           0
#define SYNTH_SYNTH8_FORCE_FRACLSB_LSB           0
#define SYNTH_SYNTH8_FORCE_FRACLSB_MASK          0x00000001
#define SYNTH_SYNTH8_FORCE_FRACLSB_GET(x)        (((x) & SYNTH_SYNTH8_FORCE_FRACLSB_MASK) >> SYNTH_SYNTH8_FORCE_FRACLSB_LSB)
#define SYNTH_SYNTH8_FORCE_FRACLSB_SET(x)        (((x) << SYNTH_SYNTH8_FORCE_FRACLSB_LSB) & SYNTH_SYNTH8_FORCE_FRACLSB_MASK)


#ifndef __ASSEMBLER__

typedef struct synth_reg_reg_s {
  volatile unsigned int synth_synth1;
  volatile unsigned int synth_synth2;
  volatile unsigned int synth_synth3;
  volatile unsigned int synth_synth4;
  volatile unsigned int synth_synth5;
  volatile unsigned int synth_synth6;
  volatile unsigned int synth_synth7;
  volatile unsigned int synth_synth8;
} synth_reg_reg_t;

#endif /* __ASSEMBLER__ */

#endif /* _SYNTH_REG_H_ */
