// ------------------------------------------------------------------
// Copyright (c) 2004-2007 Atheros Corporation.  All rights reserved.
// 
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//
// ------------------------------------------------------------------
//===================================================================
// Author(s): ="Atheros"
//===================================================================


#ifndef _GPIO_ATHR_WLAN_REG_REG_H_
#define _GPIO_ATHR_WLAN_REG_REG_H_

#define WLAN_GPIO_OUT_LOW_ADDRESS                0x00000000
#define WLAN_GPIO_OUT_LOW_OFFSET                 0x00000000
#define WLAN_GPIO_OUT_LOW_DATA_MSB               31
#define WLAN_GPIO_OUT_LOW_DATA_LSB               0
#define WLAN_GPIO_OUT_LOW_DATA_MASK              0xffffffff
#define WLAN_GPIO_OUT_LOW_DATA_GET(x)            (((x) & WLAN_GPIO_OUT_LOW_DATA_MASK) >> WLAN_GPIO_OUT_LOW_DATA_LSB)
#define WLAN_GPIO_OUT_LOW_DATA_SET(x)            (((x) << WLAN_GPIO_OUT_LOW_DATA_LSB) & WLAN_GPIO_OUT_LOW_DATA_MASK)

#define WLAN_GPIO_OUT_W1TS_LOW_ADDRESS           0x00000004
#define WLAN_GPIO_OUT_W1TS_LOW_OFFSET            0x00000004
#define WLAN_GPIO_OUT_W1TS_LOW_DATA_MSB          31
#define WLAN_GPIO_OUT_W1TS_LOW_DATA_LSB          0
#define WLAN_GPIO_OUT_W1TS_LOW_DATA_MASK         0xffffffff
#define WLAN_GPIO_OUT_W1TS_LOW_DATA_GET(x)       (((x) & WLAN_GPIO_OUT_W1TS_LOW_DATA_MASK) >> WLAN_GPIO_OUT_W1TS_LOW_DATA_LSB)
#define WLAN_GPIO_OUT_W1TS_LOW_DATA_SET(x)       (((x) << WLAN_GPIO_OUT_W1TS_LOW_DATA_LSB) & WLAN_GPIO_OUT_W1TS_LOW_DATA_MASK)

#define WLAN_GPIO_OUT_W1TC_LOW_ADDRESS           0x00000008
#define WLAN_GPIO_OUT_W1TC_LOW_OFFSET            0x00000008
#define WLAN_GPIO_OUT_W1TC_LOW_DATA_MSB          31
#define WLAN_GPIO_OUT_W1TC_LOW_DATA_LSB          0
#define WLAN_GPIO_OUT_W1TC_LOW_DATA_MASK         0xffffffff
#define WLAN_GPIO_OUT_W1TC_LOW_DATA_GET(x)       (((x) & WLAN_GPIO_OUT_W1TC_LOW_DATA_MASK) >> WLAN_GPIO_OUT_W1TC_LOW_DATA_LSB)
#define WLAN_GPIO_OUT_W1TC_LOW_DATA_SET(x)       (((x) << WLAN_GPIO_OUT_W1TC_LOW_DATA_LSB) & WLAN_GPIO_OUT_W1TC_LOW_DATA_MASK)

#define WLAN_GPIO_OUT_HIGH_ADDRESS               0x0000000c
#define WLAN_GPIO_OUT_HIGH_OFFSET                0x0000000c
#define WLAN_GPIO_OUT_HIGH_DATA_MSB              31
#define WLAN_GPIO_OUT_HIGH_DATA_LSB              0
#define WLAN_GPIO_OUT_HIGH_DATA_MASK             0xffffffff
#define WLAN_GPIO_OUT_HIGH_DATA_GET(x)           (((x) & WLAN_GPIO_OUT_HIGH_DATA_MASK) >> WLAN_GPIO_OUT_HIGH_DATA_LSB)
#define WLAN_GPIO_OUT_HIGH_DATA_SET(x)           (((x) << WLAN_GPIO_OUT_HIGH_DATA_LSB) & WLAN_GPIO_OUT_HIGH_DATA_MASK)

#define WLAN_GPIO_OUT_W1TS_HIGH_ADDRESS          0x00000010
#define WLAN_GPIO_OUT_W1TS_HIGH_OFFSET           0x00000010
#define WLAN_GPIO_OUT_W1TS_HIGH_DATA_MSB         31
#define WLAN_GPIO_OUT_W1TS_HIGH_DATA_LSB         0
#define WLAN_GPIO_OUT_W1TS_HIGH_DATA_MASK        0xffffffff
#define WLAN_GPIO_OUT_W1TS_HIGH_DATA_GET(x)      (((x) & WLAN_GPIO_OUT_W1TS_HIGH_DATA_MASK) >> WLAN_GPIO_OUT_W1TS_HIGH_DATA_LSB)
#define WLAN_GPIO_OUT_W1TS_HIGH_DATA_SET(x)      (((x) << WLAN_GPIO_OUT_W1TS_HIGH_DATA_LSB) & WLAN_GPIO_OUT_W1TS_HIGH_DATA_MASK)

#define WLAN_GPIO_OUT_W1TC_HIGH_ADDRESS          0x00000014
#define WLAN_GPIO_OUT_W1TC_HIGH_OFFSET           0x00000014
#define WLAN_GPIO_OUT_W1TC_HIGH_DATA_MSB         31
#define WLAN_GPIO_OUT_W1TC_HIGH_DATA_LSB         0
#define WLAN_GPIO_OUT_W1TC_HIGH_DATA_MASK        0xffffffff
#define WLAN_GPIO_OUT_W1TC_HIGH_DATA_GET(x)      (((x) & WLAN_GPIO_OUT_W1TC_HIGH_DATA_MASK) >> WLAN_GPIO_OUT_W1TC_HIGH_DATA_LSB)
#define WLAN_GPIO_OUT_W1TC_HIGH_DATA_SET(x)      (((x) << WLAN_GPIO_OUT_W1TC_HIGH_DATA_LSB) & WLAN_GPIO_OUT_W1TC_HIGH_DATA_MASK)

#define WLAN_GPIO_ENABLE_LOW_ADDRESS             0x00000018
#define WLAN_GPIO_ENABLE_LOW_OFFSET              0x00000018
#define WLAN_GPIO_ENABLE_LOW_DATA_MSB            31
#define WLAN_GPIO_ENABLE_LOW_DATA_LSB            0
#define WLAN_GPIO_ENABLE_LOW_DATA_MASK           0xffffffff
#define WLAN_GPIO_ENABLE_LOW_DATA_GET(x)         (((x) & WLAN_GPIO_ENABLE_LOW_DATA_MASK) >> WLAN_GPIO_ENABLE_LOW_DATA_LSB)
#define WLAN_GPIO_ENABLE_LOW_DATA_SET(x)         (((x) << WLAN_GPIO_ENABLE_LOW_DATA_LSB) & WLAN_GPIO_ENABLE_LOW_DATA_MASK)

#define WLAN_GPIO_ENABLE_W1TS_LOW_ADDRESS        0x0000001c
#define WLAN_GPIO_ENABLE_W1TS_LOW_OFFSET         0x0000001c
#define WLAN_GPIO_ENABLE_W1TS_LOW_DATA_MSB       31
#define WLAN_GPIO_ENABLE_W1TS_LOW_DATA_LSB       0
#define WLAN_GPIO_ENABLE_W1TS_LOW_DATA_MASK      0xffffffff
#define WLAN_GPIO_ENABLE_W1TS_LOW_DATA_GET(x)    (((x) & WLAN_GPIO_ENABLE_W1TS_LOW_DATA_MASK) >> WLAN_GPIO_ENABLE_W1TS_LOW_DATA_LSB)
#define WLAN_GPIO_ENABLE_W1TS_LOW_DATA_SET(x)    (((x) << WLAN_GPIO_ENABLE_W1TS_LOW_DATA_LSB) & WLAN_GPIO_ENABLE_W1TS_LOW_DATA_MASK)

#define WLAN_GPIO_ENABLE_W1TC_LOW_ADDRESS        0x00000020
#define WLAN_GPIO_ENABLE_W1TC_LOW_OFFSET         0x00000020
#define WLAN_GPIO_ENABLE_W1TC_LOW_DATA_MSB       31
#define WLAN_GPIO_ENABLE_W1TC_LOW_DATA_LSB       0
#define WLAN_GPIO_ENABLE_W1TC_LOW_DATA_MASK      0xffffffff
#define WLAN_GPIO_ENABLE_W1TC_LOW_DATA_GET(x)    (((x) & WLAN_GPIO_ENABLE_W1TC_LOW_DATA_MASK) >> WLAN_GPIO_ENABLE_W1TC_LOW_DATA_LSB)
#define WLAN_GPIO_ENABLE_W1TC_LOW_DATA_SET(x)    (((x) << WLAN_GPIO_ENABLE_W1TC_LOW_DATA_LSB) & WLAN_GPIO_ENABLE_W1TC_LOW_DATA_MASK)

#define WLAN_GPIO_ENABLE_HIGH_ADDRESS            0x00000024
#define WLAN_GPIO_ENABLE_HIGH_OFFSET             0x00000024
#define WLAN_GPIO_ENABLE_HIGH_DATA_MSB           31
#define WLAN_GPIO_ENABLE_HIGH_DATA_LSB           0
#define WLAN_GPIO_ENABLE_HIGH_DATA_MASK          0xffffffff
#define WLAN_GPIO_ENABLE_HIGH_DATA_GET(x)        (((x) & WLAN_GPIO_ENABLE_HIGH_DATA_MASK) >> WLAN_GPIO_ENABLE_HIGH_DATA_LSB)
#define WLAN_GPIO_ENABLE_HIGH_DATA_SET(x)        (((x) << WLAN_GPIO_ENABLE_HIGH_DATA_LSB) & WLAN_GPIO_ENABLE_HIGH_DATA_MASK)

#define WLAN_GPIO_ENABLE_W1TS_HIGH_ADDRESS       0x00000028
#define WLAN_GPIO_ENABLE_W1TS_HIGH_OFFSET        0x00000028
#define WLAN_GPIO_ENABLE_W1TS_HIGH_DATA_MSB      31
#define WLAN_GPIO_ENABLE_W1TS_HIGH_DATA_LSB      0
#define WLAN_GPIO_ENABLE_W1TS_HIGH_DATA_MASK     0xffffffff
#define WLAN_GPIO_ENABLE_W1TS_HIGH_DATA_GET(x)   (((x) & WLAN_GPIO_ENABLE_W1TS_HIGH_DATA_MASK) >> WLAN_GPIO_ENABLE_W1TS_HIGH_DATA_LSB)
#define WLAN_GPIO_ENABLE_W1TS_HIGH_DATA_SET(x)   (((x) << WLAN_GPIO_ENABLE_W1TS_HIGH_DATA_LSB) & WLAN_GPIO_ENABLE_W1TS_HIGH_DATA_MASK)

#define WLAN_GPIO_ENABLE_W1TC_HIGH_ADDRESS       0x0000002c
#define WLAN_GPIO_ENABLE_W1TC_HIGH_OFFSET        0x0000002c
#define WLAN_GPIO_ENABLE_W1TC_HIGH_DATA_MSB      31
#define WLAN_GPIO_ENABLE_W1TC_HIGH_DATA_LSB      0
#define WLAN_GPIO_ENABLE_W1TC_HIGH_DATA_MASK     0xffffffff
#define WLAN_GPIO_ENABLE_W1TC_HIGH_DATA_GET(x)   (((x) & WLAN_GPIO_ENABLE_W1TC_HIGH_DATA_MASK) >> WLAN_GPIO_ENABLE_W1TC_HIGH_DATA_LSB)
#define WLAN_GPIO_ENABLE_W1TC_HIGH_DATA_SET(x)   (((x) << WLAN_GPIO_ENABLE_W1TC_HIGH_DATA_LSB) & WLAN_GPIO_ENABLE_W1TC_HIGH_DATA_MASK)

#define WLAN_GPIO_IN_LOW_ADDRESS                 0x00000030
#define WLAN_GPIO_IN_LOW_OFFSET                  0x00000030
#define WLAN_GPIO_IN_LOW_DATA_MSB                31
#define WLAN_GPIO_IN_LOW_DATA_LSB                0
#define WLAN_GPIO_IN_LOW_DATA_MASK               0xffffffff
#define WLAN_GPIO_IN_LOW_DATA_GET(x)             (((x) & WLAN_GPIO_IN_LOW_DATA_MASK) >> WLAN_GPIO_IN_LOW_DATA_LSB)
#define WLAN_GPIO_IN_LOW_DATA_SET(x)             (((x) << WLAN_GPIO_IN_LOW_DATA_LSB) & WLAN_GPIO_IN_LOW_DATA_MASK)

#define WLAN_GPIO_STATUS_LOW_ADDRESS             0x00000034
#define WLAN_GPIO_STATUS_LOW_OFFSET              0x00000034
#define WLAN_GPIO_STATUS_LOW_INTERRUPT_MSB       31
#define WLAN_GPIO_STATUS_LOW_INTERRUPT_LSB       0
#define WLAN_GPIO_STATUS_LOW_INTERRUPT_MASK      0xffffffff
#define WLAN_GPIO_STATUS_LOW_INTERRUPT_GET(x)    (((x) & WLAN_GPIO_STATUS_LOW_INTERRUPT_MASK) >> WLAN_GPIO_STATUS_LOW_INTERRUPT_LSB)
#define WLAN_GPIO_STATUS_LOW_INTERRUPT_SET(x)    (((x) << WLAN_GPIO_STATUS_LOW_INTERRUPT_LSB) & WLAN_GPIO_STATUS_LOW_INTERRUPT_MASK)

#define WLAN_GPIO_IN_HIGH_ADDRESS                0x00000038
#define WLAN_GPIO_IN_HIGH_OFFSET                 0x00000038
#define WLAN_GPIO_IN_HIGH_DATA_MSB               31
#define WLAN_GPIO_IN_HIGH_DATA_LSB               0
#define WLAN_GPIO_IN_HIGH_DATA_MASK              0xffffffff
#define WLAN_GPIO_IN_HIGH_DATA_GET(x)            (((x) & WLAN_GPIO_IN_HIGH_DATA_MASK) >> WLAN_GPIO_IN_HIGH_DATA_LSB)
#define WLAN_GPIO_IN_HIGH_DATA_SET(x)            (((x) << WLAN_GPIO_IN_HIGH_DATA_LSB) & WLAN_GPIO_IN_HIGH_DATA_MASK)

#define WLAN_GPIO_STATUS_HIGH_ADDRESS            0x0000003c
#define WLAN_GPIO_STATUS_HIGH_OFFSET             0x0000003c
#define WLAN_GPIO_STATUS_HIGH_INTERRUPT_MSB      31
#define WLAN_GPIO_STATUS_HIGH_INTERRUPT_LSB      0
#define WLAN_GPIO_STATUS_HIGH_INTERRUPT_MASK     0xffffffff
#define WLAN_GPIO_STATUS_HIGH_INTERRUPT_GET(x)   (((x) & WLAN_GPIO_STATUS_HIGH_INTERRUPT_MASK) >> WLAN_GPIO_STATUS_HIGH_INTERRUPT_LSB)
#define WLAN_GPIO_STATUS_HIGH_INTERRUPT_SET(x)   (((x) << WLAN_GPIO_STATUS_HIGH_INTERRUPT_LSB) & WLAN_GPIO_STATUS_HIGH_INTERRUPT_MASK)

#define WLAN_GPIO_STATUS_W1TS_LOW_ADDRESS        0x00000040
#define WLAN_GPIO_STATUS_W1TS_LOW_OFFSET         0x00000040
#define WLAN_GPIO_STATUS_W1TS_LOW_INTERRUPT_MSB  31
#define WLAN_GPIO_STATUS_W1TS_LOW_INTERRUPT_LSB  0
#define WLAN_GPIO_STATUS_W1TS_LOW_INTERRUPT_MASK 0xffffffff
#define WLAN_GPIO_STATUS_W1TS_LOW_INTERRUPT_GET(x) (((x) & WLAN_GPIO_STATUS_W1TS_LOW_INTERRUPT_MASK) >> WLAN_GPIO_STATUS_W1TS_LOW_INTERRUPT_LSB)
#define WLAN_GPIO_STATUS_W1TS_LOW_INTERRUPT_SET(x) (((x) << WLAN_GPIO_STATUS_W1TS_LOW_INTERRUPT_LSB) & WLAN_GPIO_STATUS_W1TS_LOW_INTERRUPT_MASK)

#define WLAN_GPIO_STATUS_W1TC_LOW_ADDRESS        0x00000044
#define WLAN_GPIO_STATUS_W1TC_LOW_OFFSET         0x00000044
#define WLAN_GPIO_STATUS_W1TC_LOW_INTERRUPT_MSB  31
#define WLAN_GPIO_STATUS_W1TC_LOW_INTERRUPT_LSB  0
#define WLAN_GPIO_STATUS_W1TC_LOW_INTERRUPT_MASK 0xffffffff
#define WLAN_GPIO_STATUS_W1TC_LOW_INTERRUPT_GET(x) (((x) & WLAN_GPIO_STATUS_W1TC_LOW_INTERRUPT_MASK) >> WLAN_GPIO_STATUS_W1TC_LOW_INTERRUPT_LSB)
#define WLAN_GPIO_STATUS_W1TC_LOW_INTERRUPT_SET(x) (((x) << WLAN_GPIO_STATUS_W1TC_LOW_INTERRUPT_LSB) & WLAN_GPIO_STATUS_W1TC_LOW_INTERRUPT_MASK)

#define WLAN_GPIO_STATUS_W1TS_HIGH_ADDRESS       0x00000048
#define WLAN_GPIO_STATUS_W1TS_HIGH_OFFSET        0x00000048
#define WLAN_GPIO_STATUS_W1TS_HIGH_INTERRUPT_MSB 31
#define WLAN_GPIO_STATUS_W1TS_HIGH_INTERRUPT_LSB 0
#define WLAN_GPIO_STATUS_W1TS_HIGH_INTERRUPT_MASK 0xffffffff
#define WLAN_GPIO_STATUS_W1TS_HIGH_INTERRUPT_GET(x) (((x) & WLAN_GPIO_STATUS_W1TS_HIGH_INTERRUPT_MASK) >> WLAN_GPIO_STATUS_W1TS_HIGH_INTERRUPT_LSB)
#define WLAN_GPIO_STATUS_W1TS_HIGH_INTERRUPT_SET(x) (((x) << WLAN_GPIO_STATUS_W1TS_HIGH_INTERRUPT_LSB) & WLAN_GPIO_STATUS_W1TS_HIGH_INTERRUPT_MASK)

#define WLAN_GPIO_STATUS_W1TC_HIGH_ADDRESS       0x0000004c
#define WLAN_GPIO_STATUS_W1TC_HIGH_OFFSET        0x0000004c
#define WLAN_GPIO_STATUS_W1TC_HIGH_INTERRUPT_MSB 31
#define WLAN_GPIO_STATUS_W1TC_HIGH_INTERRUPT_LSB 0
#define WLAN_GPIO_STATUS_W1TC_HIGH_INTERRUPT_MASK 0xffffffff
#define WLAN_GPIO_STATUS_W1TC_HIGH_INTERRUPT_GET(x) (((x) & WLAN_GPIO_STATUS_W1TC_HIGH_INTERRUPT_MASK) >> WLAN_GPIO_STATUS_W1TC_HIGH_INTERRUPT_LSB)
#define WLAN_GPIO_STATUS_W1TC_HIGH_INTERRUPT_SET(x) (((x) << WLAN_GPIO_STATUS_W1TC_HIGH_INTERRUPT_LSB) & WLAN_GPIO_STATUS_W1TC_HIGH_INTERRUPT_MASK)

#define WLAN_GPIO_PIN0_ADDRESS                   0x00000050
#define WLAN_GPIO_PIN0_OFFSET                    0x00000050
#define WLAN_GPIO_PIN0_CONFIG_MSB                14
#define WLAN_GPIO_PIN0_CONFIG_LSB                11
#define WLAN_GPIO_PIN0_CONFIG_MASK               0x00007800
#define WLAN_GPIO_PIN0_CONFIG_GET(x)             (((x) & WLAN_GPIO_PIN0_CONFIG_MASK) >> WLAN_GPIO_PIN0_CONFIG_LSB)
#define WLAN_GPIO_PIN0_CONFIG_SET(x)             (((x) << WLAN_GPIO_PIN0_CONFIG_LSB) & WLAN_GPIO_PIN0_CONFIG_MASK)
#define WLAN_GPIO_PIN0_WAKEUP_ENABLE_MSB         10
#define WLAN_GPIO_PIN0_WAKEUP_ENABLE_LSB         10
#define WLAN_GPIO_PIN0_WAKEUP_ENABLE_MASK        0x00000400
#define WLAN_GPIO_PIN0_WAKEUP_ENABLE_GET(x)      (((x) & WLAN_GPIO_PIN0_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN0_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN0_WAKEUP_ENABLE_SET(x)      (((x) << WLAN_GPIO_PIN0_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN0_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN0_INT_TYPE_MSB              9
#define WLAN_GPIO_PIN0_INT_TYPE_LSB              7
#define WLAN_GPIO_PIN0_INT_TYPE_MASK             0x00000380
#define WLAN_GPIO_PIN0_INT_TYPE_GET(x)           (((x) & WLAN_GPIO_PIN0_INT_TYPE_MASK) >> WLAN_GPIO_PIN0_INT_TYPE_LSB)
#define WLAN_GPIO_PIN0_INT_TYPE_SET(x)           (((x) << WLAN_GPIO_PIN0_INT_TYPE_LSB) & WLAN_GPIO_PIN0_INT_TYPE_MASK)
#define WLAN_GPIO_PIN0_PAD_PULL_MSB              6
#define WLAN_GPIO_PIN0_PAD_PULL_LSB              5
#define WLAN_GPIO_PIN0_PAD_PULL_MASK             0x00000060
#define WLAN_GPIO_PIN0_PAD_PULL_GET(x)           (((x) & WLAN_GPIO_PIN0_PAD_PULL_MASK) >> WLAN_GPIO_PIN0_PAD_PULL_LSB)
#define WLAN_GPIO_PIN0_PAD_PULL_SET(x)           (((x) << WLAN_GPIO_PIN0_PAD_PULL_LSB) & WLAN_GPIO_PIN0_PAD_PULL_MASK)
#define WLAN_GPIO_PIN0_PAD_STRENGTH_MSB          4
#define WLAN_GPIO_PIN0_PAD_STRENGTH_LSB          3
#define WLAN_GPIO_PIN0_PAD_STRENGTH_MASK         0x00000018
#define WLAN_GPIO_PIN0_PAD_STRENGTH_GET(x)       (((x) & WLAN_GPIO_PIN0_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN0_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN0_PAD_STRENGTH_SET(x)       (((x) << WLAN_GPIO_PIN0_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN0_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN0_PAD_DRIVER_MSB            2
#define WLAN_GPIO_PIN0_PAD_DRIVER_LSB            2
#define WLAN_GPIO_PIN0_PAD_DRIVER_MASK           0x00000004
#define WLAN_GPIO_PIN0_PAD_DRIVER_GET(x)         (((x) & WLAN_GPIO_PIN0_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN0_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN0_PAD_DRIVER_SET(x)         (((x) << WLAN_GPIO_PIN0_PAD_DRIVER_LSB) & WLAN_GPIO_PIN0_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN0_SOURCE_MSB                0
#define WLAN_GPIO_PIN0_SOURCE_LSB                0
#define WLAN_GPIO_PIN0_SOURCE_MASK               0x00000001
#define WLAN_GPIO_PIN0_SOURCE_GET(x)             (((x) & WLAN_GPIO_PIN0_SOURCE_MASK) >> WLAN_GPIO_PIN0_SOURCE_LSB)
#define WLAN_GPIO_PIN0_SOURCE_SET(x)             (((x) << WLAN_GPIO_PIN0_SOURCE_LSB) & WLAN_GPIO_PIN0_SOURCE_MASK)

#define WLAN_GPIO_PIN1_ADDRESS                   0x00000054
#define WLAN_GPIO_PIN1_OFFSET                    0x00000054
#define WLAN_GPIO_PIN1_CONFIG_MSB                14
#define WLAN_GPIO_PIN1_CONFIG_LSB                11
#define WLAN_GPIO_PIN1_CONFIG_MASK               0x00007800
#define WLAN_GPIO_PIN1_CONFIG_GET(x)             (((x) & WLAN_GPIO_PIN1_CONFIG_MASK) >> WLAN_GPIO_PIN1_CONFIG_LSB)
#define WLAN_GPIO_PIN1_CONFIG_SET(x)             (((x) << WLAN_GPIO_PIN1_CONFIG_LSB) & WLAN_GPIO_PIN1_CONFIG_MASK)
#define WLAN_GPIO_PIN1_WAKEUP_ENABLE_MSB         10
#define WLAN_GPIO_PIN1_WAKEUP_ENABLE_LSB         10
#define WLAN_GPIO_PIN1_WAKEUP_ENABLE_MASK        0x00000400
#define WLAN_GPIO_PIN1_WAKEUP_ENABLE_GET(x)      (((x) & WLAN_GPIO_PIN1_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN1_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN1_WAKEUP_ENABLE_SET(x)      (((x) << WLAN_GPIO_PIN1_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN1_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN1_INT_TYPE_MSB              9
#define WLAN_GPIO_PIN1_INT_TYPE_LSB              7
#define WLAN_GPIO_PIN1_INT_TYPE_MASK             0x00000380
#define WLAN_GPIO_PIN1_INT_TYPE_GET(x)           (((x) & WLAN_GPIO_PIN1_INT_TYPE_MASK) >> WLAN_GPIO_PIN1_INT_TYPE_LSB)
#define WLAN_GPIO_PIN1_INT_TYPE_SET(x)           (((x) << WLAN_GPIO_PIN1_INT_TYPE_LSB) & WLAN_GPIO_PIN1_INT_TYPE_MASK)
#define WLAN_GPIO_PIN1_PAD_PULL_MSB              6
#define WLAN_GPIO_PIN1_PAD_PULL_LSB              5
#define WLAN_GPIO_PIN1_PAD_PULL_MASK             0x00000060
#define WLAN_GPIO_PIN1_PAD_PULL_GET(x)           (((x) & WLAN_GPIO_PIN1_PAD_PULL_MASK) >> WLAN_GPIO_PIN1_PAD_PULL_LSB)
#define WLAN_GPIO_PIN1_PAD_PULL_SET(x)           (((x) << WLAN_GPIO_PIN1_PAD_PULL_LSB) & WLAN_GPIO_PIN1_PAD_PULL_MASK)
#define WLAN_GPIO_PIN1_PAD_STRENGTH_MSB          4
#define WLAN_GPIO_PIN1_PAD_STRENGTH_LSB          3
#define WLAN_GPIO_PIN1_PAD_STRENGTH_MASK         0x00000018
#define WLAN_GPIO_PIN1_PAD_STRENGTH_GET(x)       (((x) & WLAN_GPIO_PIN1_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN1_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN1_PAD_STRENGTH_SET(x)       (((x) << WLAN_GPIO_PIN1_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN1_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN1_PAD_DRIVER_MSB            2
#define WLAN_GPIO_PIN1_PAD_DRIVER_LSB            2
#define WLAN_GPIO_PIN1_PAD_DRIVER_MASK           0x00000004
#define WLAN_GPIO_PIN1_PAD_DRIVER_GET(x)         (((x) & WLAN_GPIO_PIN1_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN1_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN1_PAD_DRIVER_SET(x)         (((x) << WLAN_GPIO_PIN1_PAD_DRIVER_LSB) & WLAN_GPIO_PIN1_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN1_SOURCE_MSB                0
#define WLAN_GPIO_PIN1_SOURCE_LSB                0
#define WLAN_GPIO_PIN1_SOURCE_MASK               0x00000001
#define WLAN_GPIO_PIN1_SOURCE_GET(x)             (((x) & WLAN_GPIO_PIN1_SOURCE_MASK) >> WLAN_GPIO_PIN1_SOURCE_LSB)
#define WLAN_GPIO_PIN1_SOURCE_SET(x)             (((x) << WLAN_GPIO_PIN1_SOURCE_LSB) & WLAN_GPIO_PIN1_SOURCE_MASK)

#define WLAN_GPIO_PIN2_ADDRESS                   0x00000058
#define WLAN_GPIO_PIN2_OFFSET                    0x00000058
#define WLAN_GPIO_PIN2_CONFIG_MSB                14
#define WLAN_GPIO_PIN2_CONFIG_LSB                11
#define WLAN_GPIO_PIN2_CONFIG_MASK               0x00007800
#define WLAN_GPIO_PIN2_CONFIG_GET(x)             (((x) & WLAN_GPIO_PIN2_CONFIG_MASK) >> WLAN_GPIO_PIN2_CONFIG_LSB)
#define WLAN_GPIO_PIN2_CONFIG_SET(x)             (((x) << WLAN_GPIO_PIN2_CONFIG_LSB) & WLAN_GPIO_PIN2_CONFIG_MASK)
#define WLAN_GPIO_PIN2_WAKEUP_ENABLE_MSB         10
#define WLAN_GPIO_PIN2_WAKEUP_ENABLE_LSB         10
#define WLAN_GPIO_PIN2_WAKEUP_ENABLE_MASK        0x00000400
#define WLAN_GPIO_PIN2_WAKEUP_ENABLE_GET(x)      (((x) & WLAN_GPIO_PIN2_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN2_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN2_WAKEUP_ENABLE_SET(x)      (((x) << WLAN_GPIO_PIN2_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN2_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN2_INT_TYPE_MSB              9
#define WLAN_GPIO_PIN2_INT_TYPE_LSB              7
#define WLAN_GPIO_PIN2_INT_TYPE_MASK             0x00000380
#define WLAN_GPIO_PIN2_INT_TYPE_GET(x)           (((x) & WLAN_GPIO_PIN2_INT_TYPE_MASK) >> WLAN_GPIO_PIN2_INT_TYPE_LSB)
#define WLAN_GPIO_PIN2_INT_TYPE_SET(x)           (((x) << WLAN_GPIO_PIN2_INT_TYPE_LSB) & WLAN_GPIO_PIN2_INT_TYPE_MASK)
#define WLAN_GPIO_PIN2_PAD_PULL_MSB              6
#define WLAN_GPIO_PIN2_PAD_PULL_LSB              5
#define WLAN_GPIO_PIN2_PAD_PULL_MASK             0x00000060
#define WLAN_GPIO_PIN2_PAD_PULL_GET(x)           (((x) & WLAN_GPIO_PIN2_PAD_PULL_MASK) >> WLAN_GPIO_PIN2_PAD_PULL_LSB)
#define WLAN_GPIO_PIN2_PAD_PULL_SET(x)           (((x) << WLAN_GPIO_PIN2_PAD_PULL_LSB) & WLAN_GPIO_PIN2_PAD_PULL_MASK)
#define WLAN_GPIO_PIN2_PAD_STRENGTH_MSB          4
#define WLAN_GPIO_PIN2_PAD_STRENGTH_LSB          3
#define WLAN_GPIO_PIN2_PAD_STRENGTH_MASK         0x00000018
#define WLAN_GPIO_PIN2_PAD_STRENGTH_GET(x)       (((x) & WLAN_GPIO_PIN2_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN2_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN2_PAD_STRENGTH_SET(x)       (((x) << WLAN_GPIO_PIN2_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN2_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN2_PAD_DRIVER_MSB            2
#define WLAN_GPIO_PIN2_PAD_DRIVER_LSB            2
#define WLAN_GPIO_PIN2_PAD_DRIVER_MASK           0x00000004
#define WLAN_GPIO_PIN2_PAD_DRIVER_GET(x)         (((x) & WLAN_GPIO_PIN2_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN2_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN2_PAD_DRIVER_SET(x)         (((x) << WLAN_GPIO_PIN2_PAD_DRIVER_LSB) & WLAN_GPIO_PIN2_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN2_SOURCE_MSB                0
#define WLAN_GPIO_PIN2_SOURCE_LSB                0
#define WLAN_GPIO_PIN2_SOURCE_MASK               0x00000001
#define WLAN_GPIO_PIN2_SOURCE_GET(x)             (((x) & WLAN_GPIO_PIN2_SOURCE_MASK) >> WLAN_GPIO_PIN2_SOURCE_LSB)
#define WLAN_GPIO_PIN2_SOURCE_SET(x)             (((x) << WLAN_GPIO_PIN2_SOURCE_LSB) & WLAN_GPIO_PIN2_SOURCE_MASK)

#define WLAN_GPIO_PIN3_ADDRESS                   0x0000005c
#define WLAN_GPIO_PIN3_OFFSET                    0x0000005c
#define WLAN_GPIO_PIN3_CONFIG_MSB                14
#define WLAN_GPIO_PIN3_CONFIG_LSB                11
#define WLAN_GPIO_PIN3_CONFIG_MASK               0x00007800
#define WLAN_GPIO_PIN3_CONFIG_GET(x)             (((x) & WLAN_GPIO_PIN3_CONFIG_MASK) >> WLAN_GPIO_PIN3_CONFIG_LSB)
#define WLAN_GPIO_PIN3_CONFIG_SET(x)             (((x) << WLAN_GPIO_PIN3_CONFIG_LSB) & WLAN_GPIO_PIN3_CONFIG_MASK)
#define WLAN_GPIO_PIN3_WAKEUP_ENABLE_MSB         10
#define WLAN_GPIO_PIN3_WAKEUP_ENABLE_LSB         10
#define WLAN_GPIO_PIN3_WAKEUP_ENABLE_MASK        0x00000400
#define WLAN_GPIO_PIN3_WAKEUP_ENABLE_GET(x)      (((x) & WLAN_GPIO_PIN3_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN3_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN3_WAKEUP_ENABLE_SET(x)      (((x) << WLAN_GPIO_PIN3_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN3_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN3_INT_TYPE_MSB              9
#define WLAN_GPIO_PIN3_INT_TYPE_LSB              7
#define WLAN_GPIO_PIN3_INT_TYPE_MASK             0x00000380
#define WLAN_GPIO_PIN3_INT_TYPE_GET(x)           (((x) & WLAN_GPIO_PIN3_INT_TYPE_MASK) >> WLAN_GPIO_PIN3_INT_TYPE_LSB)
#define WLAN_GPIO_PIN3_INT_TYPE_SET(x)           (((x) << WLAN_GPIO_PIN3_INT_TYPE_LSB) & WLAN_GPIO_PIN3_INT_TYPE_MASK)
#define WLAN_GPIO_PIN3_PAD_PULL_MSB              6
#define WLAN_GPIO_PIN3_PAD_PULL_LSB              5
#define WLAN_GPIO_PIN3_PAD_PULL_MASK             0x00000060
#define WLAN_GPIO_PIN3_PAD_PULL_GET(x)           (((x) & WLAN_GPIO_PIN3_PAD_PULL_MASK) >> WLAN_GPIO_PIN3_PAD_PULL_LSB)
#define WLAN_GPIO_PIN3_PAD_PULL_SET(x)           (((x) << WLAN_GPIO_PIN3_PAD_PULL_LSB) & WLAN_GPIO_PIN3_PAD_PULL_MASK)
#define WLAN_GPIO_PIN3_PAD_STRENGTH_MSB          4
#define WLAN_GPIO_PIN3_PAD_STRENGTH_LSB          3
#define WLAN_GPIO_PIN3_PAD_STRENGTH_MASK         0x00000018
#define WLAN_GPIO_PIN3_PAD_STRENGTH_GET(x)       (((x) & WLAN_GPIO_PIN3_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN3_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN3_PAD_STRENGTH_SET(x)       (((x) << WLAN_GPIO_PIN3_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN3_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN3_PAD_DRIVER_MSB            2
#define WLAN_GPIO_PIN3_PAD_DRIVER_LSB            2
#define WLAN_GPIO_PIN3_PAD_DRIVER_MASK           0x00000004
#define WLAN_GPIO_PIN3_PAD_DRIVER_GET(x)         (((x) & WLAN_GPIO_PIN3_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN3_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN3_PAD_DRIVER_SET(x)         (((x) << WLAN_GPIO_PIN3_PAD_DRIVER_LSB) & WLAN_GPIO_PIN3_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN3_SOURCE_MSB                0
#define WLAN_GPIO_PIN3_SOURCE_LSB                0
#define WLAN_GPIO_PIN3_SOURCE_MASK               0x00000001
#define WLAN_GPIO_PIN3_SOURCE_GET(x)             (((x) & WLAN_GPIO_PIN3_SOURCE_MASK) >> WLAN_GPIO_PIN3_SOURCE_LSB)
#define WLAN_GPIO_PIN3_SOURCE_SET(x)             (((x) << WLAN_GPIO_PIN3_SOURCE_LSB) & WLAN_GPIO_PIN3_SOURCE_MASK)

#define WLAN_GPIO_PIN4_ADDRESS                   0x00000060
#define WLAN_GPIO_PIN4_OFFSET                    0x00000060
#define WLAN_GPIO_PIN4_CONFIG_MSB                14
#define WLAN_GPIO_PIN4_CONFIG_LSB                11
#define WLAN_GPIO_PIN4_CONFIG_MASK               0x00007800
#define WLAN_GPIO_PIN4_CONFIG_GET(x)             (((x) & WLAN_GPIO_PIN4_CONFIG_MASK) >> WLAN_GPIO_PIN4_CONFIG_LSB)
#define WLAN_GPIO_PIN4_CONFIG_SET(x)             (((x) << WLAN_GPIO_PIN4_CONFIG_LSB) & WLAN_GPIO_PIN4_CONFIG_MASK)
#define WLAN_GPIO_PIN4_WAKEUP_ENABLE_MSB         10
#define WLAN_GPIO_PIN4_WAKEUP_ENABLE_LSB         10
#define WLAN_GPIO_PIN4_WAKEUP_ENABLE_MASK        0x00000400
#define WLAN_GPIO_PIN4_WAKEUP_ENABLE_GET(x)      (((x) & WLAN_GPIO_PIN4_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN4_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN4_WAKEUP_ENABLE_SET(x)      (((x) << WLAN_GPIO_PIN4_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN4_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN4_INT_TYPE_MSB              9
#define WLAN_GPIO_PIN4_INT_TYPE_LSB              7
#define WLAN_GPIO_PIN4_INT_TYPE_MASK             0x00000380
#define WLAN_GPIO_PIN4_INT_TYPE_GET(x)           (((x) & WLAN_GPIO_PIN4_INT_TYPE_MASK) >> WLAN_GPIO_PIN4_INT_TYPE_LSB)
#define WLAN_GPIO_PIN4_INT_TYPE_SET(x)           (((x) << WLAN_GPIO_PIN4_INT_TYPE_LSB) & WLAN_GPIO_PIN4_INT_TYPE_MASK)
#define WLAN_GPIO_PIN4_PAD_PULL_MSB              6
#define WLAN_GPIO_PIN4_PAD_PULL_LSB              5
#define WLAN_GPIO_PIN4_PAD_PULL_MASK             0x00000060
#define WLAN_GPIO_PIN4_PAD_PULL_GET(x)           (((x) & WLAN_GPIO_PIN4_PAD_PULL_MASK) >> WLAN_GPIO_PIN4_PAD_PULL_LSB)
#define WLAN_GPIO_PIN4_PAD_PULL_SET(x)           (((x) << WLAN_GPIO_PIN4_PAD_PULL_LSB) & WLAN_GPIO_PIN4_PAD_PULL_MASK)
#define WLAN_GPIO_PIN4_PAD_STRENGTH_MSB          4
#define WLAN_GPIO_PIN4_PAD_STRENGTH_LSB          3
#define WLAN_GPIO_PIN4_PAD_STRENGTH_MASK         0x00000018
#define WLAN_GPIO_PIN4_PAD_STRENGTH_GET(x)       (((x) & WLAN_GPIO_PIN4_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN4_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN4_PAD_STRENGTH_SET(x)       (((x) << WLAN_GPIO_PIN4_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN4_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN4_PAD_DRIVER_MSB            2
#define WLAN_GPIO_PIN4_PAD_DRIVER_LSB            2
#define WLAN_GPIO_PIN4_PAD_DRIVER_MASK           0x00000004
#define WLAN_GPIO_PIN4_PAD_DRIVER_GET(x)         (((x) & WLAN_GPIO_PIN4_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN4_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN4_PAD_DRIVER_SET(x)         (((x) << WLAN_GPIO_PIN4_PAD_DRIVER_LSB) & WLAN_GPIO_PIN4_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN4_SOURCE_MSB                0
#define WLAN_GPIO_PIN4_SOURCE_LSB                0
#define WLAN_GPIO_PIN4_SOURCE_MASK               0x00000001
#define WLAN_GPIO_PIN4_SOURCE_GET(x)             (((x) & WLAN_GPIO_PIN4_SOURCE_MASK) >> WLAN_GPIO_PIN4_SOURCE_LSB)
#define WLAN_GPIO_PIN4_SOURCE_SET(x)             (((x) << WLAN_GPIO_PIN4_SOURCE_LSB) & WLAN_GPIO_PIN4_SOURCE_MASK)

#define WLAN_GPIO_PIN5_ADDRESS                   0x00000064
#define WLAN_GPIO_PIN5_OFFSET                    0x00000064
#define WLAN_GPIO_PIN5_CONFIG_MSB                14
#define WLAN_GPIO_PIN5_CONFIG_LSB                11
#define WLAN_GPIO_PIN5_CONFIG_MASK               0x00007800
#define WLAN_GPIO_PIN5_CONFIG_GET(x)             (((x) & WLAN_GPIO_PIN5_CONFIG_MASK) >> WLAN_GPIO_PIN5_CONFIG_LSB)
#define WLAN_GPIO_PIN5_CONFIG_SET(x)             (((x) << WLAN_GPIO_PIN5_CONFIG_LSB) & WLAN_GPIO_PIN5_CONFIG_MASK)
#define WLAN_GPIO_PIN5_WAKEUP_ENABLE_MSB         10
#define WLAN_GPIO_PIN5_WAKEUP_ENABLE_LSB         10
#define WLAN_GPIO_PIN5_WAKEUP_ENABLE_MASK        0x00000400
#define WLAN_GPIO_PIN5_WAKEUP_ENABLE_GET(x)      (((x) & WLAN_GPIO_PIN5_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN5_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN5_WAKEUP_ENABLE_SET(x)      (((x) << WLAN_GPIO_PIN5_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN5_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN5_INT_TYPE_MSB              9
#define WLAN_GPIO_PIN5_INT_TYPE_LSB              7
#define WLAN_GPIO_PIN5_INT_TYPE_MASK             0x00000380
#define WLAN_GPIO_PIN5_INT_TYPE_GET(x)           (((x) & WLAN_GPIO_PIN5_INT_TYPE_MASK) >> WLAN_GPIO_PIN5_INT_TYPE_LSB)
#define WLAN_GPIO_PIN5_INT_TYPE_SET(x)           (((x) << WLAN_GPIO_PIN5_INT_TYPE_LSB) & WLAN_GPIO_PIN5_INT_TYPE_MASK)
#define WLAN_GPIO_PIN5_PAD_PULL_MSB              6
#define WLAN_GPIO_PIN5_PAD_PULL_LSB              5
#define WLAN_GPIO_PIN5_PAD_PULL_MASK             0x00000060
#define WLAN_GPIO_PIN5_PAD_PULL_GET(x)           (((x) & WLAN_GPIO_PIN5_PAD_PULL_MASK) >> WLAN_GPIO_PIN5_PAD_PULL_LSB)
#define WLAN_GPIO_PIN5_PAD_PULL_SET(x)           (((x) << WLAN_GPIO_PIN5_PAD_PULL_LSB) & WLAN_GPIO_PIN5_PAD_PULL_MASK)
#define WLAN_GPIO_PIN5_PAD_STRENGTH_MSB          4
#define WLAN_GPIO_PIN5_PAD_STRENGTH_LSB          3
#define WLAN_GPIO_PIN5_PAD_STRENGTH_MASK         0x00000018
#define WLAN_GPIO_PIN5_PAD_STRENGTH_GET(x)       (((x) & WLAN_GPIO_PIN5_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN5_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN5_PAD_STRENGTH_SET(x)       (((x) << WLAN_GPIO_PIN5_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN5_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN5_PAD_DRIVER_MSB            2
#define WLAN_GPIO_PIN5_PAD_DRIVER_LSB            2
#define WLAN_GPIO_PIN5_PAD_DRIVER_MASK           0x00000004
#define WLAN_GPIO_PIN5_PAD_DRIVER_GET(x)         (((x) & WLAN_GPIO_PIN5_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN5_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN5_PAD_DRIVER_SET(x)         (((x) << WLAN_GPIO_PIN5_PAD_DRIVER_LSB) & WLAN_GPIO_PIN5_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN5_SOURCE_MSB                0
#define WLAN_GPIO_PIN5_SOURCE_LSB                0
#define WLAN_GPIO_PIN5_SOURCE_MASK               0x00000001
#define WLAN_GPIO_PIN5_SOURCE_GET(x)             (((x) & WLAN_GPIO_PIN5_SOURCE_MASK) >> WLAN_GPIO_PIN5_SOURCE_LSB)
#define WLAN_GPIO_PIN5_SOURCE_SET(x)             (((x) << WLAN_GPIO_PIN5_SOURCE_LSB) & WLAN_GPIO_PIN5_SOURCE_MASK)

#define WLAN_GPIO_PIN6_ADDRESS                   0x00000068
#define WLAN_GPIO_PIN6_OFFSET                    0x00000068
#define WLAN_GPIO_PIN6_CONFIG_MSB                14
#define WLAN_GPIO_PIN6_CONFIG_LSB                11
#define WLAN_GPIO_PIN6_CONFIG_MASK               0x00007800
#define WLAN_GPIO_PIN6_CONFIG_GET(x)             (((x) & WLAN_GPIO_PIN6_CONFIG_MASK) >> WLAN_GPIO_PIN6_CONFIG_LSB)
#define WLAN_GPIO_PIN6_CONFIG_SET(x)             (((x) << WLAN_GPIO_PIN6_CONFIG_LSB) & WLAN_GPIO_PIN6_CONFIG_MASK)
#define WLAN_GPIO_PIN6_WAKEUP_ENABLE_MSB         10
#define WLAN_GPIO_PIN6_WAKEUP_ENABLE_LSB         10
#define WLAN_GPIO_PIN6_WAKEUP_ENABLE_MASK        0x00000400
#define WLAN_GPIO_PIN6_WAKEUP_ENABLE_GET(x)      (((x) & WLAN_GPIO_PIN6_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN6_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN6_WAKEUP_ENABLE_SET(x)      (((x) << WLAN_GPIO_PIN6_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN6_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN6_INT_TYPE_MSB              9
#define WLAN_GPIO_PIN6_INT_TYPE_LSB              7
#define WLAN_GPIO_PIN6_INT_TYPE_MASK             0x00000380
#define WLAN_GPIO_PIN6_INT_TYPE_GET(x)           (((x) & WLAN_GPIO_PIN6_INT_TYPE_MASK) >> WLAN_GPIO_PIN6_INT_TYPE_LSB)
#define WLAN_GPIO_PIN6_INT_TYPE_SET(x)           (((x) << WLAN_GPIO_PIN6_INT_TYPE_LSB) & WLAN_GPIO_PIN6_INT_TYPE_MASK)
#define WLAN_GPIO_PIN6_PAD_PULL_MSB              6
#define WLAN_GPIO_PIN6_PAD_PULL_LSB              5
#define WLAN_GPIO_PIN6_PAD_PULL_MASK             0x00000060
#define WLAN_GPIO_PIN6_PAD_PULL_GET(x)           (((x) & WLAN_GPIO_PIN6_PAD_PULL_MASK) >> WLAN_GPIO_PIN6_PAD_PULL_LSB)
#define WLAN_GPIO_PIN6_PAD_PULL_SET(x)           (((x) << WLAN_GPIO_PIN6_PAD_PULL_LSB) & WLAN_GPIO_PIN6_PAD_PULL_MASK)
#define WLAN_GPIO_PIN6_PAD_STRENGTH_MSB          4
#define WLAN_GPIO_PIN6_PAD_STRENGTH_LSB          3
#define WLAN_GPIO_PIN6_PAD_STRENGTH_MASK         0x00000018
#define WLAN_GPIO_PIN6_PAD_STRENGTH_GET(x)       (((x) & WLAN_GPIO_PIN6_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN6_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN6_PAD_STRENGTH_SET(x)       (((x) << WLAN_GPIO_PIN6_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN6_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN6_PAD_DRIVER_MSB            2
#define WLAN_GPIO_PIN6_PAD_DRIVER_LSB            2
#define WLAN_GPIO_PIN6_PAD_DRIVER_MASK           0x00000004
#define WLAN_GPIO_PIN6_PAD_DRIVER_GET(x)         (((x) & WLAN_GPIO_PIN6_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN6_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN6_PAD_DRIVER_SET(x)         (((x) << WLAN_GPIO_PIN6_PAD_DRIVER_LSB) & WLAN_GPIO_PIN6_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN6_SOURCE_MSB                0
#define WLAN_GPIO_PIN6_SOURCE_LSB                0
#define WLAN_GPIO_PIN6_SOURCE_MASK               0x00000001
#define WLAN_GPIO_PIN6_SOURCE_GET(x)             (((x) & WLAN_GPIO_PIN6_SOURCE_MASK) >> WLAN_GPIO_PIN6_SOURCE_LSB)
#define WLAN_GPIO_PIN6_SOURCE_SET(x)             (((x) << WLAN_GPIO_PIN6_SOURCE_LSB) & WLAN_GPIO_PIN6_SOURCE_MASK)

#define WLAN_GPIO_PIN7_ADDRESS                   0x0000006c
#define WLAN_GPIO_PIN7_OFFSET                    0x0000006c
#define WLAN_GPIO_PIN7_CONFIG_MSB                14
#define WLAN_GPIO_PIN7_CONFIG_LSB                11
#define WLAN_GPIO_PIN7_CONFIG_MASK               0x00007800
#define WLAN_GPIO_PIN7_CONFIG_GET(x)             (((x) & WLAN_GPIO_PIN7_CONFIG_MASK) >> WLAN_GPIO_PIN7_CONFIG_LSB)
#define WLAN_GPIO_PIN7_CONFIG_SET(x)             (((x) << WLAN_GPIO_PIN7_CONFIG_LSB) & WLAN_GPIO_PIN7_CONFIG_MASK)
#define WLAN_GPIO_PIN7_WAKEUP_ENABLE_MSB         10
#define WLAN_GPIO_PIN7_WAKEUP_ENABLE_LSB         10
#define WLAN_GPIO_PIN7_WAKEUP_ENABLE_MASK        0x00000400
#define WLAN_GPIO_PIN7_WAKEUP_ENABLE_GET(x)      (((x) & WLAN_GPIO_PIN7_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN7_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN7_WAKEUP_ENABLE_SET(x)      (((x) << WLAN_GPIO_PIN7_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN7_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN7_INT_TYPE_MSB              9
#define WLAN_GPIO_PIN7_INT_TYPE_LSB              7
#define WLAN_GPIO_PIN7_INT_TYPE_MASK             0x00000380
#define WLAN_GPIO_PIN7_INT_TYPE_GET(x)           (((x) & WLAN_GPIO_PIN7_INT_TYPE_MASK) >> WLAN_GPIO_PIN7_INT_TYPE_LSB)
#define WLAN_GPIO_PIN7_INT_TYPE_SET(x)           (((x) << WLAN_GPIO_PIN7_INT_TYPE_LSB) & WLAN_GPIO_PIN7_INT_TYPE_MASK)
#define WLAN_GPIO_PIN7_PAD_PULL_MSB              6
#define WLAN_GPIO_PIN7_PAD_PULL_LSB              5
#define WLAN_GPIO_PIN7_PAD_PULL_MASK             0x00000060
#define WLAN_GPIO_PIN7_PAD_PULL_GET(x)           (((x) & WLAN_GPIO_PIN7_PAD_PULL_MASK) >> WLAN_GPIO_PIN7_PAD_PULL_LSB)
#define WLAN_GPIO_PIN7_PAD_PULL_SET(x)           (((x) << WLAN_GPIO_PIN7_PAD_PULL_LSB) & WLAN_GPIO_PIN7_PAD_PULL_MASK)
#define WLAN_GPIO_PIN7_PAD_STRENGTH_MSB          4
#define WLAN_GPIO_PIN7_PAD_STRENGTH_LSB          3
#define WLAN_GPIO_PIN7_PAD_STRENGTH_MASK         0x00000018
#define WLAN_GPIO_PIN7_PAD_STRENGTH_GET(x)       (((x) & WLAN_GPIO_PIN7_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN7_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN7_PAD_STRENGTH_SET(x)       (((x) << WLAN_GPIO_PIN7_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN7_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN7_PAD_DRIVER_MSB            2
#define WLAN_GPIO_PIN7_PAD_DRIVER_LSB            2
#define WLAN_GPIO_PIN7_PAD_DRIVER_MASK           0x00000004
#define WLAN_GPIO_PIN7_PAD_DRIVER_GET(x)         (((x) & WLAN_GPIO_PIN7_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN7_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN7_PAD_DRIVER_SET(x)         (((x) << WLAN_GPIO_PIN7_PAD_DRIVER_LSB) & WLAN_GPIO_PIN7_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN7_SOURCE_MSB                0
#define WLAN_GPIO_PIN7_SOURCE_LSB                0
#define WLAN_GPIO_PIN7_SOURCE_MASK               0x00000001
#define WLAN_GPIO_PIN7_SOURCE_GET(x)             (((x) & WLAN_GPIO_PIN7_SOURCE_MASK) >> WLAN_GPIO_PIN7_SOURCE_LSB)
#define WLAN_GPIO_PIN7_SOURCE_SET(x)             (((x) << WLAN_GPIO_PIN7_SOURCE_LSB) & WLAN_GPIO_PIN7_SOURCE_MASK)

#define WLAN_GPIO_PIN8_ADDRESS                   0x00000070
#define WLAN_GPIO_PIN8_OFFSET                    0x00000070
#define WLAN_GPIO_PIN8_CONFIG_MSB                14
#define WLAN_GPIO_PIN8_CONFIG_LSB                11
#define WLAN_GPIO_PIN8_CONFIG_MASK               0x00007800
#define WLAN_GPIO_PIN8_CONFIG_GET(x)             (((x) & WLAN_GPIO_PIN8_CONFIG_MASK) >> WLAN_GPIO_PIN8_CONFIG_LSB)
#define WLAN_GPIO_PIN8_CONFIG_SET(x)             (((x) << WLAN_GPIO_PIN8_CONFIG_LSB) & WLAN_GPIO_PIN8_CONFIG_MASK)
#define WLAN_GPIO_PIN8_WAKEUP_ENABLE_MSB         10
#define WLAN_GPIO_PIN8_WAKEUP_ENABLE_LSB         10
#define WLAN_GPIO_PIN8_WAKEUP_ENABLE_MASK        0x00000400
#define WLAN_GPIO_PIN8_WAKEUP_ENABLE_GET(x)      (((x) & WLAN_GPIO_PIN8_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN8_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN8_WAKEUP_ENABLE_SET(x)      (((x) << WLAN_GPIO_PIN8_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN8_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN8_INT_TYPE_MSB              9
#define WLAN_GPIO_PIN8_INT_TYPE_LSB              7
#define WLAN_GPIO_PIN8_INT_TYPE_MASK             0x00000380
#define WLAN_GPIO_PIN8_INT_TYPE_GET(x)           (((x) & WLAN_GPIO_PIN8_INT_TYPE_MASK) >> WLAN_GPIO_PIN8_INT_TYPE_LSB)
#define WLAN_GPIO_PIN8_INT_TYPE_SET(x)           (((x) << WLAN_GPIO_PIN8_INT_TYPE_LSB) & WLAN_GPIO_PIN8_INT_TYPE_MASK)
#define WLAN_GPIO_PIN8_PAD_PULL_MSB              6
#define WLAN_GPIO_PIN8_PAD_PULL_LSB              5
#define WLAN_GPIO_PIN8_PAD_PULL_MASK             0x00000060
#define WLAN_GPIO_PIN8_PAD_PULL_GET(x)           (((x) & WLAN_GPIO_PIN8_PAD_PULL_MASK) >> WLAN_GPIO_PIN8_PAD_PULL_LSB)
#define WLAN_GPIO_PIN8_PAD_PULL_SET(x)           (((x) << WLAN_GPIO_PIN8_PAD_PULL_LSB) & WLAN_GPIO_PIN8_PAD_PULL_MASK)
#define WLAN_GPIO_PIN8_PAD_STRENGTH_MSB          4
#define WLAN_GPIO_PIN8_PAD_STRENGTH_LSB          3
#define WLAN_GPIO_PIN8_PAD_STRENGTH_MASK         0x00000018
#define WLAN_GPIO_PIN8_PAD_STRENGTH_GET(x)       (((x) & WLAN_GPIO_PIN8_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN8_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN8_PAD_STRENGTH_SET(x)       (((x) << WLAN_GPIO_PIN8_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN8_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN8_PAD_DRIVER_MSB            2
#define WLAN_GPIO_PIN8_PAD_DRIVER_LSB            2
#define WLAN_GPIO_PIN8_PAD_DRIVER_MASK           0x00000004
#define WLAN_GPIO_PIN8_PAD_DRIVER_GET(x)         (((x) & WLAN_GPIO_PIN8_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN8_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN8_PAD_DRIVER_SET(x)         (((x) << WLAN_GPIO_PIN8_PAD_DRIVER_LSB) & WLAN_GPIO_PIN8_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN8_SOURCE_MSB                0
#define WLAN_GPIO_PIN8_SOURCE_LSB                0
#define WLAN_GPIO_PIN8_SOURCE_MASK               0x00000001
#define WLAN_GPIO_PIN8_SOURCE_GET(x)             (((x) & WLAN_GPIO_PIN8_SOURCE_MASK) >> WLAN_GPIO_PIN8_SOURCE_LSB)
#define WLAN_GPIO_PIN8_SOURCE_SET(x)             (((x) << WLAN_GPIO_PIN8_SOURCE_LSB) & WLAN_GPIO_PIN8_SOURCE_MASK)

#define WLAN_GPIO_PIN9_ADDRESS                   0x00000074
#define WLAN_GPIO_PIN9_OFFSET                    0x00000074
#define WLAN_GPIO_PIN9_CONFIG_MSB                14
#define WLAN_GPIO_PIN9_CONFIG_LSB                11
#define WLAN_GPIO_PIN9_CONFIG_MASK               0x00007800
#define WLAN_GPIO_PIN9_CONFIG_GET(x)             (((x) & WLAN_GPIO_PIN9_CONFIG_MASK) >> WLAN_GPIO_PIN9_CONFIG_LSB)
#define WLAN_GPIO_PIN9_CONFIG_SET(x)             (((x) << WLAN_GPIO_PIN9_CONFIG_LSB) & WLAN_GPIO_PIN9_CONFIG_MASK)
#define WLAN_GPIO_PIN9_WAKEUP_ENABLE_MSB         10
#define WLAN_GPIO_PIN9_WAKEUP_ENABLE_LSB         10
#define WLAN_GPIO_PIN9_WAKEUP_ENABLE_MASK        0x00000400
#define WLAN_GPIO_PIN9_WAKEUP_ENABLE_GET(x)      (((x) & WLAN_GPIO_PIN9_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN9_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN9_WAKEUP_ENABLE_SET(x)      (((x) << WLAN_GPIO_PIN9_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN9_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN9_INT_TYPE_MSB              9
#define WLAN_GPIO_PIN9_INT_TYPE_LSB              7
#define WLAN_GPIO_PIN9_INT_TYPE_MASK             0x00000380
#define WLAN_GPIO_PIN9_INT_TYPE_GET(x)           (((x) & WLAN_GPIO_PIN9_INT_TYPE_MASK) >> WLAN_GPIO_PIN9_INT_TYPE_LSB)
#define WLAN_GPIO_PIN9_INT_TYPE_SET(x)           (((x) << WLAN_GPIO_PIN9_INT_TYPE_LSB) & WLAN_GPIO_PIN9_INT_TYPE_MASK)
#define WLAN_GPIO_PIN9_PAD_PULL_MSB              6
#define WLAN_GPIO_PIN9_PAD_PULL_LSB              5
#define WLAN_GPIO_PIN9_PAD_PULL_MASK             0x00000060
#define WLAN_GPIO_PIN9_PAD_PULL_GET(x)           (((x) & WLAN_GPIO_PIN9_PAD_PULL_MASK) >> WLAN_GPIO_PIN9_PAD_PULL_LSB)
#define WLAN_GPIO_PIN9_PAD_PULL_SET(x)           (((x) << WLAN_GPIO_PIN9_PAD_PULL_LSB) & WLAN_GPIO_PIN9_PAD_PULL_MASK)
#define WLAN_GPIO_PIN9_PAD_STRENGTH_MSB          4
#define WLAN_GPIO_PIN9_PAD_STRENGTH_LSB          3
#define WLAN_GPIO_PIN9_PAD_STRENGTH_MASK         0x00000018
#define WLAN_GPIO_PIN9_PAD_STRENGTH_GET(x)       (((x) & WLAN_GPIO_PIN9_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN9_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN9_PAD_STRENGTH_SET(x)       (((x) << WLAN_GPIO_PIN9_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN9_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN9_PAD_DRIVER_MSB            2
#define WLAN_GPIO_PIN9_PAD_DRIVER_LSB            2
#define WLAN_GPIO_PIN9_PAD_DRIVER_MASK           0x00000004
#define WLAN_GPIO_PIN9_PAD_DRIVER_GET(x)         (((x) & WLAN_GPIO_PIN9_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN9_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN9_PAD_DRIVER_SET(x)         (((x) << WLAN_GPIO_PIN9_PAD_DRIVER_LSB) & WLAN_GPIO_PIN9_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN9_SOURCE_MSB                0
#define WLAN_GPIO_PIN9_SOURCE_LSB                0
#define WLAN_GPIO_PIN9_SOURCE_MASK               0x00000001
#define WLAN_GPIO_PIN9_SOURCE_GET(x)             (((x) & WLAN_GPIO_PIN9_SOURCE_MASK) >> WLAN_GPIO_PIN9_SOURCE_LSB)
#define WLAN_GPIO_PIN9_SOURCE_SET(x)             (((x) << WLAN_GPIO_PIN9_SOURCE_LSB) & WLAN_GPIO_PIN9_SOURCE_MASK)

#define WLAN_GPIO_PIN10_ADDRESS                  0x00000078
#define WLAN_GPIO_PIN10_OFFSET                   0x00000078
#define WLAN_GPIO_PIN10_CONFIG_MSB               14
#define WLAN_GPIO_PIN10_CONFIG_LSB               11
#define WLAN_GPIO_PIN10_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN10_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN10_CONFIG_MASK) >> WLAN_GPIO_PIN10_CONFIG_LSB)
#define WLAN_GPIO_PIN10_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN10_CONFIG_LSB) & WLAN_GPIO_PIN10_CONFIG_MASK)
#define WLAN_GPIO_PIN10_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN10_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN10_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN10_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN10_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN10_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN10_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN10_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN10_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN10_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN10_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN10_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN10_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN10_INT_TYPE_MASK) >> WLAN_GPIO_PIN10_INT_TYPE_LSB)
#define WLAN_GPIO_PIN10_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN10_INT_TYPE_LSB) & WLAN_GPIO_PIN10_INT_TYPE_MASK)
#define WLAN_GPIO_PIN10_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN10_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN10_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN10_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN10_PAD_PULL_MASK) >> WLAN_GPIO_PIN10_PAD_PULL_LSB)
#define WLAN_GPIO_PIN10_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN10_PAD_PULL_LSB) & WLAN_GPIO_PIN10_PAD_PULL_MASK)
#define WLAN_GPIO_PIN10_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN10_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN10_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN10_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN10_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN10_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN10_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN10_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN10_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN10_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN10_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN10_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN10_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN10_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN10_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN10_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN10_PAD_DRIVER_LSB) & WLAN_GPIO_PIN10_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN10_SOURCE_MSB               0
#define WLAN_GPIO_PIN10_SOURCE_LSB               0
#define WLAN_GPIO_PIN10_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN10_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN10_SOURCE_MASK) >> WLAN_GPIO_PIN10_SOURCE_LSB)
#define WLAN_GPIO_PIN10_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN10_SOURCE_LSB) & WLAN_GPIO_PIN10_SOURCE_MASK)

#define WLAN_GPIO_PIN11_ADDRESS                  0x0000007c
#define WLAN_GPIO_PIN11_OFFSET                   0x0000007c
#define WLAN_GPIO_PIN11_CONFIG_MSB               14
#define WLAN_GPIO_PIN11_CONFIG_LSB               11
#define WLAN_GPIO_PIN11_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN11_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN11_CONFIG_MASK) >> WLAN_GPIO_PIN11_CONFIG_LSB)
#define WLAN_GPIO_PIN11_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN11_CONFIG_LSB) & WLAN_GPIO_PIN11_CONFIG_MASK)
#define WLAN_GPIO_PIN11_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN11_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN11_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN11_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN11_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN11_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN11_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN11_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN11_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN11_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN11_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN11_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN11_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN11_INT_TYPE_MASK) >> WLAN_GPIO_PIN11_INT_TYPE_LSB)
#define WLAN_GPIO_PIN11_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN11_INT_TYPE_LSB) & WLAN_GPIO_PIN11_INT_TYPE_MASK)
#define WLAN_GPIO_PIN11_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN11_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN11_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN11_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN11_PAD_PULL_MASK) >> WLAN_GPIO_PIN11_PAD_PULL_LSB)
#define WLAN_GPIO_PIN11_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN11_PAD_PULL_LSB) & WLAN_GPIO_PIN11_PAD_PULL_MASK)
#define WLAN_GPIO_PIN11_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN11_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN11_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN11_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN11_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN11_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN11_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN11_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN11_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN11_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN11_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN11_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN11_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN11_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN11_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN11_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN11_PAD_DRIVER_LSB) & WLAN_GPIO_PIN11_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN11_SOURCE_MSB               0
#define WLAN_GPIO_PIN11_SOURCE_LSB               0
#define WLAN_GPIO_PIN11_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN11_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN11_SOURCE_MASK) >> WLAN_GPIO_PIN11_SOURCE_LSB)
#define WLAN_GPIO_PIN11_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN11_SOURCE_LSB) & WLAN_GPIO_PIN11_SOURCE_MASK)

#define WLAN_GPIO_PIN12_ADDRESS                  0x00000080
#define WLAN_GPIO_PIN12_OFFSET                   0x00000080
#define WLAN_GPIO_PIN12_CONFIG_MSB               14
#define WLAN_GPIO_PIN12_CONFIG_LSB               11
#define WLAN_GPIO_PIN12_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN12_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN12_CONFIG_MASK) >> WLAN_GPIO_PIN12_CONFIG_LSB)
#define WLAN_GPIO_PIN12_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN12_CONFIG_LSB) & WLAN_GPIO_PIN12_CONFIG_MASK)
#define WLAN_GPIO_PIN12_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN12_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN12_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN12_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN12_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN12_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN12_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN12_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN12_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN12_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN12_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN12_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN12_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN12_INT_TYPE_MASK) >> WLAN_GPIO_PIN12_INT_TYPE_LSB)
#define WLAN_GPIO_PIN12_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN12_INT_TYPE_LSB) & WLAN_GPIO_PIN12_INT_TYPE_MASK)
#define WLAN_GPIO_PIN12_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN12_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN12_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN12_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN12_PAD_PULL_MASK) >> WLAN_GPIO_PIN12_PAD_PULL_LSB)
#define WLAN_GPIO_PIN12_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN12_PAD_PULL_LSB) & WLAN_GPIO_PIN12_PAD_PULL_MASK)
#define WLAN_GPIO_PIN12_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN12_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN12_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN12_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN12_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN12_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN12_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN12_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN12_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN12_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN12_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN12_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN12_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN12_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN12_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN12_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN12_PAD_DRIVER_LSB) & WLAN_GPIO_PIN12_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN12_SOURCE_MSB               0
#define WLAN_GPIO_PIN12_SOURCE_LSB               0
#define WLAN_GPIO_PIN12_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN12_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN12_SOURCE_MASK) >> WLAN_GPIO_PIN12_SOURCE_LSB)
#define WLAN_GPIO_PIN12_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN12_SOURCE_LSB) & WLAN_GPIO_PIN12_SOURCE_MASK)

#define WLAN_GPIO_PIN13_ADDRESS                  0x00000084
#define WLAN_GPIO_PIN13_OFFSET                   0x00000084
#define WLAN_GPIO_PIN13_CONFIG_MSB               14
#define WLAN_GPIO_PIN13_CONFIG_LSB               11
#define WLAN_GPIO_PIN13_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN13_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN13_CONFIG_MASK) >> WLAN_GPIO_PIN13_CONFIG_LSB)
#define WLAN_GPIO_PIN13_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN13_CONFIG_LSB) & WLAN_GPIO_PIN13_CONFIG_MASK)
#define WLAN_GPIO_PIN13_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN13_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN13_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN13_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN13_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN13_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN13_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN13_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN13_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN13_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN13_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN13_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN13_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN13_INT_TYPE_MASK) >> WLAN_GPIO_PIN13_INT_TYPE_LSB)
#define WLAN_GPIO_PIN13_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN13_INT_TYPE_LSB) & WLAN_GPIO_PIN13_INT_TYPE_MASK)
#define WLAN_GPIO_PIN13_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN13_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN13_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN13_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN13_PAD_PULL_MASK) >> WLAN_GPIO_PIN13_PAD_PULL_LSB)
#define WLAN_GPIO_PIN13_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN13_PAD_PULL_LSB) & WLAN_GPIO_PIN13_PAD_PULL_MASK)
#define WLAN_GPIO_PIN13_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN13_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN13_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN13_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN13_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN13_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN13_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN13_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN13_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN13_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN13_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN13_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN13_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN13_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN13_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN13_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN13_PAD_DRIVER_LSB) & WLAN_GPIO_PIN13_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN13_SOURCE_MSB               0
#define WLAN_GPIO_PIN13_SOURCE_LSB               0
#define WLAN_GPIO_PIN13_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN13_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN13_SOURCE_MASK) >> WLAN_GPIO_PIN13_SOURCE_LSB)
#define WLAN_GPIO_PIN13_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN13_SOURCE_LSB) & WLAN_GPIO_PIN13_SOURCE_MASK)

#define WLAN_GPIO_PIN14_ADDRESS                  0x00000088
#define WLAN_GPIO_PIN14_OFFSET                   0x00000088
#define WLAN_GPIO_PIN14_CONFIG_MSB               14
#define WLAN_GPIO_PIN14_CONFIG_LSB               11
#define WLAN_GPIO_PIN14_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN14_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN14_CONFIG_MASK) >> WLAN_GPIO_PIN14_CONFIG_LSB)
#define WLAN_GPIO_PIN14_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN14_CONFIG_LSB) & WLAN_GPIO_PIN14_CONFIG_MASK)
#define WLAN_GPIO_PIN14_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN14_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN14_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN14_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN14_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN14_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN14_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN14_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN14_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN14_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN14_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN14_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN14_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN14_INT_TYPE_MASK) >> WLAN_GPIO_PIN14_INT_TYPE_LSB)
#define WLAN_GPIO_PIN14_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN14_INT_TYPE_LSB) & WLAN_GPIO_PIN14_INT_TYPE_MASK)
#define WLAN_GPIO_PIN14_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN14_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN14_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN14_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN14_PAD_PULL_MASK) >> WLAN_GPIO_PIN14_PAD_PULL_LSB)
#define WLAN_GPIO_PIN14_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN14_PAD_PULL_LSB) & WLAN_GPIO_PIN14_PAD_PULL_MASK)
#define WLAN_GPIO_PIN14_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN14_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN14_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN14_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN14_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN14_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN14_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN14_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN14_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN14_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN14_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN14_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN14_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN14_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN14_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN14_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN14_PAD_DRIVER_LSB) & WLAN_GPIO_PIN14_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN14_SOURCE_MSB               0
#define WLAN_GPIO_PIN14_SOURCE_LSB               0
#define WLAN_GPIO_PIN14_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN14_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN14_SOURCE_MASK) >> WLAN_GPIO_PIN14_SOURCE_LSB)
#define WLAN_GPIO_PIN14_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN14_SOURCE_LSB) & WLAN_GPIO_PIN14_SOURCE_MASK)

#define WLAN_GPIO_PIN15_ADDRESS                  0x0000008c
#define WLAN_GPIO_PIN15_OFFSET                   0x0000008c
#define WLAN_GPIO_PIN15_CONFIG_MSB               14
#define WLAN_GPIO_PIN15_CONFIG_LSB               11
#define WLAN_GPIO_PIN15_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN15_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN15_CONFIG_MASK) >> WLAN_GPIO_PIN15_CONFIG_LSB)
#define WLAN_GPIO_PIN15_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN15_CONFIG_LSB) & WLAN_GPIO_PIN15_CONFIG_MASK)
#define WLAN_GPIO_PIN15_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN15_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN15_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN15_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN15_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN15_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN15_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN15_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN15_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN15_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN15_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN15_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN15_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN15_INT_TYPE_MASK) >> WLAN_GPIO_PIN15_INT_TYPE_LSB)
#define WLAN_GPIO_PIN15_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN15_INT_TYPE_LSB) & WLAN_GPIO_PIN15_INT_TYPE_MASK)
#define WLAN_GPIO_PIN15_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN15_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN15_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN15_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN15_PAD_PULL_MASK) >> WLAN_GPIO_PIN15_PAD_PULL_LSB)
#define WLAN_GPIO_PIN15_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN15_PAD_PULL_LSB) & WLAN_GPIO_PIN15_PAD_PULL_MASK)
#define WLAN_GPIO_PIN15_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN15_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN15_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN15_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN15_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN15_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN15_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN15_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN15_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN15_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN15_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN15_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN15_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN15_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN15_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN15_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN15_PAD_DRIVER_LSB) & WLAN_GPIO_PIN15_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN15_SOURCE_MSB               0
#define WLAN_GPIO_PIN15_SOURCE_LSB               0
#define WLAN_GPIO_PIN15_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN15_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN15_SOURCE_MASK) >> WLAN_GPIO_PIN15_SOURCE_LSB)
#define WLAN_GPIO_PIN15_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN15_SOURCE_LSB) & WLAN_GPIO_PIN15_SOURCE_MASK)

#define WLAN_GPIO_PIN16_ADDRESS                  0x00000090
#define WLAN_GPIO_PIN16_OFFSET                   0x00000090
#define WLAN_GPIO_PIN16_CONFIG_MSB               14
#define WLAN_GPIO_PIN16_CONFIG_LSB               11
#define WLAN_GPIO_PIN16_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN16_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN16_CONFIG_MASK) >> WLAN_GPIO_PIN16_CONFIG_LSB)
#define WLAN_GPIO_PIN16_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN16_CONFIG_LSB) & WLAN_GPIO_PIN16_CONFIG_MASK)
#define WLAN_GPIO_PIN16_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN16_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN16_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN16_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN16_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN16_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN16_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN16_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN16_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN16_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN16_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN16_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN16_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN16_INT_TYPE_MASK) >> WLAN_GPIO_PIN16_INT_TYPE_LSB)
#define WLAN_GPIO_PIN16_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN16_INT_TYPE_LSB) & WLAN_GPIO_PIN16_INT_TYPE_MASK)
#define WLAN_GPIO_PIN16_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN16_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN16_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN16_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN16_PAD_PULL_MASK) >> WLAN_GPIO_PIN16_PAD_PULL_LSB)
#define WLAN_GPIO_PIN16_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN16_PAD_PULL_LSB) & WLAN_GPIO_PIN16_PAD_PULL_MASK)
#define WLAN_GPIO_PIN16_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN16_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN16_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN16_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN16_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN16_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN16_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN16_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN16_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN16_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN16_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN16_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN16_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN16_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN16_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN16_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN16_PAD_DRIVER_LSB) & WLAN_GPIO_PIN16_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN16_SOURCE_MSB               0
#define WLAN_GPIO_PIN16_SOURCE_LSB               0
#define WLAN_GPIO_PIN16_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN16_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN16_SOURCE_MASK) >> WLAN_GPIO_PIN16_SOURCE_LSB)
#define WLAN_GPIO_PIN16_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN16_SOURCE_LSB) & WLAN_GPIO_PIN16_SOURCE_MASK)

#define WLAN_GPIO_PIN17_ADDRESS                  0x00000094
#define WLAN_GPIO_PIN17_OFFSET                   0x00000094
#define WLAN_GPIO_PIN17_CONFIG_MSB               14
#define WLAN_GPIO_PIN17_CONFIG_LSB               11
#define WLAN_GPIO_PIN17_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN17_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN17_CONFIG_MASK) >> WLAN_GPIO_PIN17_CONFIG_LSB)
#define WLAN_GPIO_PIN17_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN17_CONFIG_LSB) & WLAN_GPIO_PIN17_CONFIG_MASK)
#define WLAN_GPIO_PIN17_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN17_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN17_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN17_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN17_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN17_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN17_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN17_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN17_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN17_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN17_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN17_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN17_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN17_INT_TYPE_MASK) >> WLAN_GPIO_PIN17_INT_TYPE_LSB)
#define WLAN_GPIO_PIN17_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN17_INT_TYPE_LSB) & WLAN_GPIO_PIN17_INT_TYPE_MASK)
#define WLAN_GPIO_PIN17_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN17_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN17_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN17_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN17_PAD_PULL_MASK) >> WLAN_GPIO_PIN17_PAD_PULL_LSB)
#define WLAN_GPIO_PIN17_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN17_PAD_PULL_LSB) & WLAN_GPIO_PIN17_PAD_PULL_MASK)
#define WLAN_GPIO_PIN17_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN17_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN17_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN17_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN17_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN17_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN17_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN17_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN17_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN17_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN17_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN17_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN17_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN17_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN17_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN17_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN17_PAD_DRIVER_LSB) & WLAN_GPIO_PIN17_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN17_SOURCE_MSB               0
#define WLAN_GPIO_PIN17_SOURCE_LSB               0
#define WLAN_GPIO_PIN17_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN17_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN17_SOURCE_MASK) >> WLAN_GPIO_PIN17_SOURCE_LSB)
#define WLAN_GPIO_PIN17_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN17_SOURCE_LSB) & WLAN_GPIO_PIN17_SOURCE_MASK)

#define WLAN_GPIO_PIN18_ADDRESS                  0x00000098
#define WLAN_GPIO_PIN18_OFFSET                   0x00000098
#define WLAN_GPIO_PIN18_CONFIG_MSB               14
#define WLAN_GPIO_PIN18_CONFIG_LSB               11
#define WLAN_GPIO_PIN18_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN18_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN18_CONFIG_MASK) >> WLAN_GPIO_PIN18_CONFIG_LSB)
#define WLAN_GPIO_PIN18_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN18_CONFIG_LSB) & WLAN_GPIO_PIN18_CONFIG_MASK)
#define WLAN_GPIO_PIN18_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN18_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN18_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN18_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN18_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN18_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN18_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN18_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN18_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN18_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN18_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN18_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN18_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN18_INT_TYPE_MASK) >> WLAN_GPIO_PIN18_INT_TYPE_LSB)
#define WLAN_GPIO_PIN18_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN18_INT_TYPE_LSB) & WLAN_GPIO_PIN18_INT_TYPE_MASK)
#define WLAN_GPIO_PIN18_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN18_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN18_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN18_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN18_PAD_PULL_MASK) >> WLAN_GPIO_PIN18_PAD_PULL_LSB)
#define WLAN_GPIO_PIN18_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN18_PAD_PULL_LSB) & WLAN_GPIO_PIN18_PAD_PULL_MASK)
#define WLAN_GPIO_PIN18_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN18_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN18_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN18_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN18_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN18_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN18_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN18_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN18_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN18_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN18_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN18_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN18_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN18_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN18_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN18_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN18_PAD_DRIVER_LSB) & WLAN_GPIO_PIN18_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN18_SOURCE_MSB               0
#define WLAN_GPIO_PIN18_SOURCE_LSB               0
#define WLAN_GPIO_PIN18_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN18_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN18_SOURCE_MASK) >> WLAN_GPIO_PIN18_SOURCE_LSB)
#define WLAN_GPIO_PIN18_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN18_SOURCE_LSB) & WLAN_GPIO_PIN18_SOURCE_MASK)

#define WLAN_GPIO_PIN19_ADDRESS                  0x0000009c
#define WLAN_GPIO_PIN19_OFFSET                   0x0000009c
#define WLAN_GPIO_PIN19_CONFIG_MSB               14
#define WLAN_GPIO_PIN19_CONFIG_LSB               11
#define WLAN_GPIO_PIN19_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN19_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN19_CONFIG_MASK) >> WLAN_GPIO_PIN19_CONFIG_LSB)
#define WLAN_GPIO_PIN19_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN19_CONFIG_LSB) & WLAN_GPIO_PIN19_CONFIG_MASK)
#define WLAN_GPIO_PIN19_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN19_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN19_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN19_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN19_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN19_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN19_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN19_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN19_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN19_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN19_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN19_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN19_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN19_INT_TYPE_MASK) >> WLAN_GPIO_PIN19_INT_TYPE_LSB)
#define WLAN_GPIO_PIN19_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN19_INT_TYPE_LSB) & WLAN_GPIO_PIN19_INT_TYPE_MASK)
#define WLAN_GPIO_PIN19_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN19_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN19_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN19_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN19_PAD_PULL_MASK) >> WLAN_GPIO_PIN19_PAD_PULL_LSB)
#define WLAN_GPIO_PIN19_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN19_PAD_PULL_LSB) & WLAN_GPIO_PIN19_PAD_PULL_MASK)
#define WLAN_GPIO_PIN19_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN19_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN19_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN19_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN19_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN19_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN19_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN19_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN19_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN19_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN19_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN19_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN19_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN19_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN19_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN19_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN19_PAD_DRIVER_LSB) & WLAN_GPIO_PIN19_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN19_SOURCE_MSB               0
#define WLAN_GPIO_PIN19_SOURCE_LSB               0
#define WLAN_GPIO_PIN19_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN19_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN19_SOURCE_MASK) >> WLAN_GPIO_PIN19_SOURCE_LSB)
#define WLAN_GPIO_PIN19_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN19_SOURCE_LSB) & WLAN_GPIO_PIN19_SOURCE_MASK)

#define WLAN_GPIO_PIN20_ADDRESS                  0x000000a0
#define WLAN_GPIO_PIN20_OFFSET                   0x000000a0
#define WLAN_GPIO_PIN20_CONFIG_MSB               14
#define WLAN_GPIO_PIN20_CONFIG_LSB               11
#define WLAN_GPIO_PIN20_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN20_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN20_CONFIG_MASK) >> WLAN_GPIO_PIN20_CONFIG_LSB)
#define WLAN_GPIO_PIN20_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN20_CONFIG_LSB) & WLAN_GPIO_PIN20_CONFIG_MASK)
#define WLAN_GPIO_PIN20_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN20_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN20_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN20_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN20_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN20_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN20_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN20_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN20_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN20_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN20_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN20_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN20_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN20_INT_TYPE_MASK) >> WLAN_GPIO_PIN20_INT_TYPE_LSB)
#define WLAN_GPIO_PIN20_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN20_INT_TYPE_LSB) & WLAN_GPIO_PIN20_INT_TYPE_MASK)
#define WLAN_GPIO_PIN20_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN20_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN20_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN20_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN20_PAD_PULL_MASK) >> WLAN_GPIO_PIN20_PAD_PULL_LSB)
#define WLAN_GPIO_PIN20_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN20_PAD_PULL_LSB) & WLAN_GPIO_PIN20_PAD_PULL_MASK)
#define WLAN_GPIO_PIN20_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN20_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN20_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN20_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN20_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN20_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN20_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN20_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN20_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN20_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN20_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN20_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN20_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN20_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN20_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN20_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN20_PAD_DRIVER_LSB) & WLAN_GPIO_PIN20_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN20_SOURCE_MSB               0
#define WLAN_GPIO_PIN20_SOURCE_LSB               0
#define WLAN_GPIO_PIN20_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN20_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN20_SOURCE_MASK) >> WLAN_GPIO_PIN20_SOURCE_LSB)
#define WLAN_GPIO_PIN20_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN20_SOURCE_LSB) & WLAN_GPIO_PIN20_SOURCE_MASK)

#define WLAN_GPIO_PIN21_ADDRESS                  0x000000a4
#define WLAN_GPIO_PIN21_OFFSET                   0x000000a4
#define WLAN_GPIO_PIN21_CONFIG_MSB               14
#define WLAN_GPIO_PIN21_CONFIG_LSB               11
#define WLAN_GPIO_PIN21_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN21_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN21_CONFIG_MASK) >> WLAN_GPIO_PIN21_CONFIG_LSB)
#define WLAN_GPIO_PIN21_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN21_CONFIG_LSB) & WLAN_GPIO_PIN21_CONFIG_MASK)
#define WLAN_GPIO_PIN21_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN21_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN21_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN21_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN21_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN21_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN21_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN21_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN21_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN21_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN21_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN21_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN21_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN21_INT_TYPE_MASK) >> WLAN_GPIO_PIN21_INT_TYPE_LSB)
#define WLAN_GPIO_PIN21_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN21_INT_TYPE_LSB) & WLAN_GPIO_PIN21_INT_TYPE_MASK)
#define WLAN_GPIO_PIN21_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN21_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN21_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN21_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN21_PAD_PULL_MASK) >> WLAN_GPIO_PIN21_PAD_PULL_LSB)
#define WLAN_GPIO_PIN21_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN21_PAD_PULL_LSB) & WLAN_GPIO_PIN21_PAD_PULL_MASK)
#define WLAN_GPIO_PIN21_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN21_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN21_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN21_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN21_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN21_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN21_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN21_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN21_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN21_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN21_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN21_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN21_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN21_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN21_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN21_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN21_PAD_DRIVER_LSB) & WLAN_GPIO_PIN21_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN21_SOURCE_MSB               0
#define WLAN_GPIO_PIN21_SOURCE_LSB               0
#define WLAN_GPIO_PIN21_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN21_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN21_SOURCE_MASK) >> WLAN_GPIO_PIN21_SOURCE_LSB)
#define WLAN_GPIO_PIN21_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN21_SOURCE_LSB) & WLAN_GPIO_PIN21_SOURCE_MASK)

#define WLAN_GPIO_PIN22_ADDRESS                  0x000000a8
#define WLAN_GPIO_PIN22_OFFSET                   0x000000a8
#define WLAN_GPIO_PIN22_CONFIG_MSB               14
#define WLAN_GPIO_PIN22_CONFIG_LSB               11
#define WLAN_GPIO_PIN22_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN22_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN22_CONFIG_MASK) >> WLAN_GPIO_PIN22_CONFIG_LSB)
#define WLAN_GPIO_PIN22_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN22_CONFIG_LSB) & WLAN_GPIO_PIN22_CONFIG_MASK)
#define WLAN_GPIO_PIN22_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN22_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN22_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN22_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN22_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN22_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN22_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN22_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN22_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN22_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN22_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN22_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN22_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN22_INT_TYPE_MASK) >> WLAN_GPIO_PIN22_INT_TYPE_LSB)
#define WLAN_GPIO_PIN22_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN22_INT_TYPE_LSB) & WLAN_GPIO_PIN22_INT_TYPE_MASK)
#define WLAN_GPIO_PIN22_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN22_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN22_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN22_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN22_PAD_PULL_MASK) >> WLAN_GPIO_PIN22_PAD_PULL_LSB)
#define WLAN_GPIO_PIN22_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN22_PAD_PULL_LSB) & WLAN_GPIO_PIN22_PAD_PULL_MASK)
#define WLAN_GPIO_PIN22_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN22_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN22_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN22_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN22_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN22_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN22_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN22_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN22_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN22_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN22_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN22_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN22_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN22_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN22_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN22_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN22_PAD_DRIVER_LSB) & WLAN_GPIO_PIN22_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN22_SOURCE_MSB               0
#define WLAN_GPIO_PIN22_SOURCE_LSB               0
#define WLAN_GPIO_PIN22_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN22_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN22_SOURCE_MASK) >> WLAN_GPIO_PIN22_SOURCE_LSB)
#define WLAN_GPIO_PIN22_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN22_SOURCE_LSB) & WLAN_GPIO_PIN22_SOURCE_MASK)

#define WLAN_GPIO_PIN23_ADDRESS                  0x000000ac
#define WLAN_GPIO_PIN23_OFFSET                   0x000000ac
#define WLAN_GPIO_PIN23_CONFIG_MSB               14
#define WLAN_GPIO_PIN23_CONFIG_LSB               11
#define WLAN_GPIO_PIN23_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN23_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN23_CONFIG_MASK) >> WLAN_GPIO_PIN23_CONFIG_LSB)
#define WLAN_GPIO_PIN23_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN23_CONFIG_LSB) & WLAN_GPIO_PIN23_CONFIG_MASK)
#define WLAN_GPIO_PIN23_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN23_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN23_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN23_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN23_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN23_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN23_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN23_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN23_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN23_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN23_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN23_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN23_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN23_INT_TYPE_MASK) >> WLAN_GPIO_PIN23_INT_TYPE_LSB)
#define WLAN_GPIO_PIN23_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN23_INT_TYPE_LSB) & WLAN_GPIO_PIN23_INT_TYPE_MASK)
#define WLAN_GPIO_PIN23_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN23_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN23_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN23_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN23_PAD_PULL_MASK) >> WLAN_GPIO_PIN23_PAD_PULL_LSB)
#define WLAN_GPIO_PIN23_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN23_PAD_PULL_LSB) & WLAN_GPIO_PIN23_PAD_PULL_MASK)
#define WLAN_GPIO_PIN23_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN23_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN23_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN23_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN23_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN23_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN23_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN23_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN23_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN23_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN23_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN23_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN23_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN23_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN23_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN23_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN23_PAD_DRIVER_LSB) & WLAN_GPIO_PIN23_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN23_SOURCE_MSB               0
#define WLAN_GPIO_PIN23_SOURCE_LSB               0
#define WLAN_GPIO_PIN23_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN23_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN23_SOURCE_MASK) >> WLAN_GPIO_PIN23_SOURCE_LSB)
#define WLAN_GPIO_PIN23_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN23_SOURCE_LSB) & WLAN_GPIO_PIN23_SOURCE_MASK)

#define WLAN_GPIO_PIN24_ADDRESS                  0x000000b0
#define WLAN_GPIO_PIN24_OFFSET                   0x000000b0
#define WLAN_GPIO_PIN24_CONFIG_MSB               14
#define WLAN_GPIO_PIN24_CONFIG_LSB               11
#define WLAN_GPIO_PIN24_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN24_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN24_CONFIG_MASK) >> WLAN_GPIO_PIN24_CONFIG_LSB)
#define WLAN_GPIO_PIN24_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN24_CONFIG_LSB) & WLAN_GPIO_PIN24_CONFIG_MASK)
#define WLAN_GPIO_PIN24_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN24_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN24_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN24_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN24_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN24_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN24_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN24_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN24_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN24_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN24_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN24_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN24_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN24_INT_TYPE_MASK) >> WLAN_GPIO_PIN24_INT_TYPE_LSB)
#define WLAN_GPIO_PIN24_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN24_INT_TYPE_LSB) & WLAN_GPIO_PIN24_INT_TYPE_MASK)
#define WLAN_GPIO_PIN24_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN24_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN24_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN24_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN24_PAD_PULL_MASK) >> WLAN_GPIO_PIN24_PAD_PULL_LSB)
#define WLAN_GPIO_PIN24_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN24_PAD_PULL_LSB) & WLAN_GPIO_PIN24_PAD_PULL_MASK)
#define WLAN_GPIO_PIN24_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN24_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN24_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN24_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN24_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN24_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN24_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN24_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN24_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN24_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN24_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN24_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN24_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN24_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN24_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN24_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN24_PAD_DRIVER_LSB) & WLAN_GPIO_PIN24_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN24_SOURCE_MSB               0
#define WLAN_GPIO_PIN24_SOURCE_LSB               0
#define WLAN_GPIO_PIN24_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN24_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN24_SOURCE_MASK) >> WLAN_GPIO_PIN24_SOURCE_LSB)
#define WLAN_GPIO_PIN24_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN24_SOURCE_LSB) & WLAN_GPIO_PIN24_SOURCE_MASK)

#define WLAN_GPIO_PIN25_ADDRESS                  0x000000b4
#define WLAN_GPIO_PIN25_OFFSET                   0x000000b4
#define WLAN_GPIO_PIN25_CONFIG_MSB               14
#define WLAN_GPIO_PIN25_CONFIG_LSB               11
#define WLAN_GPIO_PIN25_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN25_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN25_CONFIG_MASK) >> WLAN_GPIO_PIN25_CONFIG_LSB)
#define WLAN_GPIO_PIN25_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN25_CONFIG_LSB) & WLAN_GPIO_PIN25_CONFIG_MASK)
#define WLAN_GPIO_PIN25_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN25_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN25_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN25_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN25_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN25_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN25_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN25_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN25_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN25_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN25_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN25_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN25_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN25_INT_TYPE_MASK) >> WLAN_GPIO_PIN25_INT_TYPE_LSB)
#define WLAN_GPIO_PIN25_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN25_INT_TYPE_LSB) & WLAN_GPIO_PIN25_INT_TYPE_MASK)
#define WLAN_GPIO_PIN25_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN25_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN25_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN25_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN25_PAD_PULL_MASK) >> WLAN_GPIO_PIN25_PAD_PULL_LSB)
#define WLAN_GPIO_PIN25_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN25_PAD_PULL_LSB) & WLAN_GPIO_PIN25_PAD_PULL_MASK)
#define WLAN_GPIO_PIN25_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN25_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN25_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN25_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN25_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN25_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN25_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN25_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN25_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN25_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN25_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN25_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN25_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN25_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN25_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN25_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN25_PAD_DRIVER_LSB) & WLAN_GPIO_PIN25_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN25_SOURCE_MSB               0
#define WLAN_GPIO_PIN25_SOURCE_LSB               0
#define WLAN_GPIO_PIN25_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN25_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN25_SOURCE_MASK) >> WLAN_GPIO_PIN25_SOURCE_LSB)
#define WLAN_GPIO_PIN25_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN25_SOURCE_LSB) & WLAN_GPIO_PIN25_SOURCE_MASK)

#define WLAN_GPIO_PIN26_ADDRESS                  0x000000b8
#define WLAN_GPIO_PIN26_OFFSET                   0x000000b8
#define WLAN_GPIO_PIN26_CONFIG_MSB               14
#define WLAN_GPIO_PIN26_CONFIG_LSB               11
#define WLAN_GPIO_PIN26_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN26_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN26_CONFIG_MASK) >> WLAN_GPIO_PIN26_CONFIG_LSB)
#define WLAN_GPIO_PIN26_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN26_CONFIG_LSB) & WLAN_GPIO_PIN26_CONFIG_MASK)
#define WLAN_GPIO_PIN26_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN26_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN26_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN26_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN26_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN26_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN26_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN26_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN26_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN26_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN26_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN26_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN26_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN26_INT_TYPE_MASK) >> WLAN_GPIO_PIN26_INT_TYPE_LSB)
#define WLAN_GPIO_PIN26_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN26_INT_TYPE_LSB) & WLAN_GPIO_PIN26_INT_TYPE_MASK)
#define WLAN_GPIO_PIN26_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN26_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN26_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN26_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN26_PAD_PULL_MASK) >> WLAN_GPIO_PIN26_PAD_PULL_LSB)
#define WLAN_GPIO_PIN26_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN26_PAD_PULL_LSB) & WLAN_GPIO_PIN26_PAD_PULL_MASK)
#define WLAN_GPIO_PIN26_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN26_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN26_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN26_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN26_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN26_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN26_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN26_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN26_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN26_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN26_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN26_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN26_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN26_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN26_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN26_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN26_PAD_DRIVER_LSB) & WLAN_GPIO_PIN26_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN26_SOURCE_MSB               0
#define WLAN_GPIO_PIN26_SOURCE_LSB               0
#define WLAN_GPIO_PIN26_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN26_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN26_SOURCE_MASK) >> WLAN_GPIO_PIN26_SOURCE_LSB)
#define WLAN_GPIO_PIN26_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN26_SOURCE_LSB) & WLAN_GPIO_PIN26_SOURCE_MASK)

#define WLAN_GPIO_PIN27_ADDRESS                  0x000000bc
#define WLAN_GPIO_PIN27_OFFSET                   0x000000bc
#define WLAN_GPIO_PIN27_CONFIG_MSB               14
#define WLAN_GPIO_PIN27_CONFIG_LSB               11
#define WLAN_GPIO_PIN27_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN27_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN27_CONFIG_MASK) >> WLAN_GPIO_PIN27_CONFIG_LSB)
#define WLAN_GPIO_PIN27_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN27_CONFIG_LSB) & WLAN_GPIO_PIN27_CONFIG_MASK)
#define WLAN_GPIO_PIN27_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN27_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN27_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN27_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN27_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN27_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN27_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN27_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN27_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN27_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN27_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN27_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN27_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN27_INT_TYPE_MASK) >> WLAN_GPIO_PIN27_INT_TYPE_LSB)
#define WLAN_GPIO_PIN27_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN27_INT_TYPE_LSB) & WLAN_GPIO_PIN27_INT_TYPE_MASK)
#define WLAN_GPIO_PIN27_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN27_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN27_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN27_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN27_PAD_PULL_MASK) >> WLAN_GPIO_PIN27_PAD_PULL_LSB)
#define WLAN_GPIO_PIN27_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN27_PAD_PULL_LSB) & WLAN_GPIO_PIN27_PAD_PULL_MASK)
#define WLAN_GPIO_PIN27_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN27_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN27_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN27_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN27_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN27_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN27_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN27_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN27_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN27_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN27_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN27_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN27_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN27_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN27_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN27_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN27_PAD_DRIVER_LSB) & WLAN_GPIO_PIN27_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN27_SOURCE_MSB               0
#define WLAN_GPIO_PIN27_SOURCE_LSB               0
#define WLAN_GPIO_PIN27_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN27_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN27_SOURCE_MASK) >> WLAN_GPIO_PIN27_SOURCE_LSB)
#define WLAN_GPIO_PIN27_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN27_SOURCE_LSB) & WLAN_GPIO_PIN27_SOURCE_MASK)

#define WLAN_GPIO_PIN28_ADDRESS                  0x000000c0
#define WLAN_GPIO_PIN28_OFFSET                   0x000000c0
#define WLAN_GPIO_PIN28_CONFIG_MSB               14
#define WLAN_GPIO_PIN28_CONFIG_LSB               11
#define WLAN_GPIO_PIN28_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN28_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN28_CONFIG_MASK) >> WLAN_GPIO_PIN28_CONFIG_LSB)
#define WLAN_GPIO_PIN28_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN28_CONFIG_LSB) & WLAN_GPIO_PIN28_CONFIG_MASK)
#define WLAN_GPIO_PIN28_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN28_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN28_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN28_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN28_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN28_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN28_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN28_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN28_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN28_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN28_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN28_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN28_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN28_INT_TYPE_MASK) >> WLAN_GPIO_PIN28_INT_TYPE_LSB)
#define WLAN_GPIO_PIN28_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN28_INT_TYPE_LSB) & WLAN_GPIO_PIN28_INT_TYPE_MASK)
#define WLAN_GPIO_PIN28_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN28_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN28_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN28_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN28_PAD_PULL_MASK) >> WLAN_GPIO_PIN28_PAD_PULL_LSB)
#define WLAN_GPIO_PIN28_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN28_PAD_PULL_LSB) & WLAN_GPIO_PIN28_PAD_PULL_MASK)
#define WLAN_GPIO_PIN28_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN28_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN28_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN28_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN28_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN28_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN28_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN28_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN28_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN28_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN28_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN28_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN28_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN28_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN28_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN28_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN28_PAD_DRIVER_LSB) & WLAN_GPIO_PIN28_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN28_SOURCE_MSB               0
#define WLAN_GPIO_PIN28_SOURCE_LSB               0
#define WLAN_GPIO_PIN28_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN28_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN28_SOURCE_MASK) >> WLAN_GPIO_PIN28_SOURCE_LSB)
#define WLAN_GPIO_PIN28_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN28_SOURCE_LSB) & WLAN_GPIO_PIN28_SOURCE_MASK)

#define WLAN_GPIO_PIN29_ADDRESS                  0x000000c4
#define WLAN_GPIO_PIN29_OFFSET                   0x000000c4
#define WLAN_GPIO_PIN29_CONFIG_MSB               14
#define WLAN_GPIO_PIN29_CONFIG_LSB               11
#define WLAN_GPIO_PIN29_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN29_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN29_CONFIG_MASK) >> WLAN_GPIO_PIN29_CONFIG_LSB)
#define WLAN_GPIO_PIN29_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN29_CONFIG_LSB) & WLAN_GPIO_PIN29_CONFIG_MASK)
#define WLAN_GPIO_PIN29_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN29_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN29_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN29_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN29_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN29_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN29_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN29_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN29_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN29_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN29_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN29_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN29_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN29_INT_TYPE_MASK) >> WLAN_GPIO_PIN29_INT_TYPE_LSB)
#define WLAN_GPIO_PIN29_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN29_INT_TYPE_LSB) & WLAN_GPIO_PIN29_INT_TYPE_MASK)
#define WLAN_GPIO_PIN29_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN29_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN29_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN29_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN29_PAD_PULL_MASK) >> WLAN_GPIO_PIN29_PAD_PULL_LSB)
#define WLAN_GPIO_PIN29_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN29_PAD_PULL_LSB) & WLAN_GPIO_PIN29_PAD_PULL_MASK)
#define WLAN_GPIO_PIN29_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN29_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN29_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN29_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN29_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN29_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN29_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN29_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN29_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN29_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN29_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN29_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN29_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN29_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN29_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN29_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN29_PAD_DRIVER_LSB) & WLAN_GPIO_PIN29_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN29_SOURCE_MSB               0
#define WLAN_GPIO_PIN29_SOURCE_LSB               0
#define WLAN_GPIO_PIN29_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN29_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN29_SOURCE_MASK) >> WLAN_GPIO_PIN29_SOURCE_LSB)
#define WLAN_GPIO_PIN29_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN29_SOURCE_LSB) & WLAN_GPIO_PIN29_SOURCE_MASK)

#define WLAN_GPIO_PIN30_ADDRESS                  0x000000c8
#define WLAN_GPIO_PIN30_OFFSET                   0x000000c8
#define WLAN_GPIO_PIN30_CONFIG_MSB               14
#define WLAN_GPIO_PIN30_CONFIG_LSB               11
#define WLAN_GPIO_PIN30_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN30_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN30_CONFIG_MASK) >> WLAN_GPIO_PIN30_CONFIG_LSB)
#define WLAN_GPIO_PIN30_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN30_CONFIG_LSB) & WLAN_GPIO_PIN30_CONFIG_MASK)
#define WLAN_GPIO_PIN30_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN30_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN30_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN30_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN30_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN30_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN30_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN30_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN30_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN30_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN30_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN30_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN30_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN30_INT_TYPE_MASK) >> WLAN_GPIO_PIN30_INT_TYPE_LSB)
#define WLAN_GPIO_PIN30_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN30_INT_TYPE_LSB) & WLAN_GPIO_PIN30_INT_TYPE_MASK)
#define WLAN_GPIO_PIN30_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN30_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN30_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN30_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN30_PAD_PULL_MASK) >> WLAN_GPIO_PIN30_PAD_PULL_LSB)
#define WLAN_GPIO_PIN30_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN30_PAD_PULL_LSB) & WLAN_GPIO_PIN30_PAD_PULL_MASK)
#define WLAN_GPIO_PIN30_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN30_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN30_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN30_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN30_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN30_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN30_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN30_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN30_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN30_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN30_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN30_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN30_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN30_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN30_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN30_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN30_PAD_DRIVER_LSB) & WLAN_GPIO_PIN30_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN30_SOURCE_MSB               0
#define WLAN_GPIO_PIN30_SOURCE_LSB               0
#define WLAN_GPIO_PIN30_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN30_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN30_SOURCE_MASK) >> WLAN_GPIO_PIN30_SOURCE_LSB)
#define WLAN_GPIO_PIN30_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN30_SOURCE_LSB) & WLAN_GPIO_PIN30_SOURCE_MASK)

#define WLAN_GPIO_PIN31_ADDRESS                  0x000000cc
#define WLAN_GPIO_PIN31_OFFSET                   0x000000cc
#define WLAN_GPIO_PIN31_CONFIG_MSB               14
#define WLAN_GPIO_PIN31_CONFIG_LSB               11
#define WLAN_GPIO_PIN31_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN31_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN31_CONFIG_MASK) >> WLAN_GPIO_PIN31_CONFIG_LSB)
#define WLAN_GPIO_PIN31_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN31_CONFIG_LSB) & WLAN_GPIO_PIN31_CONFIG_MASK)
#define WLAN_GPIO_PIN31_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN31_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN31_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN31_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN31_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN31_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN31_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN31_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN31_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN31_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN31_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN31_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN31_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN31_INT_TYPE_MASK) >> WLAN_GPIO_PIN31_INT_TYPE_LSB)
#define WLAN_GPIO_PIN31_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN31_INT_TYPE_LSB) & WLAN_GPIO_PIN31_INT_TYPE_MASK)
#define WLAN_GPIO_PIN31_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN31_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN31_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN31_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN31_PAD_PULL_MASK) >> WLAN_GPIO_PIN31_PAD_PULL_LSB)
#define WLAN_GPIO_PIN31_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN31_PAD_PULL_LSB) & WLAN_GPIO_PIN31_PAD_PULL_MASK)
#define WLAN_GPIO_PIN31_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN31_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN31_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN31_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN31_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN31_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN31_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN31_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN31_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN31_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN31_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN31_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN31_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN31_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN31_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN31_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN31_PAD_DRIVER_LSB) & WLAN_GPIO_PIN31_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN31_SOURCE_MSB               0
#define WLAN_GPIO_PIN31_SOURCE_LSB               0
#define WLAN_GPIO_PIN31_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN31_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN31_SOURCE_MASK) >> WLAN_GPIO_PIN31_SOURCE_LSB)
#define WLAN_GPIO_PIN31_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN31_SOURCE_LSB) & WLAN_GPIO_PIN31_SOURCE_MASK)

#define WLAN_GPIO_PIN32_ADDRESS                  0x000000d0
#define WLAN_GPIO_PIN32_OFFSET                   0x000000d0
#define WLAN_GPIO_PIN32_CONFIG_MSB               14
#define WLAN_GPIO_PIN32_CONFIG_LSB               11
#define WLAN_GPIO_PIN32_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN32_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN32_CONFIG_MASK) >> WLAN_GPIO_PIN32_CONFIG_LSB)
#define WLAN_GPIO_PIN32_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN32_CONFIG_LSB) & WLAN_GPIO_PIN32_CONFIG_MASK)
#define WLAN_GPIO_PIN32_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN32_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN32_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN32_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN32_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN32_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN32_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN32_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN32_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN32_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN32_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN32_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN32_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN32_INT_TYPE_MASK) >> WLAN_GPIO_PIN32_INT_TYPE_LSB)
#define WLAN_GPIO_PIN32_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN32_INT_TYPE_LSB) & WLAN_GPIO_PIN32_INT_TYPE_MASK)
#define WLAN_GPIO_PIN32_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN32_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN32_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN32_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN32_PAD_PULL_MASK) >> WLAN_GPIO_PIN32_PAD_PULL_LSB)
#define WLAN_GPIO_PIN32_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN32_PAD_PULL_LSB) & WLAN_GPIO_PIN32_PAD_PULL_MASK)
#define WLAN_GPIO_PIN32_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN32_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN32_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN32_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN32_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN32_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN32_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN32_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN32_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN32_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN32_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN32_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN32_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN32_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN32_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN32_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN32_PAD_DRIVER_LSB) & WLAN_GPIO_PIN32_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN32_SOURCE_MSB               0
#define WLAN_GPIO_PIN32_SOURCE_LSB               0
#define WLAN_GPIO_PIN32_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN32_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN32_SOURCE_MASK) >> WLAN_GPIO_PIN32_SOURCE_LSB)
#define WLAN_GPIO_PIN32_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN32_SOURCE_LSB) & WLAN_GPIO_PIN32_SOURCE_MASK)

#define WLAN_GPIO_PIN33_ADDRESS                  0x000000d4
#define WLAN_GPIO_PIN33_OFFSET                   0x000000d4
#define WLAN_GPIO_PIN33_CONFIG_MSB               14
#define WLAN_GPIO_PIN33_CONFIG_LSB               11
#define WLAN_GPIO_PIN33_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN33_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN33_CONFIG_MASK) >> WLAN_GPIO_PIN33_CONFIG_LSB)
#define WLAN_GPIO_PIN33_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN33_CONFIG_LSB) & WLAN_GPIO_PIN33_CONFIG_MASK)
#define WLAN_GPIO_PIN33_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN33_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN33_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN33_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN33_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN33_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN33_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN33_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN33_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN33_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN33_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN33_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN33_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN33_INT_TYPE_MASK) >> WLAN_GPIO_PIN33_INT_TYPE_LSB)
#define WLAN_GPIO_PIN33_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN33_INT_TYPE_LSB) & WLAN_GPIO_PIN33_INT_TYPE_MASK)
#define WLAN_GPIO_PIN33_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN33_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN33_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN33_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN33_PAD_PULL_MASK) >> WLAN_GPIO_PIN33_PAD_PULL_LSB)
#define WLAN_GPIO_PIN33_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN33_PAD_PULL_LSB) & WLAN_GPIO_PIN33_PAD_PULL_MASK)
#define WLAN_GPIO_PIN33_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN33_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN33_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN33_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN33_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN33_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN33_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN33_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN33_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN33_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN33_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN33_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN33_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN33_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN33_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN33_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN33_PAD_DRIVER_LSB) & WLAN_GPIO_PIN33_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN33_SOURCE_MSB               0
#define WLAN_GPIO_PIN33_SOURCE_LSB               0
#define WLAN_GPIO_PIN33_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN33_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN33_SOURCE_MASK) >> WLAN_GPIO_PIN33_SOURCE_LSB)
#define WLAN_GPIO_PIN33_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN33_SOURCE_LSB) & WLAN_GPIO_PIN33_SOURCE_MASK)

#define WLAN_GPIO_PIN34_ADDRESS                  0x000000d8
#define WLAN_GPIO_PIN34_OFFSET                   0x000000d8
#define WLAN_GPIO_PIN34_CONFIG_MSB               14
#define WLAN_GPIO_PIN34_CONFIG_LSB               11
#define WLAN_GPIO_PIN34_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN34_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN34_CONFIG_MASK) >> WLAN_GPIO_PIN34_CONFIG_LSB)
#define WLAN_GPIO_PIN34_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN34_CONFIG_LSB) & WLAN_GPIO_PIN34_CONFIG_MASK)
#define WLAN_GPIO_PIN34_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN34_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN34_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN34_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN34_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN34_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN34_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN34_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN34_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN34_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN34_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN34_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN34_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN34_INT_TYPE_MASK) >> WLAN_GPIO_PIN34_INT_TYPE_LSB)
#define WLAN_GPIO_PIN34_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN34_INT_TYPE_LSB) & WLAN_GPIO_PIN34_INT_TYPE_MASK)
#define WLAN_GPIO_PIN34_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN34_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN34_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN34_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN34_PAD_PULL_MASK) >> WLAN_GPIO_PIN34_PAD_PULL_LSB)
#define WLAN_GPIO_PIN34_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN34_PAD_PULL_LSB) & WLAN_GPIO_PIN34_PAD_PULL_MASK)
#define WLAN_GPIO_PIN34_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN34_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN34_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN34_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN34_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN34_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN34_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN34_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN34_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN34_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN34_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN34_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN34_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN34_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN34_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN34_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN34_PAD_DRIVER_LSB) & WLAN_GPIO_PIN34_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN34_SOURCE_MSB               0
#define WLAN_GPIO_PIN34_SOURCE_LSB               0
#define WLAN_GPIO_PIN34_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN34_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN34_SOURCE_MASK) >> WLAN_GPIO_PIN34_SOURCE_LSB)
#define WLAN_GPIO_PIN34_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN34_SOURCE_LSB) & WLAN_GPIO_PIN34_SOURCE_MASK)

#define WLAN_GPIO_PIN35_ADDRESS                  0x000000dc
#define WLAN_GPIO_PIN35_OFFSET                   0x000000dc
#define WLAN_GPIO_PIN35_CONFIG_MSB               14
#define WLAN_GPIO_PIN35_CONFIG_LSB               11
#define WLAN_GPIO_PIN35_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN35_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN35_CONFIG_MASK) >> WLAN_GPIO_PIN35_CONFIG_LSB)
#define WLAN_GPIO_PIN35_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN35_CONFIG_LSB) & WLAN_GPIO_PIN35_CONFIG_MASK)
#define WLAN_GPIO_PIN35_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN35_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN35_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN35_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN35_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN35_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN35_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN35_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN35_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN35_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN35_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN35_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN35_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN35_INT_TYPE_MASK) >> WLAN_GPIO_PIN35_INT_TYPE_LSB)
#define WLAN_GPIO_PIN35_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN35_INT_TYPE_LSB) & WLAN_GPIO_PIN35_INT_TYPE_MASK)
#define WLAN_GPIO_PIN35_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN35_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN35_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN35_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN35_PAD_PULL_MASK) >> WLAN_GPIO_PIN35_PAD_PULL_LSB)
#define WLAN_GPIO_PIN35_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN35_PAD_PULL_LSB) & WLAN_GPIO_PIN35_PAD_PULL_MASK)
#define WLAN_GPIO_PIN35_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN35_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN35_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN35_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN35_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN35_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN35_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN35_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN35_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN35_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN35_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN35_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN35_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN35_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN35_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN35_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN35_PAD_DRIVER_LSB) & WLAN_GPIO_PIN35_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN35_SOURCE_MSB               0
#define WLAN_GPIO_PIN35_SOURCE_LSB               0
#define WLAN_GPIO_PIN35_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN35_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN35_SOURCE_MASK) >> WLAN_GPIO_PIN35_SOURCE_LSB)
#define WLAN_GPIO_PIN35_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN35_SOURCE_LSB) & WLAN_GPIO_PIN35_SOURCE_MASK)

#define WLAN_GPIO_PIN36_ADDRESS                  0x000000e0
#define WLAN_GPIO_PIN36_OFFSET                   0x000000e0
#define WLAN_GPIO_PIN36_CONFIG_MSB               14
#define WLAN_GPIO_PIN36_CONFIG_LSB               11
#define WLAN_GPIO_PIN36_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN36_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN36_CONFIG_MASK) >> WLAN_GPIO_PIN36_CONFIG_LSB)
#define WLAN_GPIO_PIN36_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN36_CONFIG_LSB) & WLAN_GPIO_PIN36_CONFIG_MASK)
#define WLAN_GPIO_PIN36_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN36_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN36_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN36_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN36_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN36_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN36_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN36_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN36_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN36_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN36_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN36_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN36_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN36_INT_TYPE_MASK) >> WLAN_GPIO_PIN36_INT_TYPE_LSB)
#define WLAN_GPIO_PIN36_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN36_INT_TYPE_LSB) & WLAN_GPIO_PIN36_INT_TYPE_MASK)
#define WLAN_GPIO_PIN36_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN36_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN36_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN36_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN36_PAD_PULL_MASK) >> WLAN_GPIO_PIN36_PAD_PULL_LSB)
#define WLAN_GPIO_PIN36_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN36_PAD_PULL_LSB) & WLAN_GPIO_PIN36_PAD_PULL_MASK)
#define WLAN_GPIO_PIN36_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN36_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN36_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN36_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN36_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN36_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN36_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN36_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN36_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN36_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN36_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN36_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN36_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN36_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN36_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN36_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN36_PAD_DRIVER_LSB) & WLAN_GPIO_PIN36_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN36_SOURCE_MSB               0
#define WLAN_GPIO_PIN36_SOURCE_LSB               0
#define WLAN_GPIO_PIN36_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN36_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN36_SOURCE_MASK) >> WLAN_GPIO_PIN36_SOURCE_LSB)
#define WLAN_GPIO_PIN36_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN36_SOURCE_LSB) & WLAN_GPIO_PIN36_SOURCE_MASK)

#define WLAN_GPIO_PIN37_ADDRESS                  0x000000e4
#define WLAN_GPIO_PIN37_OFFSET                   0x000000e4
#define WLAN_GPIO_PIN37_CONFIG_MSB               14
#define WLAN_GPIO_PIN37_CONFIG_LSB               11
#define WLAN_GPIO_PIN37_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN37_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN37_CONFIG_MASK) >> WLAN_GPIO_PIN37_CONFIG_LSB)
#define WLAN_GPIO_PIN37_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN37_CONFIG_LSB) & WLAN_GPIO_PIN37_CONFIG_MASK)
#define WLAN_GPIO_PIN37_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN37_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN37_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN37_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN37_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN37_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN37_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN37_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN37_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN37_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN37_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN37_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN37_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN37_INT_TYPE_MASK) >> WLAN_GPIO_PIN37_INT_TYPE_LSB)
#define WLAN_GPIO_PIN37_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN37_INT_TYPE_LSB) & WLAN_GPIO_PIN37_INT_TYPE_MASK)
#define WLAN_GPIO_PIN37_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN37_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN37_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN37_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN37_PAD_PULL_MASK) >> WLAN_GPIO_PIN37_PAD_PULL_LSB)
#define WLAN_GPIO_PIN37_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN37_PAD_PULL_LSB) & WLAN_GPIO_PIN37_PAD_PULL_MASK)
#define WLAN_GPIO_PIN37_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN37_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN37_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN37_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN37_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN37_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN37_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN37_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN37_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN37_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN37_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN37_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN37_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN37_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN37_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN37_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN37_PAD_DRIVER_LSB) & WLAN_GPIO_PIN37_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN37_SOURCE_MSB               0
#define WLAN_GPIO_PIN37_SOURCE_LSB               0
#define WLAN_GPIO_PIN37_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN37_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN37_SOURCE_MASK) >> WLAN_GPIO_PIN37_SOURCE_LSB)
#define WLAN_GPIO_PIN37_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN37_SOURCE_LSB) & WLAN_GPIO_PIN37_SOURCE_MASK)

#define WLAN_GPIO_PIN38_ADDRESS                  0x000000e8
#define WLAN_GPIO_PIN38_OFFSET                   0x000000e8
#define WLAN_GPIO_PIN38_CONFIG_MSB               14
#define WLAN_GPIO_PIN38_CONFIG_LSB               11
#define WLAN_GPIO_PIN38_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN38_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN38_CONFIG_MASK) >> WLAN_GPIO_PIN38_CONFIG_LSB)
#define WLAN_GPIO_PIN38_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN38_CONFIG_LSB) & WLAN_GPIO_PIN38_CONFIG_MASK)
#define WLAN_GPIO_PIN38_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN38_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN38_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN38_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN38_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN38_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN38_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN38_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN38_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN38_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN38_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN38_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN38_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN38_INT_TYPE_MASK) >> WLAN_GPIO_PIN38_INT_TYPE_LSB)
#define WLAN_GPIO_PIN38_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN38_INT_TYPE_LSB) & WLAN_GPIO_PIN38_INT_TYPE_MASK)
#define WLAN_GPIO_PIN38_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN38_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN38_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN38_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN38_PAD_PULL_MASK) >> WLAN_GPIO_PIN38_PAD_PULL_LSB)
#define WLAN_GPIO_PIN38_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN38_PAD_PULL_LSB) & WLAN_GPIO_PIN38_PAD_PULL_MASK)
#define WLAN_GPIO_PIN38_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN38_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN38_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN38_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN38_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN38_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN38_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN38_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN38_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN38_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN38_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN38_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN38_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN38_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN38_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN38_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN38_PAD_DRIVER_LSB) & WLAN_GPIO_PIN38_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN38_SOURCE_MSB               0
#define WLAN_GPIO_PIN38_SOURCE_LSB               0
#define WLAN_GPIO_PIN38_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN38_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN38_SOURCE_MASK) >> WLAN_GPIO_PIN38_SOURCE_LSB)
#define WLAN_GPIO_PIN38_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN38_SOURCE_LSB) & WLAN_GPIO_PIN38_SOURCE_MASK)

#define WLAN_GPIO_PIN39_ADDRESS                  0x000000ec
#define WLAN_GPIO_PIN39_OFFSET                   0x000000ec
#define WLAN_GPIO_PIN39_CONFIG_MSB               14
#define WLAN_GPIO_PIN39_CONFIG_LSB               11
#define WLAN_GPIO_PIN39_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN39_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN39_CONFIG_MASK) >> WLAN_GPIO_PIN39_CONFIG_LSB)
#define WLAN_GPIO_PIN39_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN39_CONFIG_LSB) & WLAN_GPIO_PIN39_CONFIG_MASK)
#define WLAN_GPIO_PIN39_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN39_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN39_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN39_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN39_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN39_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN39_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN39_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN39_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN39_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN39_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN39_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN39_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN39_INT_TYPE_MASK) >> WLAN_GPIO_PIN39_INT_TYPE_LSB)
#define WLAN_GPIO_PIN39_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN39_INT_TYPE_LSB) & WLAN_GPIO_PIN39_INT_TYPE_MASK)
#define WLAN_GPIO_PIN39_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN39_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN39_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN39_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN39_PAD_PULL_MASK) >> WLAN_GPIO_PIN39_PAD_PULL_LSB)
#define WLAN_GPIO_PIN39_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN39_PAD_PULL_LSB) & WLAN_GPIO_PIN39_PAD_PULL_MASK)
#define WLAN_GPIO_PIN39_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN39_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN39_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN39_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN39_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN39_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN39_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN39_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN39_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN39_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN39_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN39_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN39_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN39_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN39_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN39_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN39_PAD_DRIVER_LSB) & WLAN_GPIO_PIN39_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN39_SOURCE_MSB               0
#define WLAN_GPIO_PIN39_SOURCE_LSB               0
#define WLAN_GPIO_PIN39_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN39_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN39_SOURCE_MASK) >> WLAN_GPIO_PIN39_SOURCE_LSB)
#define WLAN_GPIO_PIN39_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN39_SOURCE_LSB) & WLAN_GPIO_PIN39_SOURCE_MASK)

#define WLAN_GPIO_PIN40_ADDRESS                  0x000000f0
#define WLAN_GPIO_PIN40_OFFSET                   0x000000f0
#define WLAN_GPIO_PIN40_CONFIG_MSB               14
#define WLAN_GPIO_PIN40_CONFIG_LSB               11
#define WLAN_GPIO_PIN40_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN40_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN40_CONFIG_MASK) >> WLAN_GPIO_PIN40_CONFIG_LSB)
#define WLAN_GPIO_PIN40_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN40_CONFIG_LSB) & WLAN_GPIO_PIN40_CONFIG_MASK)
#define WLAN_GPIO_PIN40_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN40_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN40_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN40_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN40_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN40_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN40_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN40_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN40_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN40_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN40_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN40_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN40_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN40_INT_TYPE_MASK) >> WLAN_GPIO_PIN40_INT_TYPE_LSB)
#define WLAN_GPIO_PIN40_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN40_INT_TYPE_LSB) & WLAN_GPIO_PIN40_INT_TYPE_MASK)
#define WLAN_GPIO_PIN40_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN40_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN40_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN40_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN40_PAD_PULL_MASK) >> WLAN_GPIO_PIN40_PAD_PULL_LSB)
#define WLAN_GPIO_PIN40_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN40_PAD_PULL_LSB) & WLAN_GPIO_PIN40_PAD_PULL_MASK)
#define WLAN_GPIO_PIN40_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN40_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN40_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN40_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN40_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN40_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN40_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN40_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN40_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN40_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN40_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN40_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN40_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN40_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN40_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN40_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN40_PAD_DRIVER_LSB) & WLAN_GPIO_PIN40_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN40_SOURCE_MSB               0
#define WLAN_GPIO_PIN40_SOURCE_LSB               0
#define WLAN_GPIO_PIN40_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN40_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN40_SOURCE_MASK) >> WLAN_GPIO_PIN40_SOURCE_LSB)
#define WLAN_GPIO_PIN40_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN40_SOURCE_LSB) & WLAN_GPIO_PIN40_SOURCE_MASK)

#define WLAN_GPIO_PIN41_ADDRESS                  0x000000f4
#define WLAN_GPIO_PIN41_OFFSET                   0x000000f4
#define WLAN_GPIO_PIN41_CONFIG_MSB               14
#define WLAN_GPIO_PIN41_CONFIG_LSB               11
#define WLAN_GPIO_PIN41_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN41_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN41_CONFIG_MASK) >> WLAN_GPIO_PIN41_CONFIG_LSB)
#define WLAN_GPIO_PIN41_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN41_CONFIG_LSB) & WLAN_GPIO_PIN41_CONFIG_MASK)
#define WLAN_GPIO_PIN41_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN41_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN41_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN41_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN41_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN41_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN41_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN41_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN41_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN41_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN41_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN41_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN41_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN41_INT_TYPE_MASK) >> WLAN_GPIO_PIN41_INT_TYPE_LSB)
#define WLAN_GPIO_PIN41_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN41_INT_TYPE_LSB) & WLAN_GPIO_PIN41_INT_TYPE_MASK)
#define WLAN_GPIO_PIN41_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN41_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN41_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN41_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN41_PAD_PULL_MASK) >> WLAN_GPIO_PIN41_PAD_PULL_LSB)
#define WLAN_GPIO_PIN41_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN41_PAD_PULL_LSB) & WLAN_GPIO_PIN41_PAD_PULL_MASK)
#define WLAN_GPIO_PIN41_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN41_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN41_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN41_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN41_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN41_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN41_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN41_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN41_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN41_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN41_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN41_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN41_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN41_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN41_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN41_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN41_PAD_DRIVER_LSB) & WLAN_GPIO_PIN41_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN41_SOURCE_MSB               0
#define WLAN_GPIO_PIN41_SOURCE_LSB               0
#define WLAN_GPIO_PIN41_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN41_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN41_SOURCE_MASK) >> WLAN_GPIO_PIN41_SOURCE_LSB)
#define WLAN_GPIO_PIN41_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN41_SOURCE_LSB) & WLAN_GPIO_PIN41_SOURCE_MASK)

#define WLAN_GPIO_PIN42_ADDRESS                  0x000000f8
#define WLAN_GPIO_PIN42_OFFSET                   0x000000f8
#define WLAN_GPIO_PIN42_CONFIG_MSB               14
#define WLAN_GPIO_PIN42_CONFIG_LSB               11
#define WLAN_GPIO_PIN42_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN42_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN42_CONFIG_MASK) >> WLAN_GPIO_PIN42_CONFIG_LSB)
#define WLAN_GPIO_PIN42_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN42_CONFIG_LSB) & WLAN_GPIO_PIN42_CONFIG_MASK)
#define WLAN_GPIO_PIN42_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN42_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN42_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN42_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN42_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN42_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN42_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN42_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN42_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN42_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN42_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN42_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN42_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN42_INT_TYPE_MASK) >> WLAN_GPIO_PIN42_INT_TYPE_LSB)
#define WLAN_GPIO_PIN42_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN42_INT_TYPE_LSB) & WLAN_GPIO_PIN42_INT_TYPE_MASK)
#define WLAN_GPIO_PIN42_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN42_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN42_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN42_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN42_PAD_PULL_MASK) >> WLAN_GPIO_PIN42_PAD_PULL_LSB)
#define WLAN_GPIO_PIN42_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN42_PAD_PULL_LSB) & WLAN_GPIO_PIN42_PAD_PULL_MASK)
#define WLAN_GPIO_PIN42_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN42_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN42_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN42_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN42_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN42_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN42_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN42_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN42_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN42_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN42_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN42_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN42_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN42_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN42_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN42_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN42_PAD_DRIVER_LSB) & WLAN_GPIO_PIN42_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN42_SOURCE_MSB               0
#define WLAN_GPIO_PIN42_SOURCE_LSB               0
#define WLAN_GPIO_PIN42_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN42_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN42_SOURCE_MASK) >> WLAN_GPIO_PIN42_SOURCE_LSB)
#define WLAN_GPIO_PIN42_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN42_SOURCE_LSB) & WLAN_GPIO_PIN42_SOURCE_MASK)

#define WLAN_GPIO_PIN43_ADDRESS                  0x000000fc
#define WLAN_GPIO_PIN43_OFFSET                   0x000000fc
#define WLAN_GPIO_PIN43_CONFIG_MSB               14
#define WLAN_GPIO_PIN43_CONFIG_LSB               11
#define WLAN_GPIO_PIN43_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN43_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN43_CONFIG_MASK) >> WLAN_GPIO_PIN43_CONFIG_LSB)
#define WLAN_GPIO_PIN43_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN43_CONFIG_LSB) & WLAN_GPIO_PIN43_CONFIG_MASK)
#define WLAN_GPIO_PIN43_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN43_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN43_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN43_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN43_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN43_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN43_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN43_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN43_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN43_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN43_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN43_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN43_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN43_INT_TYPE_MASK) >> WLAN_GPIO_PIN43_INT_TYPE_LSB)
#define WLAN_GPIO_PIN43_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN43_INT_TYPE_LSB) & WLAN_GPIO_PIN43_INT_TYPE_MASK)
#define WLAN_GPIO_PIN43_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN43_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN43_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN43_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN43_PAD_PULL_MASK) >> WLAN_GPIO_PIN43_PAD_PULL_LSB)
#define WLAN_GPIO_PIN43_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN43_PAD_PULL_LSB) & WLAN_GPIO_PIN43_PAD_PULL_MASK)
#define WLAN_GPIO_PIN43_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN43_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN43_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN43_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN43_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN43_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN43_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN43_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN43_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN43_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN43_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN43_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN43_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN43_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN43_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN43_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN43_PAD_DRIVER_LSB) & WLAN_GPIO_PIN43_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN43_SOURCE_MSB               0
#define WLAN_GPIO_PIN43_SOURCE_LSB               0
#define WLAN_GPIO_PIN43_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN43_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN43_SOURCE_MASK) >> WLAN_GPIO_PIN43_SOURCE_LSB)
#define WLAN_GPIO_PIN43_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN43_SOURCE_LSB) & WLAN_GPIO_PIN43_SOURCE_MASK)

#define WLAN_GPIO_PIN44_ADDRESS                  0x00000100
#define WLAN_GPIO_PIN44_OFFSET                   0x00000100
#define WLAN_GPIO_PIN44_CONFIG_MSB               14
#define WLAN_GPIO_PIN44_CONFIG_LSB               11
#define WLAN_GPIO_PIN44_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN44_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN44_CONFIG_MASK) >> WLAN_GPIO_PIN44_CONFIG_LSB)
#define WLAN_GPIO_PIN44_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN44_CONFIG_LSB) & WLAN_GPIO_PIN44_CONFIG_MASK)
#define WLAN_GPIO_PIN44_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN44_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN44_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN44_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN44_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN44_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN44_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN44_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN44_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN44_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN44_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN44_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN44_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN44_INT_TYPE_MASK) >> WLAN_GPIO_PIN44_INT_TYPE_LSB)
#define WLAN_GPIO_PIN44_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN44_INT_TYPE_LSB) & WLAN_GPIO_PIN44_INT_TYPE_MASK)
#define WLAN_GPIO_PIN44_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN44_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN44_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN44_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN44_PAD_PULL_MASK) >> WLAN_GPIO_PIN44_PAD_PULL_LSB)
#define WLAN_GPIO_PIN44_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN44_PAD_PULL_LSB) & WLAN_GPIO_PIN44_PAD_PULL_MASK)
#define WLAN_GPIO_PIN44_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN44_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN44_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN44_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN44_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN44_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN44_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN44_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN44_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN44_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN44_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN44_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN44_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN44_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN44_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN44_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN44_PAD_DRIVER_LSB) & WLAN_GPIO_PIN44_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN44_SOURCE_MSB               0
#define WLAN_GPIO_PIN44_SOURCE_LSB               0
#define WLAN_GPIO_PIN44_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN44_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN44_SOURCE_MASK) >> WLAN_GPIO_PIN44_SOURCE_LSB)
#define WLAN_GPIO_PIN44_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN44_SOURCE_LSB) & WLAN_GPIO_PIN44_SOURCE_MASK)

#define WLAN_GPIO_PIN45_ADDRESS                  0x00000104
#define WLAN_GPIO_PIN45_OFFSET                   0x00000104
#define WLAN_GPIO_PIN45_CONFIG_MSB               14
#define WLAN_GPIO_PIN45_CONFIG_LSB               11
#define WLAN_GPIO_PIN45_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN45_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN45_CONFIG_MASK) >> WLAN_GPIO_PIN45_CONFIG_LSB)
#define WLAN_GPIO_PIN45_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN45_CONFIG_LSB) & WLAN_GPIO_PIN45_CONFIG_MASK)
#define WLAN_GPIO_PIN45_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN45_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN45_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN45_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN45_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN45_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN45_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN45_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN45_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN45_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN45_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN45_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN45_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN45_INT_TYPE_MASK) >> WLAN_GPIO_PIN45_INT_TYPE_LSB)
#define WLAN_GPIO_PIN45_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN45_INT_TYPE_LSB) & WLAN_GPIO_PIN45_INT_TYPE_MASK)
#define WLAN_GPIO_PIN45_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN45_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN45_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN45_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN45_PAD_PULL_MASK) >> WLAN_GPIO_PIN45_PAD_PULL_LSB)
#define WLAN_GPIO_PIN45_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN45_PAD_PULL_LSB) & WLAN_GPIO_PIN45_PAD_PULL_MASK)
#define WLAN_GPIO_PIN45_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN45_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN45_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN45_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN45_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN45_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN45_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN45_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN45_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN45_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN45_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN45_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN45_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN45_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN45_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN45_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN45_PAD_DRIVER_LSB) & WLAN_GPIO_PIN45_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN45_SOURCE_MSB               0
#define WLAN_GPIO_PIN45_SOURCE_LSB               0
#define WLAN_GPIO_PIN45_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN45_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN45_SOURCE_MASK) >> WLAN_GPIO_PIN45_SOURCE_LSB)
#define WLAN_GPIO_PIN45_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN45_SOURCE_LSB) & WLAN_GPIO_PIN45_SOURCE_MASK)

#define WLAN_GPIO_PIN46_ADDRESS                  0x00000108
#define WLAN_GPIO_PIN46_OFFSET                   0x00000108
#define WLAN_GPIO_PIN46_CONFIG_MSB               14
#define WLAN_GPIO_PIN46_CONFIG_LSB               11
#define WLAN_GPIO_PIN46_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN46_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN46_CONFIG_MASK) >> WLAN_GPIO_PIN46_CONFIG_LSB)
#define WLAN_GPIO_PIN46_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN46_CONFIG_LSB) & WLAN_GPIO_PIN46_CONFIG_MASK)
#define WLAN_GPIO_PIN46_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN46_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN46_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN46_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN46_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN46_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN46_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN46_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN46_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN46_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN46_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN46_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN46_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN46_INT_TYPE_MASK) >> WLAN_GPIO_PIN46_INT_TYPE_LSB)
#define WLAN_GPIO_PIN46_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN46_INT_TYPE_LSB) & WLAN_GPIO_PIN46_INT_TYPE_MASK)
#define WLAN_GPIO_PIN46_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN46_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN46_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN46_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN46_PAD_PULL_MASK) >> WLAN_GPIO_PIN46_PAD_PULL_LSB)
#define WLAN_GPIO_PIN46_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN46_PAD_PULL_LSB) & WLAN_GPIO_PIN46_PAD_PULL_MASK)
#define WLAN_GPIO_PIN46_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN46_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN46_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN46_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN46_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN46_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN46_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN46_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN46_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN46_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN46_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN46_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN46_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN46_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN46_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN46_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN46_PAD_DRIVER_LSB) & WLAN_GPIO_PIN46_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN46_SOURCE_MSB               0
#define WLAN_GPIO_PIN46_SOURCE_LSB               0
#define WLAN_GPIO_PIN46_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN46_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN46_SOURCE_MASK) >> WLAN_GPIO_PIN46_SOURCE_LSB)
#define WLAN_GPIO_PIN46_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN46_SOURCE_LSB) & WLAN_GPIO_PIN46_SOURCE_MASK)

#define WLAN_GPIO_PIN47_ADDRESS                  0x0000010c
#define WLAN_GPIO_PIN47_OFFSET                   0x0000010c
#define WLAN_GPIO_PIN47_CONFIG_MSB               14
#define WLAN_GPIO_PIN47_CONFIG_LSB               11
#define WLAN_GPIO_PIN47_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN47_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN47_CONFIG_MASK) >> WLAN_GPIO_PIN47_CONFIG_LSB)
#define WLAN_GPIO_PIN47_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN47_CONFIG_LSB) & WLAN_GPIO_PIN47_CONFIG_MASK)
#define WLAN_GPIO_PIN47_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN47_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN47_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN47_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN47_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN47_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN47_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN47_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN47_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN47_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN47_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN47_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN47_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN47_INT_TYPE_MASK) >> WLAN_GPIO_PIN47_INT_TYPE_LSB)
#define WLAN_GPIO_PIN47_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN47_INT_TYPE_LSB) & WLAN_GPIO_PIN47_INT_TYPE_MASK)
#define WLAN_GPIO_PIN47_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN47_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN47_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN47_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN47_PAD_PULL_MASK) >> WLAN_GPIO_PIN47_PAD_PULL_LSB)
#define WLAN_GPIO_PIN47_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN47_PAD_PULL_LSB) & WLAN_GPIO_PIN47_PAD_PULL_MASK)
#define WLAN_GPIO_PIN47_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN47_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN47_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN47_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN47_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN47_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN47_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN47_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN47_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN47_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN47_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN47_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN47_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN47_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN47_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN47_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN47_PAD_DRIVER_LSB) & WLAN_GPIO_PIN47_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN47_SOURCE_MSB               0
#define WLAN_GPIO_PIN47_SOURCE_LSB               0
#define WLAN_GPIO_PIN47_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN47_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN47_SOURCE_MASK) >> WLAN_GPIO_PIN47_SOURCE_LSB)
#define WLAN_GPIO_PIN47_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN47_SOURCE_LSB) & WLAN_GPIO_PIN47_SOURCE_MASK)

#define WLAN_GPIO_PIN48_ADDRESS                  0x00000110
#define WLAN_GPIO_PIN48_OFFSET                   0x00000110
#define WLAN_GPIO_PIN48_CONFIG_MSB               14
#define WLAN_GPIO_PIN48_CONFIG_LSB               11
#define WLAN_GPIO_PIN48_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN48_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN48_CONFIG_MASK) >> WLAN_GPIO_PIN48_CONFIG_LSB)
#define WLAN_GPIO_PIN48_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN48_CONFIG_LSB) & WLAN_GPIO_PIN48_CONFIG_MASK)
#define WLAN_GPIO_PIN48_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN48_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN48_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN48_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN48_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN48_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN48_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN48_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN48_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN48_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN48_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN48_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN48_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN48_INT_TYPE_MASK) >> WLAN_GPIO_PIN48_INT_TYPE_LSB)
#define WLAN_GPIO_PIN48_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN48_INT_TYPE_LSB) & WLAN_GPIO_PIN48_INT_TYPE_MASK)
#define WLAN_GPIO_PIN48_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN48_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN48_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN48_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN48_PAD_PULL_MASK) >> WLAN_GPIO_PIN48_PAD_PULL_LSB)
#define WLAN_GPIO_PIN48_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN48_PAD_PULL_LSB) & WLAN_GPIO_PIN48_PAD_PULL_MASK)
#define WLAN_GPIO_PIN48_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN48_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN48_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN48_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN48_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN48_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN48_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN48_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN48_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN48_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN48_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN48_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN48_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN48_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN48_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN48_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN48_PAD_DRIVER_LSB) & WLAN_GPIO_PIN48_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN48_SOURCE_MSB               0
#define WLAN_GPIO_PIN48_SOURCE_LSB               0
#define WLAN_GPIO_PIN48_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN48_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN48_SOURCE_MASK) >> WLAN_GPIO_PIN48_SOURCE_LSB)
#define WLAN_GPIO_PIN48_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN48_SOURCE_LSB) & WLAN_GPIO_PIN48_SOURCE_MASK)

#define WLAN_GPIO_PIN49_ADDRESS                  0x00000114
#define WLAN_GPIO_PIN49_OFFSET                   0x00000114
#define WLAN_GPIO_PIN49_CONFIG_MSB               14
#define WLAN_GPIO_PIN49_CONFIG_LSB               11
#define WLAN_GPIO_PIN49_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN49_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN49_CONFIG_MASK) >> WLAN_GPIO_PIN49_CONFIG_LSB)
#define WLAN_GPIO_PIN49_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN49_CONFIG_LSB) & WLAN_GPIO_PIN49_CONFIG_MASK)
#define WLAN_GPIO_PIN49_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN49_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN49_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN49_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN49_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN49_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN49_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN49_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN49_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN49_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN49_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN49_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN49_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN49_INT_TYPE_MASK) >> WLAN_GPIO_PIN49_INT_TYPE_LSB)
#define WLAN_GPIO_PIN49_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN49_INT_TYPE_LSB) & WLAN_GPIO_PIN49_INT_TYPE_MASK)
#define WLAN_GPIO_PIN49_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN49_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN49_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN49_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN49_PAD_PULL_MASK) >> WLAN_GPIO_PIN49_PAD_PULL_LSB)
#define WLAN_GPIO_PIN49_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN49_PAD_PULL_LSB) & WLAN_GPIO_PIN49_PAD_PULL_MASK)
#define WLAN_GPIO_PIN49_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN49_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN49_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN49_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN49_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN49_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN49_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN49_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN49_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN49_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN49_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN49_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN49_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN49_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN49_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN49_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN49_PAD_DRIVER_LSB) & WLAN_GPIO_PIN49_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN49_SOURCE_MSB               0
#define WLAN_GPIO_PIN49_SOURCE_LSB               0
#define WLAN_GPIO_PIN49_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN49_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN49_SOURCE_MASK) >> WLAN_GPIO_PIN49_SOURCE_LSB)
#define WLAN_GPIO_PIN49_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN49_SOURCE_LSB) & WLAN_GPIO_PIN49_SOURCE_MASK)

#define WLAN_GPIO_PIN50_ADDRESS                  0x00000118
#define WLAN_GPIO_PIN50_OFFSET                   0x00000118
#define WLAN_GPIO_PIN50_CONFIG_MSB               14
#define WLAN_GPIO_PIN50_CONFIG_LSB               11
#define WLAN_GPIO_PIN50_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN50_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN50_CONFIG_MASK) >> WLAN_GPIO_PIN50_CONFIG_LSB)
#define WLAN_GPIO_PIN50_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN50_CONFIG_LSB) & WLAN_GPIO_PIN50_CONFIG_MASK)
#define WLAN_GPIO_PIN50_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN50_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN50_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN50_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN50_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN50_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN50_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN50_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN50_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN50_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN50_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN50_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN50_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN50_INT_TYPE_MASK) >> WLAN_GPIO_PIN50_INT_TYPE_LSB)
#define WLAN_GPIO_PIN50_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN50_INT_TYPE_LSB) & WLAN_GPIO_PIN50_INT_TYPE_MASK)
#define WLAN_GPIO_PIN50_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN50_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN50_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN50_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN50_PAD_PULL_MASK) >> WLAN_GPIO_PIN50_PAD_PULL_LSB)
#define WLAN_GPIO_PIN50_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN50_PAD_PULL_LSB) & WLAN_GPIO_PIN50_PAD_PULL_MASK)
#define WLAN_GPIO_PIN50_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN50_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN50_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN50_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN50_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN50_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN50_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN50_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN50_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN50_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN50_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN50_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN50_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN50_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN50_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN50_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN50_PAD_DRIVER_LSB) & WLAN_GPIO_PIN50_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN50_SOURCE_MSB               0
#define WLAN_GPIO_PIN50_SOURCE_LSB               0
#define WLAN_GPIO_PIN50_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN50_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN50_SOURCE_MASK) >> WLAN_GPIO_PIN50_SOURCE_LSB)
#define WLAN_GPIO_PIN50_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN50_SOURCE_LSB) & WLAN_GPIO_PIN50_SOURCE_MASK)

#define WLAN_GPIO_PIN51_ADDRESS                  0x0000011c
#define WLAN_GPIO_PIN51_OFFSET                   0x0000011c
#define WLAN_GPIO_PIN51_CONFIG_MSB               14
#define WLAN_GPIO_PIN51_CONFIG_LSB               11
#define WLAN_GPIO_PIN51_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN51_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN51_CONFIG_MASK) >> WLAN_GPIO_PIN51_CONFIG_LSB)
#define WLAN_GPIO_PIN51_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN51_CONFIG_LSB) & WLAN_GPIO_PIN51_CONFIG_MASK)
#define WLAN_GPIO_PIN51_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN51_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN51_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN51_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN51_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN51_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN51_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN51_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN51_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN51_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN51_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN51_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN51_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN51_INT_TYPE_MASK) >> WLAN_GPIO_PIN51_INT_TYPE_LSB)
#define WLAN_GPIO_PIN51_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN51_INT_TYPE_LSB) & WLAN_GPIO_PIN51_INT_TYPE_MASK)
#define WLAN_GPIO_PIN51_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN51_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN51_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN51_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN51_PAD_PULL_MASK) >> WLAN_GPIO_PIN51_PAD_PULL_LSB)
#define WLAN_GPIO_PIN51_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN51_PAD_PULL_LSB) & WLAN_GPIO_PIN51_PAD_PULL_MASK)
#define WLAN_GPIO_PIN51_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN51_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN51_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN51_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN51_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN51_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN51_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN51_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN51_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN51_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN51_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN51_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN51_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN51_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN51_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN51_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN51_PAD_DRIVER_LSB) & WLAN_GPIO_PIN51_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN51_SOURCE_MSB               0
#define WLAN_GPIO_PIN51_SOURCE_LSB               0
#define WLAN_GPIO_PIN51_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN51_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN51_SOURCE_MASK) >> WLAN_GPIO_PIN51_SOURCE_LSB)
#define WLAN_GPIO_PIN51_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN51_SOURCE_LSB) & WLAN_GPIO_PIN51_SOURCE_MASK)

#define WLAN_GPIO_PIN52_ADDRESS                  0x00000120
#define WLAN_GPIO_PIN52_OFFSET                   0x00000120
#define WLAN_GPIO_PIN52_CONFIG_MSB               14
#define WLAN_GPIO_PIN52_CONFIG_LSB               11
#define WLAN_GPIO_PIN52_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN52_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN52_CONFIG_MASK) >> WLAN_GPIO_PIN52_CONFIG_LSB)
#define WLAN_GPIO_PIN52_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN52_CONFIG_LSB) & WLAN_GPIO_PIN52_CONFIG_MASK)
#define WLAN_GPIO_PIN52_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN52_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN52_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN52_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN52_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN52_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN52_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN52_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN52_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN52_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN52_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN52_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN52_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN52_INT_TYPE_MASK) >> WLAN_GPIO_PIN52_INT_TYPE_LSB)
#define WLAN_GPIO_PIN52_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN52_INT_TYPE_LSB) & WLAN_GPIO_PIN52_INT_TYPE_MASK)
#define WLAN_GPIO_PIN52_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN52_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN52_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN52_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN52_PAD_PULL_MASK) >> WLAN_GPIO_PIN52_PAD_PULL_LSB)
#define WLAN_GPIO_PIN52_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN52_PAD_PULL_LSB) & WLAN_GPIO_PIN52_PAD_PULL_MASK)
#define WLAN_GPIO_PIN52_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN52_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN52_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN52_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN52_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN52_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN52_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN52_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN52_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN52_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN52_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN52_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN52_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN52_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN52_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN52_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN52_PAD_DRIVER_LSB) & WLAN_GPIO_PIN52_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN52_SOURCE_MSB               0
#define WLAN_GPIO_PIN52_SOURCE_LSB               0
#define WLAN_GPIO_PIN52_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN52_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN52_SOURCE_MASK) >> WLAN_GPIO_PIN52_SOURCE_LSB)
#define WLAN_GPIO_PIN52_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN52_SOURCE_LSB) & WLAN_GPIO_PIN52_SOURCE_MASK)

#define WLAN_GPIO_PIN53_ADDRESS                  0x00000124
#define WLAN_GPIO_PIN53_OFFSET                   0x00000124
#define WLAN_GPIO_PIN53_CONFIG_MSB               14
#define WLAN_GPIO_PIN53_CONFIG_LSB               11
#define WLAN_GPIO_PIN53_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN53_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN53_CONFIG_MASK) >> WLAN_GPIO_PIN53_CONFIG_LSB)
#define WLAN_GPIO_PIN53_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN53_CONFIG_LSB) & WLAN_GPIO_PIN53_CONFIG_MASK)
#define WLAN_GPIO_PIN53_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN53_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN53_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN53_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN53_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN53_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN53_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN53_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN53_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN53_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN53_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN53_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN53_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN53_INT_TYPE_MASK) >> WLAN_GPIO_PIN53_INT_TYPE_LSB)
#define WLAN_GPIO_PIN53_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN53_INT_TYPE_LSB) & WLAN_GPIO_PIN53_INT_TYPE_MASK)
#define WLAN_GPIO_PIN53_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN53_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN53_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN53_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN53_PAD_PULL_MASK) >> WLAN_GPIO_PIN53_PAD_PULL_LSB)
#define WLAN_GPIO_PIN53_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN53_PAD_PULL_LSB) & WLAN_GPIO_PIN53_PAD_PULL_MASK)
#define WLAN_GPIO_PIN53_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN53_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN53_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN53_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN53_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN53_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN53_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN53_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN53_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN53_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN53_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN53_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN53_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN53_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN53_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN53_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN53_PAD_DRIVER_LSB) & WLAN_GPIO_PIN53_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN53_SOURCE_MSB               0
#define WLAN_GPIO_PIN53_SOURCE_LSB               0
#define WLAN_GPIO_PIN53_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN53_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN53_SOURCE_MASK) >> WLAN_GPIO_PIN53_SOURCE_LSB)
#define WLAN_GPIO_PIN53_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN53_SOURCE_LSB) & WLAN_GPIO_PIN53_SOURCE_MASK)

#define WLAN_GPIO_PIN54_ADDRESS                  0x00000128
#define WLAN_GPIO_PIN54_OFFSET                   0x00000128
#define WLAN_GPIO_PIN54_CONFIG_MSB               14
#define WLAN_GPIO_PIN54_CONFIG_LSB               11
#define WLAN_GPIO_PIN54_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN54_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN54_CONFIG_MASK) >> WLAN_GPIO_PIN54_CONFIG_LSB)
#define WLAN_GPIO_PIN54_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN54_CONFIG_LSB) & WLAN_GPIO_PIN54_CONFIG_MASK)
#define WLAN_GPIO_PIN54_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN54_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN54_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN54_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN54_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN54_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN54_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN54_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN54_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN54_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN54_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN54_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN54_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN54_INT_TYPE_MASK) >> WLAN_GPIO_PIN54_INT_TYPE_LSB)
#define WLAN_GPIO_PIN54_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN54_INT_TYPE_LSB) & WLAN_GPIO_PIN54_INT_TYPE_MASK)
#define WLAN_GPIO_PIN54_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN54_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN54_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN54_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN54_PAD_PULL_MASK) >> WLAN_GPIO_PIN54_PAD_PULL_LSB)
#define WLAN_GPIO_PIN54_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN54_PAD_PULL_LSB) & WLAN_GPIO_PIN54_PAD_PULL_MASK)
#define WLAN_GPIO_PIN54_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN54_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN54_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN54_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN54_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN54_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN54_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN54_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN54_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN54_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN54_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN54_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN54_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN54_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN54_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN54_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN54_PAD_DRIVER_LSB) & WLAN_GPIO_PIN54_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN54_SOURCE_MSB               0
#define WLAN_GPIO_PIN54_SOURCE_LSB               0
#define WLAN_GPIO_PIN54_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN54_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN54_SOURCE_MASK) >> WLAN_GPIO_PIN54_SOURCE_LSB)
#define WLAN_GPIO_PIN54_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN54_SOURCE_LSB) & WLAN_GPIO_PIN54_SOURCE_MASK)

#define WLAN_GPIO_PIN55_ADDRESS                  0x0000012c
#define WLAN_GPIO_PIN55_OFFSET                   0x0000012c
#define WLAN_GPIO_PIN55_CONFIG_MSB               14
#define WLAN_GPIO_PIN55_CONFIG_LSB               11
#define WLAN_GPIO_PIN55_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN55_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN55_CONFIG_MASK) >> WLAN_GPIO_PIN55_CONFIG_LSB)
#define WLAN_GPIO_PIN55_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN55_CONFIG_LSB) & WLAN_GPIO_PIN55_CONFIG_MASK)
#define WLAN_GPIO_PIN55_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN55_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN55_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN55_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN55_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN55_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN55_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN55_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN55_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN55_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN55_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN55_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN55_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN55_INT_TYPE_MASK) >> WLAN_GPIO_PIN55_INT_TYPE_LSB)
#define WLAN_GPIO_PIN55_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN55_INT_TYPE_LSB) & WLAN_GPIO_PIN55_INT_TYPE_MASK)
#define WLAN_GPIO_PIN55_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN55_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN55_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN55_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN55_PAD_PULL_MASK) >> WLAN_GPIO_PIN55_PAD_PULL_LSB)
#define WLAN_GPIO_PIN55_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN55_PAD_PULL_LSB) & WLAN_GPIO_PIN55_PAD_PULL_MASK)
#define WLAN_GPIO_PIN55_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN55_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN55_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN55_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN55_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN55_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN55_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN55_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN55_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN55_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN55_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN55_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN55_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN55_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN55_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN55_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN55_PAD_DRIVER_LSB) & WLAN_GPIO_PIN55_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN55_SOURCE_MSB               0
#define WLAN_GPIO_PIN55_SOURCE_LSB               0
#define WLAN_GPIO_PIN55_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN55_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN55_SOURCE_MASK) >> WLAN_GPIO_PIN55_SOURCE_LSB)
#define WLAN_GPIO_PIN55_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN55_SOURCE_LSB) & WLAN_GPIO_PIN55_SOURCE_MASK)

#define WLAN_GPIO_PIN56_ADDRESS                  0x00000130
#define WLAN_GPIO_PIN56_OFFSET                   0x00000130
#define WLAN_GPIO_PIN56_CONFIG_MSB               14
#define WLAN_GPIO_PIN56_CONFIG_LSB               11
#define WLAN_GPIO_PIN56_CONFIG_MASK              0x00007800
#define WLAN_GPIO_PIN56_CONFIG_GET(x)            (((x) & WLAN_GPIO_PIN56_CONFIG_MASK) >> WLAN_GPIO_PIN56_CONFIG_LSB)
#define WLAN_GPIO_PIN56_CONFIG_SET(x)            (((x) << WLAN_GPIO_PIN56_CONFIG_LSB) & WLAN_GPIO_PIN56_CONFIG_MASK)
#define WLAN_GPIO_PIN56_WAKEUP_ENABLE_MSB        10
#define WLAN_GPIO_PIN56_WAKEUP_ENABLE_LSB        10
#define WLAN_GPIO_PIN56_WAKEUP_ENABLE_MASK       0x00000400
#define WLAN_GPIO_PIN56_WAKEUP_ENABLE_GET(x)     (((x) & WLAN_GPIO_PIN56_WAKEUP_ENABLE_MASK) >> WLAN_GPIO_PIN56_WAKEUP_ENABLE_LSB)
#define WLAN_GPIO_PIN56_WAKEUP_ENABLE_SET(x)     (((x) << WLAN_GPIO_PIN56_WAKEUP_ENABLE_LSB) & WLAN_GPIO_PIN56_WAKEUP_ENABLE_MASK)
#define WLAN_GPIO_PIN56_INT_TYPE_MSB             9
#define WLAN_GPIO_PIN56_INT_TYPE_LSB             7
#define WLAN_GPIO_PIN56_INT_TYPE_MASK            0x00000380
#define WLAN_GPIO_PIN56_INT_TYPE_GET(x)          (((x) & WLAN_GPIO_PIN56_INT_TYPE_MASK) >> WLAN_GPIO_PIN56_INT_TYPE_LSB)
#define WLAN_GPIO_PIN56_INT_TYPE_SET(x)          (((x) << WLAN_GPIO_PIN56_INT_TYPE_LSB) & WLAN_GPIO_PIN56_INT_TYPE_MASK)
#define WLAN_GPIO_PIN56_PAD_PULL_MSB             6
#define WLAN_GPIO_PIN56_PAD_PULL_LSB             5
#define WLAN_GPIO_PIN56_PAD_PULL_MASK            0x00000060
#define WLAN_GPIO_PIN56_PAD_PULL_GET(x)          (((x) & WLAN_GPIO_PIN56_PAD_PULL_MASK) >> WLAN_GPIO_PIN56_PAD_PULL_LSB)
#define WLAN_GPIO_PIN56_PAD_PULL_SET(x)          (((x) << WLAN_GPIO_PIN56_PAD_PULL_LSB) & WLAN_GPIO_PIN56_PAD_PULL_MASK)
#define WLAN_GPIO_PIN56_PAD_STRENGTH_MSB         4
#define WLAN_GPIO_PIN56_PAD_STRENGTH_LSB         3
#define WLAN_GPIO_PIN56_PAD_STRENGTH_MASK        0x00000018
#define WLAN_GPIO_PIN56_PAD_STRENGTH_GET(x)      (((x) & WLAN_GPIO_PIN56_PAD_STRENGTH_MASK) >> WLAN_GPIO_PIN56_PAD_STRENGTH_LSB)
#define WLAN_GPIO_PIN56_PAD_STRENGTH_SET(x)      (((x) << WLAN_GPIO_PIN56_PAD_STRENGTH_LSB) & WLAN_GPIO_PIN56_PAD_STRENGTH_MASK)
#define WLAN_GPIO_PIN56_PAD_DRIVER_MSB           2
#define WLAN_GPIO_PIN56_PAD_DRIVER_LSB           2
#define WLAN_GPIO_PIN56_PAD_DRIVER_MASK          0x00000004
#define WLAN_GPIO_PIN56_PAD_DRIVER_GET(x)        (((x) & WLAN_GPIO_PIN56_PAD_DRIVER_MASK) >> WLAN_GPIO_PIN56_PAD_DRIVER_LSB)
#define WLAN_GPIO_PIN56_PAD_DRIVER_SET(x)        (((x) << WLAN_GPIO_PIN56_PAD_DRIVER_LSB) & WLAN_GPIO_PIN56_PAD_DRIVER_MASK)
#define WLAN_GPIO_PIN56_SOURCE_MSB               0
#define WLAN_GPIO_PIN56_SOURCE_LSB               0
#define WLAN_GPIO_PIN56_SOURCE_MASK              0x00000001
#define WLAN_GPIO_PIN56_SOURCE_GET(x)            (((x) & WLAN_GPIO_PIN56_SOURCE_MASK) >> WLAN_GPIO_PIN56_SOURCE_LSB)
#define WLAN_GPIO_PIN56_SOURCE_SET(x)            (((x) << WLAN_GPIO_PIN56_SOURCE_LSB) & WLAN_GPIO_PIN56_SOURCE_MASK)

#define SDIO_ADDRESS                             0x00000134
#define SDIO_OFFSET                              0x00000134
#define SDIO_PINS_EN_MSB                         0
#define SDIO_PINS_EN_LSB                         0
#define SDIO_PINS_EN_MASK                        0x00000001
#define SDIO_PINS_EN_GET(x)                      (((x) & SDIO_PINS_EN_MASK) >> SDIO_PINS_EN_LSB)
#define SDIO_PINS_EN_SET(x)                      (((x) << SDIO_PINS_EN_LSB) & SDIO_PINS_EN_MASK)

#define WL_SOC_APB_ADDRESS                       0x00000138
#define WL_SOC_APB_OFFSET                        0x00000138
#define WL_SOC_APB_TOGGLE_MSB                    0
#define WL_SOC_APB_TOGGLE_LSB                    0
#define WL_SOC_APB_TOGGLE_MASK                   0x00000001
#define WL_SOC_APB_TOGGLE_GET(x)                 (((x) & WL_SOC_APB_TOGGLE_MASK) >> WL_SOC_APB_TOGGLE_LSB)
#define WL_SOC_APB_TOGGLE_SET(x)                 (((x) << WL_SOC_APB_TOGGLE_LSB) & WL_SOC_APB_TOGGLE_MASK)

#define WLAN_SIGMA_DELTA_ADDRESS                 0x0000013c
#define WLAN_SIGMA_DELTA_OFFSET                  0x0000013c
#define WLAN_SIGMA_DELTA_ENABLE_MSB              16
#define WLAN_SIGMA_DELTA_ENABLE_LSB              16
#define WLAN_SIGMA_DELTA_ENABLE_MASK             0x00010000
#define WLAN_SIGMA_DELTA_ENABLE_GET(x)           (((x) & WLAN_SIGMA_DELTA_ENABLE_MASK) >> WLAN_SIGMA_DELTA_ENABLE_LSB)
#define WLAN_SIGMA_DELTA_ENABLE_SET(x)           (((x) << WLAN_SIGMA_DELTA_ENABLE_LSB) & WLAN_SIGMA_DELTA_ENABLE_MASK)
#define WLAN_SIGMA_DELTA_PRESCALAR_MSB           15
#define WLAN_SIGMA_DELTA_PRESCALAR_LSB           8
#define WLAN_SIGMA_DELTA_PRESCALAR_MASK          0x0000ff00
#define WLAN_SIGMA_DELTA_PRESCALAR_GET(x)        (((x) & WLAN_SIGMA_DELTA_PRESCALAR_MASK) >> WLAN_SIGMA_DELTA_PRESCALAR_LSB)
#define WLAN_SIGMA_DELTA_PRESCALAR_SET(x)        (((x) << WLAN_SIGMA_DELTA_PRESCALAR_LSB) & WLAN_SIGMA_DELTA_PRESCALAR_MASK)
#define WLAN_SIGMA_DELTA_TARGET_MSB              7
#define WLAN_SIGMA_DELTA_TARGET_LSB              0
#define WLAN_SIGMA_DELTA_TARGET_MASK             0x000000ff
#define WLAN_SIGMA_DELTA_TARGET_GET(x)           (((x) & WLAN_SIGMA_DELTA_TARGET_MASK) >> WLAN_SIGMA_DELTA_TARGET_LSB)
#define WLAN_SIGMA_DELTA_TARGET_SET(x)           (((x) << WLAN_SIGMA_DELTA_TARGET_LSB) & WLAN_SIGMA_DELTA_TARGET_MASK)

#define WL_BOOTSTRAP_ADDRESS                     0x00000140
#define WL_BOOTSTRAP_OFFSET                      0x00000140
#define WL_BOOTSTRAP_CPU_MBIST_EN_MSB            12
#define WL_BOOTSTRAP_CPU_MBIST_EN_LSB            12
#define WL_BOOTSTRAP_CPU_MBIST_EN_MASK           0x00001000
#define WL_BOOTSTRAP_CPU_MBIST_EN_GET(x)         (((x) & WL_BOOTSTRAP_CPU_MBIST_EN_MASK) >> WL_BOOTSTRAP_CPU_MBIST_EN_LSB)
#define WL_BOOTSTRAP_CPU_MBIST_EN_SET(x)         (((x) << WL_BOOTSTRAP_CPU_MBIST_EN_LSB) & WL_BOOTSTRAP_CPU_MBIST_EN_MASK)
#define WL_BOOTSTRAP_STATUS_MSB                  11
#define WL_BOOTSTRAP_STATUS_LSB                  0
#define WL_BOOTSTRAP_STATUS_MASK                 0x00000fff
#define WL_BOOTSTRAP_STATUS_GET(x)               (((x) & WL_BOOTSTRAP_STATUS_MASK) >> WL_BOOTSTRAP_STATUS_LSB)
#define WL_BOOTSTRAP_STATUS_SET(x)               (((x) << WL_BOOTSTRAP_STATUS_LSB) & WL_BOOTSTRAP_STATUS_MASK)

#define CORE_BOOTSTRAP_LOW_ADDRESS               0x00000144
#define CORE_BOOTSTRAP_LOW_OFFSET                0x00000144
#define CORE_BOOTSTRAP_LOW_STATUS_MSB            31
#define CORE_BOOTSTRAP_LOW_STATUS_LSB            0
#define CORE_BOOTSTRAP_LOW_STATUS_MASK           0xffffffff
#define CORE_BOOTSTRAP_LOW_STATUS_GET(x)         (((x) & CORE_BOOTSTRAP_LOW_STATUS_MASK) >> CORE_BOOTSTRAP_LOW_STATUS_LSB)
#define CORE_BOOTSTRAP_LOW_STATUS_SET(x)         (((x) << CORE_BOOTSTRAP_LOW_STATUS_LSB) & CORE_BOOTSTRAP_LOW_STATUS_MASK)

#define CORE_BOOTSTRAP_HIGH_ADDRESS              0x00000148
#define CORE_BOOTSTRAP_HIGH_OFFSET               0x00000148
#define CORE_BOOTSTRAP_HIGH_STATUS_MSB           12
#define CORE_BOOTSTRAP_HIGH_STATUS_LSB           0
#define CORE_BOOTSTRAP_HIGH_STATUS_MASK          0x00001fff
#define CORE_BOOTSTRAP_HIGH_STATUS_GET(x)        (((x) & CORE_BOOTSTRAP_HIGH_STATUS_MASK) >> CORE_BOOTSTRAP_HIGH_STATUS_LSB)
#define CORE_BOOTSTRAP_HIGH_STATUS_SET(x)        (((x) << CORE_BOOTSTRAP_HIGH_STATUS_LSB) & CORE_BOOTSTRAP_HIGH_STATUS_MASK)

#define WLAN_DEBUG_CONTROL_ADDRESS               0x0000014c
#define WLAN_DEBUG_CONTROL_OFFSET                0x0000014c
#define WLAN_DEBUG_CONTROL_ENABLE_MSB            0
#define WLAN_DEBUG_CONTROL_ENABLE_LSB            0
#define WLAN_DEBUG_CONTROL_ENABLE_MASK           0x00000001
#define WLAN_DEBUG_CONTROL_ENABLE_GET(x)         (((x) & WLAN_DEBUG_CONTROL_ENABLE_MASK) >> WLAN_DEBUG_CONTROL_ENABLE_LSB)
#define WLAN_DEBUG_CONTROL_ENABLE_SET(x)         (((x) << WLAN_DEBUG_CONTROL_ENABLE_LSB) & WLAN_DEBUG_CONTROL_ENABLE_MASK)

#define WLAN_DEBUG_INPUT_SEL_ADDRESS             0x00000150
#define WLAN_DEBUG_INPUT_SEL_OFFSET              0x00000150
#define WLAN_DEBUG_INPUT_SEL_SHIFT_MSB           5
#define WLAN_DEBUG_INPUT_SEL_SHIFT_LSB           4
#define WLAN_DEBUG_INPUT_SEL_SHIFT_MASK          0x00000030
#define WLAN_DEBUG_INPUT_SEL_SHIFT_GET(x)        (((x) & WLAN_DEBUG_INPUT_SEL_SHIFT_MASK) >> WLAN_DEBUG_INPUT_SEL_SHIFT_LSB)
#define WLAN_DEBUG_INPUT_SEL_SHIFT_SET(x)        (((x) << WLAN_DEBUG_INPUT_SEL_SHIFT_LSB) & WLAN_DEBUG_INPUT_SEL_SHIFT_MASK)
#define WLAN_DEBUG_INPUT_SEL_SRC_MSB             3
#define WLAN_DEBUG_INPUT_SEL_SRC_LSB             0
#define WLAN_DEBUG_INPUT_SEL_SRC_MASK            0x0000000f
#define WLAN_DEBUG_INPUT_SEL_SRC_GET(x)          (((x) & WLAN_DEBUG_INPUT_SEL_SRC_MASK) >> WLAN_DEBUG_INPUT_SEL_SRC_LSB)
#define WLAN_DEBUG_INPUT_SEL_SRC_SET(x)          (((x) << WLAN_DEBUG_INPUT_SEL_SRC_LSB) & WLAN_DEBUG_INPUT_SEL_SRC_MASK)

#define WLAN_DEBUG_OUT_ADDRESS                   0x00000154
#define WLAN_DEBUG_OUT_OFFSET                    0x00000154
#define WLAN_DEBUG_OUT_DATA_MSB                  17
#define WLAN_DEBUG_OUT_DATA_LSB                  0
#define WLAN_DEBUG_OUT_DATA_MASK                 0x0003ffff
#define WLAN_DEBUG_OUT_DATA_GET(x)               (((x) & WLAN_DEBUG_OUT_DATA_MASK) >> WLAN_DEBUG_OUT_DATA_LSB)
#define WLAN_DEBUG_OUT_DATA_SET(x)               (((x) << WLAN_DEBUG_OUT_DATA_LSB) & WLAN_DEBUG_OUT_DATA_MASK)

#define WLAN_RESET_TUPLE_STATUS_ADDRESS          0x00000158
#define WLAN_RESET_TUPLE_STATUS_OFFSET           0x00000158
#define WLAN_RESET_TUPLE_STATUS_TEST_RESET_TUPLE_MSB 11
#define WLAN_RESET_TUPLE_STATUS_TEST_RESET_TUPLE_LSB 8
#define WLAN_RESET_TUPLE_STATUS_TEST_RESET_TUPLE_MASK 0x00000f00
#define WLAN_RESET_TUPLE_STATUS_TEST_RESET_TUPLE_GET(x) (((x) & WLAN_RESET_TUPLE_STATUS_TEST_RESET_TUPLE_MASK) >> WLAN_RESET_TUPLE_STATUS_TEST_RESET_TUPLE_LSB)
#define WLAN_RESET_TUPLE_STATUS_TEST_RESET_TUPLE_SET(x) (((x) << WLAN_RESET_TUPLE_STATUS_TEST_RESET_TUPLE_LSB) & WLAN_RESET_TUPLE_STATUS_TEST_RESET_TUPLE_MASK)
#define WLAN_RESET_TUPLE_STATUS_PIN_RESET_TUPLE_MSB 7
#define WLAN_RESET_TUPLE_STATUS_PIN_RESET_TUPLE_LSB 0
#define WLAN_RESET_TUPLE_STATUS_PIN_RESET_TUPLE_MASK 0x000000ff
#define WLAN_RESET_TUPLE_STATUS_PIN_RESET_TUPLE_GET(x) (((x) & WLAN_RESET_TUPLE_STATUS_PIN_RESET_TUPLE_MASK) >> WLAN_RESET_TUPLE_STATUS_PIN_RESET_TUPLE_LSB)
#define WLAN_RESET_TUPLE_STATUS_PIN_RESET_TUPLE_SET(x) (((x) << WLAN_RESET_TUPLE_STATUS_PIN_RESET_TUPLE_LSB) & WLAN_RESET_TUPLE_STATUS_PIN_RESET_TUPLE_MASK)

#define ANTENNA_CONTROL_ADDRESS                  0x0000015c
#define ANTENNA_CONTROL_OFFSET                   0x0000015c
#define ANTENNA_CONTROL_RX_CLEAR_MSB             16
#define ANTENNA_CONTROL_RX_CLEAR_LSB             16
#define ANTENNA_CONTROL_RX_CLEAR_MASK            0x00010000
#define ANTENNA_CONTROL_RX_CLEAR_GET(x)          (((x) & ANTENNA_CONTROL_RX_CLEAR_MASK) >> ANTENNA_CONTROL_RX_CLEAR_LSB)
#define ANTENNA_CONTROL_RX_CLEAR_SET(x)          (((x) << ANTENNA_CONTROL_RX_CLEAR_LSB) & ANTENNA_CONTROL_RX_CLEAR_MASK)
#define ANTENNA_CONTROL_SPI_CS_MSB               15
#define ANTENNA_CONTROL_SPI_CS_LSB               15
#define ANTENNA_CONTROL_SPI_CS_MASK              0x00008000
#define ANTENNA_CONTROL_SPI_CS_GET(x)            (((x) & ANTENNA_CONTROL_SPI_CS_MASK) >> ANTENNA_CONTROL_SPI_CS_LSB)
#define ANTENNA_CONTROL_SPI_CS_SET(x)            (((x) << ANTENNA_CONTROL_SPI_CS_LSB) & ANTENNA_CONTROL_SPI_CS_MASK)
#define ANTENNA_CONTROL_SPI_MODE_MSB             14
#define ANTENNA_CONTROL_SPI_MODE_LSB             14
#define ANTENNA_CONTROL_SPI_MODE_MASK            0x00004000
#define ANTENNA_CONTROL_SPI_MODE_GET(x)          (((x) & ANTENNA_CONTROL_SPI_MODE_MASK) >> ANTENNA_CONTROL_SPI_MODE_LSB)
#define ANTENNA_CONTROL_SPI_MODE_SET(x)          (((x) << ANTENNA_CONTROL_SPI_MODE_LSB) & ANTENNA_CONTROL_SPI_MODE_MASK)
#define ANTENNA_CONTROL_LED_SEL_MSB              13
#define ANTENNA_CONTROL_LED_SEL_LSB              12
#define ANTENNA_CONTROL_LED_SEL_MASK             0x00003000
#define ANTENNA_CONTROL_LED_SEL_GET(x)           (((x) & ANTENNA_CONTROL_LED_SEL_MASK) >> ANTENNA_CONTROL_LED_SEL_LSB)
#define ANTENNA_CONTROL_LED_SEL_SET(x)           (((x) << ANTENNA_CONTROL_LED_SEL_LSB) & ANTENNA_CONTROL_LED_SEL_MASK)
#define ANTENNA_CONTROL_OVERRIDE_MSB             11
#define ANTENNA_CONTROL_OVERRIDE_LSB             8
#define ANTENNA_CONTROL_OVERRIDE_MASK            0x00000f00
#define ANTENNA_CONTROL_OVERRIDE_GET(x)          (((x) & ANTENNA_CONTROL_OVERRIDE_MASK) >> ANTENNA_CONTROL_OVERRIDE_LSB)
#define ANTENNA_CONTROL_OVERRIDE_SET(x)          (((x) << ANTENNA_CONTROL_OVERRIDE_LSB) & ANTENNA_CONTROL_OVERRIDE_MASK)
#define ANTENNA_CONTROL_VALUE_MSB                7
#define ANTENNA_CONTROL_VALUE_LSB                4
#define ANTENNA_CONTROL_VALUE_MASK               0x000000f0
#define ANTENNA_CONTROL_VALUE_GET(x)             (((x) & ANTENNA_CONTROL_VALUE_MASK) >> ANTENNA_CONTROL_VALUE_LSB)
#define ANTENNA_CONTROL_VALUE_SET(x)             (((x) << ANTENNA_CONTROL_VALUE_LSB) & ANTENNA_CONTROL_VALUE_MASK)
#define ANTENNA_CONTROL_ENABLE_MSB               3
#define ANTENNA_CONTROL_ENABLE_LSB               0
#define ANTENNA_CONTROL_ENABLE_MASK              0x0000000f
#define ANTENNA_CONTROL_ENABLE_GET(x)            (((x) & ANTENNA_CONTROL_ENABLE_MASK) >> ANTENNA_CONTROL_ENABLE_LSB)
#define ANTENNA_CONTROL_ENABLE_SET(x)            (((x) << ANTENNA_CONTROL_ENABLE_LSB) & ANTENNA_CONTROL_ENABLE_MASK)

#define SDIO2_ADDRESS                            0x00000160
#define SDIO2_OFFSET                             0x00000160
#define SDIO2_PINS_EN_MSB                        0
#define SDIO2_PINS_EN_LSB                        0
#define SDIO2_PINS_EN_MASK                       0x00000001
#define SDIO2_PINS_EN_GET(x)                     (((x) & SDIO2_PINS_EN_MASK) >> SDIO2_PINS_EN_LSB)
#define SDIO2_PINS_EN_SET(x)                     (((x) << SDIO2_PINS_EN_LSB) & SDIO2_PINS_EN_MASK)

#define SDHC_ADDRESS                             0x00000164
#define SDHC_OFFSET                              0x00000164
#define SDHC_PINS_EN_MSB                         0
#define SDHC_PINS_EN_LSB                         0
#define SDHC_PINS_EN_MASK                        0x00000001
#define SDHC_PINS_EN_GET(x)                      (((x) & SDHC_PINS_EN_MASK) >> SDHC_PINS_EN_LSB)
#define SDHC_PINS_EN_SET(x)                      (((x) << SDHC_PINS_EN_LSB) & SDHC_PINS_EN_MASK)

#define AMBA_DEBUG_BUS_ADDRESS                   0x00000168
#define AMBA_DEBUG_BUS_OFFSET                    0x00000168
#define AMBA_DEBUG_BUS_SEL_MSB                   4
#define AMBA_DEBUG_BUS_SEL_LSB                   0
#define AMBA_DEBUG_BUS_SEL_MASK                  0x0000001f
#define AMBA_DEBUG_BUS_SEL_GET(x)                (((x) & AMBA_DEBUG_BUS_SEL_MASK) >> AMBA_DEBUG_BUS_SEL_LSB)
#define AMBA_DEBUG_BUS_SEL_SET(x)                (((x) << AMBA_DEBUG_BUS_SEL_LSB) & AMBA_DEBUG_BUS_SEL_MASK)

#define CPU_MBIST_ADDRESS                        0x0000016c
#define CPU_MBIST_OFFSET                         0x0000016c
#define CPU_MBIST_BLOCK_FAIL_MSB                 10
#define CPU_MBIST_BLOCK_FAIL_LSB                 2
#define CPU_MBIST_BLOCK_FAIL_MASK                0x000007fc
#define CPU_MBIST_BLOCK_FAIL_GET(x)              (((x) & CPU_MBIST_BLOCK_FAIL_MASK) >> CPU_MBIST_BLOCK_FAIL_LSB)
#define CPU_MBIST_BLOCK_FAIL_SET(x)              (((x) << CPU_MBIST_BLOCK_FAIL_LSB) & CPU_MBIST_BLOCK_FAIL_MASK)
#define CPU_MBIST_GLOBAL_FAIL_MSB                1
#define CPU_MBIST_GLOBAL_FAIL_LSB                1
#define CPU_MBIST_GLOBAL_FAIL_MASK               0x00000002
#define CPU_MBIST_GLOBAL_FAIL_GET(x)             (((x) & CPU_MBIST_GLOBAL_FAIL_MASK) >> CPU_MBIST_GLOBAL_FAIL_LSB)
#define CPU_MBIST_GLOBAL_FAIL_SET(x)             (((x) << CPU_MBIST_GLOBAL_FAIL_LSB) & CPU_MBIST_GLOBAL_FAIL_MASK)
#define CPU_MBIST_DONE_MSB                       0
#define CPU_MBIST_DONE_LSB                       0
#define CPU_MBIST_DONE_MASK                      0x00000001
#define CPU_MBIST_DONE_GET(x)                    (((x) & CPU_MBIST_DONE_MASK) >> CPU_MBIST_DONE_LSB)
#define CPU_MBIST_DONE_SET(x)                    (((x) << CPU_MBIST_DONE_LSB) & CPU_MBIST_DONE_MASK)


#ifndef __ASSEMBLER__

typedef struct gpio_athr_wlan_reg_reg_s {
  volatile unsigned int wlan_gpio_out_low;
  volatile unsigned int wlan_gpio_out_w1ts_low;
  volatile unsigned int wlan_gpio_out_w1tc_low;
  volatile unsigned int wlan_gpio_out_high;
  volatile unsigned int wlan_gpio_out_w1ts_high;
  volatile unsigned int wlan_gpio_out_w1tc_high;
  volatile unsigned int wlan_gpio_enable_low;
  volatile unsigned int wlan_gpio_enable_w1ts_low;
  volatile unsigned int wlan_gpio_enable_w1tc_low;
  volatile unsigned int wlan_gpio_enable_high;
  volatile unsigned int wlan_gpio_enable_w1ts_high;
  volatile unsigned int wlan_gpio_enable_w1tc_high;
  volatile unsigned int wlan_gpio_in_low;
  volatile unsigned int wlan_gpio_status_low;
  volatile unsigned int wlan_gpio_in_high;
  volatile unsigned int wlan_gpio_status_high;
  volatile unsigned int wlan_gpio_status_w1ts_low;
  volatile unsigned int wlan_gpio_status_w1tc_low;
  volatile unsigned int wlan_gpio_status_w1ts_high;
  volatile unsigned int wlan_gpio_status_w1tc_high;
  volatile unsigned int wlan_gpio_pin0;
  volatile unsigned int wlan_gpio_pin1;
  volatile unsigned int wlan_gpio_pin2;
  volatile unsigned int wlan_gpio_pin3;
  volatile unsigned int wlan_gpio_pin4;
  volatile unsigned int wlan_gpio_pin5;
  volatile unsigned int wlan_gpio_pin6;
  volatile unsigned int wlan_gpio_pin7;
  volatile unsigned int wlan_gpio_pin8;
  volatile unsigned int wlan_gpio_pin9;
  volatile unsigned int wlan_gpio_pin10;
  volatile unsigned int wlan_gpio_pin11;
  volatile unsigned int wlan_gpio_pin12;
  volatile unsigned int wlan_gpio_pin13;
  volatile unsigned int wlan_gpio_pin14;
  volatile unsigned int wlan_gpio_pin15;
  volatile unsigned int wlan_gpio_pin16;
  volatile unsigned int wlan_gpio_pin17;
  volatile unsigned int wlan_gpio_pin18;
  volatile unsigned int wlan_gpio_pin19;
  volatile unsigned int wlan_gpio_pin20;
  volatile unsigned int wlan_gpio_pin21;
  volatile unsigned int wlan_gpio_pin22;
  volatile unsigned int wlan_gpio_pin23;
  volatile unsigned int wlan_gpio_pin24;
  volatile unsigned int wlan_gpio_pin25;
  volatile unsigned int wlan_gpio_pin26;
  volatile unsigned int wlan_gpio_pin27;
  volatile unsigned int wlan_gpio_pin28;
  volatile unsigned int wlan_gpio_pin29;
  volatile unsigned int wlan_gpio_pin30;
  volatile unsigned int wlan_gpio_pin31;
  volatile unsigned int wlan_gpio_pin32;
  volatile unsigned int wlan_gpio_pin33;
  volatile unsigned int wlan_gpio_pin34;
  volatile unsigned int wlan_gpio_pin35;
  volatile unsigned int wlan_gpio_pin36;
  volatile unsigned int wlan_gpio_pin37;
  volatile unsigned int wlan_gpio_pin38;
  volatile unsigned int wlan_gpio_pin39;
  volatile unsigned int wlan_gpio_pin40;
  volatile unsigned int wlan_gpio_pin41;
  volatile unsigned int wlan_gpio_pin42;
  volatile unsigned int wlan_gpio_pin43;
  volatile unsigned int wlan_gpio_pin44;
  volatile unsigned int wlan_gpio_pin45;
  volatile unsigned int wlan_gpio_pin46;
  volatile unsigned int wlan_gpio_pin47;
  volatile unsigned int wlan_gpio_pin48;
  volatile unsigned int wlan_gpio_pin49;
  volatile unsigned int wlan_gpio_pin50;
  volatile unsigned int wlan_gpio_pin51;
  volatile unsigned int wlan_gpio_pin52;
  volatile unsigned int wlan_gpio_pin53;
  volatile unsigned int wlan_gpio_pin54;
  volatile unsigned int wlan_gpio_pin55;
  volatile unsigned int wlan_gpio_pin56;
  volatile unsigned int sdio;
  volatile unsigned int wl_soc_apb;
  volatile unsigned int wlan_sigma_delta;
  volatile unsigned int wl_bootstrap;
  volatile unsigned int core_bootstrap_low;
  volatile unsigned int core_bootstrap_high;
  volatile unsigned int wlan_debug_control;
  volatile unsigned int wlan_debug_input_sel;
  volatile unsigned int wlan_debug_out;
  volatile unsigned int wlan_reset_tuple_status;
  volatile unsigned int antenna_control;
  volatile unsigned int sdio2;
  volatile unsigned int sdhc;
  volatile unsigned int amba_debug_bus;
  volatile unsigned int cpu_mbist;
} gpio_athr_wlan_reg_reg_t;

#endif /* __ASSEMBLER__ */

#endif /* _GPIO_ATHR_WLAN_REG_H_ */
