
 xstroke(1)                                                       xstroke(1)

 NAME
      xstroke - convert button strokes to commands for a generic window

 SYNOPSIS
      xstroke -h

      xstroke [-btn <button num> [<window name> [<format string>]]] ...

 DESCRIPTION
      xstroke allows you to add a new dimension to the interface of any
      of  your  current  X  programs.   Specifically,  it gives you the
      ability to use 'strokes,' an interface technique I first saw used
      in  the  Mentor  Graphics  'Design Architect' tool (though I have
      since heard of it elsewhere  -  rumor is that it started with the
      company Applicon  with a board layout tool  and CALMA's IC layout
      tool), and recently it's been added to Mozilla's browser.

      Strokes are merely  commands  that are  drawn  as  simple  shapes
      with  the  mouse.   The  idea  is that using strokes you can, for
      example in a CAD tool, draw the letter 'C' with the middle  mouse
      button  (a  rarely used button anyways) to do a copy, and then if
      you make a mistake just draw  a  'U'   to   undo.    The  strokes
      are  not  usually  letters,  as in this example, but are actually
      represented as 'button strings,' or a  string  of   numbers  that
      make   up   the   stroke.    The   button   string comes from the
      following grid (like a numeric keypad):

           -------------------
	   |  7  |  8  |  9  |
	   |-----|-----|-----|
	   |  4  |  5  |  6  |
	   |-----|-----|-----|
	   |  1  |  2  |  3  |
           -------------------

      Then, if you were to draw the following stroke:

	    ------->
	    |
	    |
	    |______

      This would be interpreted as the button string "3179" which would
      then  be sent to your application, where you could define a macro
      that would convert 3179 to a copy command or whatever  you  like.
      Notice  that  the direction of the stroke matters, if the reverse
      direction was taken, the button string would  be  9713.   If  you
      don't  want  direction to matter, you can just alias both strings
      to the same command.

      Another stroke example:

	    |\
	    | \
	    |  \
	    |   v

      Would be interpreted as "173"

      Strokes do not have to be exact - they can be drawn  anywhere  on
      the  screen,  and  xstroke will scale the invisible grid to match
      the full size of the stroke.  xstroke does the best job it can to
      try  to  interpret  what  button  string you were trying to draw.
      Because of this, it is not currently possible to use  the  middle
      sections  of  the grid (anything except 1, 3, 7 and 9) unless you
      are doing a horizontal or vertical strokes.  (This is why the 'C'
      stroke  is  a  3179  and  not  9874123).   If  you  draw strictly
      horizontal or vertical strokes, then you can get the even numbers
      into  your string, such as the strokes 46 and 82.  The center (5)
      is only generated for clicks.  The best way to visualize this  is
      to  realize  that  any  strokes that are 2-dimensional need to go
      from corner to corner, but 1-dimensional strokes go  through  the
      middles, and clicks (0-dimensions) use only the center.

      Strokes can also be as long as desired, as  an  example,  if  you
      move  the  mouse  left to right and back four times, you will get
      the button string 464646464.  This allows for an infinite  number
      of strokes (limited by memory only), however it is suggested that
      stroke commands are kept to a maximum of three lines.

 FORMAT STRINGS
      When the button string is created, xstroke  generates  fake  text
      events  to send to  the window.   The text  that  is sent  to the
      window is in the format of a 'format   string.'   Format  strings
      can contain any combination of the following three elements:

      Hi mom       Plain characters will just be sent directly

      <BSTR>       The button string (such as "3179")

      <1C:ST>      Mouse events.  These should be in the format:
		   <button action:location>
		   button      The button (1-5)
		   action      Click (C), Down (D) or Up (U)
		   location    Start  of the  stroke (ST),  end of  the
			       stroke (EN),  bottom-left of the  stroke
			       rectangle (BL) or top-right (TR)

      As an example, the following format string:

      "DOBtn<BSTR> <1D:ST><1U:EN>\n"

      Will send the text 'DOBtn' and then the button string followed by
      a  space.  Then xstroke will generate mouse events for a button 1
      down at the start of the stroke and a button 1 up at the  end  of
      the  stroke  (effectively  a  drag  from start to end).  Finally,
      xstroke will send a carriage return.

 CAVEATS
      When all of the  watched windows  are closed,  xstroke will quit.

      The watched window doesn't have to be the top window  to  receive
      stroke commands.

 EXAMPLES
      To  specify a  window to watch you  must first  specify a  button:

        xstroke -btn 2

      Since no window was specified, you will be asked to chose  it  by
      click.  (See 'Bugs' below)

      Optionally you can specify a window name to watch:

	xstroke -btn 2 xterm

      This will watch button 2 on all windows with the title 'xterm'
      Finally, you can specify (optional)  the  format string  to  use:

	xstroke -btn 2 xterm "exit\n"

      Will send exit whenever button 2 is pressed in an xterm.
      This is a complete 'window set.'  You can specify  multiple  sets
      of windows (and buttons) to watch.  For example:

        xstroke -btn 2 xterm "foo" -btn 3 kterm

      Will watch button 2 on xterms  (with the format string 'foo') and
      button  3  on  kterms (with the default format string).  You can
      also watch multiple buttons on the same window:

        xstroke -btn 2 xterm "B2S<BSTR>" -btn 3 xterm "3S<BSTR><1C:BL>"

      This will watch buttons 2 and 3 on  all  xterms  using  different
      format strings for each.
     
      If you don't specify any  options,  then  xstroke  will  let  you
      choose  the  window, and then will use the default button (2) and
      default format string.

      If you want to specify multiple sets then each set up to the last
      one needs to be complete (see 'Bugs').

 WARNINGS
      Most terminal windows won't accept text events generated by other
      programs  -  this  is  for  security  reasons.   If  you  find it
      necessary to use xstroke with xterm,  then  you can override this
      from the command-line with:
        xterm -xrm "xterm*allowSendEvents: True"

      Xterms also give you the choice of changing this  setting  on  an
      xterm   that   you  have  already  started,  by  choosing  "Allow
      SendEvents" in the control-left button menu.
      For other programs that don't allow send events, it is  suggested
      that you check the man pages or contact the author.

      xstroke doesn't make sure that format strings have  button  downs
      and  button ups always in order and in pairs.  This is actually a
      feature, you may wish to combine button strings for two  seperate
      button  strokes,  or  perhaps  use  a  button  as a lock down for
      another button ("<1D:ST>").

      Windows must be fully created before calling xstroke.   This  can
      be a problem if you try to do something such as:
	 xterm & ; xstroke -btn 2 xterm

      Chances are that the xterm won't be fully  created  by  the  time
      xstroke is invoked, and xstroke will try to access the incomplete
      window hierarchy, and any  number  of  things  can  happen.   One
      solution is:
	 xterm & ; sleep 1 ; xstroke -btn 2 xterm
      (You may need to play with different delay times to make sure  it
      works)

      If you use a format string that contains button actions that  you
      are  watching, then they will nnoott get analyzed again.  This is to
      avoid infinite loops.

 BUGS
      Currently xstroke is unable (or too stupid) to figure  out  which
      of  the  subwindows  actually  contains the window which receives
      text.  This means that you usually need to send one character  to
      the  window first so that xstroke knows where to send characters.
      This can be done by simply bringing the  watched  window  to  the
      front  and typing a character such as a space.  Some applications
      don't care about this, these are the ones that let you type  even
      when your mouse isn't over the window.

      Selecting windows by clicking (omitting name) doesn't work.
      This will either be fixed or removed in a future version.

      Argument parsing is weak.  There are some problems if you try  to
      use  some  of the defaults and then try to specify another button
      set.  For example, 'xstroke -btn 3 -btn 2  xterm  "<BSTR>"'  will
      not work.  (See 'Examples' above)
      This will be fixed in a future version.

      Special characters are not likely to work in  the  format  string
      (such as control  characters and other  non-shift modified keys).
      This may or may not be fixed in a future version.

 THANKS
      Mentor Graphics, creators of 'Design Architect' where I first saw
      the usage of strokes,  even though they won't talk to me now.  :)

      Valid Logic Systems Incorporated, who evidently had strokes  back
      in the late 80's.

      Daeron Meyer,  XNiceGuy and employee of the  Geometry Center, UMN

      Ken Chin Purcell, Author of the X utility 'Puff'

      Mark Lillibridge, author of dsimple.c

 COPYRIGHT
      Copyright 2002, David Ljung Madison <DaveSource.com>

      Use at your own risk, I'm not responsible for any damages
      to occur from use of this product.

 AUTHOR
      David Ljung Madison <DaveSource.com>

 SEE ALSO
      xterm(1)

