/*
 * Filename:     xstroke.h
 * Version:      1.5b
 * Author:       David Ljung Madison <DaveSource.com>
 * Description:  This is the header file for xstroke.c
 *
 * Copyright:    1995, David Ljung Madison
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <X11/cursorfont.h>

#define TRUE	1
#define FALSE	0

#define MIN(a,b)        ( (a) < (b) ? (a) : (b) )
#define MAX(a,b)        ( (a) < (b) ? (b) : (a) )
#define ABS(x)		( (x) > 0 ? (x) : -(x) )

#define BUP	1
#define BDOWN	2
#define BCLICK	(BUP|BDOWN)

/* The stroke link list */
typedef struct List_t {
  int			x,y;
  struct List_t		*next;
} list_t;

#define MK_PT_L(ptr) { if((ptr=(list_t *) malloc(sizeof(list_t)))==NULL) \
                         fprintf(stderr,"MEMORY ERROR!\n"); \
                       ptr->next=NULL; }

/* The windows-to-watch list */
typedef struct Win_l_t {
  Window		win,textwin;	/* the windows */
  Window		eventwin;	/* Where we got the event */
  char			*name;		/* What's my name? */
  list_t		*formats[6];	/* format for each button (ignore [0])*/
  list_t		*points;	/* points so far */
  struct Win_l_t	*next;
} Win_l_t;

#define MK_WIN_L(ptr) { if((ptr=(Win_l_t *) malloc(sizeof(Win_l_t)))==NULL) \
                         fprintf(stderr,"MEMORY ERROR!\n"); \
                       ptr->next=NULL; }

/* These are globals because it's easier, even though it's naughty ;) */
Display		*dpy;
Window		root;
Win_l_t		*watch;

#define DEFAULT_BUTTON		2
#define DEFAULT_FORMAT_STRING	"MB<BSTR>\n"

/* PROTOTYPES */
void	SelectTree(Window, int);
void	Select_Window_by_click(list_t *,int);
void	Select_Windows_by_name(Window, char *, list_t *,int);
void	usage(char *);
void	SetupSystem(int, char **, char **);
void	add_to_list(int, int, list_t **);
void	add_to_list_end(int, int, list_t **);
void	add_to_watch(Window, char *, list_t *, int);
void	addsex(int, int, list_t **);
void	analyze_strokes(int, Win_l_t *);
void	do_button(int, int, Window, int, int);
list_t	*create_format(char *);
int	find_child(Window, Window);
void	free_Win_l_t(Win_l_t *);
void	free_list(list_t **);
void	handle_keypresses(XEvent *, Win_l_t *);
int	main(int, char **, char **);
void	remove_from_watch(Window);
void	send_key(int, Window, int, int);
void	send_strokes(list_t *, int, Win_l_t *, int,int,int,int,int,int,int,int);
Win_l_t	*which_watch(Window, int);
