// Common Xfe constants

// Default initial main window width
#ifndef DEFAULT_WINDOW_WIDTH
#define DEFAULT_WINDOW_WIDTH 800
#endif

// Default initial main window heigth
#ifndef DEFAULT_WINDOW_HEIGHT
#define DEFAULT_WINDOW_HEIGHT 600
#endif

// Default initial main window X position
#ifndef DEFAULT_WINDOW_XPOS
#define DEFAULT_WINDOW_XPOS 50
#endif

// Default initial main window Y position
#ifndef DEFAULT_WINDOW_YPOS
#define DEFAULT_WINDOW_YPOS 50
#endif

// Maximum sizes for thumbnail image preview
#ifndef MAX_BIGTHUMB_SIZE
#define MAX_BIGTHUMB_SIZE 64
#endif
#ifndef MAX_MINITHUMB_SIZE
#define MAX_MINITHUMB_SIZE 20
#endif

// Minimum width of a file panel or directory panel
#ifndef MIN_PANEL_WIDTH
#define MIN_PANEL_WIDTH 100
#endif

// Maximum length of a file name
#ifndef MAXPATHLEN
#define MAXPATHLEN 1024
#endif

// Root directory string
#ifndef ROOTDIR
#define ROOTDIR "/"
#endif

// Path separator
#ifndef PATHSEPSTRING
#define PATHSEPSTRING "/"
#endif

// Maximum number of path links 
#ifndef MAXLINKS
#define MAX_LINKS 40
#endif

// Run history size
#ifndef RUN_HIST_SIZE
#define RUN_HIST_SIZE 15
#endif

// Open with history size
#ifndef OPEN_WITH_HIST_SIZE
#define OPEN_WITH_HIST_SIZE 30
#endif

// Archives history size
#ifndef ADD_TO_ARCH_HIST_SIZE
#define ADD_TO_ARCH_HIST_SIZE 30
#endif

// Local Xfe directory path
#ifndef LOCALPATH
#define LOCALPATH ".xfe"
#endif

// Local trashcan directory path
#ifndef TRASHPATH
#define TRASHPATH LOCALPATH"/trash"
#endif

// Xfe application name
#ifndef XFEAPPNAME
#define XFEAPPNAME "xfe"
#endif

// Xfe vendor name
#ifndef XFEVDRNAME
#define XFEVDRNAME "Xfe"
#endif

// Xfe config file name
#ifndef XFECONFIGNAME
#define XFECONFIGNAME "xferc"
#endif

// Default icon path
#ifndef DEFAULTICONPATH
#define DEFAULTICONPATH   "~/.xfe/icons/xfe-theme:/usr/local/share/xfe/icons/xfe-theme:/usr/share/xfe/icons/xfe-theme"
#endif

// Command to launch Xfe as root using sudo or su, using an xterm
#ifndef SUDOCMD
#define SUDOCMD "-fn 7x14 -geometry 60x4 -bc +sb -e sudo su -c xfe"
#endif

#ifndef SUCMD
#define SUCMD "-fn 7x14 -geometry 60x4 -bc +sb -e su -c xfe"
#endif

// Tooltips setup time and duration
#ifndef TOOLTIP_PAUSE 
#define TOOLTIP_PAUSE 500
#endif

#ifndef TOOLTIP_TIME
#define TOOLTIP_TIME 10000
#endif

// Coefficient used to darken the sorted column in detailed mode
#ifndef DARKEN_SORT
#define DARKEN_SORT 0.96
#endif


// Default terminal program
#ifndef DEFAULT_TERMINAL
#define DEFAULT_TERMINAL "xterm -sb"
#endif


// These have to be the same as in xferc.in

// Default text editor program
#ifndef DEFAULT_TXTEDITOR
#define DEFAULT_TXTEDITOR "xfw"
#endif

// Default text viewer program
#ifndef DEFAULT_TXTVIEWER
#define DEFAULT_TXTVIEWER "xfv"
#endif

// Default image editor program
#ifndef DEFAULT_IMGEDITOR
#define DEFAULT_IMGEDITOR "gimp"
#endif

// Default image viewer program
#ifndef DEFAULT_IMGVIEWER
#define DEFAULT_IMGVIEWER "xfi"
#endif

// Default archiver program
#ifndef DEFAULT_ARCHIVER
#define DEFAULT_ARCHIVER "xarchiver"
#endif

// Default PDF viewer program
#ifndef DEFAULT_PDFVIEWER
#define DEFAULT_PDFVIEWER "xpdf"
#endif

// Default audio viewer program
#ifndef DEFAULT_AUDIOVIEWER
#define DEFAULT_AUDIOVIEWER "xmms"
#endif

// Default video viewer program
#ifndef DEFAULT_VIDEOVIEWER
#define DEFAULT_VIDEOVIEWER "xine"
#endif


