/* textviewmode.hh
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2011 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef TEXTVIEWMODE_HH
#define TEXTVIEWMODE_HH

#include "wdefines.h"
#include "listermode.h"

class Lister;
class AContainer;
class TextView;
class FileEntry;
class TextStorageFile;
class Text;

class TextViewMode:public ListerMode
{
public:
    TextViewMode( Lister * );
    virtual ~TextViewMode();
    TextViewMode( const TextViewMode &other );
    TextViewMode &operator=( const TextViewMode &other );

    virtual void messageHandler( AGMessage * );
    virtual void on();
    virtual void off();
    virtual void activate();
    virtual void deactivate();
    virtual bool isType( const char * );
    virtual const char *getType();
    virtual int configure();
    virtual void cyclicfunc( cyclicfunc_mode_t mode );
    virtual const char* getLocaleName();
    virtual int load();
    virtual bool save( Datei * );
    virtual void relayout();
  
    static const char *getStaticLocaleName();
    static const char *getStaticType();

    void command_up();
    void command_down();
    void command_first();
    void command_last();
    void command_pageup();
    void command_pagedown();
private:
    static const char *type;
    void setName();
    TextView *m_tv;
    RefCount<TextStorageFile> m_ts;
    RefCount<AWidth> m_lencalc;
  
    FileEntry *m_lastactivefe;
  
    void update( bool force );
  
    void clearLastActiveFE();

    void showFile();

    void setFilePercentage();

    AContainer *m_cont;
    AContainer *m_ac1;
    Text *m_file_name_text;
    Text *m_file_percentage_text;
};

#endif
