1. INTRODUCTION

Wine est un programme qui permet d'excuter les logiciels crits
pour Microsoft Windows (comprenant les excutables DOS, Windows 3.x
et Win32) sur un Unix. Il est compos d'un chargeur qui charge et
excute un binaire Microsoft Windows, ainsi que d'une bibliothque (appele
Winelib) qui implmente les appels de l'API de Windows par leur
quivalent Unix ou X11. Cette bibliothque peut galement tre utilise
pour porter du code Win32 vers un excutable Unix natif.

Wine est un logiciel libre, distribu sous GNU LGPL; lisez le fichier
LICENSE pour les dtails.

2. DMARRAGE RAPIDE

Quand vous compilez  partir des sources, il est recommand d'utiliser
l'Installateur de Wine pour construire et installer Wine.  partir du
rpertoire racine des sources de Wine (qui contient ce fichier),
excutez :

./tools/wineinstall

Pour excuter un programme, tapez "wine [options] programme". Pour des
informations complmentaires et des rsolutions de problmes, lisez le
reste de ce fichier, les pages "man" de Wine, et surtout les nombreuses 
informations que vous trouverez sur http://www.winehq.org.

3. CONFIGURATION NCESSAIRE

Pour compiler et excuter Wine, vous devez avoir un des systmes
d'exploitation qui suit :

	Linux version 2.0.36 ou ultrieur
	FreeBSD 6.3 ou ultrieur
	Solaris x86 9 ou ultrieur
	NetBSD-current
	Mac OS X 10.4 ou ultrieur

tant donn que Wine ncessite une implmentation des "threads" (processus
lgers) au niveau du noyau, seuls les systmes d'exploitation mentionns
ci-haut sont supports. D'autres systmes d'exploitation implmentant les
threads noyau peuvent tre pris en charge dans le futur.

Information Linux :
  Bien que Linux 2.2.x devrait encore fonctionner et que Linux 2.0.x pourrait
  encore marcher (des versions plus anciennes de 2.0.x avaient des plantages
  dus aux threads), il est prfrable d'avoir un noyau rcent tel que 2.4.x
  ou 2.6.x.

Information FreeBSD :
  Wine ne fonctionnera gnralement pas bien pour les versions FreeBSD
  antrieures  6.3 ou 7.0 (certains patches additionnels sont disponibles pour
  FreeBSD 6.3). Voyez <http://wiki.freebsd.org/Wine> pour plus d'informations.

Information Solaris :
  Il est plus que probable que vous devrez construire Wine avec la chane
  d'outils GNU (gcc, gas, etc.). Attention : installer gas n'assure pas
  qu'il sera utilis par gcc.  Recompiler gcc aprs l'installation de gas
  ou crer un lien symbolique de cc, as et ld vers les outils GNU semble
  ncessaire.

Information NetBSD :
  Assurez-vous d'avoir les options USER_LDT, SYSVSHM, SYSVSEM et SYSVMSG
  actives dans votre noyau.

Information Mac OS X :
  Xcode 2.4 ou ultrieur est ncessaire pour compiler Wine sous x86.


Systmes de fichiers pris en charge :
  Wine devrait fonctionner sur la plupart des systmes de fichiers. Certains
  problmes de compatibilit ont t rapports lors de l'utilisation de fichiers
  accds via Samba. De plus, NTFS ne fournit pas toutes les fonctionnalits de
  systme de fichiers ncessaires pour certains applications. L'utilisation d'un
  systme de fichiers Linux natif comme ext3 est recommande.

Configuration requise de base :
  Les fichiers "include" de X11 (appels xlib6g-dev sous Debian et XFree86-devel
  sous RedHat) doivent tre installs.

  Bien entendu, vous aurez besoin du programme "make" (trs probablement GNU
  make).

  Flex 2.5 ou ultrieur, ainsi que bison, sont galement requis.

Bibliothques optionnelles :
  "Configure" affichera des messages quand des bibliothques optionnelles ne
  sont pas dtectes sur votre systme. Consultez
  http://wiki.winehq.org/Recommended_Packages (en anglais) pour des indications
  sur les paquets logiciels que vous devriez installer.

  Sur les plates-formes 64 bits, vous devez installer les versions 32 bits de
  ces bibliothques. Voyez http://wiki.winehq.org/WineOn64bit (en anglais) pour
  les dtails.

4. COMPILATION

Au cas o vous choisiriez de ne pas utiliser wineinstall, excutez les commandes
suivantes pour construire Wine :

./configure
make depend
make

Cela va construire le programme "wine" et de nombreux binaires/bibliothques de
support.
Le programme "wine" chargera et excutera les excutables Windows.
La bibliothque "libwine" ("Winelib") peut tre utilise pour compiler et lier
du code source Windows sous Unix.

Pour voir les options de compilation, tapez ./configure --help.

Pour mettre  jour vers une nouvelle version en utilisant les fichiers de mise 
niveau, tout d'abord aller dans le rpertoire de plus haut niveau de la version
actuelle (celui qui contient ce fichier README.fr). Ensuite faire un "make
clean", et mettre  jour la version avec :

    bunzip2 -c fichier-patch | patch -p1

o "fichier-patch" est le nom du fichier de mise  niveau (quelque chose du
genre wine-1.0.x.diff.bz2). Vous pouvez ensuite rexcuter "./configure", et
taper ensuite "make depend && make".

5. INSTALLATION

Une fois Wine a t construit correctement, vous pouvez tapez "make install" :
cela installera l'excutable wine, les pages man Wine et quelques autres
fichiers ncessaires.

N'oubliez pas de dsinstaller toutes les installations prcdentes de wine.
Essayez soit "dpkg -r wine", "rpm -e wine" ou "make uninstall" avant
d'installer une nouvelle version.

Une fois l'installation termine, vous pouvez naviguer dans la section Support 
http://www.winehq.org/ pour obtenir des astuces de configuration.


6. EXCUTER DES PROGRAMMES

Lorsque l'on invoque Wine, vous pouvez spcifier le chemin entier vers
l'excutable ou seulement le nom de fichier.

Pour excuter le bloc-notes par exemple :

	wine notepad		       (en utilisant le chemin d'accs spcifi
	wine notepad.exe	        dans le fichier "config" pour localiser
				        le fichier)

	wine c:\\windows\\notepad.exe  (en utilisant la syntaxe de fichiers DOS)

	wine ~/.wine/drive_c/windows/notepad.exe  (en utilisant la syntaxe Unix)

	wine notepad.exe /paramtre1 -paramtre2 paramtre3
			(en appelant le programme avec des paramtres)

Wine n'est pas encore termin ; ainsi quelques programmes peuvent planter. Quand
cela se produit, un dbogueur est dmarr  l'endroit du plantage pour que vous
puissiez essayer de rsoudre le problme.  Pour plus d'informations sur la
manire de faire, veuillez lire la section "dboguage" du Guide du dveloppeur
Wine (Wine Developer's Guide).


7. INFORMATIONS COMPLMENTAIRES

WWW	Beaucoup d'informations  propos de Wine sont disponibles sur WineHQ 
	http://www.winehq.org/ : divers guides Wine, base de donnes
	d'applications, suivi de bogues. C'est probablement le meilleur point
	de dpart.

FAQ	La Foire Aux Questions de Wine se trouve sur http://www.winehq.org/FAQ

Usenet	Vous pouvez parler des problmes en relation avec Wine
	ou obtenir de l'aide sur comp.emulators.ms-windows.wine.

Bogues	Rapportez les bogues  Wine Bugzilla  http://bugs.winehq.org
	SVP cherchez tout d'abord dans la base de donnes de bugzilla
	pour contrler que le problme n'est pas dj dcouvert avant
	de soumettre un rapport de bogue. Vous pouvez galement rapporter
	des rapports de bogue  comp.emulators.ms-windows.wine.
	SVP lisez le fichier documentation/bugs.sgml pour connatre les
	informations ncessaires.

IRC	L'aide en ligne est disponible sur le canal #WineHQ sur
	irc.freenode.net.

GIT	L'arbre de dveloppement actuel de Wine est disponible au travers de
	GIT. Voyez http://www.winehq.org/site/git pour plus d'informations.

Listes de diffusion
	Il existe de multiples listes de diffusion pour les dveloppeurs Wine ;
	voyez http://www.winehq.org/forums pour de plus amples informations.

Wiki	Le wiki Wine est situ sur http://wiki.winehq.org


Si vous ajoutez quelque chose ou corrigez un bogue, envoyez un correctif (dans le
format 'diff -u' )  la liste de diffusion wine-patches@winehq.org pour qu'il
soit inclus dans la prochaine version.

--
Alexandre Julliard
julliard@winehq.org
