
Short CMake tutorial
====================

IMPORTANT NOTE:
Using cmake with warmux is optional!
It is still possible to use the old autotools system.


Introduction:
-------------

cmake has to be called with the path to the source-dir as a parameter.
e.g.:

     cmake /home/foobar/source/warmux

This makes it possible to have source and build directories seperated.
For example, you can build in /tmp/warmux-build and leave the source-dir untouched,
which makes it easier to remove all files generated by the build-system.

After running cmake (which just generates the Makefiles for the native make-system)
you have to call make from the build-dir (which can be the source-dir) in order
to get Warmux compiled:

     make

To install Warmux just call

     make install

This command install everything needed to run warmux in $CMAKE_INSTALL_PREFIX
which defaults to /usr/local (see below how to change that).


Further cmake options:
----------------------

To install warmux in another prefix, pass the following parameter to cmake:
     -DPREFIX=/foo/bar
(this corresponds to --prefix=/foo/bar with autotools-configure)

To specify another build-type, pass the following parameter:
     -DBUILD=XXXXX
where XXXXX is one of the following:
     None (Default), Debug, Release, RelWithDebInfo, MinSizeRel

To get a more verbose compilation output use:
     make VERBOSE=1

To enable profiling support (e.g. for gprof) add the option:
    -DPROFILE=1


Compilation outside of source-dir:
----------------------------------

     cd /path/to/warmux-src
     mkdir ../warmux-build
     cd ../warmux-build
     cmake ../warmux-src
     make
     make install

The Makefiles and CMake control files will be generated inside the new
warmux-build dir, while the source-dir stays clean.


Package generation:
-------------------

With CMake it is possible to generate .tar.gz archives of Warmux.
It is possible to generate ready-to-use binary archives (that only have to
get extracted to play warmux) and source archives for compilation.
To create binary archives issue the command:
     make package
Note that you should use build-type 'Release' with binary packages.
To create source achives you need to have a clean source tree and build
Warmux outside the source-dir (see above):
     make package_source


Win32 compilation:
------------------

I assume that Mingw is installed in /mingw.
Export the following variables so that CMake can find the rigth paths:
	export CMAKE_INCLUDE_PATH=/mingw/include
	export CMAKE_LIBRARY_PATH=/mingw/lib
Then run CMake:
	cmake ../warmux-src -G "MSYS Makefiles"


Problems:
---------

On problems with CMake remove the CMakeCache.txt files and CMakeFiles/
directories manually and call "cmake ." again.
If there are still problems, contact the Warmux Development Team by
email to <warmux-dev@gna.org> or via IRC at #warmux in Freenode.
