/*
 * Copyright (c) 2011 Mathijs Henquet
 *
 * Marlin is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * Marlin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; see the file COPYING.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors:
 *      Mathijs Henquet <mathijs.henquet@gmail.com>
 *      ammonkey <am.monkeyd@gmail.com>
 *
 */

/* 
 * ToolButtonWithMenu 
 * - support long click / right click with depressed button states
 * - activate a GtkAction if any or popup a menu.
 * (used in history navigation buttons next/prev, appmenu) 
 */

using Gdk;
using Gtk;

namespace Varka.Widgets {

    public class ToolButtonWithMenu : ToolItem 
    {
        public ButtonWithMenu.MenuFetcher fetcher{
            set{ (get_child () as ButtonWithMenu).fetcher = value; }
            get{ return (get_child () as ButtonWithMenu).fetcher; }
        }

        public ToolButtonWithMenu.from_action (Gtk.Action action)
        {
            var btn = new ButtonWithMenu.from_action (action);
            btn.show ();
            add (btn);
        }
        
        public ToolButtonWithMenu (Image _image, string? _label, string? _tooltip, Gtk.Menu? _menu)
        {
            /*this.menu_orientation = _menu_orientation;

            icon_widget = image;
            label_widget = new Label (label);
            ((Label) label_widget).use_underline = true;
            can_focus = true;
            set_tooltip_text (label);

            menu = _menu;

            mnemonic_activate.connect(on_mnemonic_activate);

            Button button = (Button) get_child();
            //button.set_relief (Gtk.ReliefStyle.NORMAL);
            //button.get_style_context ().add_class ("raised");
            button.events |= EventMask.BUTTON_PRESS_MASK
                          |  EventMask.BUTTON_RELEASE_MASK;

            button.button_press_event.connect(on_button_press_event);
            button.button_release_event.connect(on_button_release_event);*/
            var btn = new ButtonWithMenu.from_params (_image, _label, _tooltip, _menu);
            btn.show ();
            add (btn);
        }

        public override void toolbar_reconfigured ()
        {
            (get_child () as Button).relief = get_relief_style ();
        }

    }
}

