//  
//  Copyright (C) 2008 Christian Hergert <chris@dronelabs.com>
//  Copyright (C) 2010 ammonkey <am.monkeyd@gmail.com>
//  Copyright (C) 2011 Giulio Collura
// 
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
// 
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
// 
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
// 

using Gtk;
using Gdk;
using GLib;

namespace Varka.Widgets {
     
    public class ModeButton : Box {
      
        public signal void mode_changed (Gtk.Widget widget);

        private List<Widget> widgets = null;
 
        private int _selected = -1;
        public int selected {
            get {
                return _selected;
            }
            set {
                set_active(value);
            }
        }
 
        public ModeButton () {
            homogeneous = true;
            spacing = 0;

            get_style_context ().add_class ("raised");
            get_style_context ().add_class ("linked");
            get_style_context ().add_class ("modebutton");
        }
 
        public void append (Gtk.Widget w) { 
            var button = new ToggleButton ();
            button.add(w);
            button.can_focus = false;
            //button.get_style_context ().add_class ("raised");
            
            button.add_events(Gdk.EventMask.SCROLL_MASK);
 
            button.button_press_event.connect (() => {
 
                int select = get_children ().index (button);
                set_active (select);
                return true;
 
            });

            add (button);
            widgets.append (w);
            button.show_all ();
        }
       
        public void set_active (int new_active, bool send_sig = true) {
             if (new_active >= get_children ().length () || _selected == new_active)
                return;
 
            if (_selected >= 0)
                ((ToggleButton) get_children ().nth_data (_selected)).set_active (false);
 
            _selected = new_active;
            ((ToggleButton) get_children ().nth_data (_selected)).set_active (true);
            if (send_sig)
                mode_changed(((ToggleButton) get_children ().nth_data (_selected)).get_child());
        }
        
        public void set_active_widget (Widget widget) {
            int select = widgets.index(widget);
            //message ("MODE select %d", select);
            set_active (select, false);
        }
        
        public new void remove(int number)
        {
            var w = (get_children ().nth_data (number) as Gtk.Bin).get_child ();
            widgets.remove (w);
            w.destroy();
        }
 
        public void clear_children () {
 
            foreach (weak Widget button in get_children ()) {
                button.hide ();
                if (button.get_parent () != null)
                    base.remove (button);
            }
            widgets = null; 
            _selected = -1;
        }
        
        protected override bool scroll_event (EventScroll ev) {
            if (ev.direction == Gdk.ScrollDirection.DOWN) {
                selected --;
            }
            else if (ev.direction == Gdk.ScrollDirection.UP) {
                selected ++;
            }

            return false;
        }

    }
}

