#!/usr/bin/env python
# -*- coding: utf-8 -*-

# messages.py
#
# Copyright (c) 2008 Magnun Leno da Silva
#
# Author: Magnun Leno da Silva <magnun.leno@gmail.com>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
# USAA.

import gobject
import gtk
import pygtk
pygtk.require('2.0')
import locale
import gettext
import os

locale.setlocale(locale.LC_ALL, '')
if os.path.exists("locale"):
    gettext.bindtextdomain('usbmanager', './locale')
else:
    gettext.bindtextdomain('usbmanager', '/usr/share/locale')


gettext.textdomain('usbmanager')
_ = gettext.gettext

def ShowMessage(parent, title, text, type=0):
    '''
        A simple message box used to create some output.
    '''
    if type is 0:
        type = gtk.MESSAGE_ERROR
    elif type is 1:
        type = gtk.MESSAGE_WARNING
    elif type is 2:
        type = gtk.MESSAGE_QUESTION
    else:
        type = gtk.MESSAGE_INFO

    dialog = gtk.MessageDialog(parent, gtk.DIALOG_DESTROY_WITH_PARENT, type,
                               gtk.BUTTONS_OK, title)
    dialog.format_secondary_text(text)
    dialog.run()
    dialog.destroy()

def Question(parent, title, text, type=0):
    '''
        A simple message box used to create some output.
    '''
    if type is 0:
        type = gtk.MESSAGE_ERROR
    elif type is 1:
        type = gtk.MESSAGE_WARNING
    elif type is 2:
        type = gtk.MESSAGE_QUESTION
    else:
        type = gtk.MESSAGE_INFO

    dialog = gtk.MessageDialog(parent, gtk.DIALOG_DESTROY_WITH_PARENT, type,
                               gtk.BUTTONS_YES_NO, title)
    dialog.format_secondary_text(text)
    ret = dialog.run()
    dialog.destroy()
    return ret


def MainWindowAlreadyOpened():
    ShowMessage(None, _("Attention!"), _("Another USB Manager window is already open"), 1)

def FunctionNotImemented():
    ShowMessage(None, _("Function not implemented yet!"), _("Sorry, we're working hard on it..."), 3)

def DeviceNotRenamable(device):
    if device.rename_info is None:
        ShowMessage(None, _("Sorry!"), _("The '%(fs)s' file system is unknown!")%{"fs":device.fs_type}+"\n"+_("Please contact the developer and request an improvement."), 3)
    else:
        ShowMessage(None, _("Sorry!"), _("The '%(command)s' command could not be found!")%{"command":device.rename_info[0]}+"\n"+_("Please ensure that the '%(package)s' package is installed.")%{"package":device.rename_info[-1]}, 3)

def UmountingDevice(device):
    ShowMessage(None, _("Attention!"), _("The '%(label)s' device will be umonted.")%{"label":device.label}, 1)

def BlockingDevice():
    ShowMessage(None, _("This device will be blocked"), _("Some informations in this device will only be updated after removing and reinserting it."),1)

def BlockedDevice():
    ShowMessage(None, _("This device is blocked"), _("Please remove and reinsert this device first!"),1)

def ErrorDuringRename(device, error):
    ShowMessage(None, _("Error while renaming %(block_device)s!")%{"block_device":device.block_device}, _("The following error ocurred!")+"\n\n"+error+"\n\n"+_("Please contact the developer."),0)

def MountingError(device, msg):
    ShowMessage(None, _('Error while mounting %s')%(device.block_device), _("The following error ocurred:")+"\n\n"+msg, 0)

def UmountingError(device, msg):
    if msg == "NO SUDO":
        CantSudo()
        return
    ShowMessage(None, _('Error while umounting %s')%(device.block_device), _("The following error ocurred:")+"\n\n"+str(msg), 0)

def QuestionFormating():
    return Question(None, _("Attention!"), _("All data will be lost during this process!")+'\n'+_("Do you want to proceed?"), type=1)
	
def CantSudo():
	ShowMessage(None, _("Sorry!"), _("Can't proceed with the requested solicitation.")+"\n"+_("Couldn't found any sudo graphical frontend"), 0)
