#!/usr/bin/env python

from distutils.core import setup
import os
import glob
from shutil import copy
from shutil import rmtree

data = [
        ('/usr/share/applications', ['data/usbmanager.desktop']),
        ('/usr/share/icons/hicolor/scalable/apps', glob.glob('data/icons/scalable/apps/*.svg')),
        ('/usr/share/icons/hicolor/24x24/apps', glob.glob('data/icons/24x24/apps/*.png')),
        ('/usr/share/icons/hicolor/32x32/apps', glob.glob('data/icons/32x32/apps/*.png')),
        ('/usr/share/icons/hicolor/64x64/apps', glob.glob('data/icons/64x64/apps/*.png')),
        ('/usr/share/icons/hicolor/128x128/apps', glob.glob('data/icons/128x128/apps/*.png')),
        ('/root/', glob.glob('data/.mtoolsrc'))
       ]

locales = os.walk('./locale').next()[2]
locales.remove('template.pot')
locales.remove('template.mo')
locales = [locale.split('.')[0] for locale in locales if locale.split('.')[1] == 'mo']

for locale in locales:
    dst = './locale/'+locale 
    if os.path.exists(dst):
        rmtree(dst)
    os.mkdir(dst)
    dst += '/LC_MESSAGES/'
    os.mkdir(dst) 
    src = './locale/'+locale+'.mo'
    dst += 'usbmanager.mo'
    copy(src, dst)
    src = 'locale/'+locale+'/LC_MESSAGES/*.mo'
    dst = '/usr/share/locale/'+locale+'/LC_MESSAGES'
    data.append((dst, glob.glob(src)))

setup(name='USBManager',
      version='1.0.0',
      description='A simple USB Storage Device Manager',
      author='Magnun Leno da Silva',
      author_email='magnun.leno@gmail.com',
      url='https://launchpad.net/usbmanager',
      license='LGPL',
      packages=[ "usbmanager", "usbmanager.gui" ],
      package_dir={ "usbmanager":"src/", },
      scripts=['usbmanager'],
      data_files=data,
     )
