/*
 *  Print Dialog for Canon LIPS/PS/LIPSLX/UFR2/CAPT Printer.
 *  Copyright (C) 2004-2008 CANON INC.
 *  All Rights Reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef	_UIMAIN
#define	_UIMAIN

#include <cups/cups.h>
#include "dialog.h"
#include "propdlg.h"
#include "cngplpmod.h"
#include "ppdkeys.h"
#include "getdata.h"
#include "ppdoptions.h"

typedef struct{
	UIDialog dialog;
	UIPropDlg *prop;
	cngplpData *data;
	char *file_name;
	int hasfile;
	int print_ok;
}UIMainDlg;

UIMainDlg *g_main_window;

#define	UI_DLG_PROP()	g_main_window->prop
#define	CNGPLP_DATA()	g_main_window->data

#define	PRINTER_TYPE_CAPT_DUPLEX	10
#define	PRINTER_TYPE_CAPT_BIND		11

UIMainDlg *CreateMainWnd(char *file_name);
int DisposeMainDlg(UIMainDlg *main_wnd);
int CreateDialogs(UIMainDlg *main_wnd);
void DisposeDialogs(void);

void UpdateMainDlgWidgets(UIMainDlg *main_wnd, int id);

void UpdateData(int id, char *value);
void UpdateDataDouble(int id, double value);
void UpdateDataInt(int id, int value);
void UpdateDataCheck(int id, int active);
void UpdateDataCombo(int id, char *combo_entry_name);
void UpdateDataComboProfileDialog(int id, char *combo_entry_name);
void UpdateDataComboFrontBackCvrDialog(int id, char *combo_entry_name);
int GetCurrDisable(int id, char *list);
double GetCurrOptDouble(int id, double def);
int GetCurrOptInt(int id, int def);
char* GetCurrOpt(int id, char *list);
char* GetOptionList(int id);
char* GetCNUIValue(char *key);
void memFree(void *pointer);

#endif

