/*
 *  Print Dialog for Canon LIPS/PS/LIPSLX/UFR2/CAPT Printer.
 *  Copyright (C) 2004-2008 CANON INC.
 *  All Rights Reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <locale.h>

#include "uimain.h"
#include "widgets.h"
#include "bookletdlg.h"
#include "gutterdlg.h"
#include "boxiddlg.h"
#include "passwddlg.h"
#include "mltlang.h"

#include "callbacks.h"
#include "interface.h"

static int g_stdout_fd;

UIMainDlg *CreateMainWnd(char *file_name)
{
	UIMainDlg *main_wnd;

	main_wnd = (UIMainDlg *)CreateDialog(sizeof(UIMainDlg), NULL);

	if(main_wnd == NULL)
		return NULL;

	UI_DIALOG(main_wnd)->window = create_MainDlg();

	if((main_wnd->data = cngplpNew(file_name)) == NULL)
	{
		DisposeDialog((UIDialog *)main_wnd);
		return NULL;
	}

	if(file_name != NULL){
		main_wnd->file_name = file_name;
		main_wnd->hasfile = 1;
	}


	SetSpinMaxValue(UI_DIALOG(main_wnd)->window, "Copies_spinbutton", 2000);
	SetTextToLabel(UI_DIALOG(main_wnd)->window, "Copies_label", " ");

	ComboSignalConnect(UI_DIALOG(main_wnd)->window, "PrinterName_combo", GTK_SIGNAL_FUNC(on_PrinterName_combo_popwin_event));

#ifndef _UI_DEBUG
	close(1);
	g_stdout_fd = open("/dev/null", O_RDWR);
#endif
	return main_wnd;
}


int CreateDialogs(UIMainDlg *main_wnd)
{
	int type, color_mode, special_func, fin_details;

	color_mode = GetCurrOptInt(ID_COLOR_MODE, 0);
	special_func = GetCurrOptInt(ID_SPECIAL_FUNC, 0);
	fin_details = GetCurrOptInt(ID_CNFINDETAILS, 0);

	type = GetCurrOptInt(ID_PRINTERTYPE, 0);
	if(type == PRINTER_TYPE_CAPT){
		char *bind = GetCurrOpt(ID_BINDEDGE, NULL);
		if(bind != NULL || fin_details == 1){
			type = PRINTER_TYPE_CAPT_BIND;
			memFree(bind);
		}
	}

	if((main_wnd->prop = CreatePropDlg(UI_DIALOG(main_wnd), type, color_mode, special_func)) == NULL)
		goto err;

	if((main_wnd->prop->booklet = CreateBookletDlg(UI_DIALOG(main_wnd->prop))) == NULL)
		goto err;

	if((main_wnd->prop->gutter = CreateGutterDlg(UI_DIALOG(main_wnd->prop))) == NULL)
		goto err;

	main_wnd->prop->user_id = GetCurrOptInt(ID_USERID, 100);

	if(type == PRINTER_TYPE_CAPT_BIND || fin_details == 1){
		if((main_wnd->prop->captfin = CreateFinDetailsDlg(UI_DIALOG(main_wnd->prop))) == NULL)
			goto err;
	}

	if(special_func){
		if((main_wnd->prop->boxid = CreateBoxIDDlg(UI_DIALOG(main_wnd->prop))) == NULL)
			goto err;
		if((main_wnd->prop->secured = CreatePassWdDlg(UI_DIALOG(main_wnd->prop), 0)) == NULL)
			goto err;
		if((main_wnd->prop->jobaccount = CreatePassWdDlg(UI_DIALOG(main_wnd->prop), 1)) == NULL)
			goto err;
		main_wnd->prop->holdqueue = CreateHoldQueueDlg(UI_DIALOG(main_wnd->prop));
		if(main_wnd->prop->holdqueue == NULL)
			goto err;
	}

	if((main_wnd->prop->profile = CreateProfileDlg(UI_DIALOG(main_wnd->prop))) == NULL)
		goto err;

	if((main_wnd->prop->ftbkcvr = CreateFrontBackCvrDlg(UI_DIALOG(main_wnd->prop))) == NULL)
		goto err;

	if((main_wnd->prop->advsettings = CreateAdvancedSettingsDlg(UI_DIALOG(main_wnd->prop))) == NULL)
		goto err;

	return 1;

err:
	DisposeDialogs();
	return 0;

}

void DisposeDialogs(void)
{
	int fin_details;
	DisposeDialog((UIDialog *)UI_DLG_PROP()->ftbkcvr);
	DisposeDialog((UIDialog *)UI_DLG_PROP()->profile);
	if(g_main_window->prop->special_func){
		DisposeDialog((UIDialog *)UI_DLG_PROP()->boxid);
		DisposeDialog((UIDialog *)UI_DLG_PROP()->secured);
		DisposeDialog((UIDialog *)UI_DLG_PROP()->jobaccount);
		DisposeDialog((UIDialog *)UI_DLG_PROP()->holdqueue);
	}
	fin_details = GetCurrOptInt(ID_CNFINDETAILS, 0);
	if(g_main_window->prop->ui_type == PRINTER_TYPE_CAPT_BIND || fin_details == 1)
		DisposeDialog((UIDialog *)UI_DLG_PROP()->captfin);
	DisposeDialog((UIDialog *)UI_DLG_PROP()->gutter);
	DisposeDialog((UIDialog *)UI_DLG_PROP()->booklet);
	DisposeDialog((UIDialog *)UI_DLG_PROP()->advsettings);
	DisposeDialog((UIDialog *)UI_DLG_PROP());
}

int DisposeMainDlg(UIMainDlg *main_wnd)
{
	DisposeDialogs();
	cngplpDestroy(main_wnd->data);
	main_wnd->data=NULL;
#ifndef _UI_DEBUG
	close(g_stdout_fd);
#endif
	return 0;
}

void UpdateData(int id, char *value)
{
	char *text;
	cngplpData *data = CNGPLP_DATA();
	if(data == NULL)
		return;
	text = cngplpSetData(data, id, value);
	UpdateWidget(id, text);
}

void UpdateDataDouble(int id, double value)
{
	char *text;
	cngplpData *data = CNGPLP_DATA();
	char str[64];
	memset(str, 0, 64);
	snprintf(str, 63, "%f", value);
	text = cngplpSetData(data, id, str);
	UpdateWidget(id, text);
}

void UpdateDataInt(int id, int value)
{
	char *text;
	cngplpData *data = CNGPLP_DATA();
	char str[64];
	memset(str, 0, 64);
	snprintf(str, 63, "%d", value);
	text = cngplpSetData(data, id, str);
	UpdateWidget(id, text);
}

void UpdateDataCheck(int id, int active)
{
	char *text;
	cngplpData *data = CNGPLP_DATA();
	char *str;
	str = active ? "true" : "false";
	text = cngplpSetData(data, id, str);
	UpdateWidget(id, text);
}

void UpdateDataCombo(int id, char *combo_entry_name)
{
	char *text;
	char *str, *tmp;

	tmp = GetCurrComboText(UI_DIALOG(g_main_window->prop)->window, combo_entry_name);
	str = TextToName(id, tmp);
	if(str == NULL)
		str = tmp;
	text = cngplpSetData(CNGPLP_DATA(), id, str);
	UpdateWidget(id, text);
}

void UpdateDataComboProfileDialog(int id, char *combo_entry_name)
{
	char *text;
	char *str, *tmp;

	tmp = GetCurrComboText(UI_DIALOG(g_main_window->prop->profile)->window, combo_entry_name);
	str = TextToName(id, tmp);
	if(str == NULL)
		str = tmp;
	text = cngplpSetData(CNGPLP_DATA(), id, str);
	UpdateWidget(id, text);
}

void UpdateDataComboFrontBackCvrDialog(int id, char *combo_entry_name)
{
        char *text;
        char *str, *tmp;

        tmp = GetCurrComboText(UI_DIALOG(g_main_window->prop->ftbkcvr)->window, combo_entry_name);
        str = TextToName(id, tmp);
        if(str == NULL)
                str = tmp;
        text = cngplpSetData(CNGPLP_DATA(), id, str);
        UpdateWidget(id, text);
}

int GetCurrDisable(int id, char *in)
{
	char *list, *plist;
	char *tmp;
	int disable = 0;

	if(in == NULL)
		list = GetOptionList(id);
	else
		list = strdup(in);

	if(list == NULL)
		return -1;
	plist = list;
	while(1){
		if((tmp = strchr(plist, '<')) == NULL){
			break;
		}else{
			tmp++;
			disable += atoi(tmp);
			plist = tmp;
		}
	}
	memFree(list);
	return disable;
}

double GetCurrOptDouble(int id, double def)
{
	char *value;
	double num;

	value = GetCurrOpt(id, NULL);
	if(value != NULL){
      setlocale (LC_NUMERIC, "C");
      num = atof(value);
      setlocale (LC_NUMERIC, "");
		memFree(value);
		return num;
	}else
		return def;
}

int GetCurrOptInt(int id, int def)
{
	char *value;
	int num;

	value = GetCurrOpt(id, NULL);
	if(value != NULL){
		num = atoi(value);
		memFree(value);
		return num;
	}else
		return def;
}

char* GetCurrOpt(int id, char *in)
{
	char *option = NULL, *popt, *plist;
	char *list, tmp[256];

	if(in == NULL)
		list = GetOptionList(id);
	else
		list = strdup(in);

	if(list == NULL)
		return NULL;

	popt = tmp;
	plist = list;
	while(1){
		if(*plist == '\0'){
			*popt = '\0';
			option = strdup(tmp);
			break;
		}
		if(*plist == ','){
			*popt = '\0';
			option = strdup(tmp);
			break;
		}
		if(*plist == ':'){
			*popt = '\0';
			option = strdup(tmp);
			break;
		}
		*popt = *plist;
		popt++;
		plist++;
	}
	memFree(list);
	return option;
}

char* GetOptionList(int id)
{
	char *list;
	list = cngplpGetData(CNGPLP_DATA(), id);
	return list;
}

char* GetCNUIValue(char *key)
{
	char *value = NULL;
	value = cngplpGetValue(CNGPLP_DATA(), key);
	return value;
}

void memFree(void *pointer)
{
	if(pointer != NULL)
		free(pointer);
}
