/*
 *  Print Dialog for Canon LIPS/PS/LIPSLX/UFR2/CAPT Printer.
 *  Copyright (C) 2004-2008 CANON INC.
 *  All Rights Reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>

#include "interface.h"
#include "support.h"

//#include "dialog.h"
#include "uimain.h"

//#include "parser.h"
//#include "cupsoption.h"
#include "widgets.h"

char* LaunchOption(int argc, char *argv[])
{
	char *file = NULL;
	if(argc > 1){
		if(strcmp(argv[1], "-h") == 0){
			printf("cngplp --- Print Dialog for Canon LIPS/PS/LIPSLX/UFR2/CAPT Printer.\n");
			printf("Usage:	cngplp		        Executing default settings.\n");
			printf("	cngplp -p [print file]  Printing Using the UI Setting.\n");
			exit(1);
		}
	}
	if(argc == 3){
		if(strcmp(argv[1], "-p") == 0){
			if(argv[2] != NULL)
				file = argv[2];
		}
	}

	return file;
}

int main(int argc, char *argv[])
{
	char *print_file_name = NULL;
#ifdef ENABLE_NLS
	bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
#ifndef OLD_GTK
	/* changes for GTK2 */
	bind_textdomain_codeset(PACKAGE, "UTF-8");
#endif
	textdomain (PACKAGE);
#endif
	gtk_set_locale ();
	gtk_init (&argc, &argv);

	add_pixmap_directory (PACKAGE_DATA_DIR "/pixmaps");
#ifdef OLD_GTK
	/* changes for GTK2 */
	/* If it is necessary, "PACKAGE_SOURCE_DIR" is defined. */
	/* Example: add to configure.in                                */
	/*  dnl Set PACKAGE_SOURCE_DIR in config.h.                    */
	/*  packagesrcdir=`cd $srcdir && pwd`                          */
	/*  AC_DEFINE_UNQUOTED(PACKAGE_SOURCE_DIR, "${packagesrcdir}") */
	add_pixmap_directory (PACKAGE_SOURCE_DIR "/pixmaps");
#endif

  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
	SigInit();

	print_file_name = LaunchOption(argc, argv);

	g_main_window = CreateMainWnd(print_file_name);
	if(g_main_window == NULL)
		return -1;

	if(CreateDialogs(g_main_window) == 0)
	{
		cngplpDestroy(g_main_window->data);
		DisposeDialog((UIDialog *)g_main_window);
		return -1;
	}

	gtk_widget_realize(UI_DIALOG(g_main_window)->window);

	SigDisable();
	UpdateMainDlgWidgets(g_main_window, 0);
	SigEnable();

	gtk_widget_show(UI_DIALOG(g_main_window)->window);
	gtk_main ();

	DisposeDialog((UIDialog *)g_main_window);

	return 0;
}


