/*
 *  Print Dialog for Canon LIPS/PS/LIPSLX/UFR2/CAPT Printer.
 *  Copyright (C) 2004-2008 CANON INC.
 *  All Rights Reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "uimain.h"
#include "widgets.h"
#include "callbacks.h"
#include "interface.h"
#include "passwddlg.h"

void CreateBoxIDDlgWidgets(UIBoxIDDlg *box);

const gchar *g_dataname_button_name[] = {
	"EnterName_radiobutton",
	"UseFileName_radiobutton",
	NULL
};

UIBoxIDDlg* CreateBoxIDDlg(UIDialog *parent)
{
        UIBoxIDDlg *dialog;

        dialog = (UIBoxIDDlg *)CreateDialog(sizeof(UIBoxIDDlg), parent);

	if(dialog == NULL)
		return NULL;

	UI_DIALOG(dialog)->window = create_BoxIdDlg();
	if(UI_DLG_TOP(dialog)->hasfile == 1)
		cngplpSetData(UI_DLG_TOP(dialog)->data, ID_DATANAME, "1");

        return dialog;
}

void CreateBoxIDDlgWidgets(UIBoxIDDlg *box)
{
	GtkWidget *window;
	char text[33];
	int max_box_num;
	window = UI_DIALOG(box)->window;

	max_box_num = GetCurrOptInt(ID_MAX_BOXIDNUM, 99);
	SetSpinMaxValue(window, "BoxID_spinbutton", max_box_num);
	snprintf(text, 32, "0 - %d", max_box_num);
	SetTextToLabel(window, "BoxID_label", text);
}

void ShowBoxIDDlg(UIBoxIDDlg *dialog)
{
	dialog->hasfile = UI_DLG_TOP(dialog)->hasfile;

	dialog->code = GetCharSet();
	SigDisable();
	UpdateBoxIDDlgWidgets(UI_DLG_PROP());
	SigEnable();
	ShowDialog((UIDialog *)dialog, NULL);
}

void HideBoxIDDlg(UIBoxIDDlg *dialog, int apply)
{
	HideDialog((UIDialog *)dialog);
	cngplpSetData(UI_DLG_TOP(dialog)->data, apply, "Boxid");
}

void UpdateBoxIDDlgWidgets(UIPropDlg *prop)
{
	GtkWidget *window;
	int value;
	int disable;
	int data_name;
	char *enter_name;

	window = UI_DIALOG(prop->boxid)->window;

	data_name = GetCurrOptInt(ID_DATANAME, 0);
	if(prop->boxid->hasfile == 0){
		SetWidgetSensitive(window, "UseFileName_radiobutton", FALSE);
		data_name = 0;
	}else{
		SetWidgetSensitive(window, "UseFileName_radiobutton", TRUE);
	}

	SetActiveRadioButton(window, g_dataname_button_name, data_name);
	enter_name = GetCurrOpt(ID_ENTERNAME, NULL);
	if(enter_name != NULL){
		SetTextEntry(window, "EnterName_entry", enter_name);
		memFree(enter_name);
	}

	disable = (data_name == 0) ? TRUE : FALSE;
	SetWidgetSensitive(window, "EnterName_hbox", disable);

	value = GetCurrOptInt(ID_BOXIDNUM, 0);
	SetSpinButton(window, "BoxID_spinbutton", value);
}

