/*
 *  Print Dialog for Canon LIPS/PS/LIPSLX/UFR2/CAPT Printer.
 *  Copyright (C) 2004-2008 CANON INC.
 *  All Rights Reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "uimain.h"
#include "widgets.h"
#include "mltlang.h"
#include "callbacks.h"
#include "interface.h"

#define	ID_DUMMY1	ID_CNSKIPBLANK

UIAdvancedSettingsDlg* CreateAdvancedSettingsDlg(UIDialog *parent)
{
	UIAdvancedSettingsDlg *dialog = NULL;

	dialog = (UIAdvancedSettingsDlg*) CreateDialog(sizeof(UIAdvancedSettingsDlg), parent);

	UI_DIALOG(dialog)->window = create_AdvancedSettingsDlg();

	return dialog;
}

void ShowAdvancedSettingsDlg(UIAdvancedSettingsDlg *dialog)
{

	SigDisable();
	UpdateAdvancedSettingsDlgWidgets(dialog);
	SigEnable();
	ShowDialog((UIDialog*)dialog, "AdvancedSettings_button");
}

void HideAdvancedSettingsDlg(UIAdvancedSettingsDlg *dialog, int apply)
{
	char *text;
	text = cngplpSetData(UI_DLG_TOP(dialog)->data, apply, "Settings");
	UpdateWidget(ID_DUMMY1, text);
	HideDialog((UIDialog *)dialog);
}

void UpdateAdvancedSettingsDlgWidgets(UIAdvancedSettingsDlg *dialog)
{
	GtkWidget *window = UI_DIALOG(dialog)->window;
	int max_value, min_value;
	char *text = NULL, label[32];
	char *val;

	min_value = GetCurrOptInt(ID_CNSHIFTPOSITIONMIN, -50);
	max_value = GetCurrOptInt(ID_CNSHIFTPOSITIONMAX, 50);
	dialog->min_shift_value = min_value;
	dialog->max_shift_value = max_value;

	if((val = GetCNUIValue("CNEnableDetailShiftPosition")) != NULL){
		if(strcasecmp(val, "True") == 0){
			text = NameToText(ID_CNSHIFTPOSITIONMAX, "ShiftRangeDouble");
			snprintf(label, 31, text, (double)min_value, (double)max_value);
			SetSpinDigits(window, "FrontLong_spinbutton", 1);
			SetSpinStepIncrementFloat(window, "FrontLong_spinbutton", 0.1);
			SetSpinMaxMinValueDouble(window, "FrontLong_spinbutton", (double)max_value, (double)min_value);
			SetSpinDigits(window, "FrontShort_spinbutton", 1);
			SetSpinStepIncrementFloat(window, "FrontShort_spinbutton", 0.1);
			SetSpinMaxMinValueDouble(window, "FrontShort_spinbutton", (double)max_value, (double)min_value);
			SetSpinDigits(window, "BackLong_spinbutton", 1);
			SetSpinStepIncrementFloat(window, "BackLong_spinbutton", 0.1);
			SetSpinMaxMinValueDouble(window, "BackLong_spinbutton", (double)max_value, (double)min_value);
			SetSpinDigits(window, "BackShort_spinbutton", 1);
			SetSpinStepIncrementFloat(window, "BackShort_spinbutton", 0.1);
			SetSpinMaxMinValueDouble(window, "BackShort_spinbutton", (double)max_value, (double)min_value);
		}
	}
	if(val == NULL || strcasecmp(val, "False") == 0){
		text = NameToText(ID_CNSHIFTPOSITIONMAX, "ShiftRange");
		snprintf(label, 31, text, min_value, max_value);
		SetSpinMaxMinValue(window, "FrontLong_spinbutton", max_value, min_value);
		SetSpinMaxMinValue(window, "FrontShort_spinbutton", max_value, min_value);
		SetSpinMaxMinValue(window, "BackLong_spinbutton", max_value, min_value);
		SetSpinMaxMinValue(window, "BackShort_spinbutton", max_value, min_value);
	}
	MemFree(val);

	SetTextToLabel(window, "FrontLongEdge_label", label);
	SetTextToLabel(window, "FrontShortEdge_label", label);
	SetTextToLabel(window, "BackLongEdge_label", label);
	SetTextToLabel(window, "BackShortEdge_label", label);
	UpdateAdvSettingsDlgWidgets(g_main_window->prop);
	return;
}

