/* gentitle - get title screen from title.pbm */

#include <stdio.h>

/* value of I used */
#define USED_I	0xc

unsigned char rom[8192];
unsigned char bmp[32*192];


main()
{
int w,h,x,y,c,i,mask;
char buf[128];
unsigned char *ptr;
FILE *in;

if((in=fopen("/usr/local/lib/z81/zx81.rom","rb"))==NULL)
  {
  fprintf(stderr,"Couldn't load ROM.\n");
  exit(1);
  }

fread(rom,1,8192,in);
fclose(in);

scanf("%s",buf);
if(strcmp(buf,"P4")!=0)
  {
  fprintf(stderr,"Raw PBM files only.\n");
  exit(1);
  }

scanf("%d%d",&w,&h);
getchar();  /* throw away the LF */

if(w!=256 || h!=192)
  {
  fprintf(stderr,"Must be 256x192.\n");
  exit(1);
  }

fread(bmp,1,32*192,stdin);

printf(";title - automatically generated by gentitle from title.pbm.\n");
printf(";edits will be lost!\n\n");

printf("screen:\n");

for(y=0;y<192;y++)
  {
  for(x=0;x<32;x++)
    {
    if((x%8)==0) printf("defb ");
    c=closest(bmp[y*32+x]);
    printf("0%02Xh%c",c,((x%8)==7)?'\n':',');
    }
  printf("defb 201\n");
  }
printf("\nhalt\n");

exit(0);
}


/* find byte available which has least bits different from c. */
int closest(c)
int c;
{
int mask;
int f;
int diff,least,leastf;

least=9;

for(f=0;f<64;f++)
  {
  diff=diffbits(rom[USED_I*256+f*8],c);
  if(diff<least)
    {
    least=diff;
    leastf=f;
    }
  diff=diffbits(rom[USED_I*256+f*8]^255,c);
  if(diff<least)
    {
    least=diff;
    leastf=f+128;
    }
  }

return(leastf);
}


/* return number of bit mismatches between a and b */
int diffbits(a,b)
int a,b;
{
int count=0;
int f,mask;

for(f=0,mask=128;f<8;f++,mask>>=1)
  if((a&mask)!=(b&mask)) count++;

return(count);
}
