<!DOCTYPE html>
<html lang="ru">
<head>
	<meta charset="UTF-8">
	<title>SliTaz Pro</title>
	<meta name="description" content="Профессиональная платформа SliTaz">
	<meta name="keywords" lang="en" content="slitaz, boot, pxe, web OS">
	<meta name="robots" content="index, follow, all">
	<meta name="modified" content="<?php echo (date( "Y-m-d H:i:s", getlastmod())); ?>">
	<meta name="author" content="Christophe Lincoln">
	<link rel="shortcut icon" href="../favicon.ico">
	<link rel="stylesheet" type="text/css" href="../slitaz.css">
</head>
<body>

<?php include("../lib/html/header.ru.html"); ?>

<!-- Block -->
<div id="block">
	<!-- Navigation -->
	<div id="block_nav" style="text-align: center; padding: 10px;">
		<img src="/images/desktop.png" alt="[ desktop ]" />
	</div>
	<!-- Information/image -->
	<div id="block_info">
		<h4>Профессионалы</h4>

		<p>Добро пожаловать на профессиональную платформу
			<a href="http://www.slitaz.org/ru/">SliTaz GNU/Linux</a>.
			SliTaz — это быстрая, надежная и профессиональная операционная
			система, построенная на технологиях открытого исходного кода.</p>
		<p>Мы — коллектив разработчиков и компаньонов, имеющих возможность
			выполнять заказные разработки и поддержку клиентов, консалтинговые
			услуги, создание модификаций LiveCD и многое другое.</p>
	</div>
</div>

<!-- Languages -->
<div id="lang">
	<a href="http://www.slitaz.org/i18n.php">
		<img src="../images/locale.png" alt="Locale" /></a>
	<a href="../en/">English</a>
	<a href="../ru/">Русский</a>
	<!--<a href="../de/">Deutsch</a>
	<a href="../fr/">Français</a>-->
</div>

<!-- Content -->
<div id="content">

<h2>Введение</h2>

<p>SliTaz — свободная система, основанная на открытом исходном коде, с большим
и растущим сообществом. Наша бизнес-модель: программное обеспечение — это
услуги, партнерство и финансовая поддержка. Мы можем предоставлять услуги по
всему миру на таких языках, как английский, французский и португальский.</p>

<p>Эта профессиональная платформа позволяет вам обратиться к команде SliTaz,
которая обработает ваш запрос и станет связующим звеном между вами и одним из
наших официальных разработчиков и спонсоров. Наша цель — мониторинг и контроль
качества работ для гарантии высокого уровня обслуживания наших клиентов.</p>


<h2>Услуги</h2>

<ul>
	<li>Разработка на заказ</li>
	<li>Консалтинг и аудит</li>
	<li>Поддержка пользователей</li>
	<li>Развертывание программного обеспечения</li>
	<li>Создание Live-систем</li>
</ul>


<h2>Разработчики SliTaz</h2>

<p>Ассоциация SliTaz — некоммерческая организация, которая имеет право оказывать
платные услуги. Мы можем нанять для вас внештатных разработчиков SliTaz. Мы
также можем помогать школам, неправительственным организациям и социальным
проектам с небольшим бюджетом. Пожалуйста, свяжитесь с нами для получения
дополнительной информации об этой услуге.</p>


<h2>Партнерство</h2>

<p>Ассоциация SliTaz станет связующим звеном между клиентами и одним из наших
партнеров. Официальные партнеры сотрудничают с официальными разработчиками
SliTaz и осуществляют финансовую поддержку проекта. Ведение бизнеса с нашими
официальными партнерами позволит вам поддержать проект SliTaz и получить
индивидуальные услуги, такие как развертывание VOIP, серверов «всё в одном»,
хот-спотов Wi-Fi, а также закрытые разработки, и многое другое.</p>

<p>Если вы хотите воспользоваться профессиональными услугами наших партнеров,
или если вы сами хотите стать официальным партнером, пожалуйста, свяжитесь
с нами по электронной или обычной почте.</p>


<h2>Финансовая поддержка</h2>

<p>Вы используете SliTaz в вашем проекте и хотите, чтобы дистрибутив стал еще
более профессиональным, а основные разработчики имели бы возможность работать
над проектом полный рабочий день? Если так, то вы можете спонсировать Ассоциацию
SliTaz, которая будет платить разработчикам за их постоянную работу на
SliTaz.</p>

<p>Если вы используете SliTaz для коммерческих целей, в университете, или если
вы просто хотите стать спонсором и получить логотип-ссылку-описание на нашем
главном сайте, пожалуйста, свяжитесь с нами. Вы можете начать финансировать
SliTaz от 40$ в месяц. Спонсорский контракт заключается на один год, показ
вашего логотипа зависит от суммы пожертвований, получаемых каждый месяц.</p>

<p>Более подробную информацию о спонсорстве SliTaz, как и список наших нынешних
спонсоров можно найти на
<a href="http://www.slitaz.org/en/sponsor/">странице спонсоров</a> сайта
SliTaz.</p>


<h2>Контакты</h2>

<p>Хотите связаться с нами или получить более подробную информацию?
Не стесняйтесь — обратитесь к нам по электронной или обычной почте.</p>

<p class="box">Электронная почта: &lt;contact at slitaz.pro&gt;</p>

<p class="box">
	Association SliTaz<br />
	Rue du Village 40<br />
	1081 Montpreveyres<br />
	Switzerland<br />
</p>

<!-- End of content -->
</div>

<?php include("../lib/html/footer.ru.html"); ?>

</body>
</html>
