<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<title>SliTaz Pro</title>
	<meta name="description" content="SliTaz Professional Platform">
	<meta name="keywords" lang="en" content="slitaz, boot, pxe, web OS">
	<meta name="robots" content="index, follow, all">
	<meta name="modified" content="<?php echo (date( "Y-m-d H:i:s", getlastmod())); ?>">
	<meta name="author" content="Christophe Lincoln">
	<link rel="shortcut icon" href="../favicon.ico">
	<link rel="stylesheet" type="text/css" href="../slitaz.css">
</head>
<body>

<?php include("../lib/html/header.html"); ?>

<!-- Block -->
<div id="block">
	<!-- Navigation -->
	<div id="block_nav" style="text-align: center; padding: 10px;">
		<img src="/images/desktop.png" alt="[ desktop ]" />
	</div>
	<!-- Information/image -->
	<div id="block_info">
		<h4>Professional</h4>
		<p>
			Welcome to the <a href="http://www.slitaz.org/en/">SliTaz GNU/Linux</a>
			professional platform. SliTaz is a fast, robust and professional
			operating system built with open source technology.
		</p>
		<p>
			We are a group of developers and partners who can provide custom
			development and support, consulting services, LiveCD flavor creation
			and more to customers.
		</p>
	</div>
</div>

<!-- Languages -->
<div id="lang">
	<a href="http://www.slitaz.org/i18n.php">
		<img src="../images/locale.png" alt="Locale" /></a>
	<a href="../en/">English</a>
	<a href="../ru/">Русский</a>
	<!--<a href="../de/">Deutsch</a>
	<a href="../fr/">Français</a>-->
</div>

<!-- Content -->
<div id="content">

<h2>Introduction</h2>

<p>
	SliTaz is free and open source system with a large and growing
	community. Our business model is software as a service, partnership
	and sponsoring. We can provide services all over the world
	and in languages such as English, French and Portuguese.
</p>
<p>
	This professional platform allows you to have contact with the SliTaz
	team who will process your request and do the mediating among yourselves
	and one of our official developers or sponsors. Our goal is to monitor
	and verify the quality of service to ensure our customers a high
	level of work.
</p>

<h2>Services</h2>

<ul>
	<li>Custom development</li>
	<li>Consulting and audit</li>
	<li>Custom support</li>
	<li>Software deployment</li>
	<li>Live system creation</li>
</ul>

<h2>SliTaz developer</h2>

<p>
	The SliTaz association is a non profit base entity which can provide
	paid services. We can employ a freelance SliTaz developer to work
	for you. We can also help Schools, ONG and social projects with a
	small budget. Please contact us for more information about this service.
</p>

<h2>Partner</h2>

<p>
	The SliTaz association will do the mediating between customers and one of
	our partners. Official partners collaborate with the official SliTaz
	developers and monetary support the project. Making business with our
	official partners lets you help the SliTaz project and get customized
	services such as VOIP deployment, all in one servers, Wifi Hot Spots,
	closed development, and more.
</p>

<p>
	If you want to get professional services from our partners or if
	you want to become an official partner, please contact us by mail
	or post.
</p>

<h2>Sponsor</h2>

<p>
	Do you use SliTaz in your project and want to see the distribution
	getting even more professional with main developers working on the
	project full time? If so, you can sponsor the SliTaz Association
	which will pay a developer to work fully 100% on SliTaz.
</p>

<p>
	If you use SliTaz for business purposes, in University or if you just
	want to sponsor and get a logo-link-description on our main website,
	please contact us. You can start sponsoring SliTaz from $40 a month.
	A sponsorship contract is signed for one year, the visibility of your
	logo depends on the amount of donation received each month.
</p>

<p>
	More information about sponsoring SliTaz and a list of our current
	sponsors can be found on the SliTaz website:
	<a href="http://www.slitaz.org/en/sponsor/">Sponsor page</a>
</p>

<h2>Contact</h2>

<p>
	Want to get in touch or get more detailed information? Don't
	hesitate to contact us by mail or post.
</p>

<p class="box">
	Mail: &lt;contact at slitaz.pro&gt;
</p>

<p class="box">
	Association SliTaz<br />
	Rue du Village 40<br />
	1081 Montpreveyres<br />
	Switzerland<br />
</p>

<!-- End of content -->
</div>

<?php include("../lib/html/footer.html"); ?>

</body>
</html>
