#!/bin/bash

version=$1
if test -z "$version"; then

   echo
   echo "Usage: $0 <version number>"
   echo
   echo "Versions should look like: 2.0.1-1.4.0"
   echo "or 2.0.1-1.4.0-beta2"
   echo
   exit 1

fi

echo 
echo "making release of shared_calendars, version $version..."
echo 
rm -f "shared_calendars-$version.tar.gz"
mv data/config.php ..

cd ..
tar czvf "shared_calendars-$version.tar.gz" calendar

mv "shared_calendars-$version.tar.gz" calendar
mv config.php calendar/data

cd calendar

echo done
echo
