<?php

/**
  * SquirrelMail Shared Calendar Plugin
  * Copyright (C) 2004-2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * This program is licensed under GPL. See COPYING for details
  *
  */


define('SM_PATH','../../');



if (file_exists(SM_PATH . 'include/validate.php')) 
   include_once(SM_PATH . 'include/validate.php');
else
   include_once(SM_PATH . 'src/validate.php');
include_once(SM_PATH . 'functions/date.php');
include_once(SM_PATH . 'plugins/calendar/functions.php');
include_once(SM_PATH . 'plugins/calendar/interface/calendar.php');
include_once(SM_PATH . 'plugins/calendar/interface/event.php');



// get calendar...
//
sqgetGlobalVar('calID', $calID, SQ_FORM);
$calID = urldecode($calID);
$calendar = get_calendar($calID);



// check that user has access rights 
// 
global $username;
if (!$calendar->canRead($username) && !$calendar->canWrite($username) && !$calendar->isOwner($username))
   exit;



sqgetGlobalVar('year', $year, SQ_FORM);
sqgetGlobalVar('month', $month, SQ_FORM);
sqgetGlobalVar('day', $day, SQ_FORM);
if (!sqgetGlobalVar('hour', $hour, SQ_FORM)) $hour = -1;
if (!sqgetGlobalVar('minute', $minute, SQ_FORM)) $minute = -1;
list($todaysYear, $todaysMonth, $todaysDay) = explode('-', date('Y-n-j'));



// make sure we have default year 
//
if (empty($year))
   $year = $todaysYear;


// make sure we have default month 
//
if (empty($month) && $year == $todaysYear)
   $month = $todaysMonth;
else if (empty($month))
   $month = 1;


// make sure we have default day 
//
if (empty($day) && $year == $todaysYear && $month == $todaysMonth)
   $day = $todaysDay;
else if (empty($day))
   $day = 1;



sqgetGlobalVar('calAction', $calAction, SQ_FORM);
sqgetGlobalVar('eventID', $eventID, SQ_FORM);



// -------------------- DELETE EVENT --------------------
// do this before printing page headers and whatnot,
// since it will redirect to another type of page view
//
if ($calAction == SM_CAL_EVENT_ACTION_REMOVE)
{

   if (!$calendar->isOwner($username) && !$calendar->canWrite($username))
   {
      echo "NO PERMISSION TO DELETE EVENT!";
      exit;
   }


   delete_event($calID, $eventID);
   header("Location: day.php?calID=$calID&year=$year&month=$month&day=$day");
   return;

}



// print standard SM page header
// and generic calendar header
//
global $color;
if (!isset($color[12])) $color[12] = '';
displayPageHeader($color, 'None');
showCalendarHeader($calendar, SM_CAL_VIEW_MODE_MONTH, $year, $month, $day);



// gather event data if needed
// 
if ($calAction == SM_CAL_EVENT_ACTION_CREATE || $calAction == SM_CAL_EVENT_ACTION_UPDATE)
{

   sqgetGlobalVar('eventName', $eventName, SQ_FORM);
   sqgetGlobalVar('eventContent', $eventContent, SQ_FORM);
//TODO: interface for this?
   $otherNotes = '';

   sqgetGlobalVar('eventType', $eventType, SQ_FORM);

   sqgetGlobalVar('isAllDay', $isAllDay, SQ_FORM);

   sqgetGlobalVar('startYear', $startYear, SQ_FORM);
   sqgetGlobalVar('startMonth', $startMonth, SQ_FORM);
   sqgetGlobalVar('startDay', $startDay, SQ_FORM);
   sqgetGlobalVar('startHour', $startHour, SQ_FORM);
   sqgetGlobalVar('startMinute', $startMinute, SQ_FORM);

   sqgetGlobalVar('endYear', $endYear, SQ_FORM);
   sqgetGlobalVar('endMonth', $endMonth, SQ_FORM);
   sqgetGlobalVar('endDay', $endDay, SQ_FORM);
   sqgetGlobalVar('endHour', $endHour, SQ_FORM);
   sqgetGlobalVar('endMinute', $endMinute, SQ_FORM);


   // pull days back to last day of month if they
   // are past that
   //
   $lastDayOfMonth = date('t', mktime(12, 0, 0, $startMonth, 15, $startYear));
   if ($startDay > $lastDayOfMonth) $startDay = $lastDayOfMonth;
   $lastDayOfMonth = date('t', mktime(12, 0, 0, $endMonth, 15, $endYear));
   if ($endDay > $lastDayOfMonth) $endDay = $lastDayOfMonth;


   // construct timestamps
   //
   $startTimestamp = mktime($startHour, $startMinute, 0, 
                            $startMonth, $startDay, $startYear);
   $endTimestamp = mktime($endHour, $endMinute, 0, 
                          $endMonth, $endDay, $endYear);


   if (isset($isAllDay) && $isAllDay == 'YES')
   {

      // if we don't zero out the time, the GMT conversion
      // below can push us to another day, which is completely
      // unexpected
      //
      $startTimestamp = mktime(0, 0, 0, $startMonth, $startDay, $startYear);
      $endTimestamp = mktime(0, 0, 0, $endMonth, $endDay + 1, $endYear);

      $startTimestamp = date('Ymd', $startTimestamp);
      $endTimestamp = date('Ymd', $endTimestamp);
   }
   else
   {
      $startTimestamp = gmdate('Ymd\THis\Z', $startTimestamp);
      $endTimestamp = gmdate('Ymd\THis\Z', $endTimestamp);
   }


   sqgetGlobalVar('endType', $endType, SQ_FORM);
   sqgetGlobalVar('eventLength', $eventLength, SQ_FORM);
   if ($endType == 'length') 
   {
      $endTimestamp = mktime($startHour, $startMinute, 0, 
                             $startMonth, $startDay, $startYear)
                    + ($eventLength * 60);
      if (isset($isAllDay) && $isAllDay == 'YES')
      {
         $endTimestamp = mktime(0, 0, 0, $startMonth, $startDay + 1, $startYear)
                       + ($eventLength * 60) - 1;
         $endTimestamp = date('Ymd', $endTimestamp);
      }
      else
         $endTimestamp = gmdate('Ymd\THis\Z', $endTimestamp);
   }

   sqgetGlobalVar('eventPriority', $eventPriority, SQ_FORM);

//TODO: reminders/alarms
   sqgetGlobalVar('enableReminder', $enableReminder, SQ_FORM);
   if ($enableReminder == 1)
      sqgetGlobalVar('reminderTime', $reminderTime, SQ_FORM);
   else
      $reminderTime = -1;


   // build RRULE
   //
   $recurrenceRule = '';
   $recurrenceDates = '';
   $recurrenceDays = array();
   $recurrenceExclusionRule = '';
   $recurrenceExclusionDates = '';
   sqgetGlobalVar('isRecurring', $isRecurring, SQ_FORM);
   if ($isRecurring == 'yes')
   {

      sqgetGlobalVar('recurrenceType', $recurrenceFreq, SQ_FORM);
      $recurrenceRule = 'FREQ=' . $recurrenceFreq;
      sqgetGlobalVar('recurrenceInterval', $recurrenceInterval, SQ_FORM);
      $recurrenceRule .= ';INTERVAL=' . $recurrenceInterval;

      sqgetGlobalVar('recurrenceDays', $recurrenceDays, SQ_FORM);
      $recurrenceDays = implode(',', $recurrenceDays);
      if (strlen($recurrenceDays))
         $recurrenceRule .= ';BYDAY=' . $recurrenceDays;


      // until we have more controls for monthly recurrence, 
      // we'll assume a BYMONTHDAY from the start date because
      // Microshit LookOut completely chokes on monthly events
      // that don't have BYMONTHDAY 
      // 
      // but we won't add this if user specified BYDAY checkbox(es)
      //
      else if ($recurrenceFreq == SM_CAL_ICAL_EVENT_RECURRENCE_FREQ_MONTHLY)
         $recurrenceRule .= ';BYMONTHDAY=' . $startDay;

      sqgetGlobalVar('endRecurrenceYear', $endRecurrenceYear, SQ_FORM);
      sqgetGlobalVar('endRecurrenceMonth', $endRecurrenceMonth, SQ_FORM);
      sqgetGlobalVar('endRecurrenceDay', $endRecurrenceDay, SQ_FORM);
      $recurrenceEndTimestamp = mktime($startHour, $startMinute, 0, 
                                $endRecurrenceMonth, 
                                $endRecurrenceDay, $endRecurrenceYear);
      $recurrenceEndTimestamp = gmdate('Ymd\THis\Z', $recurrenceEndTimestamp);
   
      sqgetGlobalVar('recurrenceCount', $recurrenceCount, SQ_FORM);

      sqgetGlobalVar('recurrenceEndType', $recurrenceEndType, SQ_FORM);
      if ($recurrenceEndType == 'count')
         $recurrenceRule .= ';COUNT=' . $recurrenceCount;
      else
         $recurrenceRule .= ';UNTIL=' . $recurrenceEndTimestamp;

   }

}



//
// take care of any event actions as needed
//
sqgetGlobalVar('deleteevent', $deleteEvent, SQ_FORM);



// -------------------- CREATE EVENT --------------------
//
if ($calAction == SM_CAL_EVENT_ACTION_CREATE)
{

   if (!$calendar->isOwner($username) && !$calendar->canWrite($username))
   {
      echo "NO PERMISSION TO CREATE EVENT!";
      exit;
   }


   $event = new Event('', 0, $domain, $eventType, $eventName, $eventContent, 
                      $otherNotes, '', $eventPriority, $startTimestamp, 
                      $endTimestamp, '', '', $recurrenceRule, $recurrenceDates,
                      $recurrenceExclusionRule, $recurrenceExclusionDates,
                      0, array($calID), $username, '', '', '', '', 
                      array($username));


   if (($errorMessage = $event->validateFields()) == '')
      $newEventID = create_event($calID, $event);

   if (!empty($errorMessage))
      display_event_edit_interface($color, $year, $month, $day, $hour, $minute, $calID, 
                                   $event, SM_CAL_EVENT_ACTION_CREATE,
                                   $errorMessage);
   else 
   {
      bindtextdomain ('calendar', SM_PATH . 'locale');
      textdomain ('calendar');

      $msg = _("Event Created Successfully");

      bindtextdomain ('squirrelmail', SM_PATH . 'locale');
      textdomain ('squirrelmail');

      display_event_edit_interface($color, $year, $month, $day, $hour, $minute, $calID, 
                                   get_event($calID, $newEventID), SM_CAL_EVENT_ACTION_UPDATE,
                                   $msg);
   }

}



// -------------------- UPDATE EVENT --------------------
//
else if ($calAction == SM_CAL_EVENT_ACTION_UPDATE && empty($deleteEvent))
{

   if (!$calendar->isOwner($username) && !$calendar->canWrite($username))
   {
      echo "NO PERMISSION TO UPDATE EVENT!";
      exit;
   }


   $oldEvent = get_event($calID, $eventID);
   $event = new Event($eventID, 0, $domain, $eventType, $eventName, $eventContent,
                      $otherNotes, '', $eventPriority, $startTimestamp, 
                      $endTimestamp, '', '', $recurrenceRule, $recurrenceDates,
                      $recurrenceExclusionRule, $recurrenceExclusionDates, 0,
                      array_unique(array_merge(array($calID), $oldEvent->getParentCalendars())), 
                      $oldEvent->createdBy(), 
                      gmdate('Ymd\THis\Z', $oldEvent->createdOn()), 
                      $username, gmdate('Ymd\THis\Z'), 
                      $oldEvent->getOwners(), $oldEvent->getReadableUsers(), 
                      $oldEvent->getWriteableUsers(), $oldEvent->getUnknownAttributes());



   if (($errorMessage = $event->validateFields()) == '')
   {
      $event->incrementSequence();
      update_event($calID, $event);
   }

   if (!empty($errorMessage))
   {
      $oldEvent = get_event($calID, $eventID);
      $event = new Event($eventID, $oldEvent->getSequence(), $domain, $eventType, 
                         $eventName, $eventContent, $otherNotes, '', $eventPriority, 
                         $startTimestamp, $endTimestamp, '', '', 
                         $recurrenceRule, $recurrenceDates,
                         $recurrenceExclusionRule, $recurrenceExclusionDates, 0,
                         array_unique(array_merge(array($calID), 
                         $oldEvent->getParentCalendars())), 
                         $oldEvent->createdBy(), 
                         gmdate('Ymd\THis\Z', $oldEvent->createdOn()), 
                         $oldEvent->lastUpdatedBy(), 
                         gmdate('Ymd\THis\Z', $oldEvent->lastUpdatedOn()), 
                         $oldEvent->getOwners(), $oldEvent->getReadableUsers(), 
                         $oldEvent->getWriteableUsers(), $oldEvent->getUnknownAttributes());

      display_event_edit_interface($color, $year, $month, $day, $hour, $minute, $calID, 
                                   $event, SM_CAL_EVENT_ACTION_UPDATE,
                                   $errorMessage);
   }
   else 
   {
      bindtextdomain ('calendar', SM_PATH . 'locale');
      textdomain ('calendar');

      $msg = _("Event Updated Successfully");

      bindtextdomain ('squirrelmail', SM_PATH . 'locale');
      textdomain ('squirrelmail');

      display_event_edit_interface($color, $year, $month, $day, $hour, $minute, $calID, 
                                   get_event($calID, $eventID), SM_CAL_EVENT_ACTION_UPDATE,
                                   $msg);
   }

}



//
// show requested event interface
//



else if ($calAction == SM_CAL_EVENT_ACTION_ADD 
      && ($calendar->isOwner($username) || $calendar->canWrite($username)))
{

   if ($calendar->isOwner($username) || $calendar->canWrite($username))
      display_event_edit_interface($color, $year, $month, $day, $hour, $minute, $calID, '', 
                                   SM_CAL_EVENT_ACTION_CREATE);

   else
      exit;

}



else if ($calAction == SM_CAL_EVENT_ACTION_EDIT)
{

   if ($calendar->isOwner($username) || $calendar->canWrite($username))
      display_event_edit_interface($color, $year, $month, $day, $hour, $minute, $calID, 
                                   get_event($calID, $eventID), SM_CAL_EVENT_ACTION_UPDATE);

   else
      display_event_display_interface($color, $year, $month, $day, $calID, 
                                      get_event($calID, $eventID)); 

}



// when user clicked the delete button on the event edit screen,
// we skipped the above code and want to use same code here for
// delete confirmation screen...
//
// (&& !empty($deleteEvent))
//
else if ($calAction == SM_CAL_EVENT_ACTION_DELETE_CONFIRM
      || $calAction == SM_CAL_EVENT_ACTION_UPDATE)
{

   if ($calendar->isOwner($username) || $calendar->canWrite($username))
      display_event_display_interface($color, $year, $month, $day, $calID, 
                                      get_event($calID, $eventID), 
                                      SM_CAL_EVENT_ACTION_REMOVE);

   else
      exit;

}



echo '</body></html>';

?>
