/* parser auto-generated by pidl */

#include "includes.h"
#include "librpc/gen_ndr/ndr_nbt.h"

#include "librpc/gen_ndr/ndr_misc.h"
#include "librpc/gen_ndr/ndr_security.h"
#include "librpc/gen_ndr/ndr_svcctl.h"
#include "librpc/gen_ndr/ndr_samr.h"
static enum ndr_err_code ndr_push_nbt_operation(struct ndr_push *ndr, int ndr_flags, uint16_t r)
{
	NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_operation(struct ndr_pull *ndr, int ndr_flags, uint16_t *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_operation(struct ndr_print *ndr, const char *name, uint16_t r)
{
	ndr_print_uint16(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "NBT_RCODE", NBT_RCODE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "NBT_FLAG_BROADCAST", NBT_FLAG_BROADCAST, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "NBT_FLAG_RECURSION_AVAIL", NBT_FLAG_RECURSION_AVAIL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "NBT_FLAG_RECURSION_DESIRED", NBT_FLAG_RECURSION_DESIRED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "NBT_FLAG_TRUNCATION", NBT_FLAG_TRUNCATION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "NBT_FLAG_AUTHORITIVE", NBT_FLAG_AUTHORITIVE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "NBT_OPCODE", NBT_OPCODE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "NBT_FLAG_REPLY", NBT_FLAG_REPLY, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbt_name_type(struct ndr_push *ndr, int ndr_flags, enum nbt_name_type r)
{
	NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_name_type(struct ndr_pull *ndr, int ndr_flags, enum nbt_name_type *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_name_type(struct ndr_print *ndr, const char *name, enum nbt_name_type r)
{
	const char *val = NULL;

	switch (r) {
		case NBT_NAME_CLIENT: val = "NBT_NAME_CLIENT"; break;
		case NBT_NAME_MS: val = "NBT_NAME_MS"; break;
		case NBT_NAME_USER: val = "NBT_NAME_USER"; break;
		case NBT_NAME_SERVER: val = "NBT_NAME_SERVER"; break;
		case NBT_NAME_PDC: val = "NBT_NAME_PDC"; break;
		case NBT_NAME_LOGON: val = "NBT_NAME_LOGON"; break;
		case NBT_NAME_MASTER: val = "NBT_NAME_MASTER"; break;
		case NBT_NAME_BROWSER: val = "NBT_NAME_BROWSER"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ void ndr_print_nbt_name(struct ndr_print *ndr, const char *name, const struct nbt_name *r)
{
	ndr_print_struct(ndr, name, "nbt_name");
	ndr->depth++;
	ndr_print_string(ndr, "name", r->name);
	ndr_print_string(ndr, "scope", r->scope);
	ndr_print_nbt_name_type(ndr, "type", r->type);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbt_qclass(struct ndr_push *ndr, int ndr_flags, enum nbt_qclass r)
{
	NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_qclass(struct ndr_pull *ndr, int ndr_flags, enum nbt_qclass *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_qclass(struct ndr_print *ndr, const char *name, enum nbt_qclass r)
{
	const char *val = NULL;

	switch (r) {
		case NBT_QCLASS_IP: val = "NBT_QCLASS_IP"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_nbt_qtype(struct ndr_push *ndr, int ndr_flags, enum nbt_qtype r)
{
	NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_qtype(struct ndr_pull *ndr, int ndr_flags, enum nbt_qtype *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_qtype(struct ndr_print *ndr, const char *name, enum nbt_qtype r)
{
	const char *val = NULL;

	switch (r) {
		case NBT_QTYPE_ADDRESS: val = "NBT_QTYPE_ADDRESS"; break;
		case NBT_QTYPE_NAMESERVICE: val = "NBT_QTYPE_NAMESERVICE"; break;
		case NBT_QTYPE_NULL: val = "NBT_QTYPE_NULL"; break;
		case NBT_QTYPE_NETBIOS: val = "NBT_QTYPE_NETBIOS"; break;
		case NBT_QTYPE_STATUS: val = "NBT_QTYPE_STATUS"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_nbt_name_question(struct ndr_push *ndr, int ndr_flags, const struct nbt_name_question *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_nbt_name(ndr, NDR_SCALARS, &r->name));
		NDR_CHECK(ndr_push_nbt_qtype(ndr, NDR_SCALARS, r->question_type));
		NDR_CHECK(ndr_push_nbt_qclass(ndr, NDR_SCALARS, r->question_class));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_name_question(struct ndr_pull *ndr, int ndr_flags, struct nbt_name_question *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_nbt_name(ndr, NDR_SCALARS, &r->name));
		NDR_CHECK(ndr_pull_nbt_qtype(ndr, NDR_SCALARS, &r->question_type));
		NDR_CHECK(ndr_pull_nbt_qclass(ndr, NDR_SCALARS, &r->question_class));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_name_question(struct ndr_print *ndr, const char *name, const struct nbt_name_question *r)
{
	ndr_print_struct(ndr, name, "nbt_name_question");
	ndr->depth++;
	ndr_print_nbt_name(ndr, "name", &r->name);
	ndr_print_nbt_qtype(ndr, "question_type", r->question_type);
	ndr_print_nbt_qclass(ndr, "question_class", r->question_class);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nb_flags(struct ndr_push *ndr, int ndr_flags, uint16_t r)
{
	NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nb_flags(struct ndr_pull *ndr, int ndr_flags, uint16_t *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nb_flags(struct ndr_print *ndr, const char *name, uint16_t r)
{
	ndr_print_uint16(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "NBT_NM_PERMANENT", NBT_NM_PERMANENT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "NBT_NM_ACTIVE", NBT_NM_ACTIVE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "NBT_NM_CONFLICT", NBT_NM_CONFLICT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "NBT_NM_DEREGISTER", NBT_NM_DEREGISTER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "NBT_NM_OWNER_TYPE", NBT_NM_OWNER_TYPE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "NBT_NM_GROUP", NBT_NM_GROUP, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbt_rdata_address(struct ndr_push *ndr, int ndr_flags, const struct nbt_rdata_address *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_nb_flags(ndr, NDR_SCALARS, r->nb_flags));
		NDR_CHECK(ndr_push_ipv4address(ndr, NDR_SCALARS, r->ipaddr));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_rdata_address(struct ndr_pull *ndr, int ndr_flags, struct nbt_rdata_address *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_nb_flags(ndr, NDR_SCALARS, &r->nb_flags));
		NDR_CHECK(ndr_pull_ipv4address(ndr, NDR_SCALARS, &r->ipaddr));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_rdata_address(struct ndr_print *ndr, const char *name, const struct nbt_rdata_address *r)
{
	ndr_print_struct(ndr, name, "nbt_rdata_address");
	ndr->depth++;
	ndr_print_nb_flags(ndr, "nb_flags", r->nb_flags);
	ndr_print_ipv4address(ndr, "ipaddr", r->ipaddr);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbt_rdata_netbios(struct ndr_push *ndr, int ndr_flags, const struct nbt_rdata_netbios *r)
{
	uint32_t cntr_addresses_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->length));
		for (cntr_addresses_0 = 0; cntr_addresses_0 < r->length / 6; cntr_addresses_0++) {
			NDR_CHECK(ndr_push_nbt_rdata_address(ndr, NDR_SCALARS, &r->addresses[cntr_addresses_0]));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_rdata_netbios(struct ndr_pull *ndr, int ndr_flags, struct nbt_rdata_netbios *r)
{
	uint32_t cntr_addresses_0;
	TALLOC_CTX *_mem_save_addresses_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->length));
		NDR_PULL_ALLOC_N(ndr, r->addresses, r->length / 6);
		_mem_save_addresses_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->addresses, 0);
		for (cntr_addresses_0 = 0; cntr_addresses_0 < r->length / 6; cntr_addresses_0++) {
			NDR_CHECK(ndr_pull_nbt_rdata_address(ndr, NDR_SCALARS, &r->addresses[cntr_addresses_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_addresses_0, 0);
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_rdata_netbios(struct ndr_print *ndr, const char *name, const struct nbt_rdata_netbios *r)
{
	uint32_t cntr_addresses_0;
	ndr_print_struct(ndr, name, "nbt_rdata_netbios");
	ndr->depth++;
	ndr_print_uint16(ndr, "length", r->length);
	ndr->print(ndr, "%s: ARRAY(%d)", "addresses", r->length / 6);
	ndr->depth++;
	for (cntr_addresses_0=0;cntr_addresses_0<r->length / 6;cntr_addresses_0++) {
		char *idx_0=NULL;
		if (asprintf(&idx_0, "[%d]", cntr_addresses_0) != -1) {
			ndr_print_nbt_rdata_address(ndr, "addresses", &r->addresses[cntr_addresses_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbt_statistics(struct ndr_push *ndr, int ndr_flags, const struct nbt_statistics *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->unit_id, 6));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->jumpers));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->test_result));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->version_number));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->period_of_statistics));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->number_of_crcs));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->number_alignment_errors));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->number_of_collisions));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->number_send_aborts));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->number_good_sends));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->number_good_receives));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->number_retransmits));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->number_no_resource_conditions));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->number_free_command_blocks));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->total_number_command_blocks));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->max_total_number_command_blocks));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->number_pending_sessions));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->max_number_pending_sessions));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->max_total_sessions_possible));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->session_data_packet_size));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_statistics(struct ndr_pull *ndr, int ndr_flags, struct nbt_statistics *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->unit_id, 6));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->jumpers));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->test_result));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->version_number));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->period_of_statistics));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->number_of_crcs));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->number_alignment_errors));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->number_of_collisions));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->number_send_aborts));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->number_good_sends));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->number_good_receives));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->number_retransmits));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->number_no_resource_conditions));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->number_free_command_blocks));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->total_number_command_blocks));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->max_total_number_command_blocks));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->number_pending_sessions));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->max_number_pending_sessions));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->max_total_sessions_possible));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->session_data_packet_size));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_statistics(struct ndr_print *ndr, const char *name, const struct nbt_statistics *r)
{
	ndr_print_struct(ndr, name, "nbt_statistics");
	ndr->depth++;
	ndr_print_array_uint8(ndr, "unit_id", r->unit_id, 6);
	ndr_print_uint8(ndr, "jumpers", r->jumpers);
	ndr_print_uint8(ndr, "test_result", r->test_result);
	ndr_print_uint16(ndr, "version_number", r->version_number);
	ndr_print_uint16(ndr, "period_of_statistics", r->period_of_statistics);
	ndr_print_uint16(ndr, "number_of_crcs", r->number_of_crcs);
	ndr_print_uint16(ndr, "number_alignment_errors", r->number_alignment_errors);
	ndr_print_uint16(ndr, "number_of_collisions", r->number_of_collisions);
	ndr_print_uint16(ndr, "number_send_aborts", r->number_send_aborts);
	ndr_print_uint32(ndr, "number_good_sends", r->number_good_sends);
	ndr_print_uint32(ndr, "number_good_receives", r->number_good_receives);
	ndr_print_uint16(ndr, "number_retransmits", r->number_retransmits);
	ndr_print_uint16(ndr, "number_no_resource_conditions", r->number_no_resource_conditions);
	ndr_print_uint16(ndr, "number_free_command_blocks", r->number_free_command_blocks);
	ndr_print_uint16(ndr, "total_number_command_blocks", r->total_number_command_blocks);
	ndr_print_uint16(ndr, "max_total_number_command_blocks", r->max_total_number_command_blocks);
	ndr_print_uint16(ndr, "number_pending_sessions", r->number_pending_sessions);
	ndr_print_uint16(ndr, "max_number_pending_sessions", r->max_number_pending_sessions);
	ndr_print_uint16(ndr, "max_total_sessions_possible", r->max_total_sessions_possible);
	ndr_print_uint16(ndr, "session_data_packet_size", r->session_data_packet_size);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbt_status_name(struct ndr_push *ndr, int ndr_flags, const struct nbt_status_name *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->name, 15, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_push_nbt_name_type(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_nb_flags(ndr, NDR_SCALARS, r->nb_flags));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_status_name(struct ndr_pull *ndr, int ndr_flags, struct nbt_status_name *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->name, 15, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_pull_nbt_name_type(ndr, NDR_SCALARS, &r->type));
		NDR_CHECK(ndr_pull_nb_flags(ndr, NDR_SCALARS, &r->nb_flags));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_status_name(struct ndr_print *ndr, const char *name, const struct nbt_status_name *r)
{
	ndr_print_struct(ndr, name, "nbt_status_name");
	ndr->depth++;
	ndr_print_string(ndr, "name", r->name);
	ndr_print_nbt_name_type(ndr, "type", r->type);
	ndr_print_nb_flags(ndr, "nb_flags", r->nb_flags);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbt_rdata_status(struct ndr_push *ndr, int ndr_flags, const struct nbt_rdata_status *r)
{
	uint32_t cntr_names_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->num_names * 18 + 47));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->num_names));
		for (cntr_names_0 = 0; cntr_names_0 < r->num_names; cntr_names_0++) {
			NDR_CHECK(ndr_push_nbt_status_name(ndr, NDR_SCALARS, &r->names[cntr_names_0]));
		}
		NDR_CHECK(ndr_push_nbt_statistics(ndr, NDR_SCALARS, &r->statistics));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_rdata_status(struct ndr_pull *ndr, int ndr_flags, struct nbt_rdata_status *r)
{
	uint32_t cntr_names_0;
	TALLOC_CTX *_mem_save_names_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->length));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->num_names));
		NDR_PULL_ALLOC_N(ndr, r->names, r->num_names);
		_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->names, 0);
		for (cntr_names_0 = 0; cntr_names_0 < r->num_names; cntr_names_0++) {
			NDR_CHECK(ndr_pull_nbt_status_name(ndr, NDR_SCALARS, &r->names[cntr_names_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, 0);
		NDR_CHECK(ndr_pull_nbt_statistics(ndr, NDR_SCALARS, &r->statistics));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_rdata_status(struct ndr_print *ndr, const char *name, const struct nbt_rdata_status *r)
{
	uint32_t cntr_names_0;
	ndr_print_struct(ndr, name, "nbt_rdata_status");
	ndr->depth++;
	ndr_print_uint16(ndr, "length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?r->num_names * 18 + 47:r->length);
	ndr_print_uint8(ndr, "num_names", r->num_names);
	ndr->print(ndr, "%s: ARRAY(%d)", "names", r->num_names);
	ndr->depth++;
	for (cntr_names_0=0;cntr_names_0<r->num_names;cntr_names_0++) {
		char *idx_0=NULL;
		if (asprintf(&idx_0, "[%d]", cntr_names_0) != -1) {
			ndr_print_nbt_status_name(ndr, "names", &r->names[cntr_names_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr_print_nbt_statistics(ndr, "statistics", &r->statistics);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbt_rdata_data(struct ndr_push *ndr, int ndr_flags, const struct nbt_rdata_data *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->length));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->data, r->length));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_rdata_data(struct ndr_pull *ndr, int ndr_flags, struct nbt_rdata_data *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->length));
		NDR_PULL_ALLOC_N(ndr, r->data, r->length);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->data, r->length));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_rdata_data(struct ndr_print *ndr, const char *name, const struct nbt_rdata_data *r)
{
	ndr_print_struct(ndr, name, "nbt_rdata_data");
	ndr->depth++;
	ndr_print_uint16(ndr, "length", r->length);
	ndr_print_array_uint8(ndr, "data", r->data, r->length);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbt_rdata(struct ndr_push *ndr, int ndr_flags, const union nbt_rdata *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case NBT_QTYPE_NETBIOS: {
				NDR_CHECK(ndr_push_nbt_rdata_netbios(ndr, NDR_SCALARS, &r->netbios));
			break; }

			case NBT_QTYPE_STATUS: {
				NDR_CHECK(ndr_push_nbt_rdata_status(ndr, NDR_SCALARS, &r->status));
			break; }

			default: {
				NDR_CHECK(ndr_push_nbt_rdata_data(ndr, NDR_SCALARS, &r->data));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case NBT_QTYPE_NETBIOS:
			break;

			case NBT_QTYPE_STATUS:
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_rdata(struct ndr_pull *ndr, int ndr_flags, union nbt_rdata *r)
{
	int level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		switch (level) {
			case NBT_QTYPE_NETBIOS: {
				NDR_CHECK(ndr_pull_nbt_rdata_netbios(ndr, NDR_SCALARS, &r->netbios));
			break; }

			case NBT_QTYPE_STATUS: {
				NDR_CHECK(ndr_pull_nbt_rdata_status(ndr, NDR_SCALARS, &r->status));
			break; }

			default: {
				NDR_CHECK(ndr_pull_nbt_rdata_data(ndr, NDR_SCALARS, &r->data));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case NBT_QTYPE_NETBIOS:
			break;

			case NBT_QTYPE_STATUS:
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_rdata(struct ndr_print *ndr, const char *name, const union nbt_rdata *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "nbt_rdata");
	switch (level) {
		case NBT_QTYPE_NETBIOS:
			ndr_print_nbt_rdata_netbios(ndr, "netbios", &r->netbios);
		break;

		case NBT_QTYPE_STATUS:
			ndr_print_nbt_rdata_status(ndr, "status", &r->status);
		break;

		default:
			ndr_print_nbt_rdata_data(ndr, "data", &r->data);
		break;

	}
}

static enum ndr_err_code ndr_push_nbt_res_rec(struct ndr_push *ndr, int ndr_flags, const struct nbt_res_rec *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_nbt_name(ndr, NDR_SCALARS, &r->name));
			NDR_CHECK(ndr_push_nbt_qtype(ndr, NDR_SCALARS, r->rr_type));
			NDR_CHECK(ndr_push_nbt_qclass(ndr, NDR_SCALARS, r->rr_class));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->ttl));
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->rdata, ((((r->rr_type) == NBT_QTYPE_NETBIOS) && talloc_check_name(ndr, "struct ndr_push") && ((r->rdata).data.length == 2))?0:r->rr_type)));
			NDR_CHECK(ndr_push_nbt_rdata(ndr, NDR_SCALARS, &r->rdata));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_res_rec(struct ndr_pull *ndr, int ndr_flags, struct nbt_res_rec *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_nbt_name(ndr, NDR_SCALARS, &r->name));
			NDR_CHECK(ndr_pull_nbt_qtype(ndr, NDR_SCALARS, &r->rr_type));
			NDR_CHECK(ndr_pull_nbt_qclass(ndr, NDR_SCALARS, &r->rr_class));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->ttl));
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->rdata, ((((r->rr_type) == NBT_QTYPE_NETBIOS) && talloc_check_name(ndr, "struct ndr_push") && ((r->rdata).data.length == 2))?0:r->rr_type)));
			NDR_CHECK(ndr_pull_nbt_rdata(ndr, NDR_SCALARS, &r->rdata));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_res_rec(struct ndr_print *ndr, const char *name, const struct nbt_res_rec *r)
{
	ndr_print_struct(ndr, name, "nbt_res_rec");
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_nbt_name(ndr, "name", &r->name);
		ndr_print_nbt_qtype(ndr, "rr_type", r->rr_type);
		ndr_print_nbt_qclass(ndr, "rr_class", r->rr_class);
		ndr_print_uint32(ndr, "ttl", r->ttl);
		ndr_print_set_switch_value(ndr, &r->rdata, ((((r->rr_type) == NBT_QTYPE_NETBIOS) && talloc_check_name(ndr, "struct ndr_push") && ((r->rdata).data.length == 2))?0:r->rr_type));
		ndr_print_nbt_rdata(ndr, "rdata", &r->rdata);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_nbt_name_packet(struct ndr_push *ndr, int ndr_flags, const struct nbt_name_packet *r)
{
	uint32_t cntr_questions_0;
	uint32_t cntr_answers_0;
	uint32_t cntr_nsrecs_0;
	uint32_t cntr_additional_0;
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_BIGENDIAN|LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->name_trn_id));
			NDR_CHECK(ndr_push_nbt_operation(ndr, NDR_SCALARS, r->operation));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->qdcount));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->ancount));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->nscount));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->arcount));
			for (cntr_questions_0 = 0; cntr_questions_0 < r->qdcount; cntr_questions_0++) {
				NDR_CHECK(ndr_push_nbt_name_question(ndr, NDR_SCALARS, &r->questions[cntr_questions_0]));
			}
			for (cntr_answers_0 = 0; cntr_answers_0 < r->ancount; cntr_answers_0++) {
				NDR_CHECK(ndr_push_nbt_res_rec(ndr, NDR_SCALARS, &r->answers[cntr_answers_0]));
			}
			for (cntr_nsrecs_0 = 0; cntr_nsrecs_0 < r->nscount; cntr_nsrecs_0++) {
				NDR_CHECK(ndr_push_nbt_res_rec(ndr, NDR_SCALARS, &r->nsrecs[cntr_nsrecs_0]));
			}
			for (cntr_additional_0 = 0; cntr_additional_0 < r->arcount; cntr_additional_0++) {
				NDR_CHECK(ndr_push_nbt_res_rec(ndr, NDR_SCALARS, &r->additional[cntr_additional_0]));
			}
			{
				uint32_t _flags_save_DATA_BLOB = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
				NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->padding));
				ndr->flags = _flags_save_DATA_BLOB;
			}
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_nbt_name_packet(struct ndr_pull *ndr, int ndr_flags, struct nbt_name_packet *r)
{
	uint32_t cntr_questions_0;
	TALLOC_CTX *_mem_save_questions_0;
	uint32_t cntr_answers_0;
	TALLOC_CTX *_mem_save_answers_0;
	uint32_t cntr_nsrecs_0;
	TALLOC_CTX *_mem_save_nsrecs_0;
	uint32_t cntr_additional_0;
	TALLOC_CTX *_mem_save_additional_0;
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_BIGENDIAN|LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->name_trn_id));
			NDR_CHECK(ndr_pull_nbt_operation(ndr, NDR_SCALARS, &r->operation));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->qdcount));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->ancount));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->nscount));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->arcount));
			NDR_PULL_ALLOC_N(ndr, r->questions, r->qdcount);
			_mem_save_questions_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->questions, 0);
			for (cntr_questions_0 = 0; cntr_questions_0 < r->qdcount; cntr_questions_0++) {
				NDR_CHECK(ndr_pull_nbt_name_question(ndr, NDR_SCALARS, &r->questions[cntr_questions_0]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_questions_0, 0);
			NDR_PULL_ALLOC_N(ndr, r->answers, r->ancount);
			_mem_save_answers_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->answers, 0);
			for (cntr_answers_0 = 0; cntr_answers_0 < r->ancount; cntr_answers_0++) {
				NDR_CHECK(ndr_pull_nbt_res_rec(ndr, NDR_SCALARS, &r->answers[cntr_answers_0]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_answers_0, 0);
			NDR_PULL_ALLOC_N(ndr, r->nsrecs, r->nscount);
			_mem_save_nsrecs_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->nsrecs, 0);
			for (cntr_nsrecs_0 = 0; cntr_nsrecs_0 < r->nscount; cntr_nsrecs_0++) {
				NDR_CHECK(ndr_pull_nbt_res_rec(ndr, NDR_SCALARS, &r->nsrecs[cntr_nsrecs_0]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_nsrecs_0, 0);
			NDR_PULL_ALLOC_N(ndr, r->additional, r->arcount);
			_mem_save_additional_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->additional, 0);
			for (cntr_additional_0 = 0; cntr_additional_0 < r->arcount; cntr_additional_0++) {
				NDR_CHECK(ndr_pull_nbt_res_rec(ndr, NDR_SCALARS, &r->additional[cntr_additional_0]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_additional_0, 0);
			{
				uint32_t _flags_save_DATA_BLOB = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
				NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->padding));
				ndr->flags = _flags_save_DATA_BLOB;
			}
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_name_packet(struct ndr_print *ndr, const char *name, const struct nbt_name_packet *r)
{
	uint32_t cntr_questions_0;
	uint32_t cntr_answers_0;
	uint32_t cntr_nsrecs_0;
	uint32_t cntr_additional_0;
	ndr_print_struct(ndr, name, "nbt_name_packet");
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_BIGENDIAN|LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_uint16(ndr, "name_trn_id", r->name_trn_id);
		ndr_print_nbt_operation(ndr, "operation", r->operation);
		ndr_print_uint16(ndr, "qdcount", r->qdcount);
		ndr_print_uint16(ndr, "ancount", r->ancount);
		ndr_print_uint16(ndr, "nscount", r->nscount);
		ndr_print_uint16(ndr, "arcount", r->arcount);
		ndr->print(ndr, "%s: ARRAY(%d)", "questions", r->qdcount);
		ndr->depth++;
		for (cntr_questions_0=0;cntr_questions_0<r->qdcount;cntr_questions_0++) {
			char *idx_0=NULL;
			if (asprintf(&idx_0, "[%d]", cntr_questions_0) != -1) {
				ndr_print_nbt_name_question(ndr, "questions", &r->questions[cntr_questions_0]);
				free(idx_0);
			}
		}
		ndr->depth--;
		ndr->print(ndr, "%s: ARRAY(%d)", "answers", r->ancount);
		ndr->depth++;
		for (cntr_answers_0=0;cntr_answers_0<r->ancount;cntr_answers_0++) {
			char *idx_0=NULL;
			if (asprintf(&idx_0, "[%d]", cntr_answers_0) != -1) {
				ndr_print_nbt_res_rec(ndr, "answers", &r->answers[cntr_answers_0]);
				free(idx_0);
			}
		}
		ndr->depth--;
		ndr->print(ndr, "%s: ARRAY(%d)", "nsrecs", r->nscount);
		ndr->depth++;
		for (cntr_nsrecs_0=0;cntr_nsrecs_0<r->nscount;cntr_nsrecs_0++) {
			char *idx_0=NULL;
			if (asprintf(&idx_0, "[%d]", cntr_nsrecs_0) != -1) {
				ndr_print_nbt_res_rec(ndr, "nsrecs", &r->nsrecs[cntr_nsrecs_0]);
				free(idx_0);
			}
		}
		ndr->depth--;
		ndr->print(ndr, "%s: ARRAY(%d)", "additional", r->arcount);
		ndr->depth++;
		for (cntr_additional_0=0;cntr_additional_0<r->arcount;cntr_additional_0++) {
			char *idx_0=NULL;
			if (asprintf(&idx_0, "[%d]", cntr_additional_0) != -1) {
				ndr_print_nbt_res_rec(ndr, "additional", &r->additional[cntr_additional_0]);
				free(idx_0);
			}
		}
		ndr->depth--;
		ndr_print_DATA_BLOB(ndr, "padding", r->padding);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static enum ndr_err_code ndr_push_dgram_msg_type(struct ndr_push *ndr, int ndr_flags, enum dgram_msg_type r)
{
	NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dgram_msg_type(struct ndr_pull *ndr, int ndr_flags, enum dgram_msg_type *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dgram_msg_type(struct ndr_print *ndr, const char *name, enum dgram_msg_type r)
{
	const char *val = NULL;

	switch (r) {
		case DGRAM_DIRECT_UNIQUE: val = "DGRAM_DIRECT_UNIQUE"; break;
		case DGRAM_DIRECT_GROUP: val = "DGRAM_DIRECT_GROUP"; break;
		case DGRAM_BCAST: val = "DGRAM_BCAST"; break;
		case DGRAM_ERROR: val = "DGRAM_ERROR"; break;
		case DGRAM_QUERY: val = "DGRAM_QUERY"; break;
		case DGRAM_QUERY_POSITIVE: val = "DGRAM_QUERY_POSITIVE"; break;
		case DGRAM_QUERY_NEGATIVE: val = "DGRAM_QUERY_NEGATIVE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_dgram_flags(struct ndr_push *ndr, int ndr_flags, uint8_t r)
{
	NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dgram_flags(struct ndr_pull *ndr, int ndr_flags, uint8_t *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dgram_flags(struct ndr_print *ndr, const char *name, uint8_t r)
{
	ndr_print_uint8(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "DGRAM_FLAG_MORE", DGRAM_FLAG_MORE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "DGRAM_FLAG_FIRST", DGRAM_FLAG_FIRST, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "DGRAM_FLAG_NODE_TYPE", DGRAM_FLAG_NODE_TYPE, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smb_command(struct ndr_push *ndr, int ndr_flags, enum smb_command r)
{
	NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smb_command(struct ndr_pull *ndr, int ndr_flags, enum smb_command *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smb_command(struct ndr_print *ndr, const char *name, enum smb_command r)
{
	const char *val = NULL;

	switch (r) {
		case SMB_TRANSACTION: val = "SMB_TRANSACTION"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_smb_trans_body(struct ndr_push *ndr, int ndr_flags, const struct smb_trans_body *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, 17));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->total_param_count));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->total_data_count));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->max_param_count));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->max_data_count));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->max_setup_count));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->pad));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->trans_flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->timeout));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->reserved));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->param_count));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->param_offset));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->data_count));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->data_offset));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, 3));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->pad2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->opcode));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->priority));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->_class));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, strlen(r->mailslot_name) + 1 + r->data.length));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->mailslot_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->data));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smb_trans_body(struct ndr_pull *ndr, int ndr_flags, struct smb_trans_body *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->wct));
		if (r->wct < 17 || r->wct > 17) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->total_param_count));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->total_data_count));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->max_param_count));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->max_data_count));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->max_setup_count));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->pad));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->trans_flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->timeout));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->reserved));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->param_count));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->param_offset));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->data_count));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->data_offset));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->setup_count));
		if (r->setup_count < 3 || r->setup_count > 3) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->pad2));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->opcode));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->priority));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->_class));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->byte_count));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->mailslot_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->data));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smb_trans_body(struct ndr_print *ndr, const char *name, const struct smb_trans_body *r)
{
	ndr_print_struct(ndr, name, "smb_trans_body");
	ndr->depth++;
	ndr_print_uint8(ndr, "wct", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?17:r->wct);
	ndr_print_uint16(ndr, "total_param_count", r->total_param_count);
	ndr_print_uint16(ndr, "total_data_count", r->total_data_count);
	ndr_print_uint16(ndr, "max_param_count", r->max_param_count);
	ndr_print_uint16(ndr, "max_data_count", r->max_data_count);
	ndr_print_uint8(ndr, "max_setup_count", r->max_setup_count);
	ndr_print_uint8(ndr, "pad", r->pad);
	ndr_print_uint16(ndr, "trans_flags", r->trans_flags);
	ndr_print_uint32(ndr, "timeout", r->timeout);
	ndr_print_uint16(ndr, "reserved", r->reserved);
	ndr_print_uint16(ndr, "param_count", r->param_count);
	ndr_print_uint16(ndr, "param_offset", r->param_offset);
	ndr_print_uint16(ndr, "data_count", r->data_count);
	ndr_print_uint16(ndr, "data_offset", r->data_offset);
	ndr_print_uint8(ndr, "setup_count", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?3:r->setup_count);
	ndr_print_uint8(ndr, "pad2", r->pad2);
	ndr_print_uint16(ndr, "opcode", r->opcode);
	ndr_print_uint16(ndr, "priority", r->priority);
	ndr_print_uint16(ndr, "_class", r->_class);
	ndr_print_uint16(ndr, "byte_count", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?strlen(r->mailslot_name) + 1 + r->data.length:r->byte_count);
	ndr_print_string(ndr, "mailslot_name", r->mailslot_name);
	ndr_print_DATA_BLOB(ndr, "data", r->data);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smb_body(struct ndr_push *ndr, int ndr_flags, const union smb_body *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case SMB_TRANSACTION: {
				NDR_CHECK(ndr_push_smb_trans_body(ndr, NDR_SCALARS, &r->trans));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case SMB_TRANSACTION:
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smb_body(struct ndr_pull *ndr, int ndr_flags, union smb_body *r)
{
	int level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		switch (level) {
			case SMB_TRANSACTION: {
				NDR_CHECK(ndr_pull_smb_trans_body(ndr, NDR_SCALARS, &r->trans));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case SMB_TRANSACTION:
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smb_body(struct ndr_print *ndr, const char *name, const union smb_body *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "smb_body");
	switch (level) {
		case SMB_TRANSACTION:
			ndr_print_smb_trans_body(ndr, "trans", &r->trans);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_dgram_smb_packet(struct ndr_push *ndr, int ndr_flags, const struct dgram_smb_packet *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_LITTLE_ENDIAN|LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_smb_command(ndr, NDR_SCALARS, r->smb_command));
			NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->err_class));
			NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->pad));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->err_code));
			NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->flags));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->flags2));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->pid_high));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->signature, 8));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->reserved));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->tid));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->pid));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->vuid));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->mid));
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->body, r->smb_command));
			NDR_CHECK(ndr_push_smb_body(ndr, NDR_SCALARS, &r->body));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dgram_smb_packet(struct ndr_pull *ndr, int ndr_flags, struct dgram_smb_packet *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_LITTLE_ENDIAN|LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_smb_command(ndr, NDR_SCALARS, &r->smb_command));
			NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->err_class));
			NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->pad));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->err_code));
			NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->flags));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->flags2));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->pid_high));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->signature, 8));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->reserved));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->tid));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->pid));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->vuid));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->mid));
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->body, r->smb_command));
			NDR_CHECK(ndr_pull_smb_body(ndr, NDR_SCALARS, &r->body));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dgram_smb_packet(struct ndr_print *ndr, const char *name, const struct dgram_smb_packet *r)
{
	ndr_print_struct(ndr, name, "dgram_smb_packet");
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_LITTLE_ENDIAN|LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_smb_command(ndr, "smb_command", r->smb_command);
		ndr_print_uint8(ndr, "err_class", r->err_class);
		ndr_print_uint8(ndr, "pad", r->pad);
		ndr_print_uint16(ndr, "err_code", r->err_code);
		ndr_print_uint8(ndr, "flags", r->flags);
		ndr_print_uint16(ndr, "flags2", r->flags2);
		ndr_print_uint16(ndr, "pid_high", r->pid_high);
		ndr_print_array_uint8(ndr, "signature", r->signature, 8);
		ndr_print_uint16(ndr, "reserved", r->reserved);
		ndr_print_uint16(ndr, "tid", r->tid);
		ndr_print_uint16(ndr, "pid", r->pid);
		ndr_print_uint16(ndr, "vuid", r->vuid);
		ndr_print_uint16(ndr, "mid", r->mid);
		ndr_print_set_switch_value(ndr, &r->body, r->smb_command);
		ndr_print_smb_body(ndr, "body", &r->body);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static enum ndr_err_code ndr_push_dgram_message_body(struct ndr_push *ndr, int ndr_flags, const union dgram_message_body *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case DGRAM_SMB: {
				NDR_CHECK(ndr_push_dgram_smb_packet(ndr, NDR_SCALARS, &r->smb));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case DGRAM_SMB:
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dgram_message_body(struct ndr_pull *ndr, int ndr_flags, union dgram_message_body *r)
{
	int level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		switch (level) {
			case DGRAM_SMB: {
				NDR_CHECK(ndr_pull_dgram_smb_packet(ndr, NDR_SCALARS, &r->smb));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case DGRAM_SMB:
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dgram_message_body(struct ndr_print *ndr, const char *name, const union dgram_message_body *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "dgram_message_body");
	switch (level) {
		case DGRAM_SMB:
			ndr_print_dgram_smb_packet(ndr, "smb", &r->smb);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_dgram_message(struct ndr_push *ndr, int ndr_flags, const struct dgram_message *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->length));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->offset));
		NDR_CHECK(ndr_push_nbt_name(ndr, NDR_SCALARS, &r->source_name));
		NDR_CHECK(ndr_push_nbt_name(ndr, NDR_SCALARS, &r->dest_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dgram_body_type));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->body, r->dgram_body_type));
		NDR_CHECK(ndr_push_dgram_message_body(ndr, NDR_SCALARS, &r->body));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dgram_message(struct ndr_pull *ndr, int ndr_flags, struct dgram_message *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->length));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->offset));
		NDR_CHECK(ndr_pull_nbt_name(ndr, NDR_SCALARS, &r->source_name));
		NDR_CHECK(ndr_pull_nbt_name(ndr, NDR_SCALARS, &r->dest_name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dgram_body_type));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->body, r->dgram_body_type));
		NDR_CHECK(ndr_pull_dgram_message_body(ndr, NDR_SCALARS, &r->body));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dgram_message(struct ndr_print *ndr, const char *name, const struct dgram_message *r)
{
	ndr_print_struct(ndr, name, "dgram_message");
	ndr->depth++;
	ndr_print_uint16(ndr, "length", r->length);
	ndr_print_uint16(ndr, "offset", r->offset);
	ndr_print_nbt_name(ndr, "source_name", &r->source_name);
	ndr_print_nbt_name(ndr, "dest_name", &r->dest_name);
	ndr_print_uint32(ndr, "dgram_body_type", r->dgram_body_type);
	ndr_print_set_switch_value(ndr, &r->body, r->dgram_body_type);
	ndr_print_dgram_message_body(ndr, "body", &r->body);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dgram_err_code(struct ndr_push *ndr, int ndr_flags, enum dgram_err_code r)
{
	NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dgram_err_code(struct ndr_pull *ndr, int ndr_flags, enum dgram_err_code *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dgram_err_code(struct ndr_print *ndr, const char *name, enum dgram_err_code r)
{
	const char *val = NULL;

	switch (r) {
		case DGRAM_ERROR_NAME_NOT_PRESENT: val = "DGRAM_ERROR_NAME_NOT_PRESENT"; break;
		case DGRAM_ERROR_INVALID_SOURCE: val = "DGRAM_ERROR_INVALID_SOURCE"; break;
		case DGRAM_ERROR_INVALID_DEST: val = "DGRAM_ERROR_INVALID_DEST"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_dgram_data(struct ndr_push *ndr, int ndr_flags, const union dgram_data *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case DGRAM_DIRECT_UNIQUE: {
				NDR_CHECK(ndr_push_dgram_message(ndr, NDR_SCALARS, &r->msg));
			break; }

			case DGRAM_DIRECT_GROUP: {
				NDR_CHECK(ndr_push_dgram_message(ndr, NDR_SCALARS, &r->msg));
			break; }

			case DGRAM_BCAST: {
				NDR_CHECK(ndr_push_dgram_message(ndr, NDR_SCALARS, &r->msg));
			break; }

			case DGRAM_ERROR: {
				NDR_CHECK(ndr_push_dgram_err_code(ndr, NDR_SCALARS, r->error));
			break; }

			case DGRAM_QUERY: {
				NDR_CHECK(ndr_push_nbt_name(ndr, NDR_SCALARS, &r->dest_name));
			break; }

			case DGRAM_QUERY_POSITIVE: {
				NDR_CHECK(ndr_push_nbt_name(ndr, NDR_SCALARS, &r->dest_name));
			break; }

			case DGRAM_QUERY_NEGATIVE: {
				NDR_CHECK(ndr_push_nbt_name(ndr, NDR_SCALARS, &r->dest_name));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case DGRAM_DIRECT_UNIQUE:
			break;

			case DGRAM_DIRECT_GROUP:
			break;

			case DGRAM_BCAST:
			break;

			case DGRAM_ERROR:
			break;

			case DGRAM_QUERY:
			break;

			case DGRAM_QUERY_POSITIVE:
			break;

			case DGRAM_QUERY_NEGATIVE:
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dgram_data(struct ndr_pull *ndr, int ndr_flags, union dgram_data *r)
{
	int level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		switch (level) {
			case DGRAM_DIRECT_UNIQUE: {
				NDR_CHECK(ndr_pull_dgram_message(ndr, NDR_SCALARS, &r->msg));
			break; }

			case DGRAM_DIRECT_GROUP: {
				NDR_CHECK(ndr_pull_dgram_message(ndr, NDR_SCALARS, &r->msg));
			break; }

			case DGRAM_BCAST: {
				NDR_CHECK(ndr_pull_dgram_message(ndr, NDR_SCALARS, &r->msg));
			break; }

			case DGRAM_ERROR: {
				NDR_CHECK(ndr_pull_dgram_err_code(ndr, NDR_SCALARS, &r->error));
			break; }

			case DGRAM_QUERY: {
				NDR_CHECK(ndr_pull_nbt_name(ndr, NDR_SCALARS, &r->dest_name));
			break; }

			case DGRAM_QUERY_POSITIVE: {
				NDR_CHECK(ndr_pull_nbt_name(ndr, NDR_SCALARS, &r->dest_name));
			break; }

			case DGRAM_QUERY_NEGATIVE: {
				NDR_CHECK(ndr_pull_nbt_name(ndr, NDR_SCALARS, &r->dest_name));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case DGRAM_DIRECT_UNIQUE:
			break;

			case DGRAM_DIRECT_GROUP:
			break;

			case DGRAM_BCAST:
			break;

			case DGRAM_ERROR:
			break;

			case DGRAM_QUERY:
			break;

			case DGRAM_QUERY_POSITIVE:
			break;

			case DGRAM_QUERY_NEGATIVE:
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dgram_data(struct ndr_print *ndr, const char *name, const union dgram_data *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "dgram_data");
	switch (level) {
		case DGRAM_DIRECT_UNIQUE:
			ndr_print_dgram_message(ndr, "msg", &r->msg);
		break;

		case DGRAM_DIRECT_GROUP:
			ndr_print_dgram_message(ndr, "msg", &r->msg);
		break;

		case DGRAM_BCAST:
			ndr_print_dgram_message(ndr, "msg", &r->msg);
		break;

		case DGRAM_ERROR:
			ndr_print_dgram_err_code(ndr, "error", r->error);
		break;

		case DGRAM_QUERY:
			ndr_print_nbt_name(ndr, "dest_name", &r->dest_name);
		break;

		case DGRAM_QUERY_POSITIVE:
			ndr_print_nbt_name(ndr, "dest_name", &r->dest_name);
		break;

		case DGRAM_QUERY_NEGATIVE:
			ndr_print_nbt_name(ndr, "dest_name", &r->dest_name);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_nbt_dgram_packet(struct ndr_push *ndr, int ndr_flags, const struct nbt_dgram_packet *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_BIGENDIAN|LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_dgram_msg_type(ndr, NDR_SCALARS, r->msg_type));
			NDR_CHECK(ndr_push_dgram_flags(ndr, NDR_SCALARS, r->flags));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->dgram_id));
			NDR_CHECK(ndr_push_ipv4address(ndr, NDR_SCALARS, r->src_addr));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->src_port));
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->data, r->msg_type));
			NDR_CHECK(ndr_push_dgram_data(ndr, NDR_SCALARS, &r->data));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_nbt_dgram_packet(struct ndr_pull *ndr, int ndr_flags, struct nbt_dgram_packet *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_BIGENDIAN|LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_dgram_msg_type(ndr, NDR_SCALARS, &r->msg_type));
			NDR_CHECK(ndr_pull_dgram_flags(ndr, NDR_SCALARS, &r->flags));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->dgram_id));
			NDR_CHECK(ndr_pull_ipv4address(ndr, NDR_SCALARS, &r->src_addr));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->src_port));
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->data, r->msg_type));
			NDR_CHECK(ndr_pull_dgram_data(ndr, NDR_SCALARS, &r->data));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_dgram_packet(struct ndr_print *ndr, const char *name, const struct nbt_dgram_packet *r)
{
	ndr_print_struct(ndr, name, "nbt_dgram_packet");
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_BIGENDIAN|LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_dgram_msg_type(ndr, "msg_type", r->msg_type);
		ndr_print_dgram_flags(ndr, "flags", r->flags);
		ndr_print_uint16(ndr, "dgram_id", r->dgram_id);
		ndr_print_ipv4address(ndr, "src_addr", r->src_addr);
		ndr_print_uint16(ndr, "src_port", r->src_port);
		ndr_print_set_switch_value(ndr, &r->data, r->msg_type);
		ndr_print_dgram_data(ndr, "data", &r->data);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static enum ndr_err_code ndr_push_nbt_netlogon_command(struct ndr_push *ndr, int ndr_flags, enum nbt_netlogon_command r)
{
	NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_netlogon_command(struct ndr_pull *ndr, int ndr_flags, enum nbt_netlogon_command *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_netlogon_command(struct ndr_print *ndr, const char *name, enum nbt_netlogon_command r)
{
	const char *val = NULL;

	switch (r) {
		case NETLOGON_QUERY_FOR_PDC: val = "NETLOGON_QUERY_FOR_PDC"; break;
		case NETLOGON_ANNOUNCE_UAS: val = "NETLOGON_ANNOUNCE_UAS"; break;
		case NETLOGON_RESPONSE_FROM_PDC: val = "NETLOGON_RESPONSE_FROM_PDC"; break;
		case NETLOGON_QUERY_FOR_PDC2: val = "NETLOGON_QUERY_FOR_PDC2"; break;
		case NETLOGON_RESPONSE_FROM_PDC2: val = "NETLOGON_RESPONSE_FROM_PDC2"; break;
		case NETLOGON_RESPONSE_FROM_PDC_USER: val = "NETLOGON_RESPONSE_FROM_PDC_USER"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_nbt_netlogon_version(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	{
		uint32_t _flags_save_BITMAP = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_LITTLE_ENDIAN);
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
		ndr->flags = _flags_save_BITMAP;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_netlogon_version(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	{
		uint32_t _flags_save_BITMAP = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_LITTLE_ENDIAN);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
		*r = v;
		ndr->flags = _flags_save_BITMAP;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_netlogon_version(struct ndr_print *ndr, const char *name, uint32_t r)
{
	{
		uint32_t _flags_save_BITMAP = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_LITTLE_ENDIAN);
		ndr_print_uint32(ndr, name, r);
		ndr->depth++;
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_VERSION_1", NETLOGON_VERSION_1, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_VERSION_5", NETLOGON_VERSION_5, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_VERSION_5EX", NETLOGON_VERSION_5EX, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_VERSION_5EX_WITH_IP", NETLOGON_VERSION_5EX_WITH_IP, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_VERSION_WITH_CLOSEST_SITE", NETLOGON_VERSION_WITH_CLOSEST_SITE, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_VERSION_AVOID_NT4_EMUL", NETLOGON_VERSION_AVOID_NT4_EMUL, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_VERSION_PDC", NETLOGON_VERSION_PDC, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_VERSION_IP", NETLOGON_VERSION_IP, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_VERSION_LOCAL", NETLOGON_VERSION_LOCAL, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_VERSION_GC", NETLOGON_VERSION_GC, r);
		ndr->depth--;
		ndr->flags = _flags_save_BITMAP;
	}
}

static enum ndr_err_code ndr_push_nbt_netlogon_query_for_pdc(struct ndr_push *ndr, int ndr_flags, const struct nbt_netlogon_query_for_pdc *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->computer_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->mailslot_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->_pad));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->unicode_name));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_nbt_netlogon_version(ndr, NDR_SCALARS, r->nt_version));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->lmnt_token));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->lm20_token));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_netlogon_query_for_pdc(struct ndr_pull *ndr, int ndr_flags, struct nbt_netlogon_query_for_pdc *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->computer_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->mailslot_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->_pad));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->unicode_name));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_nbt_netlogon_version(ndr, NDR_SCALARS, &r->nt_version));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->lmnt_token));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->lm20_token));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_netlogon_query_for_pdc(struct ndr_print *ndr, const char *name, const struct nbt_netlogon_query_for_pdc *r)
{
	ndr_print_struct(ndr, name, "nbt_netlogon_query_for_pdc");
	ndr->depth++;
	ndr_print_string(ndr, "computer_name", r->computer_name);
	ndr_print_string(ndr, "mailslot_name", r->mailslot_name);
	ndr_print_DATA_BLOB(ndr, "_pad", r->_pad);
	ndr_print_string(ndr, "unicode_name", r->unicode_name);
	ndr_print_nbt_netlogon_version(ndr, "nt_version", r->nt_version);
	ndr_print_uint16(ndr, "lmnt_token", r->lmnt_token);
	ndr_print_uint16(ndr, "lm20_token", r->lm20_token);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbt_netlogon_query_for_pdc2(struct ndr_push *ndr, int ndr_flags, const struct nbt_netlogon_query_for_pdc2 *r)
{
	uint32_t cntr_unknown_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->request_count));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->computer_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->user_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->mailslot_name));
			ndr->flags = _flags_save_string;
		}
		for (cntr_unknown_0 = 0; cntr_unknown_0 < 2; cntr_unknown_0++) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown[cntr_unknown_0]));
		}
		NDR_CHECK(ndr_push_nbt_netlogon_version(ndr, NDR_SCALARS, r->nt_version));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->lmnt_token));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->lm20_token));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_netlogon_query_for_pdc2(struct ndr_pull *ndr, int ndr_flags, struct nbt_netlogon_query_for_pdc2 *r)
{
	uint32_t cntr_unknown_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->request_count));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->computer_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->user_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->mailslot_name));
			ndr->flags = _flags_save_string;
		}
		for (cntr_unknown_0 = 0; cntr_unknown_0 < 2; cntr_unknown_0++) {
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown[cntr_unknown_0]));
		}
		NDR_CHECK(ndr_pull_nbt_netlogon_version(ndr, NDR_SCALARS, &r->nt_version));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->lmnt_token));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->lm20_token));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_netlogon_query_for_pdc2(struct ndr_print *ndr, const char *name, const struct nbt_netlogon_query_for_pdc2 *r)
{
	uint32_t cntr_unknown_0;
	ndr_print_struct(ndr, name, "nbt_netlogon_query_for_pdc2");
	ndr->depth++;
	ndr_print_uint16(ndr, "request_count", r->request_count);
	ndr_print_string(ndr, "computer_name", r->computer_name);
	ndr_print_string(ndr, "user_name", r->user_name);
	ndr_print_string(ndr, "mailslot_name", r->mailslot_name);
	ndr->print(ndr, "%s: ARRAY(%d)", "unknown", 2);
	ndr->depth++;
	for (cntr_unknown_0=0;cntr_unknown_0<2;cntr_unknown_0++) {
		char *idx_0=NULL;
		if (asprintf(&idx_0, "[%d]", cntr_unknown_0) != -1) {
			ndr_print_uint32(ndr, "unknown", r->unknown[cntr_unknown_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr_print_nbt_netlogon_version(ndr, "nt_version", r->nt_version);
	ndr_print_uint16(ndr, "lmnt_token", r->lmnt_token);
	ndr_print_uint16(ndr, "lm20_token", r->lm20_token);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbt_netlogon_response_from_pdc(struct ndr_push *ndr, int ndr_flags, const struct nbt_netlogon_response_from_pdc *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->pdc_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->_pad));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->unicode_pdc_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->domain_name));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_nbt_netlogon_version(ndr, NDR_SCALARS, r->nt_version));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->lmnt_token));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->lm20_token));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_netlogon_response_from_pdc(struct ndr_pull *ndr, int ndr_flags, struct nbt_netlogon_response_from_pdc *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->pdc_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->_pad));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->unicode_pdc_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->domain_name));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_nbt_netlogon_version(ndr, NDR_SCALARS, &r->nt_version));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->lmnt_token));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->lm20_token));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_netlogon_response_from_pdc(struct ndr_print *ndr, const char *name, const struct nbt_netlogon_response_from_pdc *r)
{
	ndr_print_struct(ndr, name, "nbt_netlogon_response_from_pdc");
	ndr->depth++;
	ndr_print_string(ndr, "pdc_name", r->pdc_name);
	ndr_print_DATA_BLOB(ndr, "_pad", r->_pad);
	ndr_print_string(ndr, "unicode_pdc_name", r->unicode_pdc_name);
	ndr_print_string(ndr, "domain_name", r->domain_name);
	ndr_print_nbt_netlogon_version(ndr, "nt_version", r->nt_version);
	ndr_print_uint16(ndr, "lmnt_token", r->lmnt_token);
	ndr_print_uint16(ndr, "lm20_token", r->lm20_token);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbt_server_type(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_server_type(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_server_type(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NBT_SERVER_PDC", NBT_SERVER_PDC, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NBT_SERVER_GC", NBT_SERVER_GC, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NBT_SERVER_LDAP", NBT_SERVER_LDAP, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NBT_SERVER_DS", NBT_SERVER_DS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NBT_SERVER_KDC", NBT_SERVER_KDC, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NBT_SERVER_TIMESERV", NBT_SERVER_TIMESERV, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NBT_SERVER_CLOSEST", NBT_SERVER_CLOSEST, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NBT_SERVER_WRITABLE", NBT_SERVER_WRITABLE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NBT_SERVER_GOOD_TIMESERV", NBT_SERVER_GOOD_TIMESERV, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NBT_SERVER_NDNC", NBT_SERVER_NDNC, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NBT_SERVER_SELECT_SECRET_DOMAIN_6", NBT_SERVER_SELECT_SECRET_DOMAIN_6, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NBT_SERVER_FULL_SECRET_DOMAIN_6", NBT_SERVER_FULL_SECRET_DOMAIN_6, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbt_dc_sock_addr(struct ndr_push *ndr, int ndr_flags, const struct nbt_dc_sock_addr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->family));
		{
			uint32_t _flags_save_ipv4address = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_push_ipv4address(ndr, NDR_SCALARS, r->pdc_ip));
			ndr->flags = _flags_save_ipv4address;
		}
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->remaining));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_dc_sock_addr(struct ndr_pull *ndr, int ndr_flags, struct nbt_dc_sock_addr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->family));
		{
			uint32_t _flags_save_ipv4address = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_pull_ipv4address(ndr, NDR_SCALARS, &r->pdc_ip));
			ndr->flags = _flags_save_ipv4address;
		}
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->remaining));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_dc_sock_addr(struct ndr_print *ndr, const char *name, const struct nbt_dc_sock_addr *r)
{
	ndr_print_struct(ndr, name, "nbt_dc_sock_addr");
	ndr->depth++;
	ndr_print_uint32(ndr, "family", r->family);
	ndr_print_ipv4address(ndr, "pdc_ip", r->pdc_ip);
	ndr_print_DATA_BLOB(ndr, "remaining", r->remaining);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbt_netlogon_response_from_pdc2(struct ndr_push *ndr, int ndr_flags, const struct nbt_netlogon_response_from_pdc2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN4);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->_pad));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_push_nbt_server_type(ndr, NDR_SCALARS, r->server_type));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->domain_uuid));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->forest));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->dns_domain));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->pdc_dns_name));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->domain));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->pdc_name));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->user_name));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->server_site));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->client_site));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->dc_sock_addr_size));
		{
			struct ndr_push *_ndr_dc_sock_addr;
			NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_dc_sock_addr, 0, r->dc_sock_addr_size));
			NDR_CHECK(ndr_push_nbt_dc_sock_addr(_ndr_dc_sock_addr, NDR_SCALARS, &r->dc_sock_addr));
			NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_dc_sock_addr, 0, r->dc_sock_addr_size));
		}
		NDR_CHECK(ndr_push_nbt_netlogon_version(ndr, NDR_SCALARS, r->nt_version));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->lmnt_token));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->lm20_token));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_netlogon_response_from_pdc2(struct ndr_pull *ndr, int ndr_flags, struct nbt_netlogon_response_from_pdc2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN4);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->_pad));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_pull_nbt_server_type(ndr, NDR_SCALARS, &r->server_type));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->domain_uuid));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->forest));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->dns_domain));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->pdc_dns_name));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->domain));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->pdc_name));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->user_name));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->server_site));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->client_site));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->dc_sock_addr_size));
		{
			struct ndr_pull *_ndr_dc_sock_addr;
			NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_dc_sock_addr, 0, r->dc_sock_addr_size));
			NDR_CHECK(ndr_pull_nbt_dc_sock_addr(_ndr_dc_sock_addr, NDR_SCALARS, &r->dc_sock_addr));
			NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_dc_sock_addr, 0, r->dc_sock_addr_size));
		}
		NDR_CHECK(ndr_pull_nbt_netlogon_version(ndr, NDR_SCALARS, &r->nt_version));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->lmnt_token));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->lm20_token));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_netlogon_response_from_pdc2(struct ndr_print *ndr, const char *name, const struct nbt_netlogon_response_from_pdc2 *r)
{
	ndr_print_struct(ndr, name, "nbt_netlogon_response_from_pdc2");
	ndr->depth++;
	ndr_print_DATA_BLOB(ndr, "_pad", r->_pad);
	ndr_print_nbt_server_type(ndr, "server_type", r->server_type);
	ndr_print_GUID(ndr, "domain_uuid", &r->domain_uuid);
	ndr_print_nbt_string(ndr, "forest", r->forest);
	ndr_print_nbt_string(ndr, "dns_domain", r->dns_domain);
	ndr_print_nbt_string(ndr, "pdc_dns_name", r->pdc_dns_name);
	ndr_print_nbt_string(ndr, "domain", r->domain);
	ndr_print_nbt_string(ndr, "pdc_name", r->pdc_name);
	ndr_print_nbt_string(ndr, "user_name", r->user_name);
	ndr_print_nbt_string(ndr, "server_site", r->server_site);
	ndr_print_nbt_string(ndr, "client_site", r->client_site);
	ndr_print_uint8(ndr, "dc_sock_addr_size", r->dc_sock_addr_size);
	ndr_print_nbt_dc_sock_addr(ndr, "dc_sock_addr", &r->dc_sock_addr);
	ndr_print_nbt_netlogon_version(ndr, "nt_version", r->nt_version);
	ndr_print_uint16(ndr, "lmnt_token", r->lmnt_token);
	ndr_print_uint16(ndr, "lm20_token", r->lm20_token);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbt_db_change(struct ndr_push *ndr, int ndr_flags, const struct nbt_db_change *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_netr_SamDatabaseID(ndr, NDR_SCALARS, r->db_index));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->serial));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->timestamp));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_db_change(struct ndr_pull *ndr, int ndr_flags, struct nbt_db_change *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_netr_SamDatabaseID(ndr, NDR_SCALARS, &r->db_index));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->serial));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->timestamp));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_db_change(struct ndr_print *ndr, const char *name, const struct nbt_db_change *r)
{
	ndr_print_struct(ndr, name, "nbt_db_change");
	ndr->depth++;
	ndr_print_netr_SamDatabaseID(ndr, "db_index", r->db_index);
	ndr_print_hyper(ndr, "serial", r->serial);
	ndr_print_NTTIME(ndr, "timestamp", r->timestamp);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbt_netlogon_announce_uas(struct ndr_push *ndr, int ndr_flags, const struct nbt_netlogon_announce_uas *r)
{
	uint32_t cntr_dbchange_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->serial_lo));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->timestamp));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->pulse));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->random));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->pdc_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->domain));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->_pad));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->unicode_pdc_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->unicode_domain));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->db_count));
		for (cntr_dbchange_0 = 0; cntr_dbchange_0 < r->db_count; cntr_dbchange_0++) {
			NDR_CHECK(ndr_push_nbt_db_change(ndr, NDR_SCALARS, &r->dbchange[cntr_dbchange_0]));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_dom_sid0(&r->sid, ndr->flags)));
		{
			struct ndr_push *_ndr_sid;
			NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_sid, 0, ndr_size_dom_sid0(&r->sid, ndr->flags)));
			NDR_CHECK(ndr_push_dom_sid0(_ndr_sid, NDR_SCALARS|NDR_BUFFERS, &r->sid));
			NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_sid, 0, ndr_size_dom_sid0(&r->sid, ndr->flags)));
		}
		NDR_CHECK(ndr_push_nbt_netlogon_version(ndr, NDR_SCALARS, r->nt_version));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->lmnt_token));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->lm20_token));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_netlogon_announce_uas(struct ndr_pull *ndr, int ndr_flags, struct nbt_netlogon_announce_uas *r)
{
	uint32_t cntr_dbchange_0;
	TALLOC_CTX *_mem_save_dbchange_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->serial_lo));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->timestamp));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pulse));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->random));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->pdc_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->domain));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->_pad));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->unicode_pdc_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->unicode_domain));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->db_count));
		NDR_PULL_ALLOC_N(ndr, r->dbchange, r->db_count);
		_mem_save_dbchange_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->dbchange, 0);
		for (cntr_dbchange_0 = 0; cntr_dbchange_0 < r->db_count; cntr_dbchange_0++) {
			NDR_CHECK(ndr_pull_nbt_db_change(ndr, NDR_SCALARS, &r->dbchange[cntr_dbchange_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dbchange_0, 0);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sid_size));
		{
			struct ndr_pull *_ndr_sid;
			NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_sid, 0, r->sid_size));
			NDR_CHECK(ndr_pull_dom_sid0(_ndr_sid, NDR_SCALARS|NDR_BUFFERS, &r->sid));
			NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_sid, 0, r->sid_size));
		}
		NDR_CHECK(ndr_pull_nbt_netlogon_version(ndr, NDR_SCALARS, &r->nt_version));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->lmnt_token));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->lm20_token));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_netlogon_announce_uas(struct ndr_print *ndr, const char *name, const struct nbt_netlogon_announce_uas *r)
{
	uint32_t cntr_dbchange_0;
	ndr_print_struct(ndr, name, "nbt_netlogon_announce_uas");
	ndr->depth++;
	ndr_print_uint32(ndr, "serial_lo", r->serial_lo);
	ndr_print_time_t(ndr, "timestamp", r->timestamp);
	ndr_print_uint32(ndr, "pulse", r->pulse);
	ndr_print_uint32(ndr, "random", r->random);
	ndr_print_string(ndr, "pdc_name", r->pdc_name);
	ndr_print_string(ndr, "domain", r->domain);
	ndr_print_DATA_BLOB(ndr, "_pad", r->_pad);
	ndr_print_string(ndr, "unicode_pdc_name", r->unicode_pdc_name);
	ndr_print_string(ndr, "unicode_domain", r->unicode_domain);
	ndr_print_uint32(ndr, "db_count", r->db_count);
	ndr->print(ndr, "%s: ARRAY(%d)", "dbchange", r->db_count);
	ndr->depth++;
	for (cntr_dbchange_0=0;cntr_dbchange_0<r->db_count;cntr_dbchange_0++) {
		char *idx_0=NULL;
		if (asprintf(&idx_0, "[%d]", cntr_dbchange_0) != -1) {
			ndr_print_nbt_db_change(ndr, "dbchange", &r->dbchange[cntr_dbchange_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "sid_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_dom_sid0(&r->sid, ndr->flags):r->sid_size);
	ndr_print_dom_sid0(ndr, "sid", &r->sid);
	ndr_print_nbt_netlogon_version(ndr, "nt_version", r->nt_version);
	ndr_print_uint16(ndr, "lmnt_token", r->lmnt_token);
	ndr_print_uint16(ndr, "lm20_token", r->lm20_token);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbt_netlogon_request(struct ndr_push *ndr, int ndr_flags, const union nbt_netlogon_request *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case NETLOGON_QUERY_FOR_PDC: {
				NDR_CHECK(ndr_push_nbt_netlogon_query_for_pdc(ndr, NDR_SCALARS, &r->pdc));
			break; }

			case NETLOGON_QUERY_FOR_PDC2: {
				NDR_CHECK(ndr_push_nbt_netlogon_query_for_pdc2(ndr, NDR_SCALARS, &r->pdc2));
			break; }

			case NETLOGON_ANNOUNCE_UAS: {
				NDR_CHECK(ndr_push_nbt_netlogon_announce_uas(ndr, NDR_SCALARS, &r->uas));
			break; }

			case NETLOGON_RESPONSE_FROM_PDC: {
				NDR_CHECK(ndr_push_nbt_netlogon_response_from_pdc(ndr, NDR_SCALARS, &r->response));
			break; }

			case NETLOGON_RESPONSE_FROM_PDC2: {
				NDR_CHECK(ndr_push_nbt_netlogon_response_from_pdc2(ndr, NDR_SCALARS, &r->response2));
			break; }

			case NETLOGON_RESPONSE_FROM_PDC_USER: {
				NDR_CHECK(ndr_push_nbt_netlogon_response_from_pdc2(ndr, NDR_SCALARS, &r->response2));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case NETLOGON_QUERY_FOR_PDC:
			break;

			case NETLOGON_QUERY_FOR_PDC2:
			break;

			case NETLOGON_ANNOUNCE_UAS:
				NDR_CHECK(ndr_push_nbt_netlogon_announce_uas(ndr, NDR_BUFFERS, &r->uas));
			break;

			case NETLOGON_RESPONSE_FROM_PDC:
			break;

			case NETLOGON_RESPONSE_FROM_PDC2:
			break;

			case NETLOGON_RESPONSE_FROM_PDC_USER:
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_netlogon_request(struct ndr_pull *ndr, int ndr_flags, union nbt_netlogon_request *r)
{
	int level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		switch (level) {
			case NETLOGON_QUERY_FOR_PDC: {
				NDR_CHECK(ndr_pull_nbt_netlogon_query_for_pdc(ndr, NDR_SCALARS, &r->pdc));
			break; }

			case NETLOGON_QUERY_FOR_PDC2: {
				NDR_CHECK(ndr_pull_nbt_netlogon_query_for_pdc2(ndr, NDR_SCALARS, &r->pdc2));
			break; }

			case NETLOGON_ANNOUNCE_UAS: {
				NDR_CHECK(ndr_pull_nbt_netlogon_announce_uas(ndr, NDR_SCALARS, &r->uas));
			break; }

			case NETLOGON_RESPONSE_FROM_PDC: {
				NDR_CHECK(ndr_pull_nbt_netlogon_response_from_pdc(ndr, NDR_SCALARS, &r->response));
			break; }

			case NETLOGON_RESPONSE_FROM_PDC2: {
				NDR_CHECK(ndr_pull_nbt_netlogon_response_from_pdc2(ndr, NDR_SCALARS, &r->response2));
			break; }

			case NETLOGON_RESPONSE_FROM_PDC_USER: {
				NDR_CHECK(ndr_pull_nbt_netlogon_response_from_pdc2(ndr, NDR_SCALARS, &r->response2));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case NETLOGON_QUERY_FOR_PDC:
			break;

			case NETLOGON_QUERY_FOR_PDC2:
			break;

			case NETLOGON_ANNOUNCE_UAS:
				NDR_CHECK(ndr_pull_nbt_netlogon_announce_uas(ndr, NDR_BUFFERS, &r->uas));
			break;

			case NETLOGON_RESPONSE_FROM_PDC:
			break;

			case NETLOGON_RESPONSE_FROM_PDC2:
			break;

			case NETLOGON_RESPONSE_FROM_PDC_USER:
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_netlogon_request(struct ndr_print *ndr, const char *name, const union nbt_netlogon_request *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "nbt_netlogon_request");
	switch (level) {
		case NETLOGON_QUERY_FOR_PDC:
			ndr_print_nbt_netlogon_query_for_pdc(ndr, "pdc", &r->pdc);
		break;

		case NETLOGON_QUERY_FOR_PDC2:
			ndr_print_nbt_netlogon_query_for_pdc2(ndr, "pdc2", &r->pdc2);
		break;

		case NETLOGON_ANNOUNCE_UAS:
			ndr_print_nbt_netlogon_announce_uas(ndr, "uas", &r->uas);
		break;

		case NETLOGON_RESPONSE_FROM_PDC:
			ndr_print_nbt_netlogon_response_from_pdc(ndr, "response", &r->response);
		break;

		case NETLOGON_RESPONSE_FROM_PDC2:
			ndr_print_nbt_netlogon_response_from_pdc2(ndr, "response2", &r->response2);
		break;

		case NETLOGON_RESPONSE_FROM_PDC_USER:
			ndr_print_nbt_netlogon_response_from_pdc2(ndr, "response2", &r->response2);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_nbt_netlogon_packet(struct ndr_push *ndr, int ndr_flags, const struct nbt_netlogon_packet *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 8));
			NDR_CHECK(ndr_push_nbt_netlogon_command(ndr, NDR_SCALARS, r->command));
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->req, r->command));
			NDR_CHECK(ndr_push_nbt_netlogon_request(ndr, NDR_SCALARS, &r->req));
		}
		if (ndr_flags & NDR_BUFFERS) {
			NDR_CHECK(ndr_push_nbt_netlogon_request(ndr, NDR_BUFFERS, &r->req));
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_nbt_netlogon_packet(struct ndr_pull *ndr, int ndr_flags, struct nbt_netlogon_packet *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 8));
			NDR_CHECK(ndr_pull_nbt_netlogon_command(ndr, NDR_SCALARS, &r->command));
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->req, r->command));
			NDR_CHECK(ndr_pull_nbt_netlogon_request(ndr, NDR_SCALARS, &r->req));
		}
		if (ndr_flags & NDR_BUFFERS) {
			NDR_CHECK(ndr_pull_nbt_netlogon_request(ndr, NDR_BUFFERS, &r->req));
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_netlogon_packet(struct ndr_print *ndr, const char *name, const struct nbt_netlogon_packet *r)
{
	ndr_print_struct(ndr, name, "nbt_netlogon_packet");
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		ndr->depth++;
		ndr_print_nbt_netlogon_command(ndr, "command", r->command);
		ndr_print_set_switch_value(ndr, &r->req, r->command);
		ndr_print_nbt_netlogon_request(ndr, "req", &r->req);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static enum ndr_err_code ndr_push_nbt_cldap_netlogon_1(struct ndr_push *ndr, int ndr_flags, const struct nbt_cldap_netlogon_1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_nbt_netlogon_command(ndr, NDR_SCALARS, r->type));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->pdc_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->user_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->domain_name));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_nbt_netlogon_version(ndr, NDR_SCALARS, 1));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->lmnt_token));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->lm20_token));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_cldap_netlogon_1(struct ndr_pull *ndr, int ndr_flags, struct nbt_cldap_netlogon_1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_nbt_netlogon_command(ndr, NDR_SCALARS, &r->type));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->pdc_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->user_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->domain_name));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_nbt_netlogon_version(ndr, NDR_SCALARS, &r->nt_version));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->lmnt_token));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->lm20_token));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_cldap_netlogon_1(struct ndr_print *ndr, const char *name, const struct nbt_cldap_netlogon_1 *r)
{
	ndr_print_struct(ndr, name, "nbt_cldap_netlogon_1");
	ndr->depth++;
	ndr_print_nbt_netlogon_command(ndr, "type", r->type);
	ndr_print_string(ndr, "pdc_name", r->pdc_name);
	ndr_print_string(ndr, "user_name", r->user_name);
	ndr_print_string(ndr, "domain_name", r->domain_name);
	ndr_print_nbt_netlogon_version(ndr, "nt_version", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?1:r->nt_version);
	ndr_print_uint16(ndr, "lmnt_token", r->lmnt_token);
	ndr_print_uint16(ndr, "lm20_token", r->lm20_token);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbt_cldap_netlogon_3(struct ndr_push *ndr, int ndr_flags, const struct nbt_cldap_netlogon_3 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_nbt_netlogon_command(ndr, NDR_SCALARS, r->type));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->pdc_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->user_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->domain_name));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->domain_uuid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->unknown_uuid));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->forest));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->dns_domain));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->pdc_dns_name));
		NDR_CHECK(ndr_push_ipv4address(ndr, NDR_SCALARS, r->pdc_ip));
		NDR_CHECK(ndr_push_nbt_server_type(ndr, NDR_SCALARS, r->server_type));
		NDR_CHECK(ndr_push_nbt_netlogon_version(ndr, NDR_SCALARS, 3));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->lmnt_token));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->lm20_token));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_cldap_netlogon_3(struct ndr_pull *ndr, int ndr_flags, struct nbt_cldap_netlogon_3 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_nbt_netlogon_command(ndr, NDR_SCALARS, &r->type));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->pdc_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->user_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->domain_name));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->domain_uuid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->unknown_uuid));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->forest));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->dns_domain));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->pdc_dns_name));
		NDR_CHECK(ndr_pull_ipv4address(ndr, NDR_SCALARS, &r->pdc_ip));
		NDR_CHECK(ndr_pull_nbt_server_type(ndr, NDR_SCALARS, &r->server_type));
		NDR_CHECK(ndr_pull_nbt_netlogon_version(ndr, NDR_SCALARS, &r->nt_version));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->lmnt_token));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->lm20_token));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_cldap_netlogon_3(struct ndr_print *ndr, const char *name, const struct nbt_cldap_netlogon_3 *r)
{
	ndr_print_struct(ndr, name, "nbt_cldap_netlogon_3");
	ndr->depth++;
	ndr_print_nbt_netlogon_command(ndr, "type", r->type);
	ndr_print_string(ndr, "pdc_name", r->pdc_name);
	ndr_print_string(ndr, "user_name", r->user_name);
	ndr_print_string(ndr, "domain_name", r->domain_name);
	ndr_print_GUID(ndr, "domain_uuid", &r->domain_uuid);
	ndr_print_GUID(ndr, "unknown_uuid", &r->unknown_uuid);
	ndr_print_nbt_string(ndr, "forest", r->forest);
	ndr_print_nbt_string(ndr, "dns_domain", r->dns_domain);
	ndr_print_nbt_string(ndr, "pdc_dns_name", r->pdc_dns_name);
	ndr_print_ipv4address(ndr, "pdc_ip", r->pdc_ip);
	ndr_print_nbt_server_type(ndr, "server_type", r->server_type);
	ndr_print_nbt_netlogon_version(ndr, "nt_version", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?3:r->nt_version);
	ndr_print_uint16(ndr, "lmnt_token", r->lmnt_token);
	ndr_print_uint16(ndr, "lm20_token", r->lm20_token);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_nbt_cldap_netlogon_5(struct ndr_push *ndr, int ndr_flags, const struct nbt_cldap_netlogon_5 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_nbt_netlogon_command(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->sbz));
		NDR_CHECK(ndr_push_nbt_server_type(ndr, NDR_SCALARS, r->server_type));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->domain_uuid));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->forest));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->dns_domain));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->pdc_dns_name));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->domain));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->pdc_name));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->user_name));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->server_site));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->client_site));
		NDR_CHECK(ndr_push_nbt_netlogon_version(ndr, NDR_SCALARS, 5));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->lmnt_token));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->lm20_token));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_nbt_cldap_netlogon_5(struct ndr_pull *ndr, int ndr_flags, struct nbt_cldap_netlogon_5 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_nbt_netlogon_command(ndr, NDR_SCALARS, &r->type));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->sbz));
		NDR_CHECK(ndr_pull_nbt_server_type(ndr, NDR_SCALARS, &r->server_type));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->domain_uuid));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->forest));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->dns_domain));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->pdc_dns_name));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->domain));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->pdc_name));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->user_name));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->server_site));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->client_site));
		NDR_CHECK(ndr_pull_nbt_netlogon_version(ndr, NDR_SCALARS, &r->nt_version));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->lmnt_token));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->lm20_token));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_cldap_netlogon_5(struct ndr_print *ndr, const char *name, const struct nbt_cldap_netlogon_5 *r)
{
	ndr_print_struct(ndr, name, "nbt_cldap_netlogon_5");
	ndr->depth++;
	ndr_print_nbt_netlogon_command(ndr, "type", r->type);
	ndr_print_uint16(ndr, "sbz", r->sbz);
	ndr_print_nbt_server_type(ndr, "server_type", r->server_type);
	ndr_print_GUID(ndr, "domain_uuid", &r->domain_uuid);
	ndr_print_nbt_string(ndr, "forest", r->forest);
	ndr_print_nbt_string(ndr, "dns_domain", r->dns_domain);
	ndr_print_nbt_string(ndr, "pdc_dns_name", r->pdc_dns_name);
	ndr_print_nbt_string(ndr, "domain", r->domain);
	ndr_print_nbt_string(ndr, "pdc_name", r->pdc_name);
	ndr_print_nbt_string(ndr, "user_name", r->user_name);
	ndr_print_nbt_string(ndr, "server_site", r->server_site);
	ndr_print_nbt_string(ndr, "client_site", r->client_site);
	ndr_print_nbt_netlogon_version(ndr, "nt_version", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?5:r->nt_version);
	ndr_print_uint16(ndr, "lmnt_token", r->lmnt_token);
	ndr_print_uint16(ndr, "lm20_token", r->lm20_token);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbt_cldap_netlogon_13(struct ndr_push *ndr, int ndr_flags, const struct nbt_cldap_netlogon_13 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_nbt_netlogon_command(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->sbz));
		NDR_CHECK(ndr_push_nbt_server_type(ndr, NDR_SCALARS, r->server_type));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->domain_uuid));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->forest));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->dns_domain));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->pdc_dns_name));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->domain));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->pdc_name));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->user_name));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->server_site));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->client_site));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->dc_sock_addr_size));
		{
			struct ndr_push *_ndr_dc_sock_addr;
			NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_dc_sock_addr, 0, r->dc_sock_addr_size));
			NDR_CHECK(ndr_push_nbt_dc_sock_addr(_ndr_dc_sock_addr, NDR_SCALARS, &r->dc_sock_addr));
			NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_dc_sock_addr, 0, r->dc_sock_addr_size));
		}
		NDR_CHECK(ndr_push_nbt_netlogon_version(ndr, NDR_SCALARS, 13));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->lmnt_token));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->lm20_token));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_cldap_netlogon_13(struct ndr_pull *ndr, int ndr_flags, struct nbt_cldap_netlogon_13 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_nbt_netlogon_command(ndr, NDR_SCALARS, &r->type));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->sbz));
		NDR_CHECK(ndr_pull_nbt_server_type(ndr, NDR_SCALARS, &r->server_type));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->domain_uuid));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->forest));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->dns_domain));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->pdc_dns_name));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->domain));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->pdc_name));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->user_name));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->server_site));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->client_site));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->dc_sock_addr_size));
		{
			struct ndr_pull *_ndr_dc_sock_addr;
			NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_dc_sock_addr, 0, r->dc_sock_addr_size));
			NDR_CHECK(ndr_pull_nbt_dc_sock_addr(_ndr_dc_sock_addr, NDR_SCALARS, &r->dc_sock_addr));
			NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_dc_sock_addr, 0, r->dc_sock_addr_size));
		}
		NDR_CHECK(ndr_pull_nbt_netlogon_version(ndr, NDR_SCALARS, &r->nt_version));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->lmnt_token));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->lm20_token));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_cldap_netlogon_13(struct ndr_print *ndr, const char *name, const struct nbt_cldap_netlogon_13 *r)
{
	ndr_print_struct(ndr, name, "nbt_cldap_netlogon_13");
	ndr->depth++;
	ndr_print_nbt_netlogon_command(ndr, "type", r->type);
	ndr_print_uint16(ndr, "sbz", r->sbz);
	ndr_print_nbt_server_type(ndr, "server_type", r->server_type);
	ndr_print_GUID(ndr, "domain_uuid", &r->domain_uuid);
	ndr_print_nbt_string(ndr, "forest", r->forest);
	ndr_print_nbt_string(ndr, "dns_domain", r->dns_domain);
	ndr_print_nbt_string(ndr, "pdc_dns_name", r->pdc_dns_name);
	ndr_print_nbt_string(ndr, "domain", r->domain);
	ndr_print_nbt_string(ndr, "pdc_name", r->pdc_name);
	ndr_print_nbt_string(ndr, "user_name", r->user_name);
	ndr_print_nbt_string(ndr, "server_site", r->server_site);
	ndr_print_nbt_string(ndr, "client_site", r->client_site);
	ndr_print_uint8(ndr, "dc_sock_addr_size", r->dc_sock_addr_size);
	ndr_print_nbt_dc_sock_addr(ndr, "dc_sock_addr", &r->dc_sock_addr);
	ndr_print_nbt_netlogon_version(ndr, "nt_version", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?13:r->nt_version);
	ndr_print_uint16(ndr, "lmnt_token", r->lmnt_token);
	ndr_print_uint16(ndr, "lm20_token", r->lm20_token);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_nbt_cldap_netlogon_15(struct ndr_push *ndr, int ndr_flags, const struct nbt_cldap_netlogon_15 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_nbt_netlogon_command(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->sbz));
		NDR_CHECK(ndr_push_nbt_server_type(ndr, NDR_SCALARS, r->server_type));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->domain_uuid));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->forest));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->dns_domain));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->pdc_dns_name));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->domain));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->pdc_name));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->user_name));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->server_site));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->client_site));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->next_closest_site));
		NDR_CHECK(ndr_push_nbt_netlogon_version(ndr, NDR_SCALARS, 15));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->lmnt_token));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->lm20_token));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_nbt_cldap_netlogon_15(struct ndr_pull *ndr, int ndr_flags, struct nbt_cldap_netlogon_15 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_nbt_netlogon_command(ndr, NDR_SCALARS, &r->type));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->sbz));
		NDR_CHECK(ndr_pull_nbt_server_type(ndr, NDR_SCALARS, &r->server_type));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->domain_uuid));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->forest));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->dns_domain));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->pdc_dns_name));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->domain));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->pdc_name));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->user_name));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->server_site));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->client_site));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->next_closest_site));
		NDR_CHECK(ndr_pull_nbt_netlogon_version(ndr, NDR_SCALARS, &r->nt_version));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->lmnt_token));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->lm20_token));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_cldap_netlogon_15(struct ndr_print *ndr, const char *name, const struct nbt_cldap_netlogon_15 *r)
{
	ndr_print_struct(ndr, name, "nbt_cldap_netlogon_15");
	ndr->depth++;
	ndr_print_nbt_netlogon_command(ndr, "type", r->type);
	ndr_print_uint16(ndr, "sbz", r->sbz);
	ndr_print_nbt_server_type(ndr, "server_type", r->server_type);
	ndr_print_GUID(ndr, "domain_uuid", &r->domain_uuid);
	ndr_print_nbt_string(ndr, "forest", r->forest);
	ndr_print_nbt_string(ndr, "dns_domain", r->dns_domain);
	ndr_print_nbt_string(ndr, "pdc_dns_name", r->pdc_dns_name);
	ndr_print_nbt_string(ndr, "domain", r->domain);
	ndr_print_nbt_string(ndr, "pdc_name", r->pdc_name);
	ndr_print_nbt_string(ndr, "user_name", r->user_name);
	ndr_print_nbt_string(ndr, "server_site", r->server_site);
	ndr_print_nbt_string(ndr, "client_site", r->client_site);
	ndr_print_nbt_string(ndr, "next_closest_site", r->next_closest_site);
	ndr_print_nbt_netlogon_version(ndr, "nt_version", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?15:r->nt_version);
	ndr_print_uint16(ndr, "lmnt_token", r->lmnt_token);
	ndr_print_uint16(ndr, "lm20_token", r->lm20_token);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_nbt_cldap_netlogon_29(struct ndr_push *ndr, int ndr_flags, const struct nbt_cldap_netlogon_29 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_nbt_netlogon_command(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->sbz));
		NDR_CHECK(ndr_push_nbt_server_type(ndr, NDR_SCALARS, r->server_type));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->domain_uuid));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->forest));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->dns_domain));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->pdc_dns_name));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->domain));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->pdc_name));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->user_name));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->server_site));
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->client_site));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->dc_sock_addr_size));
		{
			struct ndr_push *_ndr_dc_sock_addr;
			NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_dc_sock_addr, 0, r->dc_sock_addr_size));
			NDR_CHECK(ndr_push_nbt_dc_sock_addr(_ndr_dc_sock_addr, NDR_SCALARS, &r->dc_sock_addr));
			NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_dc_sock_addr, 0, r->dc_sock_addr_size));
		}
		NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->next_closest_site));
		NDR_CHECK(ndr_push_nbt_netlogon_version(ndr, NDR_SCALARS, 29));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->lmnt_token));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->lm20_token));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_nbt_cldap_netlogon_29(struct ndr_pull *ndr, int ndr_flags, struct nbt_cldap_netlogon_29 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_nbt_netlogon_command(ndr, NDR_SCALARS, &r->type));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->sbz));
		NDR_CHECK(ndr_pull_nbt_server_type(ndr, NDR_SCALARS, &r->server_type));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->domain_uuid));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->forest));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->dns_domain));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->pdc_dns_name));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->domain));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->pdc_name));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->user_name));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->server_site));
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->client_site));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->dc_sock_addr_size));
		{
			struct ndr_pull *_ndr_dc_sock_addr;
			NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_dc_sock_addr, 0, r->dc_sock_addr_size));
			NDR_CHECK(ndr_pull_nbt_dc_sock_addr(_ndr_dc_sock_addr, NDR_SCALARS, &r->dc_sock_addr));
			NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_dc_sock_addr, 0, r->dc_sock_addr_size));
		}
		NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->next_closest_site));
		NDR_CHECK(ndr_pull_nbt_netlogon_version(ndr, NDR_SCALARS, &r->nt_version));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->lmnt_token));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->lm20_token));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_cldap_netlogon_29(struct ndr_print *ndr, const char *name, const struct nbt_cldap_netlogon_29 *r)
{
	ndr_print_struct(ndr, name, "nbt_cldap_netlogon_29");
	ndr->depth++;
	ndr_print_nbt_netlogon_command(ndr, "type", r->type);
	ndr_print_uint16(ndr, "sbz", r->sbz);
	ndr_print_nbt_server_type(ndr, "server_type", r->server_type);
	ndr_print_GUID(ndr, "domain_uuid", &r->domain_uuid);
	ndr_print_nbt_string(ndr, "forest", r->forest);
	ndr_print_nbt_string(ndr, "dns_domain", r->dns_domain);
	ndr_print_nbt_string(ndr, "pdc_dns_name", r->pdc_dns_name);
	ndr_print_nbt_string(ndr, "domain", r->domain);
	ndr_print_nbt_string(ndr, "pdc_name", r->pdc_name);
	ndr_print_nbt_string(ndr, "user_name", r->user_name);
	ndr_print_nbt_string(ndr, "server_site", r->server_site);
	ndr_print_nbt_string(ndr, "client_site", r->client_site);
	ndr_print_uint8(ndr, "dc_sock_addr_size", r->dc_sock_addr_size);
	ndr_print_nbt_dc_sock_addr(ndr, "dc_sock_addr", &r->dc_sock_addr);
	ndr_print_nbt_string(ndr, "next_closest_site", r->next_closest_site);
	ndr_print_nbt_netlogon_version(ndr, "nt_version", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?29:r->nt_version);
	ndr_print_uint16(ndr, "lmnt_token", r->lmnt_token);
	ndr_print_uint16(ndr, "lm20_token", r->lm20_token);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_nbt_cldap_netlogon(struct ndr_push *ndr, int ndr_flags, const union nbt_cldap_netlogon *r)
{
	{
		uint32_t _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		if (ndr_flags & NDR_SCALARS) {
			int level = ndr_push_get_switch_value(ndr, r);
			switch (level) {
				case 0: {
					NDR_CHECK(ndr_push_nbt_cldap_netlogon_1(ndr, NDR_SCALARS, &r->logon1));
				break; }

				case 1: {
					NDR_CHECK(ndr_push_nbt_cldap_netlogon_1(ndr, NDR_SCALARS, &r->logon1));
				break; }

				case 2: {
					NDR_CHECK(ndr_push_nbt_cldap_netlogon_3(ndr, NDR_SCALARS, &r->logon3));
				break; }

				case 3: {
					NDR_CHECK(ndr_push_nbt_cldap_netlogon_3(ndr, NDR_SCALARS, &r->logon3));
				break; }

				case 4: {
					NDR_CHECK(ndr_push_nbt_cldap_netlogon_5(ndr, NDR_SCALARS, &r->logon5));
				break; }

				case 5: {
					NDR_CHECK(ndr_push_nbt_cldap_netlogon_5(ndr, NDR_SCALARS, &r->logon5));
				break; }

				case 6: {
					NDR_CHECK(ndr_push_nbt_cldap_netlogon_5(ndr, NDR_SCALARS, &r->logon5));
				break; }

				case 7: {
					NDR_CHECK(ndr_push_nbt_cldap_netlogon_5(ndr, NDR_SCALARS, &r->logon5));
				break; }

				case 8: {
					NDR_CHECK(ndr_push_nbt_cldap_netlogon_13(ndr, NDR_SCALARS, &r->logon13));
				break; }

				case 9: {
					NDR_CHECK(ndr_push_nbt_cldap_netlogon_13(ndr, NDR_SCALARS, &r->logon13));
				break; }

				case 10: {
					NDR_CHECK(ndr_push_nbt_cldap_netlogon_13(ndr, NDR_SCALARS, &r->logon13));
				break; }

				case 11: {
					NDR_CHECK(ndr_push_nbt_cldap_netlogon_13(ndr, NDR_SCALARS, &r->logon13));
				break; }

				case 12: {
					NDR_CHECK(ndr_push_nbt_cldap_netlogon_13(ndr, NDR_SCALARS, &r->logon13));
				break; }

				case 13: {
					NDR_CHECK(ndr_push_nbt_cldap_netlogon_13(ndr, NDR_SCALARS, &r->logon13));
				break; }

				case 14: {
					NDR_CHECK(ndr_push_nbt_cldap_netlogon_13(ndr, NDR_SCALARS, &r->logon13));
				break; }

				case 15: {
					NDR_CHECK(ndr_push_nbt_cldap_netlogon_13(ndr, NDR_SCALARS, &r->logon13));
				break; }

				case 16: {
					NDR_CHECK(ndr_push_nbt_cldap_netlogon_1(ndr, NDR_SCALARS, &r->logon1));
				break; }

				case 17: {
					NDR_CHECK(ndr_push_nbt_cldap_netlogon_1(ndr, NDR_SCALARS, &r->logon1));
				break; }

				case 18: {
					NDR_CHECK(ndr_push_nbt_cldap_netlogon_3(ndr, NDR_SCALARS, &r->logon3));
				break; }

				case 19: {
					NDR_CHECK(ndr_push_nbt_cldap_netlogon_3(ndr, NDR_SCALARS, &r->logon3));
				break; }

				case 20: {
					NDR_CHECK(ndr_push_nbt_cldap_netlogon_15(ndr, NDR_SCALARS, &r->logon15));
				break; }

				case 21: {
					NDR_CHECK(ndr_push_nbt_cldap_netlogon_15(ndr, NDR_SCALARS, &r->logon15));
				break; }

				case 22: {
					NDR_CHECK(ndr_push_nbt_cldap_netlogon_15(ndr, NDR_SCALARS, &r->logon15));
				break; }

				case 23: {
					NDR_CHECK(ndr_push_nbt_cldap_netlogon_15(ndr, NDR_SCALARS, &r->logon15));
				break; }

				case 24: {
					NDR_CHECK(ndr_push_nbt_cldap_netlogon_15(ndr, NDR_SCALARS, &r->logon15));
				break; }

				case 25: {
					NDR_CHECK(ndr_push_nbt_cldap_netlogon_15(ndr, NDR_SCALARS, &r->logon15));
				break; }

				case 26: {
					NDR_CHECK(ndr_push_nbt_cldap_netlogon_15(ndr, NDR_SCALARS, &r->logon15));
				break; }

				case 27: {
					NDR_CHECK(ndr_push_nbt_cldap_netlogon_15(ndr, NDR_SCALARS, &r->logon15));
				break; }

				case 28: {
					NDR_CHECK(ndr_push_nbt_cldap_netlogon_15(ndr, NDR_SCALARS, &r->logon15));
				break; }

				case 29: {
					NDR_CHECK(ndr_push_nbt_cldap_netlogon_29(ndr, NDR_SCALARS, &r->logon29));
				break; }

				case 30: {
					NDR_CHECK(ndr_push_nbt_cldap_netlogon_29(ndr, NDR_SCALARS, &r->logon29));
				break; }

				case 31: {
					NDR_CHECK(ndr_push_nbt_cldap_netlogon_29(ndr, NDR_SCALARS, &r->logon29));
				break; }

				default:
					return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
			}
		}
		if (ndr_flags & NDR_BUFFERS) {
			int level = ndr_push_get_switch_value(ndr, r);
			switch (level) {
				case 0:
				break;

				case 1:
				break;

				case 2:
				break;

				case 3:
				break;

				case 4:
				break;

				case 5:
				break;

				case 6:
				break;

				case 7:
				break;

				case 8:
				break;

				case 9:
				break;

				case 10:
				break;

				case 11:
				break;

				case 12:
				break;

				case 13:
				break;

				case 14:
				break;

				case 15:
				break;

				case 16:
				break;

				case 17:
				break;

				case 18:
				break;

				case 19:
				break;

				case 20:
				break;

				case 21:
				break;

				case 22:
				break;

				case 23:
				break;

				case 24:
				break;

				case 25:
				break;

				case 26:
				break;

				case 27:
				break;

				case 28:
				break;

				case 29:
				break;

				case 30:
				break;

				case 31:
				break;

				default:
					return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
			}
		}
		ndr->flags = _flags_save_UNION;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_nbt_cldap_netlogon(struct ndr_pull *ndr, int ndr_flags, union nbt_cldap_netlogon *r)
{
	int level;
	{
		uint32_t _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		level = ndr_pull_get_switch_value(ndr, r);
		if (ndr_flags & NDR_SCALARS) {
			switch (level) {
				case 0: {
					NDR_CHECK(ndr_pull_nbt_cldap_netlogon_1(ndr, NDR_SCALARS, &r->logon1));
				break; }

				case 1: {
					NDR_CHECK(ndr_pull_nbt_cldap_netlogon_1(ndr, NDR_SCALARS, &r->logon1));
				break; }

				case 2: {
					NDR_CHECK(ndr_pull_nbt_cldap_netlogon_3(ndr, NDR_SCALARS, &r->logon3));
				break; }

				case 3: {
					NDR_CHECK(ndr_pull_nbt_cldap_netlogon_3(ndr, NDR_SCALARS, &r->logon3));
				break; }

				case 4: {
					NDR_CHECK(ndr_pull_nbt_cldap_netlogon_5(ndr, NDR_SCALARS, &r->logon5));
				break; }

				case 5: {
					NDR_CHECK(ndr_pull_nbt_cldap_netlogon_5(ndr, NDR_SCALARS, &r->logon5));
				break; }

				case 6: {
					NDR_CHECK(ndr_pull_nbt_cldap_netlogon_5(ndr, NDR_SCALARS, &r->logon5));
				break; }

				case 7: {
					NDR_CHECK(ndr_pull_nbt_cldap_netlogon_5(ndr, NDR_SCALARS, &r->logon5));
				break; }

				case 8: {
					NDR_CHECK(ndr_pull_nbt_cldap_netlogon_13(ndr, NDR_SCALARS, &r->logon13));
				break; }

				case 9: {
					NDR_CHECK(ndr_pull_nbt_cldap_netlogon_13(ndr, NDR_SCALARS, &r->logon13));
				break; }

				case 10: {
					NDR_CHECK(ndr_pull_nbt_cldap_netlogon_13(ndr, NDR_SCALARS, &r->logon13));
				break; }

				case 11: {
					NDR_CHECK(ndr_pull_nbt_cldap_netlogon_13(ndr, NDR_SCALARS, &r->logon13));
				break; }

				case 12: {
					NDR_CHECK(ndr_pull_nbt_cldap_netlogon_13(ndr, NDR_SCALARS, &r->logon13));
				break; }

				case 13: {
					NDR_CHECK(ndr_pull_nbt_cldap_netlogon_13(ndr, NDR_SCALARS, &r->logon13));
				break; }

				case 14: {
					NDR_CHECK(ndr_pull_nbt_cldap_netlogon_13(ndr, NDR_SCALARS, &r->logon13));
				break; }

				case 15: {
					NDR_CHECK(ndr_pull_nbt_cldap_netlogon_13(ndr, NDR_SCALARS, &r->logon13));
				break; }

				case 16: {
					NDR_CHECK(ndr_pull_nbt_cldap_netlogon_1(ndr, NDR_SCALARS, &r->logon1));
				break; }

				case 17: {
					NDR_CHECK(ndr_pull_nbt_cldap_netlogon_1(ndr, NDR_SCALARS, &r->logon1));
				break; }

				case 18: {
					NDR_CHECK(ndr_pull_nbt_cldap_netlogon_3(ndr, NDR_SCALARS, &r->logon3));
				break; }

				case 19: {
					NDR_CHECK(ndr_pull_nbt_cldap_netlogon_3(ndr, NDR_SCALARS, &r->logon3));
				break; }

				case 20: {
					NDR_CHECK(ndr_pull_nbt_cldap_netlogon_15(ndr, NDR_SCALARS, &r->logon15));
				break; }

				case 21: {
					NDR_CHECK(ndr_pull_nbt_cldap_netlogon_15(ndr, NDR_SCALARS, &r->logon15));
				break; }

				case 22: {
					NDR_CHECK(ndr_pull_nbt_cldap_netlogon_15(ndr, NDR_SCALARS, &r->logon15));
				break; }

				case 23: {
					NDR_CHECK(ndr_pull_nbt_cldap_netlogon_15(ndr, NDR_SCALARS, &r->logon15));
				break; }

				case 24: {
					NDR_CHECK(ndr_pull_nbt_cldap_netlogon_15(ndr, NDR_SCALARS, &r->logon15));
				break; }

				case 25: {
					NDR_CHECK(ndr_pull_nbt_cldap_netlogon_15(ndr, NDR_SCALARS, &r->logon15));
				break; }

				case 26: {
					NDR_CHECK(ndr_pull_nbt_cldap_netlogon_15(ndr, NDR_SCALARS, &r->logon15));
				break; }

				case 27: {
					NDR_CHECK(ndr_pull_nbt_cldap_netlogon_15(ndr, NDR_SCALARS, &r->logon15));
				break; }

				case 28: {
					NDR_CHECK(ndr_pull_nbt_cldap_netlogon_15(ndr, NDR_SCALARS, &r->logon15));
				break; }

				case 29: {
					NDR_CHECK(ndr_pull_nbt_cldap_netlogon_29(ndr, NDR_SCALARS, &r->logon29));
				break; }

				case 30: {
					NDR_CHECK(ndr_pull_nbt_cldap_netlogon_29(ndr, NDR_SCALARS, &r->logon29));
				break; }

				case 31: {
					NDR_CHECK(ndr_pull_nbt_cldap_netlogon_29(ndr, NDR_SCALARS, &r->logon29));
				break; }

				default:
					return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
			}
		}
		if (ndr_flags & NDR_BUFFERS) {
			switch (level) {
				case 0:
				break;

				case 1:
				break;

				case 2:
				break;

				case 3:
				break;

				case 4:
				break;

				case 5:
				break;

				case 6:
				break;

				case 7:
				break;

				case 8:
				break;

				case 9:
				break;

				case 10:
				break;

				case 11:
				break;

				case 12:
				break;

				case 13:
				break;

				case 14:
				break;

				case 15:
				break;

				case 16:
				break;

				case 17:
				break;

				case 18:
				break;

				case 19:
				break;

				case 20:
				break;

				case 21:
				break;

				case 22:
				break;

				case 23:
				break;

				case 24:
				break;

				case 25:
				break;

				case 26:
				break;

				case 27:
				break;

				case 28:
				break;

				case 29:
				break;

				case 30:
				break;

				case 31:
				break;

				default:
					return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
			}
		}
		ndr->flags = _flags_save_UNION;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_cldap_netlogon(struct ndr_print *ndr, const char *name, const union nbt_cldap_netlogon *r)
{
	int level;
	{
		uint32_t _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		level = ndr_print_get_switch_value(ndr, r);
		ndr_print_union(ndr, name, level, "nbt_cldap_netlogon");
		switch (level) {
			case 0:
				ndr_print_nbt_cldap_netlogon_1(ndr, "logon1", &r->logon1);
			break;

			case 1:
				ndr_print_nbt_cldap_netlogon_1(ndr, "logon1", &r->logon1);
			break;

			case 2:
				ndr_print_nbt_cldap_netlogon_3(ndr, "logon3", &r->logon3);
			break;

			case 3:
				ndr_print_nbt_cldap_netlogon_3(ndr, "logon3", &r->logon3);
			break;

			case 4:
				ndr_print_nbt_cldap_netlogon_5(ndr, "logon5", &r->logon5);
			break;

			case 5:
				ndr_print_nbt_cldap_netlogon_5(ndr, "logon5", &r->logon5);
			break;

			case 6:
				ndr_print_nbt_cldap_netlogon_5(ndr, "logon5", &r->logon5);
			break;

			case 7:
				ndr_print_nbt_cldap_netlogon_5(ndr, "logon5", &r->logon5);
			break;

			case 8:
				ndr_print_nbt_cldap_netlogon_13(ndr, "logon13", &r->logon13);
			break;

			case 9:
				ndr_print_nbt_cldap_netlogon_13(ndr, "logon13", &r->logon13);
			break;

			case 10:
				ndr_print_nbt_cldap_netlogon_13(ndr, "logon13", &r->logon13);
			break;

			case 11:
				ndr_print_nbt_cldap_netlogon_13(ndr, "logon13", &r->logon13);
			break;

			case 12:
				ndr_print_nbt_cldap_netlogon_13(ndr, "logon13", &r->logon13);
			break;

			case 13:
				ndr_print_nbt_cldap_netlogon_13(ndr, "logon13", &r->logon13);
			break;

			case 14:
				ndr_print_nbt_cldap_netlogon_13(ndr, "logon13", &r->logon13);
			break;

			case 15:
				ndr_print_nbt_cldap_netlogon_13(ndr, "logon13", &r->logon13);
			break;

			case 16:
				ndr_print_nbt_cldap_netlogon_1(ndr, "logon1", &r->logon1);
			break;

			case 17:
				ndr_print_nbt_cldap_netlogon_1(ndr, "logon1", &r->logon1);
			break;

			case 18:
				ndr_print_nbt_cldap_netlogon_3(ndr, "logon3", &r->logon3);
			break;

			case 19:
				ndr_print_nbt_cldap_netlogon_3(ndr, "logon3", &r->logon3);
			break;

			case 20:
				ndr_print_nbt_cldap_netlogon_15(ndr, "logon15", &r->logon15);
			break;

			case 21:
				ndr_print_nbt_cldap_netlogon_15(ndr, "logon15", &r->logon15);
			break;

			case 22:
				ndr_print_nbt_cldap_netlogon_15(ndr, "logon15", &r->logon15);
			break;

			case 23:
				ndr_print_nbt_cldap_netlogon_15(ndr, "logon15", &r->logon15);
			break;

			case 24:
				ndr_print_nbt_cldap_netlogon_15(ndr, "logon15", &r->logon15);
			break;

			case 25:
				ndr_print_nbt_cldap_netlogon_15(ndr, "logon15", &r->logon15);
			break;

			case 26:
				ndr_print_nbt_cldap_netlogon_15(ndr, "logon15", &r->logon15);
			break;

			case 27:
				ndr_print_nbt_cldap_netlogon_15(ndr, "logon15", &r->logon15);
			break;

			case 28:
				ndr_print_nbt_cldap_netlogon_15(ndr, "logon15", &r->logon15);
			break;

			case 29:
				ndr_print_nbt_cldap_netlogon_29(ndr, "logon29", &r->logon29);
			break;

			case 30:
				ndr_print_nbt_cldap_netlogon_29(ndr, "logon29", &r->logon29);
			break;

			case 31:
				ndr_print_nbt_cldap_netlogon_29(ndr, "logon29", &r->logon29);
			break;

			default:
				ndr_print_bad_level(ndr, name, level);
		}
		ndr->flags = _flags_save_UNION;
	}
}

static enum ndr_err_code ndr_push_nbt_ntlogon_command(struct ndr_push *ndr, int ndr_flags, enum nbt_ntlogon_command r)
{
	NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_ntlogon_command(struct ndr_pull *ndr, int ndr_flags, enum nbt_ntlogon_command *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_ntlogon_command(struct ndr_print *ndr, const char *name, enum nbt_ntlogon_command r)
{
	const char *val = NULL;

	switch (r) {
		case NTLOGON_SAM_LOGON: val = "NTLOGON_SAM_LOGON"; break;
		case NTLOGON_SAM_LOGON_REPLY: val = "NTLOGON_SAM_LOGON_REPLY"; break;
		case NTLOGON_SAM_LOGON_REPLY15: val = "NTLOGON_SAM_LOGON_REPLY15"; break;
		case NTLOGON_RESPONSE_FROM_PDC2: val = "NTLOGON_RESPONSE_FROM_PDC2"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_nbt_ntlogon_sam_logon(struct ndr_push *ndr, int ndr_flags, const struct nbt_ntlogon_sam_logon *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->request_count));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->computer_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->user_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->mailslot_name));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_samr_AcctFlags(ndr, NDR_SCALARS, r->acct_control));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_dom_sid0(&r->sid, ndr->flags)));
		{
			struct ndr_push *_ndr_sid;
			NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_sid, 0, ndr_size_dom_sid0(&r->sid, ndr->flags)));
			NDR_CHECK(ndr_push_dom_sid0(_ndr_sid, NDR_SCALARS|NDR_BUFFERS, &r->sid));
			NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_sid, 0, ndr_size_dom_sid0(&r->sid, ndr->flags)));
		}
		NDR_CHECK(ndr_push_nbt_netlogon_version(ndr, NDR_SCALARS, r->nt_version));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->lmnt_token));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->lm20_token));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_ntlogon_sam_logon(struct ndr_pull *ndr, int ndr_flags, struct nbt_ntlogon_sam_logon *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->request_count));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->computer_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->user_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->mailslot_name));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_samr_AcctFlags(ndr, NDR_SCALARS, &r->acct_control));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sid_size));
		{
			struct ndr_pull *_ndr_sid;
			NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_sid, 0, r->sid_size));
			NDR_CHECK(ndr_pull_dom_sid0(_ndr_sid, NDR_SCALARS|NDR_BUFFERS, &r->sid));
			NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_sid, 0, r->sid_size));
		}
		NDR_CHECK(ndr_pull_nbt_netlogon_version(ndr, NDR_SCALARS, &r->nt_version));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->lmnt_token));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->lm20_token));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_ntlogon_sam_logon(struct ndr_print *ndr, const char *name, const struct nbt_ntlogon_sam_logon *r)
{
	ndr_print_struct(ndr, name, "nbt_ntlogon_sam_logon");
	ndr->depth++;
	ndr_print_uint16(ndr, "request_count", r->request_count);
	ndr_print_string(ndr, "computer_name", r->computer_name);
	ndr_print_string(ndr, "user_name", r->user_name);
	ndr_print_string(ndr, "mailslot_name", r->mailslot_name);
	ndr_print_samr_AcctFlags(ndr, "acct_control", r->acct_control);
	ndr_print_uint32(ndr, "sid_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_dom_sid0(&r->sid, ndr->flags):r->sid_size);
	ndr_print_dom_sid0(ndr, "sid", &r->sid);
	ndr_print_nbt_netlogon_version(ndr, "nt_version", r->nt_version);
	ndr_print_uint16(ndr, "lmnt_token", r->lmnt_token);
	ndr_print_uint16(ndr, "lm20_token", r->lm20_token);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbt_ntlogon_sam_logon_reply(struct ndr_push *ndr, int ndr_flags, const struct nbt_ntlogon_sam_logon_reply *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->server));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->user_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->domain));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_nbt_netlogon_version(ndr, NDR_SCALARS, r->nt_version));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->lmnt_token));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->lm20_token));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_ntlogon_sam_logon_reply(struct ndr_pull *ndr, int ndr_flags, struct nbt_ntlogon_sam_logon_reply *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->server));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->user_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->domain));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_nbt_netlogon_version(ndr, NDR_SCALARS, &r->nt_version));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->lmnt_token));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->lm20_token));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_ntlogon_sam_logon_reply(struct ndr_print *ndr, const char *name, const struct nbt_ntlogon_sam_logon_reply *r)
{
	ndr_print_struct(ndr, name, "nbt_ntlogon_sam_logon_reply");
	ndr->depth++;
	ndr_print_string(ndr, "server", r->server);
	ndr_print_string(ndr, "user_name", r->user_name);
	ndr_print_string(ndr, "domain", r->domain);
	ndr_print_nbt_netlogon_version(ndr, "nt_version", r->nt_version);
	ndr_print_uint16(ndr, "lmnt_token", r->lmnt_token);
	ndr_print_uint16(ndr, "lm20_token", r->lm20_token);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbt_ntlogon_request(struct ndr_push *ndr, int ndr_flags, const union nbt_ntlogon_request *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case NTLOGON_SAM_LOGON: {
				NDR_CHECK(ndr_push_nbt_ntlogon_sam_logon(ndr, NDR_SCALARS, &r->logon));
			break; }

			case NTLOGON_SAM_LOGON_REPLY: {
				NDR_CHECK(ndr_push_nbt_ntlogon_sam_logon_reply(ndr, NDR_SCALARS, &r->reply));
			break; }

			case NTLOGON_SAM_LOGON_REPLY15: {
				NDR_CHECK(ndr_push_nbt_ntlogon_sam_logon_reply(ndr, NDR_SCALARS, &r->reply));
			break; }

			case NTLOGON_RESPONSE_FROM_PDC2: {
				NDR_CHECK(ndr_push_nbt_netlogon_response_from_pdc2(ndr, NDR_SCALARS, &r->reply2));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case NTLOGON_SAM_LOGON:
				NDR_CHECK(ndr_push_nbt_ntlogon_sam_logon(ndr, NDR_BUFFERS, &r->logon));
			break;

			case NTLOGON_SAM_LOGON_REPLY:
			break;

			case NTLOGON_SAM_LOGON_REPLY15:
			break;

			case NTLOGON_RESPONSE_FROM_PDC2:
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_ntlogon_request(struct ndr_pull *ndr, int ndr_flags, union nbt_ntlogon_request *r)
{
	int level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		switch (level) {
			case NTLOGON_SAM_LOGON: {
				NDR_CHECK(ndr_pull_nbt_ntlogon_sam_logon(ndr, NDR_SCALARS, &r->logon));
			break; }

			case NTLOGON_SAM_LOGON_REPLY: {
				NDR_CHECK(ndr_pull_nbt_ntlogon_sam_logon_reply(ndr, NDR_SCALARS, &r->reply));
			break; }

			case NTLOGON_SAM_LOGON_REPLY15: {
				NDR_CHECK(ndr_pull_nbt_ntlogon_sam_logon_reply(ndr, NDR_SCALARS, &r->reply));
			break; }

			case NTLOGON_RESPONSE_FROM_PDC2: {
				NDR_CHECK(ndr_pull_nbt_netlogon_response_from_pdc2(ndr, NDR_SCALARS, &r->reply2));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case NTLOGON_SAM_LOGON:
				NDR_CHECK(ndr_pull_nbt_ntlogon_sam_logon(ndr, NDR_BUFFERS, &r->logon));
			break;

			case NTLOGON_SAM_LOGON_REPLY:
			break;

			case NTLOGON_SAM_LOGON_REPLY15:
			break;

			case NTLOGON_RESPONSE_FROM_PDC2:
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_ntlogon_request(struct ndr_print *ndr, const char *name, const union nbt_ntlogon_request *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "nbt_ntlogon_request");
	switch (level) {
		case NTLOGON_SAM_LOGON:
			ndr_print_nbt_ntlogon_sam_logon(ndr, "logon", &r->logon);
		break;

		case NTLOGON_SAM_LOGON_REPLY:
			ndr_print_nbt_ntlogon_sam_logon_reply(ndr, "reply", &r->reply);
		break;

		case NTLOGON_SAM_LOGON_REPLY15:
			ndr_print_nbt_ntlogon_sam_logon_reply(ndr, "reply", &r->reply);
		break;

		case NTLOGON_RESPONSE_FROM_PDC2:
			ndr_print_nbt_netlogon_response_from_pdc2(ndr, "reply2", &r->reply2);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_nbt_ntlogon_packet(struct ndr_push *ndr, int ndr_flags, const struct nbt_ntlogon_packet *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_nbt_ntlogon_command(ndr, NDR_SCALARS, r->command));
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->req, r->command));
			NDR_CHECK(ndr_push_nbt_ntlogon_request(ndr, NDR_SCALARS, &r->req));
		}
		if (ndr_flags & NDR_BUFFERS) {
			NDR_CHECK(ndr_push_nbt_ntlogon_request(ndr, NDR_BUFFERS, &r->req));
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_nbt_ntlogon_packet(struct ndr_pull *ndr, int ndr_flags, struct nbt_ntlogon_packet *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_nbt_ntlogon_command(ndr, NDR_SCALARS, &r->command));
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->req, r->command));
			NDR_CHECK(ndr_pull_nbt_ntlogon_request(ndr, NDR_SCALARS, &r->req));
		}
		if (ndr_flags & NDR_BUFFERS) {
			NDR_CHECK(ndr_pull_nbt_ntlogon_request(ndr, NDR_BUFFERS, &r->req));
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_ntlogon_packet(struct ndr_print *ndr, const char *name, const struct nbt_ntlogon_packet *r)
{
	ndr_print_struct(ndr, name, "nbt_ntlogon_packet");
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		ndr->depth++;
		ndr_print_nbt_ntlogon_command(ndr, "command", r->command);
		ndr_print_set_switch_value(ndr, &r->req, r->command);
		ndr_print_nbt_ntlogon_request(ndr, "req", &r->req);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static enum ndr_err_code ndr_push_nbt_browse_opcode(struct ndr_push *ndr, int ndr_flags, enum nbt_browse_opcode r)
{
	NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_browse_opcode(struct ndr_pull *ndr, int ndr_flags, enum nbt_browse_opcode *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_browse_opcode(struct ndr_print *ndr, const char *name, enum nbt_browse_opcode r)
{
	const char *val = NULL;

	switch (r) {
		case HostAnnouncement: val = "HostAnnouncement"; break;
		case AnnouncementRequest: val = "AnnouncementRequest"; break;
		case Election: val = "Election"; break;
		case GetBackupListReq: val = "GetBackupListReq"; break;
		case GetBackupListResp: val = "GetBackupListResp"; break;
		case BecomeBackup: val = "BecomeBackup"; break;
		case DomainAnnouncement: val = "DomainAnnouncement"; break;
		case MasterAnnouncement: val = "MasterAnnouncement"; break;
		case ResetBrowserState: val = "ResetBrowserState"; break;
		case LocalMasterAnnouncement: val = "LocalMasterAnnouncement"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_nbt_browse_host_announcement(struct ndr_push *ndr, int ndr_flags, const struct nbt_browse_host_announcement *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->UpdateCount));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->Periodicity));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->ServerName, 16, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->OSMajor));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->OSMinor));
		NDR_CHECK(ndr_push_svcctl_ServerType(ndr, NDR_SCALARS, r->ServerType));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->BroMajorVer));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->BroMinorVer));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->Signature));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->Comment));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_browse_host_announcement(struct ndr_pull *ndr, int ndr_flags, struct nbt_browse_host_announcement *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->UpdateCount));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->Periodicity));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->ServerName, 16, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->OSMajor));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->OSMinor));
		NDR_CHECK(ndr_pull_svcctl_ServerType(ndr, NDR_SCALARS, &r->ServerType));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->BroMajorVer));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->BroMinorVer));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->Signature));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->Comment));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_browse_host_announcement(struct ndr_print *ndr, const char *name, const struct nbt_browse_host_announcement *r)
{
	ndr_print_struct(ndr, name, "nbt_browse_host_announcement");
	ndr->depth++;
	ndr_print_uint8(ndr, "UpdateCount", r->UpdateCount);
	ndr_print_uint32(ndr, "Periodicity", r->Periodicity);
	ndr_print_string(ndr, "ServerName", r->ServerName);
	ndr_print_uint8(ndr, "OSMajor", r->OSMajor);
	ndr_print_uint8(ndr, "OSMinor", r->OSMinor);
	ndr_print_svcctl_ServerType(ndr, "ServerType", r->ServerType);
	ndr_print_uint8(ndr, "BroMajorVer", r->BroMajorVer);
	ndr_print_uint8(ndr, "BroMinorVer", r->BroMinorVer);
	ndr_print_uint16(ndr, "Signature", r->Signature);
	ndr_print_string(ndr, "Comment", r->Comment);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbt_browse_announcement_request(struct ndr_push *ndr, int ndr_flags, const struct nbt_browse_announcement_request *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->Unused));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->ResponseName));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_browse_announcement_request(struct ndr_pull *ndr, int ndr_flags, struct nbt_browse_announcement_request *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->Unused));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->ResponseName));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_browse_announcement_request(struct ndr_print *ndr, const char *name, const struct nbt_browse_announcement_request *r)
{
	ndr_print_struct(ndr, name, "nbt_browse_announcement_request");
	ndr->depth++;
	ndr_print_uint8(ndr, "Unused", r->Unused);
	ndr_print_string(ndr, "ResponseName", r->ResponseName);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbt_browse_election_request(struct ndr_push *ndr, int ndr_flags, const struct nbt_browse_election_request *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->Version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->Criteria));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->UpTime));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->Reserved));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->ServerName));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_browse_election_request(struct ndr_pull *ndr, int ndr_flags, struct nbt_browse_election_request *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->Version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->Criteria));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->UpTime));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->Reserved));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->ServerName));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_browse_election_request(struct ndr_print *ndr, const char *name, const struct nbt_browse_election_request *r)
{
	ndr_print_struct(ndr, name, "nbt_browse_election_request");
	ndr->depth++;
	ndr_print_uint8(ndr, "Version", r->Version);
	ndr_print_uint32(ndr, "Criteria", r->Criteria);
	ndr_print_uint32(ndr, "UpTime", r->UpTime);
	ndr_print_uint32(ndr, "Reserved", r->Reserved);
	ndr_print_string(ndr, "ServerName", r->ServerName);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbt_browse_backup_list_request(struct ndr_push *ndr, int ndr_flags, const struct nbt_browse_backup_list_request *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->ReqCount));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->Token));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_browse_backup_list_request(struct ndr_pull *ndr, int ndr_flags, struct nbt_browse_backup_list_request *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->ReqCount));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->Token));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_browse_backup_list_request(struct ndr_print *ndr, const char *name, const struct nbt_browse_backup_list_request *r)
{
	ndr_print_struct(ndr, name, "nbt_browse_backup_list_request");
	ndr->depth++;
	ndr_print_uint8(ndr, "ReqCount", r->ReqCount);
	ndr_print_uint32(ndr, "Token", r->Token);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbt_browse_backup_list_response(struct ndr_push *ndr, int ndr_flags, const struct nbt_browse_backup_list_response *r)
{
	uint32_t cntr_BackupServerList_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->BackupCount));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->Token));
		for (cntr_BackupServerList_0 = 0; cntr_BackupServerList_0 < r->BackupCount; cntr_BackupServerList_0++) {
			NDR_CHECK(ndr_push_nbt_name(ndr, NDR_SCALARS, &r->BackupServerList[cntr_BackupServerList_0]));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_browse_backup_list_response(struct ndr_pull *ndr, int ndr_flags, struct nbt_browse_backup_list_response *r)
{
	uint32_t cntr_BackupServerList_0;
	TALLOC_CTX *_mem_save_BackupServerList_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->BackupCount));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->Token));
		NDR_PULL_ALLOC_N(ndr, r->BackupServerList, r->BackupCount);
		_mem_save_BackupServerList_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->BackupServerList, 0);
		for (cntr_BackupServerList_0 = 0; cntr_BackupServerList_0 < r->BackupCount; cntr_BackupServerList_0++) {
			NDR_CHECK(ndr_pull_nbt_name(ndr, NDR_SCALARS, &r->BackupServerList[cntr_BackupServerList_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_BackupServerList_0, 0);
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_browse_backup_list_response(struct ndr_print *ndr, const char *name, const struct nbt_browse_backup_list_response *r)
{
	uint32_t cntr_BackupServerList_0;
	ndr_print_struct(ndr, name, "nbt_browse_backup_list_response");
	ndr->depth++;
	ndr_print_uint8(ndr, "BackupCount", r->BackupCount);
	ndr_print_uint32(ndr, "Token", r->Token);
	ndr->print(ndr, "%s: ARRAY(%d)", "BackupServerList", r->BackupCount);
	ndr->depth++;
	for (cntr_BackupServerList_0=0;cntr_BackupServerList_0<r->BackupCount;cntr_BackupServerList_0++) {
		char *idx_0=NULL;
		if (asprintf(&idx_0, "[%d]", cntr_BackupServerList_0) != -1) {
			ndr_print_nbt_name(ndr, "BackupServerList", &r->BackupServerList[cntr_BackupServerList_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbt_browse_become_backup(struct ndr_push *ndr, int ndr_flags, const struct nbt_browse_become_backup *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->BrowserName));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_browse_become_backup(struct ndr_pull *ndr, int ndr_flags, struct nbt_browse_become_backup *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->BrowserName));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_browse_become_backup(struct ndr_print *ndr, const char *name, const struct nbt_browse_become_backup *r)
{
	ndr_print_struct(ndr, name, "nbt_browse_become_backup");
	ndr->depth++;
	ndr_print_string(ndr, "BrowserName", r->BrowserName);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbt_browse_domain_announcement(struct ndr_push *ndr, int ndr_flags, const struct nbt_browse_domain_announcement *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->UpdateCount));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->Periodicity));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->ServerName, 16, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->OSMajor));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->OSMinor));
		NDR_CHECK(ndr_push_svcctl_ServerType(ndr, NDR_SCALARS, r->ServerType));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->MysteriousField));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->Comment));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_browse_domain_announcement(struct ndr_pull *ndr, int ndr_flags, struct nbt_browse_domain_announcement *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->UpdateCount));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->Periodicity));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->ServerName, 16, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->OSMajor));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->OSMinor));
		NDR_CHECK(ndr_pull_svcctl_ServerType(ndr, NDR_SCALARS, &r->ServerType));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->MysteriousField));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->Comment));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_browse_domain_announcement(struct ndr_print *ndr, const char *name, const struct nbt_browse_domain_announcement *r)
{
	ndr_print_struct(ndr, name, "nbt_browse_domain_announcement");
	ndr->depth++;
	ndr_print_uint8(ndr, "UpdateCount", r->UpdateCount);
	ndr_print_uint32(ndr, "Periodicity", r->Periodicity);
	ndr_print_string(ndr, "ServerName", r->ServerName);
	ndr_print_uint8(ndr, "OSMajor", r->OSMajor);
	ndr_print_uint8(ndr, "OSMinor", r->OSMinor);
	ndr_print_svcctl_ServerType(ndr, "ServerType", r->ServerType);
	ndr_print_uint32(ndr, "MysteriousField", r->MysteriousField);
	ndr_print_string(ndr, "Comment", r->Comment);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbt_browse_master_announcement(struct ndr_push *ndr, int ndr_flags, const struct nbt_browse_master_announcement *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->ServerName));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_browse_master_announcement(struct ndr_pull *ndr, int ndr_flags, struct nbt_browse_master_announcement *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->ServerName));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_browse_master_announcement(struct ndr_print *ndr, const char *name, const struct nbt_browse_master_announcement *r)
{
	ndr_print_struct(ndr, name, "nbt_browse_master_announcement");
	ndr->depth++;
	ndr_print_string(ndr, "ServerName", r->ServerName);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbt_browse_reset_state(struct ndr_push *ndr, int ndr_flags, const struct nbt_browse_reset_state *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->Command));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_browse_reset_state(struct ndr_pull *ndr, int ndr_flags, struct nbt_browse_reset_state *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->Command));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_browse_reset_state(struct ndr_print *ndr, const char *name, const struct nbt_browse_reset_state *r)
{
	ndr_print_struct(ndr, name, "nbt_browse_reset_state");
	ndr->depth++;
	ndr_print_uint8(ndr, "Command", r->Command);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbt_browse_local_master_announcement(struct ndr_push *ndr, int ndr_flags, const struct nbt_browse_local_master_announcement *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->UpdateCount));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->Periodicity));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->ServerName, 16, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->OSMajor));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->OSMinor));
		NDR_CHECK(ndr_push_svcctl_ServerType(ndr, NDR_SCALARS, r->ServerType));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->BroMajorVer));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->BroMinorVer));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->Signature));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->Comment));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_browse_local_master_announcement(struct ndr_pull *ndr, int ndr_flags, struct nbt_browse_local_master_announcement *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->UpdateCount));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->Periodicity));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->ServerName, 16, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->OSMajor));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->OSMinor));
		NDR_CHECK(ndr_pull_svcctl_ServerType(ndr, NDR_SCALARS, &r->ServerType));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->BroMajorVer));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->BroMinorVer));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->Signature));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->Comment));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_browse_local_master_announcement(struct ndr_print *ndr, const char *name, const struct nbt_browse_local_master_announcement *r)
{
	ndr_print_struct(ndr, name, "nbt_browse_local_master_announcement");
	ndr->depth++;
	ndr_print_uint8(ndr, "UpdateCount", r->UpdateCount);
	ndr_print_uint32(ndr, "Periodicity", r->Periodicity);
	ndr_print_string(ndr, "ServerName", r->ServerName);
	ndr_print_uint8(ndr, "OSMajor", r->OSMajor);
	ndr_print_uint8(ndr, "OSMinor", r->OSMinor);
	ndr_print_svcctl_ServerType(ndr, "ServerType", r->ServerType);
	ndr_print_uint8(ndr, "BroMajorVer", r->BroMajorVer);
	ndr_print_uint8(ndr, "BroMinorVer", r->BroMinorVer);
	ndr_print_uint16(ndr, "Signature", r->Signature);
	ndr_print_string(ndr, "Comment", r->Comment);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_nbt_browse_payload(struct ndr_push *ndr, int ndr_flags, const union nbt_browse_payload *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case HostAnnouncement: {
				NDR_CHECK(ndr_push_nbt_browse_host_announcement(ndr, NDR_SCALARS, &r->host_annoucement));
			break; }

			case AnnouncementRequest: {
				NDR_CHECK(ndr_push_nbt_browse_announcement_request(ndr, NDR_SCALARS, &r->announcement_request));
			break; }

			case Election: {
				NDR_CHECK(ndr_push_nbt_browse_election_request(ndr, NDR_SCALARS, &r->election_request));
			break; }

			case GetBackupListReq: {
				NDR_CHECK(ndr_push_nbt_browse_backup_list_request(ndr, NDR_SCALARS, &r->backup_list_request));
			break; }

			case GetBackupListResp: {
				NDR_CHECK(ndr_push_nbt_browse_backup_list_response(ndr, NDR_SCALARS, &r->backup_list_response));
			break; }

			case BecomeBackup: {
				NDR_CHECK(ndr_push_nbt_browse_become_backup(ndr, NDR_SCALARS, &r->become_backup));
			break; }

			case DomainAnnouncement: {
				NDR_CHECK(ndr_push_nbt_browse_domain_announcement(ndr, NDR_SCALARS, &r->domain_announcement));
			break; }

			case MasterAnnouncement: {
				NDR_CHECK(ndr_push_nbt_browse_master_announcement(ndr, NDR_SCALARS, &r->master_announcement));
			break; }

			case ResetBrowserState: {
				NDR_CHECK(ndr_push_nbt_browse_reset_state(ndr, NDR_SCALARS, &r->reset_browser_state));
			break; }

			case LocalMasterAnnouncement: {
				NDR_CHECK(ndr_push_nbt_browse_local_master_announcement(ndr, NDR_SCALARS, &r->local_master_announcement));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case HostAnnouncement:
			break;

			case AnnouncementRequest:
			break;

			case Election:
			break;

			case GetBackupListReq:
			break;

			case GetBackupListResp:
			break;

			case BecomeBackup:
			break;

			case DomainAnnouncement:
			break;

			case MasterAnnouncement:
			break;

			case ResetBrowserState:
			break;

			case LocalMasterAnnouncement:
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_nbt_browse_payload(struct ndr_pull *ndr, int ndr_flags, union nbt_browse_payload *r)
{
	int level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		switch (level) {
			case HostAnnouncement: {
				NDR_CHECK(ndr_pull_nbt_browse_host_announcement(ndr, NDR_SCALARS, &r->host_annoucement));
			break; }

			case AnnouncementRequest: {
				NDR_CHECK(ndr_pull_nbt_browse_announcement_request(ndr, NDR_SCALARS, &r->announcement_request));
			break; }

			case Election: {
				NDR_CHECK(ndr_pull_nbt_browse_election_request(ndr, NDR_SCALARS, &r->election_request));
			break; }

			case GetBackupListReq: {
				NDR_CHECK(ndr_pull_nbt_browse_backup_list_request(ndr, NDR_SCALARS, &r->backup_list_request));
			break; }

			case GetBackupListResp: {
				NDR_CHECK(ndr_pull_nbt_browse_backup_list_response(ndr, NDR_SCALARS, &r->backup_list_response));
			break; }

			case BecomeBackup: {
				NDR_CHECK(ndr_pull_nbt_browse_become_backup(ndr, NDR_SCALARS, &r->become_backup));
			break; }

			case DomainAnnouncement: {
				NDR_CHECK(ndr_pull_nbt_browse_domain_announcement(ndr, NDR_SCALARS, &r->domain_announcement));
			break; }

			case MasterAnnouncement: {
				NDR_CHECK(ndr_pull_nbt_browse_master_announcement(ndr, NDR_SCALARS, &r->master_announcement));
			break; }

			case ResetBrowserState: {
				NDR_CHECK(ndr_pull_nbt_browse_reset_state(ndr, NDR_SCALARS, &r->reset_browser_state));
			break; }

			case LocalMasterAnnouncement: {
				NDR_CHECK(ndr_pull_nbt_browse_local_master_announcement(ndr, NDR_SCALARS, &r->local_master_announcement));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case HostAnnouncement:
			break;

			case AnnouncementRequest:
			break;

			case Election:
			break;

			case GetBackupListReq:
			break;

			case GetBackupListResp:
			break;

			case BecomeBackup:
			break;

			case DomainAnnouncement:
			break;

			case MasterAnnouncement:
			break;

			case ResetBrowserState:
			break;

			case LocalMasterAnnouncement:
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_browse_payload(struct ndr_print *ndr, const char *name, const union nbt_browse_payload *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "nbt_browse_payload");
	switch (level) {
		case HostAnnouncement:
			ndr_print_nbt_browse_host_announcement(ndr, "host_annoucement", &r->host_annoucement);
		break;

		case AnnouncementRequest:
			ndr_print_nbt_browse_announcement_request(ndr, "announcement_request", &r->announcement_request);
		break;

		case Election:
			ndr_print_nbt_browse_election_request(ndr, "election_request", &r->election_request);
		break;

		case GetBackupListReq:
			ndr_print_nbt_browse_backup_list_request(ndr, "backup_list_request", &r->backup_list_request);
		break;

		case GetBackupListResp:
			ndr_print_nbt_browse_backup_list_response(ndr, "backup_list_response", &r->backup_list_response);
		break;

		case BecomeBackup:
			ndr_print_nbt_browse_become_backup(ndr, "become_backup", &r->become_backup);
		break;

		case DomainAnnouncement:
			ndr_print_nbt_browse_domain_announcement(ndr, "domain_announcement", &r->domain_announcement);
		break;

		case MasterAnnouncement:
			ndr_print_nbt_browse_master_announcement(ndr, "master_announcement", &r->master_announcement);
		break;

		case ResetBrowserState:
			ndr_print_nbt_browse_reset_state(ndr, "reset_browser_state", &r->reset_browser_state);
		break;

		case LocalMasterAnnouncement:
			ndr_print_nbt_browse_local_master_announcement(ndr, "local_master_announcement", &r->local_master_announcement);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_nbt_browse_packet(struct ndr_push *ndr, int ndr_flags, const struct nbt_browse_packet *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_nbt_browse_opcode(ndr, NDR_SCALARS, r->opcode));
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->payload, r->opcode));
			NDR_CHECK(ndr_push_nbt_browse_payload(ndr, NDR_SCALARS, &r->payload));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_nbt_browse_packet(struct ndr_pull *ndr, int ndr_flags, struct nbt_browse_packet *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_nbt_browse_opcode(ndr, NDR_SCALARS, &r->opcode));
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->payload, r->opcode));
			NDR_CHECK(ndr_pull_nbt_browse_payload(ndr, NDR_SCALARS, &r->payload));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_nbt_browse_packet(struct ndr_print *ndr, const char *name, const struct nbt_browse_packet *r)
{
	ndr_print_struct(ndr, name, "nbt_browse_packet");
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		ndr->depth++;
		ndr_print_nbt_browse_opcode(ndr, "opcode", r->opcode);
		ndr_print_set_switch_value(ndr, &r->payload, r->opcode);
		ndr_print_nbt_browse_payload(ndr, "payload", &r->payload);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

