require 'rational'
require 'pp'

require 'test/unit'
require 'rbconfig'

class GcdTest < Test::Unit::TestCase

  @@biggest_positive_fixnum = 1
  until (x = ((@@biggest_positive_fixnum << 1) + 1)).class == Bignum
    @@biggest_positive_fixnum = x
  end
  @@biggest_positive_fixnum = (@@biggest_positive_fixnum - 10)
  until (x = (@@biggest_positive_fixnum + 1)).class == Bignum
    @@biggest_positive_fixnum = x
  end
  @@smallest_positive_bignum = x
  
  @@biggest_negative_fixnum = -1
  until (x = (@@biggest_negative_fixnum << 1)).class == Bignum
    @@biggest_negative_fixnum = x
  end
  until (x = (@@biggest_negative_fixnum - 1)).class == Bignum
    @@biggest_negative_fixnum = x
  end
  @@smallest_negative_bignum = x
  
  def xc x
    [ x.class, x ].inspect
  end

case RbConfig::CONFIG['build_cpu']
when 'amd64', 'x86_64'
  # values generated by ruby 1.8.7 (2009-06-12 patchlevel 174) [x86_64-linux]
@@expected = 
[["[Fixnum, 1] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1] gcd [Fixnum, 2] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1] gcd [Fixnum, 4] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1] gcd [Fixnum, 5] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1] gcd [Fixnum, 25] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1] gcd [Fixnum, -2] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1] gcd [Fixnum, -4] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1] gcd [Fixnum, -5] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1] gcd [Fixnum, -25] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1] gcd [Fixnum, 4611686018427387903] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1] gcd [Fixnum, -4611686018427387903] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1] gcd [Fixnum, -4611686018427387904] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1] gcd [Bignum, 4611686018427387904] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1] gcd [Bignum, 4611686018427387904] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1] gcd [Fixnum, -4611686018427387904] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1] gcd [Bignum, -4611686018427387905] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1] gcd [Bignum, 4611686018427387905] => ", "[Fixnum, 1]"],
 ["[Fixnum, 2] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Fixnum, 2] gcd [Fixnum, 2] => ", "[Fixnum, 2]"],
 ["[Fixnum, 2] gcd [Fixnum, 4] => ", "[Fixnum, 2]"],
 ["[Fixnum, 2] gcd [Fixnum, 5] => ", "[Fixnum, 1]"],
 ["[Fixnum, 2] gcd [Fixnum, 25] => ", "[Fixnum, 1]"],
 ["[Fixnum, 2] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Fixnum, 2] gcd [Fixnum, -2] => ", "[Fixnum, 2]"],
 ["[Fixnum, 2] gcd [Fixnum, -4] => ", "[Fixnum, 2]"],
 ["[Fixnum, 2] gcd [Fixnum, -5] => ", "[Fixnum, 1]"],
 ["[Fixnum, 2] gcd [Fixnum, -25] => ", "[Fixnum, 1]"],
 ["[Fixnum, 2] gcd [Fixnum, 4611686018427387903] => ", "[Fixnum, 1]"],
 ["[Fixnum, 2] gcd [Fixnum, -4611686018427387903] => ", "[Fixnum, 1]"],
 ["[Fixnum, 2] gcd [Fixnum, -4611686018427387904] => ", "[Fixnum, 2]"],
 ["[Fixnum, 2] gcd [Bignum, 4611686018427387904] => ", "[Fixnum, 2]"],
 ["[Fixnum, 2] gcd [Bignum, 4611686018427387904] => ", "[Fixnum, 2]"],
 ["[Fixnum, 2] gcd [Fixnum, -4611686018427387904] => ", "[Fixnum, 2]"],
 ["[Fixnum, 2] gcd [Bignum, -4611686018427387905] => ", "[Fixnum, 1]"],
 ["[Fixnum, 2] gcd [Bignum, 4611686018427387905] => ", "[Fixnum, 1]"],
 ["[Fixnum, 4] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Fixnum, 4] gcd [Fixnum, 2] => ", "[Fixnum, 2]"],
 ["[Fixnum, 4] gcd [Fixnum, 4] => ", "[Fixnum, 4]"],
 ["[Fixnum, 4] gcd [Fixnum, 5] => ", "[Fixnum, 1]"],
 ["[Fixnum, 4] gcd [Fixnum, 25] => ", "[Fixnum, 1]"],
 ["[Fixnum, 4] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Fixnum, 4] gcd [Fixnum, -2] => ", "[Fixnum, 2]"],
 ["[Fixnum, 4] gcd [Fixnum, -4] => ", "[Fixnum, 4]"],
 ["[Fixnum, 4] gcd [Fixnum, -5] => ", "[Fixnum, 1]"],
 ["[Fixnum, 4] gcd [Fixnum, -25] => ", "[Fixnum, 1]"],
 ["[Fixnum, 4] gcd [Fixnum, 4611686018427387903] => ", "[Fixnum, 1]"],
 ["[Fixnum, 4] gcd [Fixnum, -4611686018427387903] => ", "[Fixnum, 1]"],
 ["[Fixnum, 4] gcd [Fixnum, -4611686018427387904] => ", "[Fixnum, 4]"],
 ["[Fixnum, 4] gcd [Bignum, 4611686018427387904] => ", "[Fixnum, 4]"],
 ["[Fixnum, 4] gcd [Bignum, 4611686018427387904] => ", "[Fixnum, 4]"],
 ["[Fixnum, 4] gcd [Fixnum, -4611686018427387904] => ", "[Fixnum, 4]"],
 ["[Fixnum, 4] gcd [Bignum, -4611686018427387905] => ", "[Fixnum, 1]"],
 ["[Fixnum, 4] gcd [Bignum, 4611686018427387905] => ", "[Fixnum, 1]"],
 ["[Fixnum, 5] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Fixnum, 5] gcd [Fixnum, 2] => ", "[Fixnum, 1]"],
 ["[Fixnum, 5] gcd [Fixnum, 4] => ", "[Fixnum, 1]"],
 ["[Fixnum, 5] gcd [Fixnum, 5] => ", "[Fixnum, 5]"],
 ["[Fixnum, 5] gcd [Fixnum, 25] => ", "[Fixnum, 5]"],
 ["[Fixnum, 5] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Fixnum, 5] gcd [Fixnum, -2] => ", "[Fixnum, 1]"],
 ["[Fixnum, 5] gcd [Fixnum, -4] => ", "[Fixnum, 1]"],
 ["[Fixnum, 5] gcd [Fixnum, -5] => ", "[Fixnum, 5]"],
 ["[Fixnum, 5] gcd [Fixnum, -25] => ", "[Fixnum, 5]"],
 ["[Fixnum, 5] gcd [Fixnum, 4611686018427387903] => ", "[Fixnum, 1]"],
 ["[Fixnum, 5] gcd [Fixnum, -4611686018427387903] => ", "[Fixnum, 1]"],
 ["[Fixnum, 5] gcd [Fixnum, -4611686018427387904] => ", "[Fixnum, 1]"],
 ["[Fixnum, 5] gcd [Bignum, 4611686018427387904] => ", "[Fixnum, 1]"],
 ["[Fixnum, 5] gcd [Bignum, 4611686018427387904] => ", "[Fixnum, 1]"],
 ["[Fixnum, 5] gcd [Fixnum, -4611686018427387904] => ", "[Fixnum, 1]"],
 ["[Fixnum, 5] gcd [Bignum, -4611686018427387905] => ", "[Fixnum, 5]"],
 ["[Fixnum, 5] gcd [Bignum, 4611686018427387905] => ", "[Fixnum, 5]"],
 ["[Fixnum, 25] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Fixnum, 25] gcd [Fixnum, 2] => ", "[Fixnum, 1]"],
 ["[Fixnum, 25] gcd [Fixnum, 4] => ", "[Fixnum, 1]"],
 ["[Fixnum, 25] gcd [Fixnum, 5] => ", "[Fixnum, 5]"],
 ["[Fixnum, 25] gcd [Fixnum, 25] => ", "[Fixnum, 25]"],
 ["[Fixnum, 25] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Fixnum, 25] gcd [Fixnum, -2] => ", "[Fixnum, 1]"],
 ["[Fixnum, 25] gcd [Fixnum, -4] => ", "[Fixnum, 1]"],
 ["[Fixnum, 25] gcd [Fixnum, -5] => ", "[Fixnum, 5]"],
 ["[Fixnum, 25] gcd [Fixnum, -25] => ", "[Fixnum, 25]"],
 ["[Fixnum, 25] gcd [Fixnum, 4611686018427387903] => ", "[Fixnum, 1]"],
 ["[Fixnum, 25] gcd [Fixnum, -4611686018427387903] => ", "[Fixnum, 1]"],
 ["[Fixnum, 25] gcd [Fixnum, -4611686018427387904] => ", "[Fixnum, 1]"],
 ["[Fixnum, 25] gcd [Bignum, 4611686018427387904] => ", "[Fixnum, 1]"],
 ["[Fixnum, 25] gcd [Bignum, 4611686018427387904] => ", "[Fixnum, 1]"],
 ["[Fixnum, 25] gcd [Fixnum, -4611686018427387904] => ", "[Fixnum, 1]"],
 ["[Fixnum, 25] gcd [Bignum, -4611686018427387905] => ", "[Fixnum, 5]"],
 ["[Fixnum, 25] gcd [Bignum, 4611686018427387905] => ", "[Fixnum, 5]"],
 ["[Fixnum, -1] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1] gcd [Fixnum, 2] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1] gcd [Fixnum, 4] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1] gcd [Fixnum, 5] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1] gcd [Fixnum, 25] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1] gcd [Fixnum, -2] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1] gcd [Fixnum, -4] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1] gcd [Fixnum, -5] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1] gcd [Fixnum, -25] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1] gcd [Fixnum, 4611686018427387903] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1] gcd [Fixnum, -4611686018427387903] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1] gcd [Fixnum, -4611686018427387904] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1] gcd [Bignum, 4611686018427387904] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1] gcd [Bignum, 4611686018427387904] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1] gcd [Fixnum, -4611686018427387904] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1] gcd [Bignum, -4611686018427387905] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1] gcd [Bignum, 4611686018427387905] => ", "[Fixnum, 1]"],
 ["[Fixnum, -2] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Fixnum, -2] gcd [Fixnum, 2] => ", "[Fixnum, 2]"],
 ["[Fixnum, -2] gcd [Fixnum, 4] => ", "[Fixnum, 2]"],
 ["[Fixnum, -2] gcd [Fixnum, 5] => ", "[Fixnum, 1]"],
 ["[Fixnum, -2] gcd [Fixnum, 25] => ", "[Fixnum, 1]"],
 ["[Fixnum, -2] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Fixnum, -2] gcd [Fixnum, -2] => ", "[Fixnum, 2]"],
 ["[Fixnum, -2] gcd [Fixnum, -4] => ", "[Fixnum, 2]"],
 ["[Fixnum, -2] gcd [Fixnum, -5] => ", "[Fixnum, 1]"],
 ["[Fixnum, -2] gcd [Fixnum, -25] => ", "[Fixnum, 1]"],
 ["[Fixnum, -2] gcd [Fixnum, 4611686018427387903] => ", "[Fixnum, 1]"],
 ["[Fixnum, -2] gcd [Fixnum, -4611686018427387903] => ", "[Fixnum, 1]"],
 ["[Fixnum, -2] gcd [Fixnum, -4611686018427387904] => ", "[Fixnum, 2]"],
 ["[Fixnum, -2] gcd [Bignum, 4611686018427387904] => ", "[Fixnum, 2]"],
 ["[Fixnum, -2] gcd [Bignum, 4611686018427387904] => ", "[Fixnum, 2]"],
 ["[Fixnum, -2] gcd [Fixnum, -4611686018427387904] => ", "[Fixnum, 2]"],
 ["[Fixnum, -2] gcd [Bignum, -4611686018427387905] => ", "[Fixnum, 1]"],
 ["[Fixnum, -2] gcd [Bignum, 4611686018427387905] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4] gcd [Fixnum, 2] => ", "[Fixnum, 2]"],
 ["[Fixnum, -4] gcd [Fixnum, 4] => ", "[Fixnum, 4]"],
 ["[Fixnum, -4] gcd [Fixnum, 5] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4] gcd [Fixnum, 25] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4] gcd [Fixnum, -2] => ", "[Fixnum, 2]"],
 ["[Fixnum, -4] gcd [Fixnum, -4] => ", "[Fixnum, 4]"],
 ["[Fixnum, -4] gcd [Fixnum, -5] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4] gcd [Fixnum, -25] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4] gcd [Fixnum, 4611686018427387903] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4] gcd [Fixnum, -4611686018427387903] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4] gcd [Fixnum, -4611686018427387904] => ", "[Fixnum, 4]"],
 ["[Fixnum, -4] gcd [Bignum, 4611686018427387904] => ", "[Fixnum, 4]"],
 ["[Fixnum, -4] gcd [Bignum, 4611686018427387904] => ", "[Fixnum, 4]"],
 ["[Fixnum, -4] gcd [Fixnum, -4611686018427387904] => ", "[Fixnum, 4]"],
 ["[Fixnum, -4] gcd [Bignum, -4611686018427387905] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4] gcd [Bignum, 4611686018427387905] => ", "[Fixnum, 1]"],
 ["[Fixnum, -5] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Fixnum, -5] gcd [Fixnum, 2] => ", "[Fixnum, 1]"],
 ["[Fixnum, -5] gcd [Fixnum, 4] => ", "[Fixnum, 1]"],
 ["[Fixnum, -5] gcd [Fixnum, 5] => ", "[Fixnum, 5]"],
 ["[Fixnum, -5] gcd [Fixnum, 25] => ", "[Fixnum, 5]"],
 ["[Fixnum, -5] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Fixnum, -5] gcd [Fixnum, -2] => ", "[Fixnum, 1]"],
 ["[Fixnum, -5] gcd [Fixnum, -4] => ", "[Fixnum, 1]"],
 ["[Fixnum, -5] gcd [Fixnum, -5] => ", "[Fixnum, 5]"],
 ["[Fixnum, -5] gcd [Fixnum, -25] => ", "[Fixnum, 5]"],
 ["[Fixnum, -5] gcd [Fixnum, 4611686018427387903] => ", "[Fixnum, 1]"],
 ["[Fixnum, -5] gcd [Fixnum, -4611686018427387903] => ", "[Fixnum, 1]"],
 ["[Fixnum, -5] gcd [Fixnum, -4611686018427387904] => ", "[Fixnum, 1]"],
 ["[Fixnum, -5] gcd [Bignum, 4611686018427387904] => ", "[Fixnum, 1]"],
 ["[Fixnum, -5] gcd [Bignum, 4611686018427387904] => ", "[Fixnum, 1]"],
 ["[Fixnum, -5] gcd [Fixnum, -4611686018427387904] => ", "[Fixnum, 1]"],
 ["[Fixnum, -5] gcd [Bignum, -4611686018427387905] => ", "[Fixnum, 5]"],
 ["[Fixnum, -5] gcd [Bignum, 4611686018427387905] => ", "[Fixnum, 5]"],
 ["[Fixnum, -25] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Fixnum, -25] gcd [Fixnum, 2] => ", "[Fixnum, 1]"],
 ["[Fixnum, -25] gcd [Fixnum, 4] => ", "[Fixnum, 1]"],
 ["[Fixnum, -25] gcd [Fixnum, 5] => ", "[Fixnum, 5]"],
 ["[Fixnum, -25] gcd [Fixnum, 25] => ", "[Fixnum, 25]"],
 ["[Fixnum, -25] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Fixnum, -25] gcd [Fixnum, -2] => ", "[Fixnum, 1]"],
 ["[Fixnum, -25] gcd [Fixnum, -4] => ", "[Fixnum, 1]"],
 ["[Fixnum, -25] gcd [Fixnum, -5] => ", "[Fixnum, 5]"],
 ["[Fixnum, -25] gcd [Fixnum, -25] => ", "[Fixnum, 25]"],
 ["[Fixnum, -25] gcd [Fixnum, 4611686018427387903] => ", "[Fixnum, 1]"],
 ["[Fixnum, -25] gcd [Fixnum, -4611686018427387903] => ", "[Fixnum, 1]"],
 ["[Fixnum, -25] gcd [Fixnum, -4611686018427387904] => ", "[Fixnum, 1]"],
 ["[Fixnum, -25] gcd [Bignum, 4611686018427387904] => ", "[Fixnum, 1]"],
 ["[Fixnum, -25] gcd [Bignum, 4611686018427387904] => ", "[Fixnum, 1]"],
 ["[Fixnum, -25] gcd [Fixnum, -4611686018427387904] => ", "[Fixnum, 1]"],
 ["[Fixnum, -25] gcd [Bignum, -4611686018427387905] => ", "[Fixnum, 5]"],
 ["[Fixnum, -25] gcd [Bignum, 4611686018427387905] => ", "[Fixnum, 5]"],
 ["[Fixnum, 4611686018427387903] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Fixnum, 4611686018427387903] gcd [Fixnum, 2] => ", "[Fixnum, 1]"],
 ["[Fixnum, 4611686018427387903] gcd [Fixnum, 4] => ", "[Fixnum, 1]"],
 ["[Fixnum, 4611686018427387903] gcd [Fixnum, 5] => ", "[Fixnum, 1]"],
 ["[Fixnum, 4611686018427387903] gcd [Fixnum, 25] => ", "[Fixnum, 1]"],
 ["[Fixnum, 4611686018427387903] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Fixnum, 4611686018427387903] gcd [Fixnum, -2] => ", "[Fixnum, 1]"],
 ["[Fixnum, 4611686018427387903] gcd [Fixnum, -4] => ", "[Fixnum, 1]"],
 ["[Fixnum, 4611686018427387903] gcd [Fixnum, -5] => ", "[Fixnum, 1]"],
 ["[Fixnum, 4611686018427387903] gcd [Fixnum, -25] => ", "[Fixnum, 1]"],
 ["[Fixnum, 4611686018427387903] gcd [Fixnum, 4611686018427387903] => ",
  "[Fixnum, 4611686018427387903]"],
 ["[Fixnum, 4611686018427387903] gcd [Fixnum, -4611686018427387903] => ",
  "[Fixnum, 4611686018427387903]"],
 ["[Fixnum, 4611686018427387903] gcd [Fixnum, -4611686018427387904] => ",
  "[Fixnum, 1]"],
 ["[Fixnum, 4611686018427387903] gcd [Bignum, 4611686018427387904] => ",
  "[Fixnum, 1]"],
 ["[Fixnum, 4611686018427387903] gcd [Bignum, 4611686018427387904] => ",
  "[Fixnum, 1]"],
 ["[Fixnum, 4611686018427387903] gcd [Fixnum, -4611686018427387904] => ",
  "[Fixnum, 1]"],
 ["[Fixnum, 4611686018427387903] gcd [Bignum, -4611686018427387905] => ",
  "[Fixnum, 1]"],
 ["[Fixnum, 4611686018427387903] gcd [Bignum, 4611686018427387905] => ",
  "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387903] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387903] gcd [Fixnum, 2] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387903] gcd [Fixnum, 4] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387903] gcd [Fixnum, 5] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387903] gcd [Fixnum, 25] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387903] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387903] gcd [Fixnum, -2] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387903] gcd [Fixnum, -4] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387903] gcd [Fixnum, -5] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387903] gcd [Fixnum, -25] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387903] gcd [Fixnum, 4611686018427387903] => ",
  "[Fixnum, 4611686018427387903]"],
 ["[Fixnum, -4611686018427387903] gcd [Fixnum, -4611686018427387903] => ",
  "[Fixnum, 4611686018427387903]"],
 ["[Fixnum, -4611686018427387903] gcd [Fixnum, -4611686018427387904] => ",
  "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387903] gcd [Bignum, 4611686018427387904] => ",
  "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387903] gcd [Bignum, 4611686018427387904] => ",
  "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387903] gcd [Fixnum, -4611686018427387904] => ",
  "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387903] gcd [Bignum, -4611686018427387905] => ",
  "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387903] gcd [Bignum, 4611686018427387905] => ",
  "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387904] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387904] gcd [Fixnum, 2] => ", "[Fixnum, 2]"],
 ["[Fixnum, -4611686018427387904] gcd [Fixnum, 4] => ", "[Fixnum, 4]"],
 ["[Fixnum, -4611686018427387904] gcd [Fixnum, 5] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387904] gcd [Fixnum, 25] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387904] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387904] gcd [Fixnum, -2] => ", "[Fixnum, 2]"],
 ["[Fixnum, -4611686018427387904] gcd [Fixnum, -4] => ", "[Fixnum, 4]"],
 ["[Fixnum, -4611686018427387904] gcd [Fixnum, -5] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387904] gcd [Fixnum, -25] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387904] gcd [Fixnum, 4611686018427387903] => ",
  "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387904] gcd [Fixnum, -4611686018427387903] => ",
  "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387904] gcd [Fixnum, -4611686018427387904] => ",
  "[Bignum, 4611686018427387904]"],
 ["[Fixnum, -4611686018427387904] gcd [Bignum, 4611686018427387904] => ",
  "[Bignum, 4611686018427387904]"],
 ["[Fixnum, -4611686018427387904] gcd [Bignum, 4611686018427387904] => ",
  "[Bignum, 4611686018427387904]"],
 ["[Fixnum, -4611686018427387904] gcd [Fixnum, -4611686018427387904] => ",
  "[Bignum, 4611686018427387904]"],
 ["[Fixnum, -4611686018427387904] gcd [Bignum, -4611686018427387905] => ",
  "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387904] gcd [Bignum, 4611686018427387905] => ",
  "[Fixnum, 1]"],
 ["[Bignum, 4611686018427387904] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Bignum, 4611686018427387904] gcd [Fixnum, 2] => ", "[Fixnum, 2]"],
 ["[Bignum, 4611686018427387904] gcd [Fixnum, 4] => ", "[Fixnum, 4]"],
 ["[Bignum, 4611686018427387904] gcd [Fixnum, 5] => ", "[Fixnum, 1]"],
 ["[Bignum, 4611686018427387904] gcd [Fixnum, 25] => ", "[Fixnum, 1]"],
 ["[Bignum, 4611686018427387904] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Bignum, 4611686018427387904] gcd [Fixnum, -2] => ", "[Fixnum, 2]"],
 ["[Bignum, 4611686018427387904] gcd [Fixnum, -4] => ", "[Fixnum, 4]"],
 ["[Bignum, 4611686018427387904] gcd [Fixnum, -5] => ", "[Fixnum, 1]"],
 ["[Bignum, 4611686018427387904] gcd [Fixnum, -25] => ", "[Fixnum, 1]"],
 ["[Bignum, 4611686018427387904] gcd [Fixnum, 4611686018427387903] => ",
  "[Fixnum, 1]"],
 ["[Bignum, 4611686018427387904] gcd [Fixnum, -4611686018427387903] => ",
  "[Fixnum, 1]"],
 ["[Bignum, 4611686018427387904] gcd [Fixnum, -4611686018427387904] => ",
  "[Bignum, 4611686018427387904]"],
 ["[Bignum, 4611686018427387904] gcd [Bignum, 4611686018427387904] => ",
  "[Bignum, 4611686018427387904]"],
 ["[Bignum, 4611686018427387904] gcd [Bignum, 4611686018427387904] => ",
  "[Bignum, 4611686018427387904]"],
 ["[Bignum, 4611686018427387904] gcd [Fixnum, -4611686018427387904] => ",
  "[Bignum, 4611686018427387904]"],
 ["[Bignum, 4611686018427387904] gcd [Bignum, -4611686018427387905] => ",
  "[Fixnum, 1]"],
 ["[Bignum, 4611686018427387904] gcd [Bignum, 4611686018427387905] => ",
  "[Fixnum, 1]"],
 ["[Bignum, 4611686018427387904] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Bignum, 4611686018427387904] gcd [Fixnum, 2] => ", "[Fixnum, 2]"],
 ["[Bignum, 4611686018427387904] gcd [Fixnum, 4] => ", "[Fixnum, 4]"],
 ["[Bignum, 4611686018427387904] gcd [Fixnum, 5] => ", "[Fixnum, 1]"],
 ["[Bignum, 4611686018427387904] gcd [Fixnum, 25] => ", "[Fixnum, 1]"],
 ["[Bignum, 4611686018427387904] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Bignum, 4611686018427387904] gcd [Fixnum, -2] => ", "[Fixnum, 2]"],
 ["[Bignum, 4611686018427387904] gcd [Fixnum, -4] => ", "[Fixnum, 4]"],
 ["[Bignum, 4611686018427387904] gcd [Fixnum, -5] => ", "[Fixnum, 1]"],
 ["[Bignum, 4611686018427387904] gcd [Fixnum, -25] => ", "[Fixnum, 1]"],
 ["[Bignum, 4611686018427387904] gcd [Fixnum, 4611686018427387903] => ",
  "[Fixnum, 1]"],
 ["[Bignum, 4611686018427387904] gcd [Fixnum, -4611686018427387903] => ",
  "[Fixnum, 1]"],
 ["[Bignum, 4611686018427387904] gcd [Fixnum, -4611686018427387904] => ",
  "[Bignum, 4611686018427387904]"],
 ["[Bignum, 4611686018427387904] gcd [Bignum, 4611686018427387904] => ",
  "[Bignum, 4611686018427387904]"],
 ["[Bignum, 4611686018427387904] gcd [Bignum, 4611686018427387904] => ",
  "[Bignum, 4611686018427387904]"],
 ["[Bignum, 4611686018427387904] gcd [Fixnum, -4611686018427387904] => ",
  "[Bignum, 4611686018427387904]"],
 ["[Bignum, 4611686018427387904] gcd [Bignum, -4611686018427387905] => ",
  "[Fixnum, 1]"],
 ["[Bignum, 4611686018427387904] gcd [Bignum, 4611686018427387905] => ",
  "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387904] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387904] gcd [Fixnum, 2] => ", "[Fixnum, 2]"],
 ["[Fixnum, -4611686018427387904] gcd [Fixnum, 4] => ", "[Fixnum, 4]"],
 ["[Fixnum, -4611686018427387904] gcd [Fixnum, 5] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387904] gcd [Fixnum, 25] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387904] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387904] gcd [Fixnum, -2] => ", "[Fixnum, 2]"],
 ["[Fixnum, -4611686018427387904] gcd [Fixnum, -4] => ", "[Fixnum, 4]"],
 ["[Fixnum, -4611686018427387904] gcd [Fixnum, -5] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387904] gcd [Fixnum, -25] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387904] gcd [Fixnum, 4611686018427387903] => ",
  "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387904] gcd [Fixnum, -4611686018427387903] => ",
  "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387904] gcd [Fixnum, -4611686018427387904] => ",
  "[Bignum, 4611686018427387904]"],
 ["[Fixnum, -4611686018427387904] gcd [Bignum, 4611686018427387904] => ",
  "[Bignum, 4611686018427387904]"],
 ["[Fixnum, -4611686018427387904] gcd [Bignum, 4611686018427387904] => ",
  "[Bignum, 4611686018427387904]"],
 ["[Fixnum, -4611686018427387904] gcd [Fixnum, -4611686018427387904] => ",
  "[Bignum, 4611686018427387904]"],
 ["[Fixnum, -4611686018427387904] gcd [Bignum, -4611686018427387905] => ",
  "[Fixnum, 1]"],
 ["[Fixnum, -4611686018427387904] gcd [Bignum, 4611686018427387905] => ",
  "[Fixnum, 1]"],
 ["[Bignum, -4611686018427387905] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Bignum, -4611686018427387905] gcd [Fixnum, 2] => ", "[Fixnum, 1]"],
 ["[Bignum, -4611686018427387905] gcd [Fixnum, 4] => ", "[Fixnum, 1]"],
 ["[Bignum, -4611686018427387905] gcd [Fixnum, 5] => ", "[Fixnum, 5]"],
 ["[Bignum, -4611686018427387905] gcd [Fixnum, 25] => ", "[Fixnum, 5]"],
 ["[Bignum, -4611686018427387905] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Bignum, -4611686018427387905] gcd [Fixnum, -2] => ", "[Fixnum, 1]"],
 ["[Bignum, -4611686018427387905] gcd [Fixnum, -4] => ", "[Fixnum, 1]"],
 ["[Bignum, -4611686018427387905] gcd [Fixnum, -5] => ", "[Fixnum, 5]"],
 ["[Bignum, -4611686018427387905] gcd [Fixnum, -25] => ", "[Fixnum, 5]"],
 ["[Bignum, -4611686018427387905] gcd [Fixnum, 4611686018427387903] => ",
  "[Fixnum, 1]"],
 ["[Bignum, -4611686018427387905] gcd [Fixnum, -4611686018427387903] => ",
  "[Fixnum, 1]"],
 ["[Bignum, -4611686018427387905] gcd [Fixnum, -4611686018427387904] => ",
  "[Fixnum, 1]"],
 ["[Bignum, -4611686018427387905] gcd [Bignum, 4611686018427387904] => ",
  "[Fixnum, 1]"],
 ["[Bignum, -4611686018427387905] gcd [Bignum, 4611686018427387904] => ",
  "[Fixnum, 1]"],
 ["[Bignum, -4611686018427387905] gcd [Fixnum, -4611686018427387904] => ",
  "[Fixnum, 1]"],
 ["[Bignum, -4611686018427387905] gcd [Bignum, -4611686018427387905] => ",
  "[Bignum, 4611686018427387905]"],
 ["[Bignum, -4611686018427387905] gcd [Bignum, 4611686018427387905] => ",
  "[Bignum, 4611686018427387905]"],
 ["[Bignum, 4611686018427387905] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Bignum, 4611686018427387905] gcd [Fixnum, 2] => ", "[Fixnum, 1]"],
 ["[Bignum, 4611686018427387905] gcd [Fixnum, 4] => ", "[Fixnum, 1]"],
 ["[Bignum, 4611686018427387905] gcd [Fixnum, 5] => ", "[Fixnum, 5]"],
 ["[Bignum, 4611686018427387905] gcd [Fixnum, 25] => ", "[Fixnum, 5]"],
 ["[Bignum, 4611686018427387905] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Bignum, 4611686018427387905] gcd [Fixnum, -2] => ", "[Fixnum, 1]"],
 ["[Bignum, 4611686018427387905] gcd [Fixnum, -4] => ", "[Fixnum, 1]"],
 ["[Bignum, 4611686018427387905] gcd [Fixnum, -5] => ", "[Fixnum, 5]"],
 ["[Bignum, 4611686018427387905] gcd [Fixnum, -25] => ", "[Fixnum, 5]"],
 ["[Bignum, 4611686018427387905] gcd [Fixnum, 4611686018427387903] => ",
  "[Fixnum, 1]"],
 ["[Bignum, 4611686018427387905] gcd [Fixnum, -4611686018427387903] => ",
  "[Fixnum, 1]"],
 ["[Bignum, 4611686018427387905] gcd [Fixnum, -4611686018427387904] => ",
  "[Fixnum, 1]"],
 ["[Bignum, 4611686018427387905] gcd [Bignum, 4611686018427387904] => ",
  "[Fixnum, 1]"],
 ["[Bignum, 4611686018427387905] gcd [Bignum, 4611686018427387904] => ",
  "[Fixnum, 1]"],
 ["[Bignum, 4611686018427387905] gcd [Fixnum, -4611686018427387904] => ",
  "[Fixnum, 1]"],
 ["[Bignum, 4611686018427387905] gcd [Bignum, -4611686018427387905] => ",
  "[Bignum, 4611686018427387905]"],
 ["[Bignum, 4611686018427387905] gcd [Bignum, 4611686018427387905] => ",
  "[Bignum, 4611686018427387905]"]]
when 'i686', 'i386'
  # values generated by ruby 1.8.7 (2009-06-12 patchlevel 174) [i486-linux]
@@expected = 
[["[Fixnum, 1] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1] gcd [Fixnum, 2] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1] gcd [Fixnum, 4] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1] gcd [Fixnum, 5] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1] gcd [Fixnum, 25] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1] gcd [Fixnum, -2] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1] gcd [Fixnum, -4] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1] gcd [Fixnum, -5] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1] gcd [Fixnum, -25] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1] gcd [Fixnum, 1073741823] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1] gcd [Fixnum, -1073741823] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1] gcd [Fixnum, -1073741824] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1] gcd [Bignum, 1073741824] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1] gcd [Bignum, 1073741824] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1] gcd [Fixnum, -1073741824] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1] gcd [Bignum, -1073741825] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1] gcd [Bignum, 1073741825] => ", "[Fixnum, 1]"],
 ["[Fixnum, 2] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Fixnum, 2] gcd [Fixnum, 2] => ", "[Fixnum, 2]"],
 ["[Fixnum, 2] gcd [Fixnum, 4] => ", "[Fixnum, 2]"],
 ["[Fixnum, 2] gcd [Fixnum, 5] => ", "[Fixnum, 1]"],
 ["[Fixnum, 2] gcd [Fixnum, 25] => ", "[Fixnum, 1]"],
 ["[Fixnum, 2] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Fixnum, 2] gcd [Fixnum, -2] => ", "[Fixnum, 2]"],
 ["[Fixnum, 2] gcd [Fixnum, -4] => ", "[Fixnum, 2]"],
 ["[Fixnum, 2] gcd [Fixnum, -5] => ", "[Fixnum, 1]"],
 ["[Fixnum, 2] gcd [Fixnum, -25] => ", "[Fixnum, 1]"],
 ["[Fixnum, 2] gcd [Fixnum, 1073741823] => ", "[Fixnum, 1]"],
 ["[Fixnum, 2] gcd [Fixnum, -1073741823] => ", "[Fixnum, 1]"],
 ["[Fixnum, 2] gcd [Fixnum, -1073741824] => ", "[Fixnum, 2]"],
 ["[Fixnum, 2] gcd [Bignum, 1073741824] => ", "[Fixnum, 2]"],
 ["[Fixnum, 2] gcd [Bignum, 1073741824] => ", "[Fixnum, 2]"],
 ["[Fixnum, 2] gcd [Fixnum, -1073741824] => ", "[Fixnum, 2]"],
 ["[Fixnum, 2] gcd [Bignum, -1073741825] => ", "[Fixnum, 1]"],
 ["[Fixnum, 2] gcd [Bignum, 1073741825] => ", "[Fixnum, 1]"],
 ["[Fixnum, 4] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Fixnum, 4] gcd [Fixnum, 2] => ", "[Fixnum, 2]"],
 ["[Fixnum, 4] gcd [Fixnum, 4] => ", "[Fixnum, 4]"],
 ["[Fixnum, 4] gcd [Fixnum, 5] => ", "[Fixnum, 1]"],
 ["[Fixnum, 4] gcd [Fixnum, 25] => ", "[Fixnum, 1]"],
 ["[Fixnum, 4] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Fixnum, 4] gcd [Fixnum, -2] => ", "[Fixnum, 2]"],
 ["[Fixnum, 4] gcd [Fixnum, -4] => ", "[Fixnum, 4]"],
 ["[Fixnum, 4] gcd [Fixnum, -5] => ", "[Fixnum, 1]"],
 ["[Fixnum, 4] gcd [Fixnum, -25] => ", "[Fixnum, 1]"],
 ["[Fixnum, 4] gcd [Fixnum, 1073741823] => ", "[Fixnum, 1]"],
 ["[Fixnum, 4] gcd [Fixnum, -1073741823] => ", "[Fixnum, 1]"],
 ["[Fixnum, 4] gcd [Fixnum, -1073741824] => ", "[Fixnum, 4]"],
 ["[Fixnum, 4] gcd [Bignum, 1073741824] => ", "[Fixnum, 4]"],
 ["[Fixnum, 4] gcd [Bignum, 1073741824] => ", "[Fixnum, 4]"],
 ["[Fixnum, 4] gcd [Fixnum, -1073741824] => ", "[Fixnum, 4]"],
 ["[Fixnum, 4] gcd [Bignum, -1073741825] => ", "[Fixnum, 1]"],
 ["[Fixnum, 4] gcd [Bignum, 1073741825] => ", "[Fixnum, 1]"],
 ["[Fixnum, 5] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Fixnum, 5] gcd [Fixnum, 2] => ", "[Fixnum, 1]"],
 ["[Fixnum, 5] gcd [Fixnum, 4] => ", "[Fixnum, 1]"],
 ["[Fixnum, 5] gcd [Fixnum, 5] => ", "[Fixnum, 5]"],
 ["[Fixnum, 5] gcd [Fixnum, 25] => ", "[Fixnum, 5]"],
 ["[Fixnum, 5] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Fixnum, 5] gcd [Fixnum, -2] => ", "[Fixnum, 1]"],
 ["[Fixnum, 5] gcd [Fixnum, -4] => ", "[Fixnum, 1]"],
 ["[Fixnum, 5] gcd [Fixnum, -5] => ", "[Fixnum, 5]"],
 ["[Fixnum, 5] gcd [Fixnum, -25] => ", "[Fixnum, 5]"],
 ["[Fixnum, 5] gcd [Fixnum, 1073741823] => ", "[Fixnum, 1]"],
 ["[Fixnum, 5] gcd [Fixnum, -1073741823] => ", "[Fixnum, 1]"],
 ["[Fixnum, 5] gcd [Fixnum, -1073741824] => ", "[Fixnum, 1]"],
 ["[Fixnum, 5] gcd [Bignum, 1073741824] => ", "[Fixnum, 1]"],
 ["[Fixnum, 5] gcd [Bignum, 1073741824] => ", "[Fixnum, 1]"],
 ["[Fixnum, 5] gcd [Fixnum, -1073741824] => ", "[Fixnum, 1]"],
 ["[Fixnum, 5] gcd [Bignum, -1073741825] => ", "[Fixnum, 5]"],
 ["[Fixnum, 5] gcd [Bignum, 1073741825] => ", "[Fixnum, 5]"],
 ["[Fixnum, 25] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Fixnum, 25] gcd [Fixnum, 2] => ", "[Fixnum, 1]"],
 ["[Fixnum, 25] gcd [Fixnum, 4] => ", "[Fixnum, 1]"],
 ["[Fixnum, 25] gcd [Fixnum, 5] => ", "[Fixnum, 5]"],
 ["[Fixnum, 25] gcd [Fixnum, 25] => ", "[Fixnum, 25]"],
 ["[Fixnum, 25] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Fixnum, 25] gcd [Fixnum, -2] => ", "[Fixnum, 1]"],
 ["[Fixnum, 25] gcd [Fixnum, -4] => ", "[Fixnum, 1]"],
 ["[Fixnum, 25] gcd [Fixnum, -5] => ", "[Fixnum, 5]"],
 ["[Fixnum, 25] gcd [Fixnum, -25] => ", "[Fixnum, 25]"],
 ["[Fixnum, 25] gcd [Fixnum, 1073741823] => ", "[Fixnum, 1]"],
 ["[Fixnum, 25] gcd [Fixnum, -1073741823] => ", "[Fixnum, 1]"],
 ["[Fixnum, 25] gcd [Fixnum, -1073741824] => ", "[Fixnum, 1]"],
 ["[Fixnum, 25] gcd [Bignum, 1073741824] => ", "[Fixnum, 1]"],
 ["[Fixnum, 25] gcd [Bignum, 1073741824] => ", "[Fixnum, 1]"],
 ["[Fixnum, 25] gcd [Fixnum, -1073741824] => ", "[Fixnum, 1]"],
 ["[Fixnum, 25] gcd [Bignum, -1073741825] => ", "[Fixnum, 25]"],
 ["[Fixnum, 25] gcd [Bignum, 1073741825] => ", "[Fixnum, 25]"],
 ["[Fixnum, -1] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1] gcd [Fixnum, 2] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1] gcd [Fixnum, 4] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1] gcd [Fixnum, 5] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1] gcd [Fixnum, 25] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1] gcd [Fixnum, -2] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1] gcd [Fixnum, -4] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1] gcd [Fixnum, -5] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1] gcd [Fixnum, -25] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1] gcd [Fixnum, 1073741823] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1] gcd [Fixnum, -1073741823] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1] gcd [Fixnum, -1073741824] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1] gcd [Bignum, 1073741824] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1] gcd [Bignum, 1073741824] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1] gcd [Fixnum, -1073741824] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1] gcd [Bignum, -1073741825] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1] gcd [Bignum, 1073741825] => ", "[Fixnum, 1]"],
 ["[Fixnum, -2] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Fixnum, -2] gcd [Fixnum, 2] => ", "[Fixnum, 2]"],
 ["[Fixnum, -2] gcd [Fixnum, 4] => ", "[Fixnum, 2]"],
 ["[Fixnum, -2] gcd [Fixnum, 5] => ", "[Fixnum, 1]"],
 ["[Fixnum, -2] gcd [Fixnum, 25] => ", "[Fixnum, 1]"],
 ["[Fixnum, -2] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Fixnum, -2] gcd [Fixnum, -2] => ", "[Fixnum, 2]"],
 ["[Fixnum, -2] gcd [Fixnum, -4] => ", "[Fixnum, 2]"],
 ["[Fixnum, -2] gcd [Fixnum, -5] => ", "[Fixnum, 1]"],
 ["[Fixnum, -2] gcd [Fixnum, -25] => ", "[Fixnum, 1]"],
 ["[Fixnum, -2] gcd [Fixnum, 1073741823] => ", "[Fixnum, 1]"],
 ["[Fixnum, -2] gcd [Fixnum, -1073741823] => ", "[Fixnum, 1]"],
 ["[Fixnum, -2] gcd [Fixnum, -1073741824] => ", "[Fixnum, 2]"],
 ["[Fixnum, -2] gcd [Bignum, 1073741824] => ", "[Fixnum, 2]"],
 ["[Fixnum, -2] gcd [Bignum, 1073741824] => ", "[Fixnum, 2]"],
 ["[Fixnum, -2] gcd [Fixnum, -1073741824] => ", "[Fixnum, 2]"],
 ["[Fixnum, -2] gcd [Bignum, -1073741825] => ", "[Fixnum, 1]"],
 ["[Fixnum, -2] gcd [Bignum, 1073741825] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4] gcd [Fixnum, 2] => ", "[Fixnum, 2]"],
 ["[Fixnum, -4] gcd [Fixnum, 4] => ", "[Fixnum, 4]"],
 ["[Fixnum, -4] gcd [Fixnum, 5] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4] gcd [Fixnum, 25] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4] gcd [Fixnum, -2] => ", "[Fixnum, 2]"],
 ["[Fixnum, -4] gcd [Fixnum, -4] => ", "[Fixnum, 4]"],
 ["[Fixnum, -4] gcd [Fixnum, -5] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4] gcd [Fixnum, -25] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4] gcd [Fixnum, 1073741823] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4] gcd [Fixnum, -1073741823] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4] gcd [Fixnum, -1073741824] => ", "[Fixnum, 4]"],
 ["[Fixnum, -4] gcd [Bignum, 1073741824] => ", "[Fixnum, 4]"],
 ["[Fixnum, -4] gcd [Bignum, 1073741824] => ", "[Fixnum, 4]"],
 ["[Fixnum, -4] gcd [Fixnum, -1073741824] => ", "[Fixnum, 4]"],
 ["[Fixnum, -4] gcd [Bignum, -1073741825] => ", "[Fixnum, 1]"],
 ["[Fixnum, -4] gcd [Bignum, 1073741825] => ", "[Fixnum, 1]"],
 ["[Fixnum, -5] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Fixnum, -5] gcd [Fixnum, 2] => ", "[Fixnum, 1]"],
 ["[Fixnum, -5] gcd [Fixnum, 4] => ", "[Fixnum, 1]"],
 ["[Fixnum, -5] gcd [Fixnum, 5] => ", "[Fixnum, 5]"],
 ["[Fixnum, -5] gcd [Fixnum, 25] => ", "[Fixnum, 5]"],
 ["[Fixnum, -5] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Fixnum, -5] gcd [Fixnum, -2] => ", "[Fixnum, 1]"],
 ["[Fixnum, -5] gcd [Fixnum, -4] => ", "[Fixnum, 1]"],
 ["[Fixnum, -5] gcd [Fixnum, -5] => ", "[Fixnum, 5]"],
 ["[Fixnum, -5] gcd [Fixnum, -25] => ", "[Fixnum, 5]"],
 ["[Fixnum, -5] gcd [Fixnum, 1073741823] => ", "[Fixnum, 1]"],
 ["[Fixnum, -5] gcd [Fixnum, -1073741823] => ", "[Fixnum, 1]"],
 ["[Fixnum, -5] gcd [Fixnum, -1073741824] => ", "[Fixnum, 1]"],
 ["[Fixnum, -5] gcd [Bignum, 1073741824] => ", "[Fixnum, 1]"],
 ["[Fixnum, -5] gcd [Bignum, 1073741824] => ", "[Fixnum, 1]"],
 ["[Fixnum, -5] gcd [Fixnum, -1073741824] => ", "[Fixnum, 1]"],
 ["[Fixnum, -5] gcd [Bignum, -1073741825] => ", "[Fixnum, 5]"],
 ["[Fixnum, -5] gcd [Bignum, 1073741825] => ", "[Fixnum, 5]"],
 ["[Fixnum, -25] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Fixnum, -25] gcd [Fixnum, 2] => ", "[Fixnum, 1]"],
 ["[Fixnum, -25] gcd [Fixnum, 4] => ", "[Fixnum, 1]"],
 ["[Fixnum, -25] gcd [Fixnum, 5] => ", "[Fixnum, 5]"],
 ["[Fixnum, -25] gcd [Fixnum, 25] => ", "[Fixnum, 25]"],
 ["[Fixnum, -25] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Fixnum, -25] gcd [Fixnum, -2] => ", "[Fixnum, 1]"],
 ["[Fixnum, -25] gcd [Fixnum, -4] => ", "[Fixnum, 1]"],
 ["[Fixnum, -25] gcd [Fixnum, -5] => ", "[Fixnum, 5]"],
 ["[Fixnum, -25] gcd [Fixnum, -25] => ", "[Fixnum, 25]"],
 ["[Fixnum, -25] gcd [Fixnum, 1073741823] => ", "[Fixnum, 1]"],
 ["[Fixnum, -25] gcd [Fixnum, -1073741823] => ", "[Fixnum, 1]"],
 ["[Fixnum, -25] gcd [Fixnum, -1073741824] => ", "[Fixnum, 1]"],
 ["[Fixnum, -25] gcd [Bignum, 1073741824] => ", "[Fixnum, 1]"],
 ["[Fixnum, -25] gcd [Bignum, 1073741824] => ", "[Fixnum, 1]"],
 ["[Fixnum, -25] gcd [Fixnum, -1073741824] => ", "[Fixnum, 1]"],
 ["[Fixnum, -25] gcd [Bignum, -1073741825] => ", "[Fixnum, 25]"],
 ["[Fixnum, -25] gcd [Bignum, 1073741825] => ", "[Fixnum, 25]"],
 ["[Fixnum, 1073741823] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1073741823] gcd [Fixnum, 2] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1073741823] gcd [Fixnum, 4] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1073741823] gcd [Fixnum, 5] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1073741823] gcd [Fixnum, 25] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1073741823] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1073741823] gcd [Fixnum, -2] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1073741823] gcd [Fixnum, -4] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1073741823] gcd [Fixnum, -5] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1073741823] gcd [Fixnum, -25] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1073741823] gcd [Fixnum, 1073741823] => ", "[Fixnum, 1073741823]"],
 ["[Fixnum, 1073741823] gcd [Fixnum, -1073741823] => ",
  "[Fixnum, 1073741823]"],
 ["[Fixnum, 1073741823] gcd [Fixnum, -1073741824] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1073741823] gcd [Bignum, 1073741824] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1073741823] gcd [Bignum, 1073741824] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1073741823] gcd [Fixnum, -1073741824] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1073741823] gcd [Bignum, -1073741825] => ", "[Fixnum, 1]"],
 ["[Fixnum, 1073741823] gcd [Bignum, 1073741825] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741823] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741823] gcd [Fixnum, 2] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741823] gcd [Fixnum, 4] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741823] gcd [Fixnum, 5] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741823] gcd [Fixnum, 25] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741823] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741823] gcd [Fixnum, -2] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741823] gcd [Fixnum, -4] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741823] gcd [Fixnum, -5] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741823] gcd [Fixnum, -25] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741823] gcd [Fixnum, 1073741823] => ",
  "[Fixnum, 1073741823]"],
 ["[Fixnum, -1073741823] gcd [Fixnum, -1073741823] => ",
  "[Fixnum, 1073741823]"],
 ["[Fixnum, -1073741823] gcd [Fixnum, -1073741824] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741823] gcd [Bignum, 1073741824] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741823] gcd [Bignum, 1073741824] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741823] gcd [Fixnum, -1073741824] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741823] gcd [Bignum, -1073741825] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741823] gcd [Bignum, 1073741825] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741824] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741824] gcd [Fixnum, 2] => ", "[Fixnum, 2]"],
 ["[Fixnum, -1073741824] gcd [Fixnum, 4] => ", "[Fixnum, 4]"],
 ["[Fixnum, -1073741824] gcd [Fixnum, 5] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741824] gcd [Fixnum, 25] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741824] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741824] gcd [Fixnum, -2] => ", "[Fixnum, 2]"],
 ["[Fixnum, -1073741824] gcd [Fixnum, -4] => ", "[Fixnum, 4]"],
 ["[Fixnum, -1073741824] gcd [Fixnum, -5] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741824] gcd [Fixnum, -25] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741824] gcd [Fixnum, 1073741823] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741824] gcd [Fixnum, -1073741823] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741824] gcd [Fixnum, -1073741824] => ",
  "[Bignum, 1073741824]"],
 ["[Fixnum, -1073741824] gcd [Bignum, 1073741824] => ",
  "[Bignum, 1073741824]"],
 ["[Fixnum, -1073741824] gcd [Bignum, 1073741824] => ",
  "[Bignum, 1073741824]"],
 ["[Fixnum, -1073741824] gcd [Fixnum, -1073741824] => ",
  "[Bignum, 1073741824]"],
 ["[Fixnum, -1073741824] gcd [Bignum, -1073741825] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741824] gcd [Bignum, 1073741825] => ", "[Fixnum, 1]"],
 ["[Bignum, 1073741824] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Bignum, 1073741824] gcd [Fixnum, 2] => ", "[Fixnum, 2]"],
 ["[Bignum, 1073741824] gcd [Fixnum, 4] => ", "[Fixnum, 4]"],
 ["[Bignum, 1073741824] gcd [Fixnum, 5] => ", "[Fixnum, 1]"],
 ["[Bignum, 1073741824] gcd [Fixnum, 25] => ", "[Fixnum, 1]"],
 ["[Bignum, 1073741824] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Bignum, 1073741824] gcd [Fixnum, -2] => ", "[Fixnum, 2]"],
 ["[Bignum, 1073741824] gcd [Fixnum, -4] => ", "[Fixnum, 4]"],
 ["[Bignum, 1073741824] gcd [Fixnum, -5] => ", "[Fixnum, 1]"],
 ["[Bignum, 1073741824] gcd [Fixnum, -25] => ", "[Fixnum, 1]"],
 ["[Bignum, 1073741824] gcd [Fixnum, 1073741823] => ", "[Fixnum, 1]"],
 ["[Bignum, 1073741824] gcd [Fixnum, -1073741823] => ", "[Fixnum, 1]"],
 ["[Bignum, 1073741824] gcd [Fixnum, -1073741824] => ",
  "[Bignum, 1073741824]"],
 ["[Bignum, 1073741824] gcd [Bignum, 1073741824] => ", "[Bignum, 1073741824]"],
 ["[Bignum, 1073741824] gcd [Bignum, 1073741824] => ", "[Bignum, 1073741824]"],
 ["[Bignum, 1073741824] gcd [Fixnum, -1073741824] => ",
  "[Bignum, 1073741824]"],
 ["[Bignum, 1073741824] gcd [Bignum, -1073741825] => ", "[Fixnum, 1]"],
 ["[Bignum, 1073741824] gcd [Bignum, 1073741825] => ", "[Fixnum, 1]"],
 ["[Bignum, 1073741824] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Bignum, 1073741824] gcd [Fixnum, 2] => ", "[Fixnum, 2]"],
 ["[Bignum, 1073741824] gcd [Fixnum, 4] => ", "[Fixnum, 4]"],
 ["[Bignum, 1073741824] gcd [Fixnum, 5] => ", "[Fixnum, 1]"],
 ["[Bignum, 1073741824] gcd [Fixnum, 25] => ", "[Fixnum, 1]"],
 ["[Bignum, 1073741824] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Bignum, 1073741824] gcd [Fixnum, -2] => ", "[Fixnum, 2]"],
 ["[Bignum, 1073741824] gcd [Fixnum, -4] => ", "[Fixnum, 4]"],
 ["[Bignum, 1073741824] gcd [Fixnum, -5] => ", "[Fixnum, 1]"],
 ["[Bignum, 1073741824] gcd [Fixnum, -25] => ", "[Fixnum, 1]"],
 ["[Bignum, 1073741824] gcd [Fixnum, 1073741823] => ", "[Fixnum, 1]"],
 ["[Bignum, 1073741824] gcd [Fixnum, -1073741823] => ", "[Fixnum, 1]"],
 ["[Bignum, 1073741824] gcd [Fixnum, -1073741824] => ",
  "[Bignum, 1073741824]"],
 ["[Bignum, 1073741824] gcd [Bignum, 1073741824] => ", "[Bignum, 1073741824]"],
 ["[Bignum, 1073741824] gcd [Bignum, 1073741824] => ", "[Bignum, 1073741824]"],
 ["[Bignum, 1073741824] gcd [Fixnum, -1073741824] => ",
  "[Bignum, 1073741824]"],
 ["[Bignum, 1073741824] gcd [Bignum, -1073741825] => ", "[Fixnum, 1]"],
 ["[Bignum, 1073741824] gcd [Bignum, 1073741825] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741824] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741824] gcd [Fixnum, 2] => ", "[Fixnum, 2]"],
 ["[Fixnum, -1073741824] gcd [Fixnum, 4] => ", "[Fixnum, 4]"],
 ["[Fixnum, -1073741824] gcd [Fixnum, 5] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741824] gcd [Fixnum, 25] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741824] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741824] gcd [Fixnum, -2] => ", "[Fixnum, 2]"],
 ["[Fixnum, -1073741824] gcd [Fixnum, -4] => ", "[Fixnum, 4]"],
 ["[Fixnum, -1073741824] gcd [Fixnum, -5] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741824] gcd [Fixnum, -25] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741824] gcd [Fixnum, 1073741823] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741824] gcd [Fixnum, -1073741823] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741824] gcd [Fixnum, -1073741824] => ",
  "[Bignum, 1073741824]"],
 ["[Fixnum, -1073741824] gcd [Bignum, 1073741824] => ",
  "[Bignum, 1073741824]"],
 ["[Fixnum, -1073741824] gcd [Bignum, 1073741824] => ",
  "[Bignum, 1073741824]"],
 ["[Fixnum, -1073741824] gcd [Fixnum, -1073741824] => ",
  "[Bignum, 1073741824]"],
 ["[Fixnum, -1073741824] gcd [Bignum, -1073741825] => ", "[Fixnum, 1]"],
 ["[Fixnum, -1073741824] gcd [Bignum, 1073741825] => ", "[Fixnum, 1]"],
 ["[Bignum, -1073741825] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Bignum, -1073741825] gcd [Fixnum, 2] => ", "[Fixnum, 1]"],
 ["[Bignum, -1073741825] gcd [Fixnum, 4] => ", "[Fixnum, 1]"],
 ["[Bignum, -1073741825] gcd [Fixnum, 5] => ", "[Fixnum, 5]"],
 ["[Bignum, -1073741825] gcd [Fixnum, 25] => ", "[Fixnum, 25]"],
 ["[Bignum, -1073741825] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Bignum, -1073741825] gcd [Fixnum, -2] => ", "[Fixnum, 1]"],
 ["[Bignum, -1073741825] gcd [Fixnum, -4] => ", "[Fixnum, 1]"],
 ["[Bignum, -1073741825] gcd [Fixnum, -5] => ", "[Fixnum, 5]"],
 ["[Bignum, -1073741825] gcd [Fixnum, -25] => ", "[Fixnum, 25]"],
 ["[Bignum, -1073741825] gcd [Fixnum, 1073741823] => ", "[Fixnum, 1]"],
 ["[Bignum, -1073741825] gcd [Fixnum, -1073741823] => ", "[Fixnum, 1]"],
 ["[Bignum, -1073741825] gcd [Fixnum, -1073741824] => ", "[Fixnum, 1]"],
 ["[Bignum, -1073741825] gcd [Bignum, 1073741824] => ", "[Fixnum, 1]"],
 ["[Bignum, -1073741825] gcd [Bignum, 1073741824] => ", "[Fixnum, 1]"],
 ["[Bignum, -1073741825] gcd [Fixnum, -1073741824] => ", "[Fixnum, 1]"],
 ["[Bignum, -1073741825] gcd [Bignum, -1073741825] => ",
  "[Bignum, 1073741825]"],
 ["[Bignum, -1073741825] gcd [Bignum, 1073741825] => ",
  "[Bignum, 1073741825]"],
 ["[Bignum, 1073741825] gcd [Fixnum, 1] => ", "[Fixnum, 1]"],
 ["[Bignum, 1073741825] gcd [Fixnum, 2] => ", "[Fixnum, 1]"],
 ["[Bignum, 1073741825] gcd [Fixnum, 4] => ", "[Fixnum, 1]"],
 ["[Bignum, 1073741825] gcd [Fixnum, 5] => ", "[Fixnum, 5]"],
 ["[Bignum, 1073741825] gcd [Fixnum, 25] => ", "[Fixnum, 25]"],
 ["[Bignum, 1073741825] gcd [Fixnum, -1] => ", "[Fixnum, 1]"],
 ["[Bignum, 1073741825] gcd [Fixnum, -2] => ", "[Fixnum, 1]"],
 ["[Bignum, 1073741825] gcd [Fixnum, -4] => ", "[Fixnum, 1]"],
 ["[Bignum, 1073741825] gcd [Fixnum, -5] => ", "[Fixnum, 5]"],
 ["[Bignum, 1073741825] gcd [Fixnum, -25] => ", "[Fixnum, 25]"],
 ["[Bignum, 1073741825] gcd [Fixnum, 1073741823] => ", "[Fixnum, 1]"],
 ["[Bignum, 1073741825] gcd [Fixnum, -1073741823] => ", "[Fixnum, 1]"],
 ["[Bignum, 1073741825] gcd [Fixnum, -1073741824] => ", "[Fixnum, 1]"],
 ["[Bignum, 1073741825] gcd [Bignum, 1073741824] => ", "[Fixnum, 1]"],
 ["[Bignum, 1073741825] gcd [Bignum, 1073741824] => ", "[Fixnum, 1]"],
 ["[Bignum, 1073741825] gcd [Fixnum, -1073741824] => ", "[Fixnum, 1]"],
 ["[Bignum, 1073741825] gcd [Bignum, -1073741825] => ",
  "[Bignum, 1073741825]"],
 ["[Bignum, 1073741825] gcd [Bignum, 1073741825] => ", "[Bignum, 1073741825]"]]
else
  pp RbConfig::CONFIG
  @@expected = nil
end

  def test_results
    values = 
      [
       1, 2, 4, 5, 25,
       -1, -2, -4, -5, -25,
       @@biggest_positive_fixnum, - @@biggest_positive_fixnum,
       @@biggest_negative_fixnum, - @@biggest_negative_fixnum,
       @@smallest_positive_bignum, - @@smallest_positive_bignum,
       @@smallest_negative_bignum, - @@smallest_negative_bignum,
      ]

    result = [ ]
    values.each do | x |
      values.each do | y |
        result <<
          [ "#{xc(x)} gcd #{xc(y)} => ", 
            begin
              xc(x.gcd(y))
            rescue => err
              err
            end
          ]
      end
    end
    
    if @@expected 
      if result != @@expected
        @@expected.each_with_index do | x, i |
          y = result[i]
          assert_equal x, y
        end
      end
    else
      puts "@@expected = "
      pp result
    end
  end
end
