/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSWebKitTransitionEvent.h"

#include <wtf/GetPtr.h>

#include "KURL.h"
#include "WebKitTransitionEvent.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSWebKitTransitionEvent)

/* Hash table */

static const HashTableValue JSWebKitTransitionEventTableValues[4] =
{
    { "propertyName", DontDelete|ReadOnly, (intptr_t)jsWebKitTransitionEventPropertyName, (intptr_t)0 },
    { "elapsedTime", DontDelete|ReadOnly, (intptr_t)jsWebKitTransitionEventElapsedTime, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsWebKitTransitionEventConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSWebKitTransitionEventTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 7, JSWebKitTransitionEventTableValues, 0 };
#else
    { 8, 7, JSWebKitTransitionEventTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSWebKitTransitionEventConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSWebKitTransitionEventConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSWebKitTransitionEventConstructorTableValues, 0 };
#else
    { 1, 0, JSWebKitTransitionEventConstructorTableValues, 0 };
#endif

class JSWebKitTransitionEventConstructor : public DOMObject {
public:
    JSWebKitTransitionEventConstructor(ExecState* exec)
        : DOMObject(JSWebKitTransitionEventConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSWebKitTransitionEventPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSWebKitTransitionEventConstructor::s_info = { "WebKitTransitionEventConstructor", 0, &JSWebKitTransitionEventConstructorTable, 0 };

bool JSWebKitTransitionEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebKitTransitionEventConstructor, DOMObject>(exec, &JSWebKitTransitionEventConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSWebKitTransitionEventPrototypeTableValues[2] =
{
    { "initWebKitTransitionEvent", DontDelete|Function, (intptr_t)jsWebKitTransitionEventPrototypeFunctionInitWebKitTransitionEvent, (intptr_t)5 },
    { 0, 0, 0, 0 }
};

static const HashTable JSWebKitTransitionEventPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSWebKitTransitionEventPrototypeTableValues, 0 };
#else
    { 2, 1, JSWebKitTransitionEventPrototypeTableValues, 0 };
#endif

const ClassInfo JSWebKitTransitionEventPrototype::s_info = { "WebKitTransitionEventPrototype", 0, &JSWebKitTransitionEventPrototypeTable, 0 };

JSObject* JSWebKitTransitionEventPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSWebKitTransitionEvent>(exec);
}

bool JSWebKitTransitionEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSWebKitTransitionEventPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSWebKitTransitionEvent::s_info = { "WebKitTransitionEvent", &JSEvent::s_info, &JSWebKitTransitionEventTable, 0 };

JSWebKitTransitionEvent::JSWebKitTransitionEvent(PassRefPtr<Structure> structure, PassRefPtr<WebKitTransitionEvent> impl)
    : JSEvent(structure, impl)
{
}

JSObject* JSWebKitTransitionEvent::createPrototype(ExecState* exec)
{
    return new (exec) JSWebKitTransitionEventPrototype(JSWebKitTransitionEventPrototype::createStructure(JSEventPrototype::self(exec)));
}

bool JSWebKitTransitionEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebKitTransitionEvent, Base>(exec, &JSWebKitTransitionEventTable, this, propertyName, slot);
}

JSValuePtr jsWebKitTransitionEventPropertyName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    WebKitTransitionEvent* imp = static_cast<WebKitTransitionEvent*>(static_cast<JSWebKitTransitionEvent*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->propertyName());
}

JSValuePtr jsWebKitTransitionEventElapsedTime(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    WebKitTransitionEvent* imp = static_cast<WebKitTransitionEvent*>(static_cast<JSWebKitTransitionEvent*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->elapsedTime());
}

JSValuePtr jsWebKitTransitionEventConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSWebKitTransitionEvent*>(asObject(slot.slotBase()))->getConstructor(exec);
}
JSValuePtr JSWebKitTransitionEvent::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSWebKitTransitionEventConstructor>(exec);
}

JSValuePtr jsWebKitTransitionEventPrototypeFunctionInitWebKitTransitionEvent(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSWebKitTransitionEvent::s_info))
        return throwError(exec, TypeError);
    JSWebKitTransitionEvent* castedThisObj = static_cast<JSWebKitTransitionEvent*>(asObject(thisValue));
    WebKitTransitionEvent* imp = static_cast<WebKitTransitionEvent*>(castedThisObj->impl());
    const UString& typeArg = args.at(exec, 0)->toString(exec);
    bool canBubbleArg = args.at(exec, 1)->toBoolean(exec);
    bool cancelableArg = args.at(exec, 2)->toBoolean(exec);
    const UString& propertyNameArg = args.at(exec, 3)->toString(exec);
    double elapsedTimeArg = args.at(exec, 4)->toNumber(exec);

    imp->initWebKitTransitionEvent(typeArg, canBubbleArg, cancelableArg, propertyNameArg, elapsedTimeArg);
    return jsUndefined();
}


}
