/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSRangeException.h"

#include <wtf/GetPtr.h>

#include "KURL.h"
#include "RangeException.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSRangeException)

/* Hash table */

static const HashTableValue JSRangeExceptionTableValues[5] =
{
    { "code", DontDelete|ReadOnly, (intptr_t)jsRangeExceptionCode, (intptr_t)0 },
    { "name", DontDelete|ReadOnly, (intptr_t)jsRangeExceptionName, (intptr_t)0 },
    { "message", DontDelete|ReadOnly, (intptr_t)jsRangeExceptionMessage, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsRangeExceptionConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSRangeExceptionTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSRangeExceptionTableValues, 0 };
#else
    { 10, 7, JSRangeExceptionTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSRangeExceptionConstructorTableValues[3] =
{
    { "BAD_BOUNDARYPOINTS_ERR", DontDelete|ReadOnly, (intptr_t)jsRangeExceptionBAD_BOUNDARYPOINTS_ERR, (intptr_t)0 },
    { "INVALID_NODE_TYPE_ERR", DontDelete|ReadOnly, (intptr_t)jsRangeExceptionINVALID_NODE_TYPE_ERR, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSRangeExceptionConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 1, JSRangeExceptionConstructorTableValues, 0 };
#else
    { 4, 3, JSRangeExceptionConstructorTableValues, 0 };
#endif

class JSRangeExceptionConstructor : public DOMObject {
public:
    JSRangeExceptionConstructor(ExecState* exec)
        : DOMObject(JSRangeExceptionConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSRangeExceptionPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSRangeExceptionConstructor::s_info = { "RangeExceptionConstructor", 0, &JSRangeExceptionConstructorTable, 0 };

bool JSRangeExceptionConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSRangeExceptionConstructor, DOMObject>(exec, &JSRangeExceptionConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSRangeExceptionPrototypeTableValues[4] =
{
    { "BAD_BOUNDARYPOINTS_ERR", DontDelete|ReadOnly, (intptr_t)jsRangeExceptionBAD_BOUNDARYPOINTS_ERR, (intptr_t)0 },
    { "INVALID_NODE_TYPE_ERR", DontDelete|ReadOnly, (intptr_t)jsRangeExceptionINVALID_NODE_TYPE_ERR, (intptr_t)0 },
    { "toString", DontDelete|DontEnum|Function, (intptr_t)jsRangeExceptionPrototypeFunctionToString, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSRangeExceptionPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSRangeExceptionPrototypeTableValues, 0 };
#else
    { 8, 7, JSRangeExceptionPrototypeTableValues, 0 };
#endif

const ClassInfo JSRangeExceptionPrototype::s_info = { "RangeExceptionPrototype", 0, &JSRangeExceptionPrototypeTable, 0 };

JSObject* JSRangeExceptionPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSRangeException>(exec);
}

bool JSRangeExceptionPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSRangeExceptionPrototype, JSObject>(exec, &JSRangeExceptionPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSRangeException::s_info = { "RangeException", 0, &JSRangeExceptionTable, 0 };

JSRangeException::JSRangeException(PassRefPtr<Structure> structure, PassRefPtr<RangeException> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSRangeException::~JSRangeException()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSRangeException::createPrototype(ExecState* exec)
{
    return new (exec) JSRangeExceptionPrototype(JSRangeExceptionPrototype::createStructure(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSRangeException::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSRangeException, Base>(exec, &JSRangeExceptionTable, this, propertyName, slot);
}

JSValuePtr jsRangeExceptionCode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    RangeException* imp = static_cast<RangeException*>(static_cast<JSRangeException*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->code());
}

JSValuePtr jsRangeExceptionName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    RangeException* imp = static_cast<RangeException*>(static_cast<JSRangeException*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->name());
}

JSValuePtr jsRangeExceptionMessage(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    RangeException* imp = static_cast<RangeException*>(static_cast<JSRangeException*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->message());
}

JSValuePtr jsRangeExceptionConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSRangeException*>(asObject(slot.slotBase()))->getConstructor(exec);
}
JSValuePtr JSRangeException::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSRangeExceptionConstructor>(exec);
}

JSValuePtr jsRangeExceptionPrototypeFunctionToString(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSRangeException::s_info))
        return throwError(exec, TypeError);
    JSRangeException* castedThisObj = static_cast<JSRangeException*>(asObject(thisValue));
    RangeException* imp = static_cast<RangeException*>(castedThisObj->impl());


    JSC::JSValuePtr result = jsString(exec, imp->toString());
    return result;
}

// Constant getters

JSValuePtr jsRangeExceptionBAD_BOUNDARYPOINTS_ERR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValuePtr jsRangeExceptionINVALID_NODE_TYPE_ERR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSC::JSValuePtr toJS(JSC::ExecState* exec, RangeException* object)
{
    return getDOMObjectWrapper<JSRangeException>(exec, object);
}
RangeException* toRangeException(JSC::JSValuePtr value)
{
    return value->isObject(&JSRangeException::s_info) ? static_cast<JSRangeException*>(asObject(value))->impl() : 0;
}

}
