# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
# See the COPYING file for license information.
#
# Copyright (c) 2006, 2007 Guillaume Chazarain <guichaz@yahoo.fr>

class observable(object):
    """The Observer/Observable pattern"""

    def __init__(self):
        self.callbacks = []

    def add_observer(self, callback):
        self.callbacks.append(callback)

    def del_observer(self, callback):
        self.callbacks.remove(callback)

    def fire_observers(self, *args, **kwargs):
        # Copy in case the list is modified by an observer
        for cb in self.callbacks[:]:
            cb(*args, **kwargs)
