/*
 * Decompiled with CFR 0.152.
 */
package org.fife.plaf.OfficeXP;

import com.sun.java.swing.plaf.windows.WindowsToolBarUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;

public class OfficeXPToolBarUI
extends WindowsToolBarUI {
    private Listener listener;
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);

    public static ComponentUI createUI(JComponent jComponent) {
        return new OfficeXPToolBarUI();
    }

    public static final int getContainedComponentsHeight(JComponent jComponent) {
        Component[] componentArray = jComponent.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += componentArray[i].getHeight();
        }
        Insets insets = jComponent.getInsets();
        return n2 + insets.top + insets.bottom;
    }

    public static final int getContainedComponentsWidth(JComponent jComponent) {
        Component[] componentArray = jComponent.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += componentArray[i].getWidth();
        }
        Insets insets = jComponent.getInsets();
        return n2 + insets.left + insets.right;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        JToolBar jToolBar = (JToolBar)jComponent;
        this.listener = new Listener(jToolBar);
        jToolBar.addContainerListener(this.listener);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.paint(graphics, jComponent, jComponent.getBackground(), UIManager.getColor("MenuBar.background"));
    }

    public void paint(Graphics graphics, JComponent jComponent, Color color, Color color2) {
        Insets insets;
        Container container = jComponent.getParent();
        boolean bl = container instanceof JFileChooser;
        if (bl) {
            super.paint(graphics, jComponent);
        }
        Rectangle rectangle = jComponent.getBounds();
        Border border = jComponent.getBorder();
        Insets insets2 = insets = border != null ? border.getBorderInsets(jComponent) : EMPTY_INSETS;
        if (!this.isFloating() && !bl && ((JToolBar)jComponent).isBorderPainted()) {
            graphics.setColor(color2);
            graphics.fillRect(0, 0, rectangle.width, 2);
            rectangle.y += 2;
        } else if (bl) {
            insets.right = 0;
            insets.bottom = 0;
            insets.left = 0;
            insets.top = 0;
        }
        graphics.setColor(color2);
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        if (((JToolBar)jComponent).getOrientation() == 0) {
            ComponentOrientation componentOrientation = this.toolBar.getComponentOrientation();
            int n = OfficeXPToolBarUI.getContainedComponentsWidth(jComponent);
            graphics.setColor(color);
            if (componentOrientation.isLeftToRight()) {
                graphics.fillRect(insets.left, insets.top, n - insets.left, rectangle.height - insets.top);
            } else {
                int n2 = rectangle.width - insets.right - n - 1;
                graphics.fillRect(n2, insets.top, n, rectangle.height - insets.top);
            }
        } else {
            int n = OfficeXPToolBarUI.getContainedComponentsHeight(jComponent);
            graphics.setColor(color);
            graphics.fillRect(0, insets.top, rectangle.width, n - insets.top);
        }
    }

    public void setFloating(boolean bl, Point point) {
        this.toolBar.setBorderPainted(!bl);
        super.setFloating(bl, point);
    }

    private static final boolean shouldNotBeOpaque(Component component) {
        return component instanceof JComponent && !(component instanceof JTextField) && !(component instanceof JComboBox);
    }

    public void uninstallUI(JComponent jComponent) {
        JToolBar jToolBar = (JToolBar)jComponent;
        this.listener.restoreOriginalOpaquities();
        jToolBar.removeContainerListener(this.listener);
        this.listener = null;
        super.uninstallUI(jComponent);
    }

    private class Listener
    implements ContainerListener {
        private HashMap origOpaquities = new HashMap(8);

        public Listener(JToolBar jToolBar) {
            SwingUtilities.invokeLater(new Runnable(this, jToolBar){
                private final /* synthetic */ JToolBar val$toolBar;
                private final /* synthetic */ Listener this$1;
                {
                    this.this$1 = listener;
                    this.val$toolBar = jToolBar;
                }

                public void run() {
                    Component[] componentArray = this.val$toolBar.getComponents();
                    for (int i = 0; i < componentArray.length; ++i) {
                        Listener.access$000(this.this$1, componentArray[i]);
                    }
                }
            });
        }

        private void addToolbarComponent(Component component) {
            if (OfficeXPToolBarUI.shouldNotBeOpaque(component)) {
                JComponent jComponent = (JComponent)component;
                this.origOpaquities.put(jComponent, new Boolean(jComponent.isOpaque()));
                jComponent.setOpaque(false);
            }
        }

        public void componentAdded(ContainerEvent containerEvent) {
            this.addToolbarComponent(containerEvent.getChild());
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            this.removeToolbarComponent(component);
            this.origOpaquities.remove(component);
        }

        private void removeToolbarComponent(Component component) {
            if (component instanceof JComponent) {
                JComponent jComponent = (JComponent)component;
                Boolean bl = (Boolean)this.origOpaquities.get(component);
                if (bl != null) {
                    jComponent.setOpaque(bl);
                }
            }
        }

        public void restoreOriginalOpaquities() {
            Iterator iterator = this.origOpaquities.keySet().iterator();
            while (iterator.hasNext()) {
                this.removeToolbarComponent((JComponent)iterator.next());
            }
            this.origOpaquities.clear();
        }

        static /* synthetic */ void access$000(Listener listener, Component component) {
            listener.addToolbarComponent(component);
        }
    }
}

