/*
 * Decompiled with CFR 0.152.
 */
package net.sf.phpeasyvcs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.event.EventListenerList;
import net.sf.phpeasyvcs.ProgressEvent;
import net.sf.phpeasyvcs.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Uploader {
    private static final long DIR_SIZE = 1024L;
    private URL remoteRoot;
    private String cookies;
    private EventListenerList listenerList;
    private boolean running = false;
    private File currentFile = null;
    private long progress = 0L;
    private long total = 0L;

    public Uploader(URL remoteRoot, String cookies) {
        this.remoteRoot = remoteRoot;
        this.cookies = cookies;
        this.listenerList = new EventListenerList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFile(File file, String comment, boolean doExtract) throws Exception {
        if (file == null) {
            return true;
        }
        Uploader uploader = this;
        synchronized (uploader) {
            if (this.running) {
                return false;
            }
            this.running = true;
        }
        this.total = this.getSize(file);
        this.progress = 0L;
        try {
            this.currentFile = file;
            URL url = new URL(this.remoteRoot.toString() + "/" + URLEncoder.encode(file.getName(), "UTF-8"));
            boolean bl = this.uploadFile(file, url, comment != null ? comment : "", doExtract);
            return bl;
        }
        finally {
            Uploader uploader2 = this;
            synchronized (uploader2) {
                this.running = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFiles(Collection<File> files, String comment, boolean doExtract) throws Exception {
        if (files == null || files.size() <= 0) {
            return true;
        }
        Uploader uploader = this;
        synchronized (uploader) {
            if (this.running) {
                return false;
            }
            this.running = true;
        }
        try {
            this.total = 0L;
            for (File file : files) {
                this.total += this.getSize(file);
            }
            this.progress = 0L;
            boolean result = true;
            Iterator<File> i$ = files.iterator();
            while (i$.hasNext()) {
                File file;
                this.currentFile = file = i$.next();
                URL url = new URL(this.remoteRoot.toString() + "/" + URLEncoder.encode(file.getName(), "UTF-8"));
                result = this.uploadFile(file, url, comment != null ? comment : "", doExtract) && result;
            }
            boolean bl = result;
            return bl;
        }
        finally {
            Uploader uploader2 = this;
            synchronized (uploader2) {
                this.running = false;
            }
        }
    }

    private long getSize(File file) {
        if (file.isDirectory()) {
            File[] files;
            long size = 1024L;
            for (File f : files = file.listFiles()) {
                size += this.getSize(f);
            }
            return size;
        }
        return file.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean uploadFile(File file, URL url, String comment, boolean doExtract) throws Exception {
        String charset = "UTF-8";
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Cookie", this.cookies);
        conn.setDoOutput(true);
        conn.setRequestProperty("Accept-Charset", charset);
        OutputStream os = null;
        if (file.isDirectory()) {
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=" + charset);
            os = conn.getOutputStream();
            PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(os, charset), true);
            writer.append("comment=").append(URLEncoder.encode(comment, charset));
            int status = conn.getResponseCode();
            if (status >= 200 && status < 300) {
                File[] files;
                this.progress += 1024L;
                this.fireProgress(new ProgressEvent(this.currentFile, this.progress, this.total));
                boolean ok = true;
                for (File f : files = file.listFiles()) {
                    URL u = new URL(url.toString() + "/" + URLEncoder.encode(f.getName(), "UTF-8"));
                    ok = this.uploadFile(f, u, comment, false) && ok;
                }
                boolean arr$ = ok;
                return arr$;
            }
            boolean ok = false;
            return ok;
        }
        String CRLF = "\r\n";
        String boundary = Long.toHexString(System.currentTimeMillis());
        conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        os = conn.getOutputStream();
        PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(os, charset), true);
        writer.append("--" + boundary).append(CRLF);
        writer.append("Content-Disposition: form-data; name=\"comment\"").append(CRLF);
        writer.append("Content-Type: text/plain; charset=" + charset).append(CRLF);
        writer.append(CRLF);
        writer.append(comment).append(CRLF).flush();
        writer.append("--" + boundary).append(CRLF);
        writer.append("Content-Disposition: form-data; name=\"file\"; filename=\"" + file.getName() + "\"").append(CRLF);
        writer.append("Content-Type: " + URLConnection.guessContentTypeFromName(file.getName())).append(CRLF);
        writer.append("Content-Transfer-Encoding: binary").append(CRLF);
        writer.append(CRLF).flush();
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            byte[] buffer = new byte[32768];
            int length = 0;
            while ((length = ((InputStream)is).read(buffer)) >= 0) {
                os.write(buffer, 0, length);
                this.progress += (long)length;
                this.fireProgress(new ProgressEvent(this.currentFile, this.progress, this.total));
            }
            os.flush();
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {}
            }
        }
        writer.append(CRLF).flush();
        writer.append("--" + boundary + "--").append(CRLF);
        writer.flush();
        int status = conn.getResponseCode();
        boolean bl = status >= 200 && status < 300;
        return bl;
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void addProgressListener(ProgressListener listener) {
        this.listenerList.add(ProgressListener.class, listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.listenerList.remove(ProgressListener.class, listener);
    }

    void fireProgress(ProgressEvent event) {
        for (ProgressListener listener : (ProgressListener[])this.listenerList.getListeners(ProgressListener.class)) {
            listener.progressOccurred(event);
        }
    }
}

