/*
 * Decompiled with CFR 0.152.
 */
package net.sf.phpeasyvcs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.event.EventListenerList;
import net.sf.phpeasyvcs.JSON;
import net.sf.phpeasyvcs.ProgressEvent;
import net.sf.phpeasyvcs.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Downloader {
    private static final long DIR_SIZE = 1024L;
    private URL remoteRoot;
    private String cookies;
    private EventListenerList listenerList;
    private boolean running = false;
    private String currentName = null;
    private long progress = 0L;
    private long total = 0L;

    public Downloader(URL remoteRoot, String cookies) {
        this.remoteRoot = remoteRoot;
        this.cookies = cookies;
        this.listenerList = new EventListenerList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadFile(File dir, String name) throws Exception {
        Downloader downloader = this;
        synchronized (downloader) {
            if (this.running) {
                return false;
            }
            this.running = true;
        }
        try {
            HashSet<String> names = new HashSet<String>();
            names.add(name);
            HashMap<String, Object> namesAndSizes = new HashMap<String, Object>();
            this.total = this.getSize(this.remoteRoot, names, namesAndSizes);
            this.progress = 0L;
            this.currentName = null;
            this.downloadFiles(dir, this.remoteRoot, namesAndSizes);
            boolean bl = true;
            return bl;
        }
        finally {
            Downloader downloader2 = this;
            synchronized (downloader2) {
                this.running = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadFiles(File dir, Collection<String> names) throws IOException {
        Downloader downloader = this;
        synchronized (downloader) {
            if (this.running) {
                return false;
            }
            this.running = true;
        }
        try {
            HashMap<String, Object> namesAndSizes = new HashMap<String, Object>();
            this.total = this.getSize(this.remoteRoot, names, namesAndSizes);
            this.progress = 0L;
            this.currentName = null;
            this.downloadFiles(dir, this.remoteRoot, namesAndSizes);
            boolean bl = true;
            return bl;
        }
        finally {
            Downloader downloader2 = this;
            synchronized (downloader2) {
                this.running = false;
            }
        }
    }

    private long getSize(URL url, Collection<String> names, Map<String, Object> namesAndSizes) throws IOException {
        long totalSize = 0L;
        if (url.toString().length() <= this.remoteRoot.toString().length()) {
            this.fireProgress(new ProgressEvent("Preparing...", 0L, 100L));
        } else {
            this.fireProgress(new ProgressEvent("Preparing... (" + url.toString().substring(this.remoteRoot.toString().length() + 1) + ")", 0L, 100L));
        }
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Cookie", this.cookies);
        int status = conn.getResponseCode();
        if (status == 200) {
            String contenttype = conn.getContentType();
            int pos = contenttype.indexOf("charset=");
            String charset = pos >= 0 ? contenttype.substring(pos + 8) : "UTF-8";
            Object result = JSON.read(new InputStreamReader(conn.getInputStream(), charset));
            for (Map item : (List)result) {
                boolean isDir;
                String name = item.get("name").toString();
                if (names != null && !names.contains(name)) continue;
                boolean bl = isDir = item.containsKey("directory") ? (Boolean)item.get("directory") : false;
                if (isDir) {
                    HashMap<String, Object> subNamesAndSizes = new HashMap<String, Object>();
                    long size = this.getSize(new URL(url.toString() + "/" + name), null, subNamesAndSizes);
                    namesAndSizes.put(name, subNamesAndSizes);
                    totalSize += 1024L + size;
                    continue;
                }
                long size = ((Number)item.get("size")).longValue();
                namesAndSizes.put(name, size);
                totalSize += size;
            }
        }
        return totalSize;
    }

    private boolean downloadFiles(File dir, URL url, Map<String, Object> namesAndSizes) throws IOException {
        boolean ok = true;
        boolean setCurrentName = this.currentName == null;
        for (String name : namesAndSizes.keySet()) {
            Object value;
            if (setCurrentName) {
                this.currentName = name;
            }
            if ((value = namesAndSizes.get(name)) instanceof Number) {
                URL fileURL = new URL(url.toString() + "/" + URLEncoder.encode(name, "UTF-8"));
                HttpURLConnection conn = (HttpURLConnection)fileURL.openConnection();
                conn.setRequestProperty("Cookie", this.cookies);
                int status = conn.getResponseCode();
                if (status == 200) {
                    int len;
                    InputStream is = conn.getInputStream();
                    File file = new File(dir.getPath() + "/" + name);
                    FileOutputStream os = new FileOutputStream(file);
                    byte[] buf = new byte[65536];
                    while ((len = is.read(buf)) >= 0) {
                        ((OutputStream)os).write(buf, 0, len);
                        this.progress += (long)len;
                        this.fireProgress(new ProgressEvent(this.currentName, this.progress, this.total));
                    }
                    ((OutputStream)os).close();
                    is.close();
                    continue;
                }
                ok = false;
                continue;
            }
            Map subNamesAndSizes = (Map)namesAndSizes.get(name);
            File subDir = new File(dir.getPath() + "/" + name);
            ok = subDir.mkdirs() && ok;
            this.progress += 1024L;
            this.fireProgress(new ProgressEvent(this.currentName, this.progress, this.total));
            ok = this.downloadFiles(subDir, new URL(url.toString() + "/" + name), subNamesAndSizes) && ok;
        }
        return ok;
    }

    public void addProgressListener(ProgressListener listener) {
        this.listenerList.add(ProgressListener.class, listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.listenerList.remove(ProgressListener.class, listener);
    }

    void fireProgress(ProgressEvent event) {
        for (ProgressListener listener : (ProgressListener[])this.listenerList.getListeners(ProgressListener.class)) {
            listener.progressOccurred(event);
        }
    }
}

