
/*
 * Copyright (C) 2002-2003 Stefan Holst
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: otk_list.h 2099 2007-05-21 12:22:02Z mschwerin $
 *
 */

#ifndef HAVE_OTK_LIST_H
#define HAVE_OTK_LIST_H


typedef enum {

    /**
     * Items of the list may not be selected.
     */
    OTK_LIST_SELECTION_NONE,

    /**
     * Only one item of the list at a time may be selected. Selecting a new
     * item will unselect the previously selected item.
     */
    OTK_LIST_SELECTION_SINGLE,

    /**
     * Multiple items of the list may be selected at the same time.
     */
    OTK_LIST_SELECTION_MULTIPLE,
} otk_list_selection_t;


/**
 * Removes all items from the list.
 */
void otk_list_clear (otk_widget_t * list);

/**
 * Returns the index of the item that is the first of the visible items.
 */
int otk_list_get_pos (otk_widget_t * list);
void otk_list_set_pos (otk_widget_t * list, int pos);

/**
 * Returns the item that has the focus.
 */
int otk_list_get_focus (otk_widget_t * list);
void otk_list_set_focus (otk_widget_t * list, int pos);

/**
 * Returns the number of items in the list.
 */
int otk_list_get_length (otk_widget_t * list);

int *otk_list_get_selected_pos (otk_widget_t * list, int *num_selected);
void **otk_list_get_selected (otk_widget_t * list, int *num_selected);
void otk_list_set_selected (otk_widget_t * list, int pos, bool selected);
void otk_list_clear_selection (otk_widget_t * list);
int otk_list_get_selected_count (otk_widget_t * list);
void otk_list_select_all (otk_widget_t * list);

otk_widget_t *otk_listentry_get_list (otk_widget_t * listentry);

otk_widget_t *otk_list_new (otk_t * otk, int x, int y, int w, int h,
                            int entry_height, int entry_spacing,
                            bool show_border, bool show_scrollbar,
                            otk_list_selection_t allow_select,
                            void *list_cb_data);

otk_widget_t *otk_listentry_new (otk_widget_t * list, const char *label,
                                 otk_cb_t activate_cb, void *activate_cb_data,
                                 otk_cb_t select_cb, void *select_cb_data,
                                 otk_cb_t remove_cb, void *remove_cb_data);

otk_widget_t *otk_selector_new (otk_t * otk, int x, int y, int w,
                                otk_int_set_cb_t cb, void *cb_data);

otk_widget_t *otk_selectoritem_new (otk_widget_t * selector,
                                    const char *label,
                                    otk_cb_t activate_cb,
                                    void *activate_cb_data);

otk_widget_t *otk_menulist_new (otk_t * otk, int x, int y, int w, int h,
                                int entry_height, int entry_spacing,
                                void *cb_data);

otk_widget_t *otk_menuitem_new (otk_widget_t * menu, const char *label,
                                otk_cb_t activate_cb, void *activate_cb_data);

#endif /* HAVE_OTK_LIST_H */
