
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: menulist.h 2537 2007-07-17 13:45:38Z mschwerin $
 *
 */

#ifndef HAVE_MENU_LIST_H
#define HAVE_MENU_LIST_H

#include "list.h"
#include "otk.h"

/// This represents one item in a menu.
typedef struct menuitem_s menuitem_t;
/// This represents a list of menuitems.
typedef struct menulist_s menulist_t;

/// This represents one item in a menu.
struct menuitem_s {
    /// The title of this item.
    char *title;

    /// A sub menu.
    menulist_t *submenu;

    /// Is this item a link to a parent.
    bool is_uplink;

    /// The callback of this item.
    void (*cb) (void *data);

    /// The user data that is passed to the callback.
    void *cb_data;
};


/// This represents a list of menuitems.
struct menulist_s {
    /// The list.
    l_list_t *list;

    /// The parent of this list.
    menulist_t *parent;

    /// The top left corner of the menu.
    int x;
    /// The top left corner of the menu.
    int y;
    /// The width of the menu.
    int w;
    /// The height of the menu.
    int h;
};


/**
 * Creates a new menu list reading the content from a file.
 *
 * @param mrl                   The MRL of the file containing the content
 *                              of the new menu.
 * @param parent                The parent menu. This may be NULL.
 */
menulist_t *menulist_new (const char *mrl, menulist_t * parent);


/**
 * Frees a menulist.
 *
 * @param menulist              The menulist object.
 */
void menulist_free (menulist_t * menulist);


#endif /* HAVE_MENU_LIST_H */
