dnl
dnl checking for libexif
dnl
AC_DEFUN([AC_CHECK_EXIF], [
    LIBEXIF_0_5_REQUIRED=0.5.12
    LIBEXIF_REQUIRED=0.6.9

    AC_ARG_ENABLE([exif],
                  AC_HELP_STRING([--disable-exif],
                                 [do not activate EXIF support]),
                  [enable_exif=$enableval], [enable_exif=yes])

    have_exif=no
    if test x$enable_exif = xyes ; then
       PKG_CHECK_MODULES(EXIF, libexif >= $LIBEXIF_REQUIRED,
                         AC_DEFINE(HAVE_LIBEXIF, 1, [Define to 1 if we have libexif support])
                         have_exif=yes,
                         [AC_MSG_RESULT(no)
                          PKG_CHECK_MODULES(EXIF, libexif >= $LIBEXIF_0_5_REQUIRED,
                                            [AC_DEFINE(HAVE_LIBEXIF_0_5, 1, [Using libexif 0.5])]
                                            have_exif=[yes],
                                            have_exif=[no])
                         ])
    fi
])
