/*
 *   
 *   Ophcrack is a Lanmanager/NTLM hash cracker based on the faster time-memory
 *   trade-off using rainbow tables. 
 *   
 *   Created with the help of: Maxime Mueller, Luca Wullschleger, Claude
 *   Hochreutiner, Andreas Huber and Etienne Dysli.
 *   
 *   Copyright (c) 2013 Philippe Oechslin, Cedric Tissieres, 
 *                      Bertrand Mesot, Pierre Lestringant
 *   
 *   Ophcrack is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *   
 *   Ophcrack is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with Ophcrack; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *   
 *   This program is released under the GPL with the additional exemption 
 *   that compiling, linking, and/or using OpenSSL is allowed.
 *   
 *   
 *   $Rev: 165 $
 *   $Date: 2013-04-23 16:03:33 +0200 (Tue, 23 Apr 2013) $
 *   
 *   
*/
/* WARNING: this file is a NOT copy from implCPU/v6 */

#ifndef IOCONTEXT_H
#define IOCONTEXT_H

#include <stdint.h>

#include "tableInfo.h"
#include "markov.h"

#define DEFAULT_CONTEXT_FILE_NAME "tablesInfo.xml"

typedef struct contextStruct contextStruct;
struct contextStruct{
  unsigned int nbTable;
  char** binFileName;
  char** startFileName;
  char** indexFileName;
  markovType mtype;
  char* markovFileName;
  char*	patternFileName;
  unsigned int*	nbByteM0;
  unsigned int* nbByteM;
  unsigned int* nbByteBin;
  unsigned int nbBitIndex;
  tableInfo** ti;
};

char readContextFromXML(contextStruct* cs, char* path);

void contextStruct_free(contextStruct* cs);


#endif
