/*
 *   
 *   Ophcrack is a Lanmanager/NTLM hash cracker based on the faster time-memory
 *   trade-off using rainbow tables. 
 *   
 *   Created with the help of: Maxime Mueller, Luca Wullschleger, Claude
 *   Hochreutiner, Andreas Huber and Etienne Dysli.
 *   
 *   Copyright (c) 2013 Philippe Oechslin, Cedric Tissieres, 
 *                      Bertrand Mesot, Pierre Lestringant
 *   
 *   Ophcrack is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *   
 *   Ophcrack is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with Ophcrack; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *   
 *   This program is released under the GPL with the additional exemption 
 *   that compiling, linking, and/or using OpenSSL is allowed.
 *   
 *   
 *   $Rev: 167 $
 *   $Date: 2013-05-02 12:42:33 +0200 (Thu, 02 May 2013) $
 *   
 *   
*/
/* WARNING: this file is a NOT copy from implCPU/v6 */

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <expat.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>

#include "ioMarkov.h"
#include "ioContext.h"

#define DEFAULT_FILE_NAME_SIZE 100

#define TABLE_BIN_NAME_PREFIX "bin"
#define TABLE_START_NAME_PREFIX "start"
#define TABLE_INDEX_NAME_PREFIX "index"
#define TABLE_FILE_NAME_SUFFIX ".dat"

typedef enum xmlElement xmlElement;
enum xmlElement{
  BINNAME, STARTNAME, INDEXNAME, NBCHAIN, NBCOLUMN, POWER2, MARKOVTYPE, MARKOVNAME, PATTERNNAME, BYTEM0, BYTEM, BYTEBIN, NBBITINDEX, UNKOWN
};

typedef struct xmlDataWrapper xmlDataWrapper;
struct xmlDataWrapper{
  contextStruct* cs;
  xmlElement currentElement;
  int tableCounter;
};

void handle_start_element(void *data, const char *element, const char **attribute){
  xmlDataWrapper* wrap = (xmlDataWrapper*)data;
	
  if (!strcmp(element, "binName")){
    wrap->currentElement = BINNAME;
    return;
  }
  if (!strcmp(element, "startName")){
    wrap->currentElement = STARTNAME;
    return;
  }
  if (!strcmp(element, "indexName")){
    wrap->currentElement = INDEXNAME;
    return;
  }
  if (!strcmp(element, "nbChain")){
    wrap->currentElement = NBCHAIN;
    return;
  }
  if (!strcmp(element, "nbColumn")){
    wrap->currentElement = NBCOLUMN;
    return;
  }
  if (!strcmp(element, "power2")){
    wrap->currentElement = POWER2;
    return;
  }
  if (!strcmp(element, "nbByteM0")){
    wrap->currentElement = BYTEM0;
    return;
  }
  if (!strcmp(element, "nbByteM")){
    wrap->currentElement = BYTEM;
    return;
  }
  if (!strcmp(element, "nbByteBin")){
    wrap->currentElement = BYTEBIN;
    return;
  }
  if (!strcmp(element, "markovType")){
    wrap->currentElement = MARKOVTYPE;
    return;
  }
  if (!strcmp(element, "markovFileName")){
    wrap->currentElement = MARKOVNAME;
    return;
  }
  if (!strcmp(element, "patternFileName")){
    wrap->currentElement = PATTERNNAME;
    return;
  }
  if (!strcmp(element, "nbBitIndex")){
    wrap->currentElement = NBBITINDEX;
    return;
  }
  if (!strcmp(element, "tableStorage")){
    unsigned int i;
	
    wrap->cs->nbTable = atoi(attribute[1]);
		
    wrap->cs->binFileName = (char**)malloc(sizeof(void*)*wrap->cs->nbTable);
    wrap->cs->startFileName = (char**)malloc(sizeof(void*)*wrap->cs->nbTable);
    wrap->cs->indexFileName = (char**)malloc(sizeof(void*)*wrap->cs->nbTable);
		
    wrap->cs->ti = (tableInfo**)malloc(sizeof(void*)*wrap->cs->nbTable);
		
    for (i = 0; i < wrap->cs->nbTable; i++){
      wrap->cs->binFileName[i] = (char*)malloc(DEFAULT_FILE_NAME_SIZE);
      wrap->cs->startFileName[i] = (char*)malloc(DEFAULT_FILE_NAME_SIZE);
      wrap->cs->indexFileName[i] = (char*)malloc(DEFAULT_FILE_NAME_SIZE);
			
      memset(wrap->cs->binFileName[i], '\0', DEFAULT_FILE_NAME_SIZE);
      memset(wrap->cs->startFileName[i], '\0', DEFAULT_FILE_NAME_SIZE);
      memset(wrap->cs->indexFileName[i], '\0', DEFAULT_FILE_NAME_SIZE);
			
      wrap->cs->ti[i] = (tableInfo*)malloc(sizeof(tableInfo));
    }
		
    wrap->cs->markovFileName = (char*)malloc(DEFAULT_FILE_NAME_SIZE);
    memset(wrap->cs->markovFileName, '\0', DEFAULT_FILE_NAME_SIZE);
		
    wrap->cs->patternFileName = (char*)malloc(DEFAULT_FILE_NAME_SIZE);
    memset(wrap->cs->patternFileName, '\0', DEFAULT_FILE_NAME_SIZE);
		
    wrap->cs->nbByteM0 = (unsigned int*)malloc(sizeof(unsigned int)*wrap->cs->nbTable);
    wrap->cs->nbByteM = (unsigned int*)malloc(sizeof(unsigned int)*wrap->cs->nbTable);
    wrap->cs->nbByteBin = (unsigned int*)malloc(sizeof(unsigned int)*wrap->cs->nbTable);
  }
  wrap->currentElement = UNKOWN;
}

void handle_end_element(void *data, const char *element){
  ((xmlDataWrapper*)data)->currentElement = UNKOWN;
  if (!strcmp(element, "table")){
    ((xmlDataWrapper*)data)->tableCounter ++;
  }
}

void handle_data(void *data, const char *content, int length){
  xmlDataWrapper* wrap = (xmlDataWrapper*)data;
	
  switch(wrap->currentElement){
  case BINNAME		: {memcpy(wrap->cs->binFileName[wrap->tableCounter], content, length); break;}
  case STARTNAME		: {memcpy(wrap->cs->startFileName[wrap->tableCounter], content, length); break;}
  case INDEXNAME		: {memcpy(wrap->cs->indexFileName[wrap->tableCounter], content, length); break;}
  case NBCHAIN		: {wrap->cs->ti[wrap->tableCounter]->nbChain = atol(content); break;}
  case NBCOLUMN		: {wrap->cs->ti[wrap->tableCounter]->nbColumn = atoi(content); break;}
  case POWER2			: {wrap->cs->ti[wrap->tableCounter]->power2 = atoi(content); break;}
  case MARKOVTYPE 	: {wrap->cs->mtype = fromStringMarkovType(content, length); break;}
  case MARKOVNAME 	: {memcpy(wrap->cs->markovFileName, content, length); break;}
  case PATTERNNAME 	: {memcpy(wrap->cs->patternFileName, content, length); break;}
  case BYTEM0			: {wrap->cs->nbByteM0[wrap->tableCounter] = atoi(content); break;}
  case BYTEM			: {wrap->cs->nbByteM[wrap->tableCounter] = atoi(content); break;}
  case BYTEBIN		: {wrap->cs->nbByteBin[wrap->tableCounter] = atoi(content); break;}
  case NBBITINDEX	: {wrap->cs->nbBitIndex = atoi(content); break;}
  case UNKOWN			: {break;}
  }
}

char readContextFromXML(contextStruct* cs, char* path){
  struct stat sb;
  char* xmlBuff;
  char fileName[256];
  sprintf(fileName, "%s/%s", path, DEFAULT_CONTEXT_FILE_NAME);
	
  int xmlFile = open(fileName, O_RDONLY);
	
  if (xmlFile == -1){
    return 0;
  }
	
  if (fstat(xmlFile, &sb) == -1){
    close(xmlFile);
    return 0;
  }

  xmlBuff = mmap(NULL, sb.st_size,  PROT_READ, MAP_PRIVATE, xmlFile, 0);
  if (xmlBuff == MAP_FAILED){
    close(xmlFile);
    return 0;
  }

	
  xmlDataWrapper data;
  data.cs = cs;
  data.currentElement = UNKOWN;
  data.tableCounter = 0;
	
  XML_Parser parser = XML_ParserCreate(NULL);
  XML_SetUserData(parser, &data);
  XML_SetElementHandler(parser, handle_start_element, handle_end_element);
  XML_SetCharacterDataHandler(parser, handle_data);
	
  if(XML_Parse(parser, xmlBuff, sb.st_size,  XML_TRUE) == XML_STATUS_ERROR){
    XML_ParserFree(parser);
    munmap(xmlBuff, sb.st_size);
    close(xmlFile);
    return 0;
  }
  else{
    XML_ParserFree(parser);
    munmap(xmlBuff, sb.st_size);
    close(xmlFile);
  }
	
  return 1;
}

void contextStruct_free(contextStruct* cs){
  unsigned int i;
	
  if (cs != NULL){
    if (cs->binFileName !=NULL){
      for (i = 0; i < cs->nbTable; i++){
	free(cs->binFileName[i]);
      }
      free(cs->binFileName);
    }
    if (cs->startFileName != NULL){
      for (i = 0; i < cs->nbTable; i++){
	free(cs->startFileName[i]);
      }
      free(cs->startFileName);
    }
    if (cs->indexFileName != NULL){
      for (i = 0; i < cs->nbTable; i++){
	free(cs->indexFileName[i]);
      }
      free(cs->indexFileName);
    }
    if (cs->markovFileName != NULL){
      free(cs->markovFileName);
    }
    if (cs->patternFileName != NULL){
      free(cs->patternFileName);
    }
    if (cs->nbByteM0 != NULL){
      free(cs->nbByteM0);
    }
    if (cs->nbByteM != NULL){
      free(cs->nbByteM);
    }
    if (cs->nbByteBin != NULL){
      free(cs->nbByteBin);
    }
    if (cs->ti != NULL){
      for (i = 0; i < cs->nbTable; i++){
	free(cs->ti[i]);
      }
      free(cs->ti);
    }
  }
  free(cs);
}
