/*
 *   
 *   Ophcrack is a Lanmanager/NTLM hash cracker based on the faster time-memory
 *   trade-off using rainbow tables. 
 *   
 *   Created with the help of: Maxime Mueller, Luca Wullschleger, Claude
 *   Hochreutiner, Andreas Huber and Etienne Dysli.
 *   
 *   Copyright (c) 2013 Philippe Oechslin, Cedric Tissieres, 
 *                      Bertrand Mesot, Pierre Lestringant
 *   
 *   Ophcrack is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *   
 *   Ophcrack is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with Ophcrack; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *   
 *   This program is released under the GPL with the additional exemption 
 *   that compiling, linking, and/or using OpenSSL is allowed.
 *   
 *   
 *   $Rev: 166 $
 *   $Date: 2013-04-23 16:16:34 +0200 (Tue, 23 Apr 2013) $
 *   
 *   
*/
#include <stdlib.h>
#include <stdint.h>
#include <string.h>

#include "probaTable.h"
#include "ioContext.h"
#include "hashToPwd.h"
#include "ophel.h"
#include "hash.h"

/*-------------------------------------------------------------------------*/
int probaTable_setup(void *tbl_) {
  table_t *tbl = tbl_;
  int idx = tbl->idx;
	
  tbl->ncols  = tbl->ptw->cs->ti[idx]->nbColumn;
  tbl->offset = tbl->ptw->cs->ti[idx]->nbColumn; 
	
  tbl->sizes  = (uint64_t*)malloc((2+2*tbl->ptw->cs->nbTable)*sizeof(uint64_t));
  tbl->sizes[0] = tbl->ptw->cs->nbTable;
  tbl->sizes[1] = (power(2, tbl->ptw->cs->nbBitIndex)+1) * tbl->ptw->cs->nbByteM[idx];
  tbl->sizes[2*idx+2] = tbl->ptw->cs->ti[idx]->nbChain * tbl->ptw->cs->nbByteBin[idx];
  tbl->sizes[2*idx+3] = tbl->ptw->cs->ti[idx]->nbChain * tbl->ptw->cs->nbByteM0[idx];

  tbl->find    = probaTable_find;
  tbl->check   = probaTable_check;
  tbl->isvalid = probaTable_isvalid;

  tbl->lookup_idx = probaTable_lookup_idx;
  tbl->lookup_end = probaTable_lookup_end;
  tbl->lookup_srt = probaTable_lookup_srt;

  return 1;
}
/*-------------------------------------------------------------------------*/
void probaTable_find(void *hsh_, void *tbl_, void *el_) {
  hash_t* 	hsh = hsh_;
  table_t* 	tbl = tbl_;
  ophel_t* 	el = el_;
	
  uchar_t* 	hash = hsh->hash;
  ophstat_t* 	stat = el->stat;
  uint64_t	end;
  uint32_t	idx = tbl->idx;
  uint32_t 	nbColumn = tbl->ncols;
  uint32_t	startColumn = el->col;
  uint32_t 	power2 = tbl->ptw->cs->ti[idx]->power2;

  end = hashToIndex(tbl->ptw->array, tbl->ptw->mdpw, tbl->ptw->mis, (unsigned int*)hash, startColumn, nbColumn, power2, idx, nbColumn);
  stat->hredux += nbColumn-startColumn-1;

  el->prefix  = end >> (power2 - tbl->ptw->cs->nbBitIndex);
  el->postfix = end & ((uint64_t)0xffffffffffffffff >> (64 + tbl->ptw->cs->nbBitIndex - power2));
}
/*-------------------------------------------------------------------------*/
int probaTable_lookup_idx(void *hsh_, void *tbl_, void *el_) {
  table_t* 	tbl = tbl_;
  ophel_t*	el  = el_;
  uint32_t 	prefix = el->prefix;
  ophstat_t*	stat = el->stat;
  uint32_t	nbByteM = tbl->ptw->cs->nbByteM[tbl->idx];

  stat->prefix++;

  if (tbl->preload > 0) {
    char* mem = tbl->idxmem + prefix*nbByteM;
    el->low = 0;
    el->high = 0;
    memcpy(&(el->low), mem, nbByteM);
    memcpy(&(el->high), mem+nbByteM, nbByteM);
  }
  else {
    FILE *idxfile = tbl->idxfile;
    fseeko(idxfile, prefix*nbByteM, SEEK_SET);
    el->low = 0;
    el->high = 0;
    fread(&(el->low), nbByteM, 1, idxfile);
    fread(&(el->high), nbByteM, 1, idxfile);
    stat->fseek_idx++;
  }

  return 1;
}
/*-------------------------------------------------------------------------*/
int probaTable_lookup_end(void *hsh_, void *tbl_, void *el_) {
  table_t* 	tbl = tbl_;
  ophel_t* 	el  = el_;
  ophstat_t* 	stat = el->stat;

  uint64_t 	postfix = el->postfix;
  uint64_t 	range = el->high - el->low;
  uint64_t 	i;
  uint32_t	nbByteBin = tbl->ptw->cs->nbByteBin[tbl->idx];
  uint64_t 	temp;
  char* 		mem;

  if (tbl->preload > 1) {
    mem = tbl->endmem + el->low*nbByteBin;
		
    for (i = 0; i < range; i++){
      temp = 0;
      memcpy(&temp, mem+i*nbByteBin, nbByteBin);
      if (temp == postfix){
	stat->postfix ++;
	break;
      }
    }
  }
  else {
    mem = (char*)malloc(range*nbByteBin);
    FILE* endfile = tbl->endfile;

    fseeko(endfile, el->low*nbByteBin, SEEK_SET);
    fread(mem, nbByteBin, range, endfile);
    stat->fseek_end++;

    for (i = 0; i < range; i++){
      temp = 0;
      memcpy(&temp, mem+i*nbByteBin, nbByteBin);
      if (temp == postfix){
	stat->postfix ++;
	break;
      }
    }
    free(mem);
  }

  el->offset = el->low+i;

  return  (i == range) ? 0 : 1;
}
/*-------------------------------------------------------------------------*/
int probaTable_lookup_srt(void *hsh_, void *tbl_, void *el_) {
  table_t* 	tbl = tbl_;
  ophel_t* 	el  = el_;
  ophstat_t* 	stat = el->stat;
  uint32_t	nbByteM0 = tbl->ptw->cs->nbByteM0[tbl->idx];
	
  stat->start ++;

  if (tbl->preload > 2) {
    el->start = 0;
    memcpy(&(el->start), tbl->srtmem + el->offset*nbByteM0, nbByteM0);
  }
  else {
    FILE *srtfile = tbl->srtfile;

    fseeko(srtfile, el->offset*nbByteM0, SEEK_SET);
    el->start = 0;
    fread(&(el->start), nbByteM0, 1, srtfile);
    stat->fseek_srt ++;
  }

  return 1;
}
/*-------------------------------------------------------------------------*/
int probaTable_check(void *hsh_, void *tbl_, void *el_) {
  hash_t* 	hsh   = hsh_;
  table_t* 	tbl  = tbl_;
  ophel_t* 	el   = el_;
	
  ophstat_t* 	stat = el->stat;
  uint32_t	taille;
  uint32_t	idx = tbl->idx;
  uint32_t 	nbColumn = tbl->ncols;
  uint32_t	stopColumn = el->col;
  uint32_t 	power2 = tbl->ptw->cs->ti[idx]->power2;
  char		pwdUTF[PWD_UTF_SIZE] = {0};

  taille = indexToPwdUTF(tbl->ptw->array, tbl->ptw->mdpw, tbl->ptw->mis, el->start, power2, stopColumn, idx, nbColumn, pwdUTF);
	
  stat->hredux += stopColumn;
  stat->falarm_hredux += stopColumn;
	
  if (checkFoundPwd(pwdUTF, taille, (unsigned int*)(hsh->hash), el->pwd)){
    stat->match_table++;
    stat->falarm_hredux = 0;
    return 1;
  }
  else{
    stat->falarm ++;
    return 0;
  }
}
/*-------------------------------------------------------------------------*/
int probaTable_isvalid(void *hsh_, void *tbl_) {
  hash_t *hsh = hsh_;

  return (hsh->kind == nt)? 1 : 0;
}
/*-------------------------------------------------------------------------*/
