/* Nessus Attack Scripting Language
 *
 * Copyright (C) 2002 - 2004 Tenable Network Security
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2,
 * as published by the Free Software Foundation
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef OPENVAS_ICMP_H
#define OPENVAS_ICMP_H

#ifdef HAVE_NETINET_IP_ICMP_H
#include <netinet/ip_icmp.h>
#endif

#if !defined(HAVE_STRUCT_ICMP) || (HAVE_STRUCT_ICMP == 0)
struct icmp_ra_addr
{
  u_int32_t ira_addr;
  u_int32_t ira_preference;
};
#define HAVE_STRUCT_ICMP 1

struct icmp
{
  u_char icmp_type;             /* type of message, see below */
  u_char icmp_code;             /* type sub code */
  u_short icmp_cksum;           /* ones complement cksum of struct */
  union
  {
    u_char ih_pptr;             /* ICMP_PARAMPROB */
    struct in_addr ih_gwaddr;   /* ICMP_REDIRECT */
    struct ih_idseq
    {
      n_short icd_id;
      n_short icd_seq;
    } ih_idseq;
    int ih_void;

    /* ICMP_UNREACH_NEEDFRAG -- Path MTU Discovery (RFC1191) */
    struct ih_pmtu
    {
      n_short ipm_void;
      n_short ipm_nextmtu;
    } ih_pmtu;

    struct ih_rtradv
    {
      u_char irt_num_addrs;
      u_char irt_wpa;
      u_int16_t irt_lifetime;
    } ih_rtradv;
  } icmp_hun;
#define	icmp_pptr	icmp_hun.ih_pptr
#define	icmp_gwaddr	icmp_hun.ih_gwaddr
#define	icmp_id		icmp_hun.ih_idseq.icd_id
#define	icmp_seq	icmp_hun.ih_idseq.icd_seq
#define	icmp_void	icmp_hun.ih_void
#define	icmp_pmvoid	icmp_hun.ih_pmtu.ipm_void
#define	icmp_nextmtu	icmp_hun.ih_pmtu.ipm_nextmtu
#define	icmp_num_addrs	icmp_hun.ih_rtradv.irt_num_addrs
#define	icmp_wpa	icmp_hun.ih_rtradv.irt_wpa
#define	icmp_lifetime	icmp_hun.ih_rtradv.irt_lifetime
  union
  {
    struct id_ts
    {
      n_time its_otime;
      n_time its_rtime;
      n_time its_ttime;
    } id_ts;
    struct id_ip
    {
      struct ip idi_ip;
      /* options and then 64 bits of data */
    } id_ip;
    struct icmp_ra_addr id_radv;
    u_long id_mask;
    char id_data[1];
  } icmp_dun;
#define	icmp_otime	icmp_dun.id_ts.its_otime
#define	icmp_rtime	icmp_dun.id_ts.its_rtime
#define	icmp_ttime	icmp_dun.id_ts.its_ttime
#define	icmp_ip		icmp_dun.id_ip.idi_ip
#define	icmp_radv	icmp_dun.id_radv
#define	icmp_mask	icmp_dun.id_mask
#define	icmp_data	icmp_dun.id_data
};

#endif /* not defined(HAVE_STRUCT_ICMP) */

#ifndef HAS_ICMP_ICMP_LIFETIME
#define SET_ICMP_LIFETIME(x,y) (x).icmp_hun.ih_void = (x).icmp_hun.ih_void & y
#else
#define SET_ICMP_LIFETIME(x,y) (x).icmp_lifetime = y
#endif

#endif
