/* OpenVAS Client
 * Copyright (C) 1998, 1999 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2,
 * as published by the Free Software Foundation
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef OPENVAS_REPORT_UTILS_H__
#define OPENVAS_REPORT_UTILS_H__

int arglist_length(struct arglist *);

int number_of_false_positives_by_host(struct arglist * );

int number_of_notes_by_port(struct arglist *);
int number_of_notes_by_host(struct arglist * );

int number_of_warnings_by_port(struct arglist *);
int number_of_warnings_by_host(struct arglist * );

int number_of_holes_by_port(struct arglist *);
int number_of_holes_by_host(struct arglist *);

int number_of_false_positives(struct arglist * );
int number_of_log_messages(struct arglist * );
int number_of_notes(struct arglist * );
int number_of_warnings(struct arglist * );
int number_of_holes(struct arglist * );

struct arglist *most_dangerous_host(struct arglist *);

int safe_strcmp(char*, char*);
#endif
