/* OpenVAS Client
 * Copyright (C) 1998 - 2001 Renaud Deraison
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2,
 * as published by the Free Software Foundation
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <includes.h>
#include "report.h"
#include "error_dlg.h"
#include "backend.h"
#include "data_mining.h"
#include "report_utils.h"
#include "nbe_output.h"


/*------------------------- Private functions ------------------------------*/

/**
 * @brief Initializes a backend with contents from a nbe report file (or stdin).
 * 
 * I.e. copy file contents to backends file.
 *
 * @todo Where does befd get cleaned up?  Also should check that initial open works
 * 
 * @param filename Filename of nbe file to import from or "-" for stdin.
 * 
 * @return Backend index or -1 in case of error.
 */
int
nbe_to_backend (const char* filename)
{
 int fd = (strcmp(filename, "-") == 0) ? 0 : open(filename, O_RDONLY);
 int be = backend_init(NULL);
 int befd = backend_fd(be);
 char buf[4096];
 int e;

 while((e = read(fd, buf, sizeof(buf))) > 0)
 {
  write(befd, buf, e);
 }
 if(e < 0)
 {
  perror("read ");
  return -1;
 }
 close(fd);
 return be;
}

extern int F_quiet_mode;

/**
 * @brief Export a backend to nbe file.
 *
 * Does not handle the case where the backend is not
 * a file.
 *
 * @todo Where does befd get cleaned up?  Also should check that initial open works.
 * 
 * @param filename name of file or "-" for stdout.
 */
int
backend_to_nbe (int be, char* filename)
{
 int fd;
 int befd = backend_fd(be);
 off_t tot = 0;
 char buf[4096];
 struct stat stat;
 int len;

 if (strcmp(filename, "-") == 0)
  fd = 1; /* stdout */
 else
   if (F_quiet_mode)
     fd = open(filename, O_RDWR|O_CREAT|O_TRUNC, 0600);
   else
     fd = open(filename, O_RDWR|O_CREAT|O_EXCL, 0600);

 if(fd < 0)
 {
   int e = errno;
   perror(filename);
   show_error("%s: %s", filename, strerror(e));
   return -1;
 }

 lseek(befd, 0, SEEK_SET);
 fstat(befd, &stat);
 len = (int)stat.st_size;
 while(tot < len)
 {
  int e;
  bzero(buf, sizeof(buf));
  e = read(befd, buf, sizeof(buf));
  if(e < 0)
   {
    perror("read ");
    close(fd);
    return -1;
   }
  write(fd, buf, e);
  tot+=e;
 }

 close(fd);
 return 0;
}
