/* OpenVAS Client
 * Copyright (C) 1998 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _OPENVAS_COMM_H
#define _OPENVAS_COMM_H

#include "context.h"

/* TODO ONMERGE: These are duplicates of defines in
   openvas-scanner/cnvts/find_service/find_service.c . */
#define PREF_CHECKBOX "checkbox"
#define PREF_ENTRY "entry"
#define PREF_RADIO "radio"
#define PREF_PASSWORD "password"
#define PREF_FILE "file"
#define PREF_SSH_CREDENTIALS "sshlogin"
#define NO_SSH_LOGIN_SELECTED _("Select SSH Login")


int comm_init(int,char*);
int comm_get_pluginlist();
int comm_get_preferences(struct context *);
int comm_get_rules(struct context *);

int comm_get_plugins(struct context *);

int comm_send_preferences(struct context *);
int comm_send_rules(struct context *);

int comm_get_dependencies(struct context*);

int comm_parse_preference(struct context *, struct arglist *, struct arglist *,
    struct arglist *, char *, char *, int);

int comm_get_certificates(struct context*);

GSList* send_ssh_credential_files (GSList* files_to_send);

#ifdef USE_OMP
gboolean comm_omp_send_files (struct context* context, int socket, gnutls_session_t session);
#endif

#endif
