/* OpenVAS Client
 * Copyright (C) 1998 - 2001 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2,
 * as published by the Free Software Foundation
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * cli.c - Command Line Interface manager
 * 
 * modified by Axel Nennker <axel@nennker.de> 20020418 
 *	do not need gtk here
 *	removed gcc -Wall complaints, NULL pointer checks
 */

#ifndef __CLI_H__
#define __CLI_H__

typedef int (*output_func_t)(struct arglist *, char *);

struct cli_args {
	char * server;
	int    port;
	char * login;
	char * password;
	char * cipher;
	char * target;
	char * results;
	char * extension;
	int  interactive;
	output_func_t output;
	int backend;
	int verbose;
	int backend_output_func;
	};

struct cli_args * cli_args_new();
void cli_args_server(struct cli_args *, char*);
void cli_args_port(struct cli_args *,int);

void cli_args_login(struct cli_args *,char*);
void cli_args_password(struct cli_args *,char*);

void cli_args_target(struct cli_args *,char*);
void cli_args_results(struct cli_args *,char*);

void cli_args_output(struct cli_args *, char* type);

int cli_connect_to_scanner(struct cli_args*);

int cli_test_network(struct cli_args*);
void cli_report(struct cli_args*);

void cli_dump_plugins(struct cli_args*);
void cli_dump_prefs(struct cli_args*);

void cli_sql_dump_plugins(struct cli_args*);
void cli_sql_dump_prefs(struct cli_args*);
void cli_args_verbose(struct cli_args*, int);

int cli_close_connection(struct cli_args*);

#endif /* __CLI_H__ */
